/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.oda.design.ColumnDefinition;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.DesignPackage;
import org.eclipse.datatools.connectivity.oda.design.DesignSessionRequest;
import org.eclipse.datatools.connectivity.oda.design.DocumentRoot;
import org.eclipse.datatools.connectivity.oda.design.ExpressionVariable;
import org.eclipse.datatools.connectivity.oda.design.ExpressionVariableType;
import org.eclipse.datatools.connectivity.oda.design.OdaDesignSession;
import org.eclipse.datatools.connectivity.oda.design.Properties;
import org.eclipse.datatools.connectivity.oda.design.Property;
import org.eclipse.datatools.connectivity.oda.design.ResourceIdentifiers;
import org.eclipse.datatools.connectivity.oda.design.ResultSetColumns;
import org.eclipse.datatools.connectivity.oda.design.SortKey;
import org.eclipse.datatools.connectivity.oda.design.nls.Messages;
import org.eclipse.datatools.connectivity.oda.design.util.DesignValidator;
import org.eclipse.datatools.connectivity.oda.design.util.DesignXMLProcessor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;

public class DesignUtil {
    private static final String RESOURCE_KEY_PREFIX = "%";
    private static final String RESOURCE_KEY_DOUBLE_PREFIX = "%%";
    private static final char RESOURCE_KEY_SEPARATOR = ' ';
    private static Diagnostician sm_diagnostician;
    static final String PLUGIN_ID = "org.eclipse.datatools.connectivity.oda.design";
    private static final String sm_loggerName = "org.eclipse.datatools.connectivity.oda.design.util";
    private static String sm_className;
    private static Logger sm_logger;

    private DesignUtil() {
    }

    public static void validateObject(EObject eObject) throws IllegalStateException {
        Diagnostic diagnostic = DesignUtil.diagnoseObject(eObject);
        if (diagnostic == null || diagnostic.getSeverity() == 0) {
            return;
        }
        if (diagnostic.getSeverity() == 4) {
            String errWarnMsg = DesignUtil.getDiagnosticMessages(diagnostic, 4, 2);
            throw new IllegalStateException(errWarnMsg);
        }
        String diagnosticMsg = DesignUtil.getDiagnosticMessages(diagnostic, 2, 1);
        if (diagnostic.getSeverity() == 2) {
            DiagnosticException ex = new DiagnosticException(diagnostic);
            DesignUtil.getLogger().logp(Level.WARNING, sm_className, "validateObject", diagnosticMsg, (Throwable)ex);
        } else {
            DesignUtil.getLogger().logp(Level.INFO, sm_className, "validateObject", diagnosticMsg);
        }
    }

    public static Diagnostic diagnoseObject(EObject eObject) {
        if (!DesignUtil.canDiagnose()) {
            return null;
        }
        Diagnostician designDiagnostician = DesignUtil.getDiagnostician();
        return designDiagnostician.validate(eObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Diagnostician getDiagnostician() {
        if (sm_diagnostician != null) return sm_diagnostician;
        Class<DesignUtil> clazz = DesignUtil.class;
        synchronized (DesignUtil.class) {
            if (sm_diagnostician != null) return sm_diagnostician;
            EValidator.Registry eValidatorRegistry = EValidator.Registry.INSTANCE;
            eValidatorRegistry.put((Object)((EPackage)DesignPackage.Literals.DATA_SET_QUERY.eContainer()), (Object)new DesignValidator());
            sm_diagnostician = new Diagnostician(eValidatorRegistry);
            // ** MonitorExit[var0] (shouldn't be in output)
            return sm_diagnostician;
        }
    }

    private static String getDiagnosticMessages(Diagnostic diagnostic, int messageType1, int messageType2) {
        if (diagnostic == null) {
            return null;
        }
        String errMsg = diagnostic.getMessage();
        for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
            if (childDiagnostic.getSeverity() != messageType1 && childDiagnostic.getSeverity() != messageType2) continue;
            errMsg = String.valueOf(errMsg) + "\n" + childDiagnostic.getMessage();
        }
        return errMsg;
    }

    private static boolean canDiagnose() {
        return true;
    }

    public static java.util.Properties convertDataSourceProperties(DataSourceDesign dataSourceDesign) {
        if (dataSourceDesign == null) {
            return new java.util.Properties();
        }
        java.util.Properties publicProps = DesignUtil.convertDesignProperties(dataSourceDesign.getPublicProperties());
        java.util.Properties propCollection = DesignUtil.convertDesignProperties(dataSourceDesign.getPrivateProperties());
        propCollection.putAll((Map<?, ?>)publicProps);
        return propCollection;
    }

    public static java.util.Properties convertDesignProperties(Properties designProps) {
        java.util.Properties utilProps = new java.util.Properties();
        if (designProps == null || designProps.isEmpty()) {
            return utilProps;
        }
        for (Property designProp : designProps.getProperties()) {
            if (designProp.getNameValue() == null || designProp.getNameValue().getName() == null || designProp.getNameValue().getValue() == null) continue;
            utilProps.setProperty(designProp.getNameValue().getName(), designProp.getNameValue().getValue());
        }
        return utilProps;
    }

    public static Properties convertToDesignProperties(java.util.Properties utilProps) {
        Properties designProps = DesignFactory.eINSTANCE.createProperties();
        if (utilProps == null || utilProps.size() == 0) {
            return designProps;
        }
        for (Map.Entry<Object, Object> utilProp : utilProps.entrySet()) {
            designProps.setProperty((String)utilProp.getKey(), (String)utilProp.getValue());
        }
        return designProps;
    }

    public static String validateRequestSession(DesignSessionRequest requestSession) throws IllegalStateException {
        if (requestSession == null) {
            throw new IllegalStateException(Messages.design_nullArgument);
        }
        DesignUtil.validateObject(requestSession);
        DataSourceDesign dataSourceDesign = requestSession.getDataSourceDesign();
        if (dataSourceDesign == null) {
            throw new IllegalStateException(Messages.design_missingDataSourceDesign);
        }
        String odaDataSourceId = dataSourceDesign.getOdaExtensionDataSourceId();
        if (odaDataSourceId == null || odaDataSourceId.length() == 0) {
            throw new IllegalStateException(Messages.design_missingId);
        }
        return odaDataSourceId;
    }

    public static void validateDataSourceDesign(DataSourceDesign dataSourceDesign) throws IllegalStateException {
        if (dataSourceDesign == null) {
            throw new IllegalStateException(Messages.design_nullArgument);
        }
        DesignUtil.validateObject(dataSourceDesign);
    }

    public static File convertPathToFile(String filePath) {
        return DesignUtil.convertPathToResourceFile(filePath, null);
    }

    public static File convertPathToResourceFile(String filePath, ResourceIdentifiers designResourceIds) {
        File resolvedStoreFile;
        String resolvedStoreFilePath;
        if (filePath == null || filePath.length() == 0) {
            return null;
        }
        File file = new File(filePath);
        if (file.exists()) {
            return file;
        }
        if (designResourceIds != null && (resolvedStoreFilePath = DesignUtil.resolveToApplResourcePath(filePath, designResourceIds)) != null && !resolvedStoreFilePath.equals(filePath) && (resolvedStoreFile = new File(resolvedStoreFilePath)).exists()) {
            return resolvedStoreFile;
        }
        try {
            URL url = new URL(filePath);
            if (DesignUtil.isRunningOSGiPlatform()) {
                url = FileLocator.toFileURL((URL)url);
            }
            return new File(url.toURI());
        }
        catch (MalformedURLException e) {
            DesignUtil.getLogger().fine(String.valueOf(DesignUtil.getExceptionMessage(e)) + " (" + filePath + ")");
        }
        catch (URISyntaxException e) {
            DesignUtil.getLogger().fine(String.valueOf(DesignUtil.getExceptionMessage(e)) + " (" + filePath + ")");
        }
        catch (IOException e) {
            DesignUtil.getLogger().info(String.valueOf(DesignUtil.getExceptionMessage(e)) + " (" + filePath + ")");
        }
        return null;
    }

    static boolean isRunningOSGiPlatform() {
        return Platform.getBundle((String)PLUGIN_ID) != null;
    }

    public static String convertFileToPath(File aFile) {
        if (aFile == null) {
            return null;
        }
        return aFile.getPath();
    }

    public static String convertFileToResourcePath(File aFile, ResourceIdentifiers designResourceIds, boolean convertToRelativePath) {
        File applResourceBaseFile;
        String applResourceBase;
        File normalizedFile = DesignUtil.getNormalizedFile(aFile);
        String filePath = DesignUtil.convertFileToPath(normalizedFile);
        assert (normalizedFile.isAbsolute());
        if (!normalizedFile.isAbsolute() || !convertToRelativePath) {
            return filePath;
        }
        if (convertToRelativePath && designResourceIds != null && (applResourceBase = designResourceIds.getApplResourceBaseURIString()) != null && (applResourceBaseFile = DesignUtil.getNormalizedFile(DesignUtil.convertPathToFile(applResourceBase))) != null) {
            File fileParent = normalizedFile.getParentFile();
            while (fileParent != null) {
                if (fileParent.equals(applResourceBaseFile)) {
                    filePath = filePath.substring(DesignUtil.convertFileToPath(fileParent).length() + 1);
                    filePath = filePath.replace(File.separator, "/");
                    break;
                }
                fileParent = fileParent.getParentFile();
            }
        }
        return filePath;
    }

    private static File getNormalizedFile(File aFile) {
        if (aFile == null) {
            return null;
        }
        try {
            return aFile.getCanonicalFile();
        }
        catch (Exception exception) {
            return aFile.getAbsoluteFile();
        }
    }

    public static String resolveToApplResourcePath(String filePath, ResourceIdentifiers designResourceIds) {
        File resolvedFile;
        if (filePath == null || designResourceIds == null || designResourceIds.getApplResourceBaseURI() == null) {
            return filePath;
        }
        if (new File(filePath).isAbsolute()) {
            return filePath;
        }
        try {
            java.net.URI filePathURI = new java.net.URI(null, null, filePath, null);
            resolvedFile = new File(designResourceIds.getApplResourceBaseURI().resolve(filePathURI));
        }
        catch (Exception ex) {
            DesignUtil.getLogger().info(String.valueOf(DesignUtil.getExceptionMessage(ex)) + " (" + filePath + ")");
            return null;
        }
        return resolvedFile.getPath();
    }

    public static void saveOdaDesignSession(OdaDesignSession odaDesignSession, File outputFile) throws IOException, IllegalArgumentException {
        if (outputFile == null) {
            throw new IllegalArgumentException();
        }
        URI fileURI = URI.createFileURI((String)outputFile.getAbsolutePath());
        DesignUtil.saveOdaDesignSession(odaDesignSession, fileURI);
    }

    public static void saveOdaDesignSession(OdaDesignSession odaDesignSession, URI uri) throws IOException {
        DocumentRoot documentRoot = DesignFactory.eINSTANCE.createDocumentRoot();
        documentRoot.setOdaDesignSession(odaDesignSession);
        DesignXMLProcessor xmlProcessor = new DesignXMLProcessor();
        Resource resource = xmlProcessor.createResource(uri);
        resource.getContents().add((Object)documentRoot);
        try {
            resource.save(null);
        }
        catch (IOException ex) {
            DesignUtil.getLogger().logp(Level.INFO, sm_className, "saveOdaDesignSession( OdaDesignSession, URI )", "Not able to serialize the ODA design session to specified URI.", ex);
            throw ex;
        }
    }

    public static OdaDesignSession loadOdaDesignSession(File resourceFile) throws IOException, IllegalArgumentException {
        if (resourceFile == null) {
            throw new IllegalArgumentException();
        }
        URI fileURI = URI.createFileURI((String)resourceFile.getAbsolutePath());
        return DesignUtil.loadOdaDesignSession(fileURI);
    }

    public static OdaDesignSession loadOdaDesignSession(URI uri) throws IOException {
        DocumentRoot documentRoot;
        OdaDesignSession odaDesignSession;
        DesignXMLProcessor xmlProcessor = new DesignXMLProcessor();
        Resource resource = xmlProcessor.createResource(uri);
        try {
            resource.load(null);
        }
        catch (IOException ex) {
            DesignUtil.getLogger().logp(Level.INFO, sm_className, "loadOdaDesignSession( URI )", "Not able to load the specified URI.", ex);
            throw ex;
        }
        if (resource.getContents().isEmpty()) {
            DesignUtil.getLogger().logp(Level.WARNING, sm_className, "loadOdaDesignSession( URI )", "The specified resource URI (" + uri.toString() + ") is empty.");
            return null;
        }
        Object content = resource.getContents().get(0);
        if (content instanceof DocumentRoot && (odaDesignSession = (documentRoot = (DocumentRoot)content).getOdaDesignSession()) != null) {
            return odaDesignSession;
        }
        DesignUtil.getLogger().logp(Level.WARNING, sm_className, "loadOdaDesignSession( URI )", "The resource URI (" + uri.toString() + ") does not contain an ODA Design Session.");
        return null;
    }

    public static ExpressionVariable createFilterVariable(ResultSetColumns columns, int columnIndex) {
        ColumnDefinition columnDefn = (ColumnDefinition)columns.getResultColumnDefinitions().get(columnIndex);
        if (columnDefn == null) {
            return null;
        }
        String identifier = columnDefn.getAttributes().getName();
        if (identifier.length() == 0) {
            identifier = Integer.valueOf(columnDefn.getAttributes().getPosition()).toString();
        }
        ExpressionVariable columnExprVar = DesignFactory.eINSTANCE.createExpressionVariable();
        columnExprVar.setIdentifier(identifier);
        columnExprVar.setNativeDataTypeCode(columnDefn.getAttributes().getNativeDataTypeCode());
        columnExprVar.setType(ExpressionVariableType.RESULT_SET_COLUMN);
        return columnExprVar;
    }

    public static SortKey createSortKeyWithColumnIdentifier(ResultSetColumns columns, int columnIndex) {
        ColumnDefinition columnDefn = (ColumnDefinition)columns.getResultColumnDefinitions().get(columnIndex);
        if (columnDefn == null) {
            return null;
        }
        SortKey aSortKey = DesignFactory.eINSTANCE.createSortKey();
        aSortKey.setColumnName(columnDefn.getAttributes().getName());
        aSortKey.setColumnPosition(columnDefn.getAttributes().getPosition());
        return aSortKey;
    }

    public static String getResourceKey(String attributeValue) {
        return DesignUtil.parseResourceValue(attributeValue, true);
    }

    public static String addKeyToResourceAttribute(String newKey, String attributeValue) {
        String defaultValue = DesignUtil.getDefaultResourceString(attributeValue);
        return DesignUtil.formatResourceAttribute(newKey, defaultValue);
    }

    public static String getDefaultResourceString(String attributeValue) {
        return DesignUtil.parseResourceValue(attributeValue, false);
    }

    public static String addDefaultToResourceAttribute(String newDefault, String attributeValue) {
        String key = DesignUtil.getResourceKey(attributeValue);
        return DesignUtil.formatResourceAttribute(key, newDefault);
    }

    private static String formatResourceAttribute(String key, String defaultValue) {
        if (key == null || key.trim().length() == 0) {
            if (defaultValue == null) {
                return null;
            }
            if (defaultValue.startsWith(RESOURCE_KEY_PREFIX)) {
                return RESOURCE_KEY_PREFIX + defaultValue;
            }
            return defaultValue;
        }
        if ((key = key.trim()).indexOf(32) != -1) {
            throw new IllegalArgumentException(Messages.bind((String)Messages.design_invalidResourceKey, (Object)key));
        }
        if (!key.startsWith(RESOURCE_KEY_PREFIX)) {
            key = RESOURCE_KEY_PREFIX + key;
        }
        if (defaultValue == null || defaultValue.length() == 0) {
            return key;
        }
        return String.valueOf(key) + ' ' + defaultValue;
    }

    private static String parseResourceValue(String attributeValue, boolean getKey) {
        if (attributeValue == null) {
            return null;
        }
        String key = null;
        String defaultValue = null;
        String s = attributeValue;
        if (!s.startsWith(RESOURCE_KEY_PREFIX)) {
            defaultValue = attributeValue;
        } else if (s.startsWith(RESOURCE_KEY_DOUBLE_PREFIX)) {
            defaultValue = s.substring(1);
        } else {
            int keySeparatorIndex = s.indexOf(32);
            if (keySeparatorIndex == -1) {
                key = s.substring(1);
            } else {
                key = s.substring(1, keySeparatorIndex);
                if (keySeparatorIndex + 1 < s.length()) {
                    defaultValue = s.substring(keySeparatorIndex + 1);
                }
            }
        }
        return getKey ? key : defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Logger getLogger() {
        if (sm_logger != null) return sm_logger;
        Class<DesignUtil> clazz = DesignUtil.class;
        synchronized (DesignUtil.class) {
            if (sm_logger != null) return sm_logger;
            sm_className = DesignUtil.class.getName();
            sm_logger = Logger.getLogger(sm_loggerName);
            // ** MonitorExit[var0] (shouldn't be in output)
            return sm_logger;
        }
    }

    private static String getExceptionMessage(Exception ex) {
        if (ex == null) {
            return null;
        }
        return ex.getCause() != null ? ex.getCause().getLocalizedMessage() : ex.toString();
    }
}

