/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.birt.emitters.excel.handlers;

import java.util.Stack;
import org.apache.poi.ss.util.CellRangeAddress;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.ITaskOption;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.ir.TableGroupDesign;
import uk.co.spudsoft.birt.emitters.excel.EmitterServices;
import uk.co.spudsoft.birt.emitters.excel.HandlerState;
import uk.co.spudsoft.birt.emitters.excel.framework.Logger;
import uk.co.spudsoft.birt.emitters.excel.handlers.AbstractRealTableHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.IHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.TopLevelTableRowHandler;

public class TopLevelTableHandler
extends AbstractRealTableHandler {
    private Stack<Integer> groupStarts;

    public TopLevelTableHandler(Logger log, IHandler parent, ITableContent table) {
        super(log, parent, table);
    }

    @Override
    public void startTable(HandlerState state, ITableContent table) throws BirtException {
        String password;
        state.colNum = 0;
        super.startTable(state, table);
        String name = state.correctSheetName(table.getName());
        if (name != null && !name.isEmpty()) {
            state.sheetName = name;
        }
        if ((password = EmitterServices.stringOption((ITaskOption)state.getRenderOptions(), (IContent)table, "ExcelEmitter.SheetProtectPassword", null)) != null && !password.isEmpty()) {
            state.sheetPassword = password;
        }
        if (EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), (IContent)table, "ExcelEmitter.GroupSummaryHeader", false)) {
            state.currentSheet.setRowSumsBelow(false);
        }
    }

    @Override
    public void endTable(HandlerState state, ITableContent table) throws BirtException {
        boolean blankRowAfterTopLevelTable;
        super.endTable(state, table);
        boolean autoFilter = EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), (IContent)table, "ExcelEmitter.AutoFilter", false);
        if (autoFilter) {
            int autoEndRow = this.endDetailsRow;
            int autoEndCol = state.colNum - 1;
            if (autoEndRow < this.startRow) {
                autoEndRow = this.startRow;
            }
            if (autoEndCol < this.startCol) {
                autoEndCol = this.startCol;
            }
            this.log.debug("Applying auto filter to [", this.startRow, ",", this.startCol, "] - [", autoEndRow, ",", autoEndCol, "]");
            CellRangeAddress wholeTable = new CellRangeAddress(this.startRow, autoEndRow, this.startCol, autoEndCol);
            state.currentSheet.setAutoFilter(wholeTable);
        }
        if (blankRowAfterTopLevelTable = EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), (IContent)table, "ExcelEmitter.BlankRowAfterTopLevelTable", false)) {
            ++state.rowNum;
        }
        state.setHandler(this.parent);
    }

    @Override
    public void startRow(HandlerState state, IRowContent row) throws BirtException {
        state.setHandler(new TopLevelTableRowHandler(this.log, (IHandler)this, row));
        state.getHandler().startRow(state, row);
    }

    @Override
    public void startTableGroup(HandlerState state, ITableGroupContent group) throws BirtException {
        TableGroupDesign groupDesign;
        this.log.debug("startTableGroup @" + state.rowNum + " called " + group.getBookmark());
        if (this.groupStarts == null) {
            this.groupStarts = new Stack();
        }
        this.groupStarts.push(state.rowNum);
        Object groupDesignObject = group.getGenerateBy();
        if (groupDesignObject instanceof TableGroupDesign && ("always".equals((groupDesign = (TableGroupDesign)groupDesignObject).getPageBreakBefore()) || "always-excluding-first".equals(groupDesign.getPageBreakBefore()) || "always".equals(groupDesign.getPageBreakAfter()) || "always-excluding-last".equals(groupDesign.getPageBreakAfter())) && group.getTOC() != null) {
            state.sheetName = state.correctSheetName(group.getTOC().toString());
        }
    }

    @Override
    public void endTableGroup(HandlerState state, ITableGroupContent group) throws BirtException {
        this.log.debug("endTableGroup @" + state.rowNum + " called " + group.getBookmark());
        int start = this.groupStarts.pop();
        if (start < state.rowNum - 1) {
            boolean disableGrouping = false;
            if (EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), (IContent)group, "ExcelEmitter.DisableGrouping", false)) {
                disableGrouping = true;
            }
            if (!disableGrouping) {
                if (state.currentSheet.getRowSumsBelow()) {
                    this.log.debug("TableGroup of rows below ", start, " - ", state.rowNum - 2);
                    state.currentSheet.groupRow(start, state.rowNum - 2);
                } else {
                    this.log.debug("TableGroup of rows above ", start + 1, " - ", state.rowNum - 1);
                    state.currentSheet.groupRow(start + 1, state.rowNum - 1);
                }
            }
        }
    }
}

