/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.IASTSharedValues;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class ConstructorReferenceFinder {
    private final IType fType;
    private final IMethod[] fConstructors;

    private ConstructorReferenceFinder(IType type) throws JavaModelException {
        this.fConstructors = JavaElementUtil.getAllConstructors(type);
        this.fType = type;
    }

    private ConstructorReferenceFinder(IMethod constructor) {
        this.fConstructors = new IMethod[]{constructor};
        this.fType = constructor.getDeclaringType();
    }

    public static SearchResultGroup[] getConstructorReferences(IType type, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        return new ConstructorReferenceFinder(type).getConstructorReferences(pm, null, 2, status);
    }

    public static SearchResultGroup[] getConstructorReferences(IType type, WorkingCopyOwner owner, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        return new ConstructorReferenceFinder(type).getConstructorReferences(pm, owner, 2, status);
    }

    public static SearchResultGroup[] getConstructorOccurrences(IMethod constructor, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        Assert.isTrue((boolean)constructor.isConstructor());
        return new ConstructorReferenceFinder(constructor).getConstructorReferences(pm, null, 3, status);
    }

    private SearchResultGroup[] getConstructorReferences(IProgressMonitor pm, WorkingCopyOwner owner, int limitTo, RefactoringStatus status) throws JavaModelException {
        IJavaSearchScope scope = this.createSearchScope();
        SearchPattern pattern = RefactoringSearchEngine.createOrPattern((IJavaElement[])this.fConstructors, limitTo);
        if (pattern == null) {
            if (this.fConstructors.length != 0) {
                return new SearchResultGroup[0];
            }
            return this.getImplicitConstructorReferences(pm, owner, status);
        }
        return this.removeUnrealReferences(RefactoringSearchEngine.search(pattern, owner, scope, pm, status));
    }

    private SearchResultGroup[] removeUnrealReferences(SearchResultGroup[] groups) {
        ArrayList<SearchResultGroup> result = new ArrayList<SearchResultGroup>(groups.length);
        SearchResultGroup[] searchResultGroupArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            SearchResultGroup group = searchResultGroupArray[n2];
            ICompilationUnit cu = group.getCompilationUnit();
            if (cu != null) {
                CompilationUnit cuNode = new RefactoringASTParser(IASTSharedValues.SHARED_AST_LEVEL).parse((ITypeRoot)cu, false);
                SearchMatch[] allSearchResults = group.getSearchResults();
                ArrayList<SearchMatch> realConstructorReferences = new ArrayList<SearchMatch>(Arrays.asList(allSearchResults));
                SearchMatch[] searchMatchArray = allSearchResults;
                int n3 = allSearchResults.length;
                int n4 = 0;
                while (n4 < n3) {
                    SearchMatch searchResult = searchMatchArray[n4];
                    if (!this.isRealConstructorReferenceNode(ASTNodeSearchUtil.getAstNode(searchResult, cuNode))) {
                        realConstructorReferences.remove(searchResult);
                    }
                    ++n4;
                }
                if (!realConstructorReferences.isEmpty()) {
                    result.add(new SearchResultGroup(group.getResource(), realConstructorReferences.toArray(new SearchMatch[realConstructorReferences.size()])));
                }
            }
            ++n2;
        }
        return result.toArray(new SearchResultGroup[result.size()]);
    }

    private boolean isRealConstructorReferenceNode(ASTNode node) {
        MethodDeclaration md;
        String typeName = this.fConstructors[0].getDeclaringType().getElementName();
        if (node.getParent() instanceof AbstractTypeDeclaration && ((AbstractTypeDeclaration)node.getParent()).getNameProperty().equals(node.getLocationInParent())) {
            return false;
        }
        return !(node.getParent() instanceof MethodDeclaration) || !MethodDeclaration.NAME_PROPERTY.equals(node.getLocationInParent()) || !(md = (MethodDeclaration)node.getParent()).isConstructor() || md.getName().getIdentifier().equals(typeName);
    }

    private IJavaSearchScope createSearchScope() throws JavaModelException {
        if (this.fConstructors.length == 0) {
            return RefactoringScopeFactory.create((IJavaElement)this.fType);
        }
        return RefactoringScopeFactory.create((IJavaElement)this.getMostVisibleConstructor());
    }

    private IMethod getMostVisibleConstructor() throws JavaModelException {
        Assert.isTrue((this.fConstructors.length > 0 ? 1 : 0) != 0);
        IMethod candidate = this.fConstructors[0];
        int visibility = JdtFlags.getVisibilityCode((IMember)this.fConstructors[0]);
        int i = 1;
        while (i < this.fConstructors.length) {
            IMethod constructor = this.fConstructors[i];
            if (JdtFlags.isHigherVisibility(JdtFlags.getVisibilityCode((IMember)constructor), visibility)) {
                candidate = constructor;
            }
            ++i;
        }
        return candidate;
    }

    private SearchResultGroup[] getImplicitConstructorReferences(IProgressMonitor pm, WorkingCopyOwner owner, RefactoringStatus status) throws JavaModelException {
        pm.beginTask("", 2);
        ArrayList<SearchMatch> searchMatches = new ArrayList<SearchMatch>(this.getImplicitConstructorReferencesFromHierarchy(owner, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
        searchMatches.addAll(this.getImplicitConstructorReferencesInClassCreations(owner, (IProgressMonitor)new SubProgressMonitor(pm, 1), status));
        pm.done();
        return RefactoringSearchEngine.groupByCu(searchMatches.toArray(new SearchMatch[searchMatches.size()]), status);
    }

    private List<SearchMatch> getImplicitConstructorReferencesInClassCreations(WorkingCopyOwner owner, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)this.fType, (int)2, (int)24);
        IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)this.fType);
        SearchResultGroup[] refs = RefactoringSearchEngine.search(pattern, owner, scope, pm, status);
        ArrayList<SearchMatch> result = new ArrayList<SearchMatch>();
        SearchResultGroup[] searchResultGroupArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            SearchResultGroup group = searchResultGroupArray[n2];
            ICompilationUnit cu = group.getCompilationUnit();
            if (cu != null) {
                CompilationUnit cuNode = new RefactoringASTParser(IASTSharedValues.SHARED_AST_LEVEL).parse((ITypeRoot)cu, false);
                SearchMatch[] searchMatchArray = group.getSearchResults();
                int n3 = searchMatchArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    SearchMatch searchResult = searchMatchArray[n4];
                    ASTNode node = ASTNodeSearchUtil.getAstNode(searchResult, cuNode);
                    if (ConstructorReferenceFinder.isImplicitConstructorReferenceNodeInClassCreations(node)) {
                        result.add(searchResult);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return result;
    }

    public static boolean isImplicitConstructorReferenceNodeInClassCreations(ASTNode node) {
        if (node instanceof Type) {
            ASTNode grandParent;
            ASTNode parent = node.getParent();
            if (parent instanceof ClassInstanceCreation) {
                return node.equals((Object)((ClassInstanceCreation)parent).getType());
            }
            if (parent instanceof ParameterizedType && (grandParent = parent.getParent()) instanceof ClassInstanceCreation) {
                ParameterizedType type = (ParameterizedType)((ClassInstanceCreation)grandParent).getType();
                return node.equals((Object)type.getType());
            }
        }
        return false;
    }

    private List<SearchMatch> getImplicitConstructorReferencesFromHierarchy(WorkingCopyOwner owner, IProgressMonitor pm) throws JavaModelException {
        IType[] subTypes = ConstructorReferenceFinder.getNonBinarySubtypes(owner, this.fType, pm);
        ArrayList<SearchMatch> result = new ArrayList<SearchMatch>(subTypes.length);
        IType[] iTypeArray = subTypes;
        int n = subTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType subType = iTypeArray[n2];
            result.addAll(ConstructorReferenceFinder.getAllSuperConstructorInvocations(subType));
            ++n2;
        }
        return result;
    }

    private static IType[] getNonBinarySubtypes(WorkingCopyOwner owner, IType type, IProgressMonitor monitor) throws JavaModelException {
        ITypeHierarchy hierarchy = null;
        hierarchy = owner == null ? type.newTypeHierarchy(monitor) : type.newSupertypeHierarchy(owner, monitor);
        IType[] subTypes = hierarchy.getAllSubtypes(type);
        ArrayList<IType> result = new ArrayList<IType>(subTypes.length);
        IType[] iTypeArray = subTypes;
        int n = subTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType subType = iTypeArray[n2];
            if (!subType.isBinary()) {
                result.add(subType);
            }
            ++n2;
        }
        return result.toArray(new IType[result.size()]);
    }

    private static Collection<SearchMatch> getAllSuperConstructorInvocations(IType type) throws JavaModelException {
        IMethod[] constructors = JavaElementUtil.getAllConstructors(type);
        CompilationUnit cuNode = new RefactoringASTParser(IASTSharedValues.SHARED_AST_LEVEL).parse((ITypeRoot)type.getCompilationUnit(), false);
        ArrayList<SearchMatch> result = new ArrayList<SearchMatch>(constructors.length);
        IMethod[] iMethodArray = constructors;
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod constructor = iMethodArray[n2];
            SuperConstructorInvocation superCall = ConstructorReferenceFinder.getSuperConstructorCallNode(constructor, cuNode);
            if (superCall != null) {
                result.add(ConstructorReferenceFinder.createSearchResult((ASTNode)superCall, constructor));
            }
            ++n2;
        }
        return result;
    }

    private static SearchMatch createSearchResult(ASTNode superCall, IMethod constructor) {
        int start = superCall.getStartPosition();
        int end = ASTNodes.getInclusiveEnd(superCall);
        IResource resource = constructor.getResource();
        return new SearchMatch((IJavaElement)constructor, 0, start, end - start, SearchEngine.getDefaultSearchParticipant(), resource);
    }

    private static SuperConstructorInvocation getSuperConstructorCallNode(IMethod constructor, CompilationUnit cuNode) throws JavaModelException {
        Assert.isTrue((boolean)constructor.isConstructor());
        MethodDeclaration constructorNode = ASTNodeSearchUtil.getMethodDeclarationNode(constructor, cuNode);
        Assert.isTrue((boolean)constructorNode.isConstructor());
        Block body = constructorNode.getBody();
        Assert.isNotNull((Object)body);
        List statements = body.statements();
        if (!statements.isEmpty() && statements.get(0) instanceof SuperConstructorInvocation) {
            return (SuperConstructorInvocation)statements.get(0);
        }
        return null;
    }
}

