/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component.virtual;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.AbstractPickList;
import org.eclipse.e4.tools.emf.ui.internal.common.E4PickList;
import org.eclipse.e4.tools.emf.ui.internal.common.VirtualEntry;
import org.eclipse.e4.tools.emf.ui.internal.imp.ModelImportWizard;
import org.eclipse.e4.ui.model.application.descriptor.basic.MBasicFactory;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptorContainer;
import org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicPackageImpl;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class VPartDescriptor
extends AbstractComponentEditor<MPartDescriptorContainer> {
    private Composite composite;
    private EMFDataBindingContext context;
    private TableViewer viewer;
    private final List<Action> actions = new ArrayList<Action>();
    private final List<Action> actionsImport = new ArrayList<Action>();

    @Inject
    public VPartDescriptor() {
    }

    @PostConstruct
    void init() {
        this.actions.add(new Action(this.Messages.VPartDescriptor_AddPartDescriptor, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.PartDescriptor")){

            public void run() {
                VPartDescriptor.this.handleAdd();
            }
        });
        this.actionsImport.add(new Action(this.Messages.VPartDescriptor_Views, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.Part")){

            public void run() {
                VPartDescriptor.this.handleImport(BasicPackageImpl.Literals.PART_DESCRIPTOR, "view");
            }
        });
        this.actionsImport.add(new Action(this.Messages.VPartDescriptor_Editors, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.Part")){

            public void run() {
                VPartDescriptor.this.handleImport(BasicPackageImpl.Literals.PART_DESCRIPTOR, "editor");
            }
        });
        this.actionsImport.add(new Action(this.Messages.VPartDescriptor_ViewAsCompatibilityView, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.Part")){

            public void run() {
                VPartDescriptor.this.handleImport(BasicPackageImpl.Literals.PART_DESCRIPTOR, "compatibilityView");
            }
        });
    }

    @Override
    public String getLabel(Object element) {
        return this.Messages.VPartDescriptor_TreeLabel;
    }

    @Override
    public String getDetailLabel(Object element) {
        return null;
    }

    @Override
    public String getDescription(Object element) {
        return this.Messages.VPartDescriptor_TreeLabelDescription;
    }

    @Override
    public Composite doGetEditor(Composite parent, Object object) {
        if (this.composite == null) {
            this.context = new EMFDataBindingContext();
            this.composite = this.createForm(parent, this.context, this.getMaster());
        }
        VirtualEntry o = (VirtualEntry)object;
        this.viewer.setInput(o.getList());
        this.getMaster().setValue((Object)((MPartDescriptorContainer)o.getOriginalParent()));
        return this.composite;
    }

    private Composite createForm(Composite parent, EMFDataBindingContext context, WritableValue<MPartDescriptorContainer> master) {
        CTabFolder folder = new CTabFolder(parent, 1024);
        CTabItem item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabDefault);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        E4PickList pickList = new E4PickList(parent, 0, Arrays.asList(AbstractPickList.PickListFeatures.NO_PICKER), (AbstractComponentEditor)this, (EStructuralFeature)BasicPackageImpl.Literals.PART_DESCRIPTOR_CONTAINER__DESCRIPTORS){

            @Override
            protected void addPressed() {
                VPartDescriptor.this.handleAdd();
            }

            @Override
            protected List<?> getContainerChildren(Object container) {
                MPartDescriptorContainer c = (MPartDescriptorContainer)container;
                return c.getDescriptors();
            }
        };
        pickList.setLayoutData(new GridData(4, 4, true, true, 3, 1));
        this.viewer = pickList.getList();
        folder.setSelection(0);
        return folder;
    }

    @Override
    public IObservableList<?> getChildList(Object element) {
        return null;
    }

    protected void handleAdd() {
        MPartDescriptor partDescription = MBasicFactory.INSTANCE.createPartDescriptor();
        this.addToModel(partDescription);
    }

    private void addToModel(MPartDescriptor partDescription) {
        this.setElementId(partDescription);
        Command cmd = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getMaster().getValue(), (Object)BasicPackageImpl.Literals.PART_DESCRIPTOR_CONTAINER__DESCRIPTORS, (Object)partDescription);
        if (cmd.canExecute()) {
            this.getEditingDomain().getCommandStack().execute(cmd);
            this.getEditor().setSelection(partDescription);
        }
    }

    protected void handleImport(EClass eClass, String hint) {
        if (eClass == BasicPackageImpl.Literals.PART_DESCRIPTOR) {
            ModelImportWizard wizard = new ModelImportWizard(MPartDescriptor.class, this, hint, this.resourcePool);
            WizardDialog wizardDialog = new WizardDialog(this.viewer.getControl().getShell(), (IWizard)wizard);
            if (wizardDialog.open() == 0) {
                MPartDescriptor[] parts;
                MPartDescriptor[] mPartDescriptorArray = parts = (MPartDescriptor[])wizard.getElements(MPartDescriptor.class);
                int n = parts.length;
                int n2 = 0;
                while (n2 < n) {
                    MPartDescriptor part = mPartDescriptorArray[n2];
                    this.addToModel(part);
                    ++n2;
                }
            }
        }
    }

    @Override
    public List<Action> getActions(Object element) {
        ArrayList<Action> l = new ArrayList<Action>(super.getActions(element));
        l.addAll(this.actions);
        return l;
    }

    @Override
    public List<Action> getActionsImport(Object element) {
        ArrayList<Action> l = new ArrayList<Action>(super.getActionsImport(element));
        l.addAll(this.actionsImport);
        return l;
    }
}

