/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.isite.ISiteCategoryDefinition;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.site.SiteFeatureAdapter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.forms.editor.IFormPage;

class SiteLabelProvider
extends LabelProvider {
    private PDELabelProvider fSharedProvider;
    private Image fSiteFeatureImage = PDEPluginImages.DESC_FEATURE_OBJ.createImage();
    private Image fMissingSiteFeatureImage = PDEPluginImages.DESC_NOREF_FEATURE_OBJ.createImage();
    private Image fPageImage;
    private Image fCatDefImage = PDEPluginImages.DESC_CATEGORY_OBJ.createImage();

    public SiteLabelProvider() {
        this.fPageImage = PDEPluginImages.DESC_PAGE_OBJ.createImage();
        this.fSharedProvider = PDEPlugin.getDefault().getLabelProvider();
        this.fSharedProvider.connect((Object)this);
    }

    public Image getImage(Object element) {
        if (element instanceof ISiteCategoryDefinition) {
            return this.fCatDefImage;
        }
        if (element instanceof SiteFeatureAdapter) {
            if (PDECore.getDefault().getFeatureModelManager().findFeatureModelRelaxed(((SiteFeatureAdapter)element).feature.getId(), ((SiteFeatureAdapter)element).feature.getVersion()) == null) {
                return this.fMissingSiteFeatureImage;
            }
            return this.fSiteFeatureImage;
        }
        if (element instanceof IFormPage) {
            return this.fPageImage;
        }
        return this.fSharedProvider.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof ISiteCategoryDefinition) {
            return ((ISiteCategoryDefinition)element).getName();
        }
        if (element instanceof SiteFeatureAdapter) {
            ISiteFeature feature = ((SiteFeatureAdapter)element).feature;
            return this.fSharedProvider.getObjectText(feature);
        }
        if (element instanceof IFormPage) {
            return ((IFormPage)element).getTitle();
        }
        return this.fSharedProvider.getText(element);
    }

    public void dispose() {
        this.fSharedProvider.disconnect((Object)this);
        if (this.fCatDefImage != null && !this.fCatDefImage.isDisposed()) {
            this.fCatDefImage.dispose();
            this.fCatDefImage = null;
        }
        if (this.fSiteFeatureImage != null && !this.fSiteFeatureImage.isDisposed()) {
            this.fSiteFeatureImage.dispose();
            this.fSiteFeatureImage = null;
        }
        if (this.fMissingSiteFeatureImage != null && !this.fMissingSiteFeatureImage.isDisposed()) {
            this.fMissingSiteFeatureImage.dispose();
            this.fMissingSiteFeatureImage = null;
        }
        if (this.fPageImage != null && !this.fPageImage.isDisposed()) {
            this.fPageImage.dispose();
            this.fPageImage = null;
        }
        super.dispose();
    }
}

