/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.empty;

import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.Messages;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.empty.EmptyFilterOption;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.empty.TitleAreaFilterDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TitleAreaFilterDialogWithEmptyOptions
extends TitleAreaFilterDialog {
    private Button btnExcludeEmptyValues;
    private Button btnOnlyEmptyValues;
    private Button btnIncludeEmptyValues;
    private EmptyFilterOption emptyFilterOption;
    private boolean bShowEmptyOptions = true;
    private Composite compOptions;
    private Composite parent;

    public TitleAreaFilterDialogWithEmptyOptions(Shell parent, ILabelProvider renderer) {
        super(parent, renderer);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        this.parent = parent;
        Composite comp = (Composite)super.createDialogArea(parent);
        this.compOptions = new Composite(comp, 0);
        this.compOptions.setLayoutData((Object)new GridData(4, 128, true, false));
        this.compOptions.setLayout((Layout)new RowLayout());
        this.compOptions.moveAbove((Control)this.getText());
        this.btnExcludeEmptyValues = new Button(this.compOptions, 16);
        this.btnExcludeEmptyValues.setText(Messages.TitleAreaFilterDialogWithEmptyOptions_excludeEmptyValues);
        this.btnExcludeEmptyValues.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TitleAreaFilterDialogWithEmptyOptions.this.setEmptyFilterOption(EmptyFilterOption.EXCLUDE);
            }
        });
        this.btnIncludeEmptyValues = new Button(this.compOptions, 16);
        this.btnIncludeEmptyValues.setText(Messages.TitleAreaFilterDialogWithEmptyOptions_includeEmptyValues);
        this.btnIncludeEmptyValues.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TitleAreaFilterDialogWithEmptyOptions.this.setEmptyFilterOption(EmptyFilterOption.INCLUDE);
            }
        });
        this.btnOnlyEmptyValues = new Button(this.compOptions, 16);
        this.btnOnlyEmptyValues.setText(Messages.TitleAreaFilterDialogWithEmptyOptions_onlyEmptyValues);
        this.btnOnlyEmptyValues.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TitleAreaFilterDialogWithEmptyOptions.this.setEmptyFilterOption(EmptyFilterOption.ONLY);
            }
        });
        String toolTip = Messages.TitleAreaFilterDialogWithEmptyOptions_emptyValueDescription;
        this.btnExcludeEmptyValues.setToolTipText(toolTip);
        this.btnIncludeEmptyValues.setToolTipText(toolTip);
        this.btnOnlyEmptyValues.setToolTipText(toolTip);
        this.setEmptyFilterOption(EmptyFilterOption.EXCLUDE);
        this.updateEmptyOptionState();
        parent.pack();
        return comp;
    }

    public boolean close() {
        return super.close();
    }

    public EmptyFilterOption getEmptyFilterOption() {
        return this.emptyFilterOption;
    }

    public void setEmptyFilterOption(EmptyFilterOption emptyFilterOption) {
        this.emptyFilterOption = emptyFilterOption;
        this.updateUi();
    }

    private void updateUi() {
        if (this.btnExcludeEmptyValues == null) {
            return;
        }
        switch (this.emptyFilterOption) {
            case EXCLUDE: {
                this.btnExcludeEmptyValues.setSelection(true);
                this.btnIncludeEmptyValues.setSelection(false);
                this.btnOnlyEmptyValues.setSelection(false);
                break;
            }
            case INCLUDE: {
                this.btnExcludeEmptyValues.setSelection(false);
                this.btnIncludeEmptyValues.setSelection(true);
                this.btnOnlyEmptyValues.setSelection(false);
                break;
            }
            case ONLY: {
                this.btnExcludeEmptyValues.setSelection(false);
                this.btnIncludeEmptyValues.setSelection(false);
                this.btnOnlyEmptyValues.setSelection(true);
                break;
            }
        }
    }

    public void setShowEmptyOptions(boolean bShow) {
        this.bShowEmptyOptions = bShow;
        this.updateEmptyOptionState();
    }

    private void updateEmptyOptionState() {
        if (this.compOptions == null) {
            return;
        }
        this.compOptions.setVisible(this.bShowEmptyOptions);
        ((GridData)this.compOptions.getLayoutData()).exclude = !this.bShowEmptyOptions;
        this.parent.layout();
    }
}

