/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.search.federated.FederatedSearchEntry;
import org.eclipse.help.internal.search.federated.LocalHelp;
import org.eclipse.help.search.ISearchEngineResult;
import org.eclipse.help.search.ISearchEngineResultCollector;
import org.eclipse.help.search.ISearchScope;
import org.eclipse.help.ui.internal.HelpUIResources;
import org.eclipse.help.ui.internal.IHelpUIConstants;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.views.ComboPart;
import org.eclipse.help.ui.internal.views.EngineDescriptor;
import org.eclipse.help.ui.internal.views.EngineDescriptorManager;
import org.eclipse.help.ui.internal.views.HistoryScopeSet;
import org.eclipse.help.ui.internal.views.IHelpPart;
import org.eclipse.help.ui.internal.views.ReusableHelpPart;
import org.eclipse.help.ui.internal.views.ScopePreferenceDialog;
import org.eclipse.help.ui.internal.views.ScopePreferenceManager;
import org.eclipse.help.ui.internal.views.ScopeSet;
import org.eclipse.help.ui.internal.views.ScopeSetDialog;
import org.eclipse.help.ui.internal.views.ScopeSetManager;
import org.eclipse.help.ui.internal.views.ScopeState;
import org.eclipse.help.ui.internal.views.SearchResultsPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class SearchPart
extends AbstractFormPart
implements IHelpPart,
IHelpUIConstants {
    private ReusableHelpPart parent;
    protected static List previousSearchQueryData = new ArrayList(20);
    private static final String HREF_SEARCH_HELP = "/org.eclipse.platform.doc.user/tasks/help_search.htm";
    private static boolean SEARCH_HELP_AVAILABLE = false;
    private String id;
    private Composite container;
    private Composite filteringGroup;
    private FormText searchWordText;
    private ComboPart searchWordCombo;
    private Section scopeSection;
    private Button goButton;
    private Button shellDefaultButton;
    private Hyperlink scopeSetLink;
    private Hyperlink advancedLink;
    private Observer engineObserver;
    private ScopeSetManager scopeSetManager;
    private static final int COMBO_HISTORY_SIZE = 10;
    private JobListener jobListener;
    private boolean searchPending;
    private SearchScopeObserver scopeObserver;
    private Section alternateQuerySection;
    private FormToolkit toolkit;
    private Composite alternateQueryComposite;

    static {
        InputStream is = HelpSystem.getHelpContent((String)HREF_SEARCH_HELP);
        if (is != null) {
            try {
                is.close();
                SEARCH_HELP_AVAILABLE = true;
            }
            catch (IOException iOException) {}
        }
    }

    public SearchPart(Composite parent, FormToolkit toolkit) {
        this.toolkit = toolkit;
        this.container = toolkit.createComposite(parent);
        this.scopeSetManager = ScopeState.getInstance().getScopeSetManager();
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        this.container.setLayout((Layout)layout);
        this.createSearchExpressionSection(toolkit);
        this.searchWordCombo = new ComboPart(this.container, toolkit, toolkit.getBorderStyle());
        this.updateSearchCombo(null);
        TableWrapData td = new TableWrapData(256);
        td.maxWidth = 100;
        td.valign = 32;
        this.searchWordCombo.getControl().setLayoutData((Object)td);
        this.goButton = toolkit.createButton(this.container, Messages.SearchPart_go, 8);
        this.goButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchPart.this.handleButtonPressed();
            }
        });
        this.goButton.setEnabled(false);
        this.searchWordCombo.addModifyListener(e -> this.goButton.setEnabled(this.searchWordCombo.getText().length() > 0));
        this.searchWordCombo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r' && SearchPart.this.goButton.isEnabled()) {
                    SearchPart.this.doSearch(SearchPart.this.searchWordCombo.getText());
                }
            }
        });
        this.searchWordCombo.getControl().addListener(15, event -> {
            this.shellDefaultButton = null;
            Shell shell = this.searchWordCombo.getControl().getShell();
            Button button = shell.getDefaultButton();
            if (button != null) {
                this.shellDefaultButton = button;
                shell.setDefaultButton(this.goButton);
            }
        });
        this.searchWordCombo.getControl().addListener(16, event -> {
            if (this.shellDefaultButton != null) {
                Shell shell = this.searchWordCombo.getControl().getShell();
                shell.setDefaultButton(this.shellDefaultButton);
                this.shellDefaultButton = null;
            }
        });
        this.createScopeSection(toolkit);
        toolkit.paintBordersFor(this.container);
        this.jobListener = new JobListener();
        Job.getJobManager().addJobChangeListener((IJobChangeListener)this.jobListener);
    }

    private void createScopeSection(FormToolkit toolkit) {
        this.scopeSection = toolkit.createSection(this.container, 8226);
        this.scopeSection.setText(Messages.limit_to);
        TableWrapData td = new TableWrapData();
        td.colspan = 2;
        td.align = 128;
        this.scopeSection.setLayoutData((Object)td);
        this.filteringGroup = toolkit.createComposite((Composite)this.scopeSection);
        this.scopeSection.setClient((Control)this.filteringGroup);
        TableWrapLayout flayout = new TableWrapLayout();
        flayout.numColumns = 2;
        this.filteringGroup.setLayout((Layout)flayout);
        this.createScopeSet(this.scopeSection, toolkit);
        toolkit.paintBordersFor(this.filteringGroup);
        this.scopeObserver = new SearchScopeObserver();
        this.scopeSetManager.addObserver(this.scopeObserver);
    }

    private void createSearchExpressionSection(FormToolkit toolkit) {
        Section searchExpressionSection = toolkit.createSection(this.container, 8226);
        searchExpressionSection.setText(Messages.expression);
        TableWrapData td = new TableWrapData();
        td.colspan = 2;
        td.align = 128;
        searchExpressionSection.setLayoutData((Object)td);
        Composite detailGroup = toolkit.createComposite((Composite)searchExpressionSection);
        searchExpressionSection.setClient((Control)detailGroup);
        TableWrapLayout dgLayout = new TableWrapLayout();
        detailGroup.setLayout((Layout)dgLayout);
        this.searchWordText = toolkit.createFormText(detailGroup, false);
        this.searchWordText.setImage("etool16/help.png", HelpUIResources.getImage("etool16/help.png"));
        this.searchWordText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                SearchPart.this.parent.showURL(SearchPart.HREF_SEARCH_HELP, true);
            }
        });
        this.updateSearchWordText();
        toolkit.paintBordersFor(detailGroup);
    }

    private void createAlternateQueriesSection(FormToolkit toolkit) {
        TableWrapData td = new TableWrapData();
        td.colspan = 2;
        td.align = 128;
        this.container.setMenu(new Menu((Control)this.container));
        this.alternateQuerySection = toolkit.createSection(this.container, 8226);
        this.alternateQuerySection.setLayoutData((Object)td);
        this.alternateQuerySection.setText(Messages.AlternateQueries);
        this.alternateQueryComposite = toolkit.createComposite((Composite)this.alternateQuerySection);
        this.alternateQuerySection.setClient((Control)this.alternateQueryComposite);
        TableWrapLayout flayout = new TableWrapLayout();
        flayout.numColumns = 1;
        this.alternateQueryComposite.setLayout((Layout)flayout);
        this.alternateQuerySection.setExpanded(true);
    }

    private void createAdvancedLink(Composite parent, FormToolkit toolkit) {
        this.advancedLink = toolkit.createHyperlink(parent, Messages.FederatedSearchPart_advanced, 0);
        this.advancedLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                SearchPart.this.doAdvanced();
            }
        });
        TableWrapData td = new TableWrapData();
        td.colspan = 2;
        this.advancedLink.setLayoutData((Object)td);
    }

    private void createScopeSet(Section section, FormToolkit toolkit) {
        this.scopeSetLink = toolkit.createHyperlink((Composite)section, null, 64);
        this.scopeSetLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                SearchPart.this.doChangeScopeSet();
            }
        });
        this.scopeSetLink.setToolTipText(Messages.FederatedSearchPart_changeScopeSet);
        section.setTextClient((Control)this.scopeSetLink);
        ScopeSet active = this.scopeSetManager.getActiveSet();
        this.setActiveScopeSet(active);
    }

    private void updateSearchWordText() {
        StringBuilder buff = new StringBuilder();
        buff.append("<form>");
        buff.append("<p>");
        buff.append(Messages.expression_label);
        if (SEARCH_HELP_AVAILABLE) {
            buff.append("</p><p>");
            buff.append("<img href=\"");
            buff.append("etool16/help.png");
            buff.append("\"/> ");
            buff.append("<a href=\"");
            buff.append(HREF_SEARCH_HELP);
            buff.append("\">");
            buff.append(Messages.SearchPart_learnMore);
            buff.append("</a>");
        }
        buff.append("</p>");
        buff.append("</form>");
        this.searchWordText.setText(buff.toString(), true, false);
    }

    private void setActiveScopeSet(ScopeSet set) {
        this.scopeSetLink.setText(set.getName());
        this.scopeSetManager.setActiveSet(set);
        this.updateMasters(set);
        this.scopeSection.layout();
        if (this.parent != null) {
            this.parent.reflow();
        }
    }

    private void updateMasters(ScopeSet set) {
        Control[] children = ((Composite)this.scopeSection.getClient()).getChildren();
        int i = 0;
        while (i < children.length) {
            Button master;
            Object data;
            Control child = children[i];
            if (child instanceof Button && (data = (master = (Button)child).getData()) != null && data instanceof EngineDescriptor) {
                EngineDescriptor ed = (EngineDescriptor)data;
                master.setSelection(set.getEngineEnabled(ed));
            }
            ++i;
        }
    }

    private void loadEngines(Composite container, FormToolkit toolkit) {
        EngineDescriptorManager descManager = this.parent.getEngineManager();
        EngineDescriptor[] descriptors = descManager.getDescriptors();
        int i = 0;
        while (i < descriptors.length) {
            EngineDescriptor desc = descriptors[i];
            this.loadEngine(desc, container, toolkit);
            ++i;
        }
        this.engineObserver = (o, arg) -> {
            EngineDescriptorManager.DescriptorEvent event = (EngineDescriptorManager.DescriptorEvent)arg;
            int kind = event.getKind();
            EngineDescriptor desc = event.getDescriptor();
            if (kind == 1) {
                this.advancedLink.dispose();
                this.loadEngine(desc, container, toolkit);
                this.createAdvancedLink(container, toolkit);
                this.parent.reflow();
            } else if (kind == 2) {
                this.removeEngine(desc);
            } else {
                this.updateEngine(desc);
            }
        };
        descManager.addObserver(this.engineObserver);
        this.updateMasters(this.scopeSetManager.getActiveSet());
    }

    private EngineDescriptor loadEngine(final EngineDescriptor edesc, Composite container, FormToolkit toolkit) {
        Label ilabel = toolkit.createLabel(container, null);
        ilabel.setImage(edesc.getIconImage());
        ilabel.setData((Object)edesc);
        final Button master = toolkit.createButton(container, edesc.getLabel(), 32);
        master.setData((Object)edesc);
        master.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchPart.this.scopeSetManager.getActiveSet().setEngineEnabled(edesc, master.getSelection());
            }
        });
        String desc = edesc.getDescription();
        if (desc != null) {
            Label spacer = toolkit.createLabel(container, null);
            spacer.setData((Object)edesc);
            Label dlabel = toolkit.createLabel(container, desc, 64);
            dlabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            dlabel.setLayoutData((Object)new TableWrapData(256));
            dlabel.setMenu(container.getMenu());
            dlabel.setData((Object)edesc);
        }
        return edesc;
    }

    private void removeEngine(EngineDescriptor desc) {
        boolean reflowNeeded = false;
        Control[] children = ((Composite)this.scopeSection.getClient()).getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            EngineDescriptor ed = (EngineDescriptor)child.getData();
            if (ed == desc) {
                child.setMenu(null);
                child.dispose();
                reflowNeeded = true;
            }
            ++i;
        }
        if (reflowNeeded) {
            this.parent.reflow();
        }
    }

    private void updateEngine(EngineDescriptor desc) {
        Control[] children = ((Composite)this.scopeSection.getClient()).getChildren();
        boolean reflowNeeded = false;
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            EngineDescriptor ed = (EngineDescriptor)child.getData();
            if (ed == desc) {
                Button b = (Button)children[i + 1];
                b.setText(desc.getLabel());
                Label d = (Label)children[i + 3];
                d.setText(desc.getDescription());
                d.getParent().layout();
                reflowNeeded = true;
                break;
            }
            ++i;
        }
        if (reflowNeeded) {
            this.parent.reflow();
        }
    }

    public void startSearch(String text) {
        this.searchWordCombo.setText(text);
        this.doSearch(text);
    }

    private void storeSearchHistory(String expression) {
        HistoryScopeSet sset = this.scopeSetManager.findSearchSet(expression);
        if (sset == null) {
            sset = new HistoryScopeSet(expression);
            this.scopeSetManager.add(sset);
        }
        ScopeSet activeSet = this.scopeSetManager.getActiveSet();
        sset.copyFrom(activeSet);
        sset.save();
        this.updateSearchCombo(sset);
        this.searchWordCombo.setText(expression);
    }

    private void updateSearchCombo(HistoryScopeSet current) {
        HistoryScopeSet sset;
        ScopeSet[] sets = this.scopeSetManager.getScopeSets(true);
        ArrayList<String> items = new ArrayList<String>();
        ArrayList<HistoryScopeSet> toDelete = new ArrayList<HistoryScopeSet>();
        int i = sets.length - 1;
        while (i >= 0) {
            sset = (HistoryScopeSet)sets[i];
            if (current == null || sset != current) {
                if (sets.length - i > 10) {
                    toDelete.add(sset);
                }
                items.add(sset.getExpression());
            }
            --i;
        }
        i = 0;
        while (i < toDelete.size()) {
            sset = (HistoryScopeSet)toDelete.get(i);
            this.scopeSetManager.remove(sset);
            ++i;
        }
        if (items.size() > 0) {
            this.searchWordCombo.setItems(items.toArray(new String[items.size()]));
        }
    }

    private void handleButtonPressed() {
        if (this.searchWordCombo.getControl().isEnabled()) {
            this.doSearch(this.searchWordCombo.getText());
        } else {
            this.goButton.setEnabled(false);
            this.stop();
        }
    }

    private void doSearch(String text) {
        this.doSearch(text, false);
    }

    private void doSearch(String text, boolean fromHistory) {
        String setExpression;
        ScopeSet set = this.scopeSetManager.getActiveSet();
        if (!fromHistory && set instanceof HistoryScopeSet && (setExpression = ((HistoryScopeSet)set).getExpression()).equals(text)) {
            fromHistory = true;
        }
        if (!fromHistory) {
            this.storeSearchHistory(text);
            boolean switchedSet = this.scopeSetManager.restoreLastExplicitSet();
            set = this.scopeSetManager.getActiveSet();
            if (switchedSet) {
                this.setActiveScopeSet(set);
            }
        }
        ArrayList<FederatedSearchEntry> entries = new ArrayList<FederatedSearchEntry>();
        final SearchResultsPart results = (SearchResultsPart)this.parent.findPart("fsearch-result");
        ArrayList<EngineDescriptor> eds = new ArrayList<EngineDescriptor>();
        EngineDescriptor[] engineDescriptors = this.parent.getEngineManager().getDescriptors();
        int i = 0;
        while (i < engineDescriptors.length) {
            final EngineDescriptor ed = engineDescriptors[i];
            if (set.getEngineEnabled(ed) && ed.getEngine() != null) {
                ISearchScope scope = ed.createSearchScope(set.getPreferenceStore());
                FederatedSearchEntry entry = new FederatedSearchEntry(ed.getId(), ed.getLabel(), scope, ed.getEngine(), new ISearchEngineResultCollector(){

                    public void accept(ISearchEngineResult searchResult) {
                        results.add(ed, searchResult);
                    }

                    public void accept(ISearchEngineResult[] searchResults) {
                        results.add(ed, searchResults);
                        if (ed.getEngine() instanceof LocalHelp && !SearchPart.this.container.isDisposed()) {
                            SearchPart.this.container.getDisplay().asyncExec((Runnable)new Thread(){

                                @Override
                                public void run() {
                                    List alts;
                                    if ((this).SearchPart.this.alternateQuerySection != null) {
                                        (this).SearchPart.this.alternateQuerySection.dispose();
                                        (this).SearchPart.this.alternateQuerySection = null;
                                    }
                                    if (!(alts = ((LocalHelp)ed.getEngine()).getAlternates()).isEmpty()) {
                                        SearchPart.this.createAlternateQueriesSection((this).SearchPart.this.toolkit);
                                        int b = 0;
                                        while (b < alts.size()) {
                                            Hyperlink link = (this).SearchPart.this.toolkit.createHyperlink((this).SearchPart.this.alternateQueryComposite, (String)alts.get(b), 0);
                                            link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                                                public void linkActivated(HyperlinkEvent e) {
                                                    if (!((this).this).SearchPart.this.searchWordCombo.getControl().isDisposed()) {
                                                        ((this).this).SearchPart.this.searchWordCombo.setText(((Hyperlink)e.getSource()).getText());
                                                        SearchPart.this.doSearch(((Hyperlink)e.getSource()).getText());
                                                    }
                                                }
                                            });
                                            ++b;
                                        }
                                    }
                                }
                            });
                        }
                    }

                    public void error(IStatus status) {
                        results.error(ed, status);
                    }
                });
                entries.add(entry);
                eds.add(ed);
            }
            ++i;
        }
        if (entries.isEmpty()) {
            return;
        }
        FederatedSearchEntry[] array = entries.toArray(new FederatedSearchEntry[entries.size()]);
        if (this.scopeSection.isExpanded()) {
            this.scopeSection.setExpanded(false);
            this.parent.reflow();
        }
        results.clearResults();
        results.startNewSearch(text, eds);
        BaseHelpSystem.getSearchManager().search(text, array);
    }

    private void doAdvanced() {
        ScopeSet set = this.scopeSetManager.getActiveSet();
        ScopePreferenceManager manager = new ScopePreferenceManager(this.parent.getEngineManager(), set);
        ScopePreferenceDialog dialog = new ScopePreferenceDialog(this.container.getShell(), manager, this.parent.getEngineManager(), set.isEditable());
        dialog.setPreferenceStore(set.getPreferenceStore());
        dialog.create();
        dialog.getShell().setText(NLS.bind((String)Messages.ScopePreferenceDialog_wtitle, (Object)set.getName()));
        dialog.open();
        this.updateMasters(set);
    }

    private void doChangeScopeSet() {
        ScopeSetDialog dialog = new ScopeSetDialog(this.container.getShell(), this.scopeSetManager, this.parent.getEngineManager(), false);
        dialog.setInput(this.scopeSetManager);
        dialog.create();
        dialog.getShell().setText(Messages.ScopeSetDialog_wtitle);
        if (dialog.open() == 0) {
            ScopeSet set = dialog.getActiveSet();
            if (set != null) {
                this.setActiveScopeSet(set);
            }
            this.scopeSetManager.save();
            this.scopeSetManager.notifyObservers();
        }
    }

    public void dispose() {
        ScopeSet activeSet = this.scopeSetManager.getActiveSet();
        if (activeSet != null) {
            activeSet.save();
        }
        if (this.engineObserver != null) {
            this.parent.getEngineManager().deleteObserver(this.engineObserver);
            this.engineObserver = null;
        }
        if (this.scopeObserver != null) {
            ScopeState.getInstance().getScopeSetManager().deleteObserver(this.scopeObserver);
        }
        Job.getJobManager().removeJobChangeListener((IJobChangeListener)this.jobListener);
        this.stop();
        super.dispose();
    }

    @Override
    public Control getControl() {
        return this.container;
    }

    @Override
    public void init(ReusableHelpPart parent, String id, IMemento memento) {
        this.parent = parent;
        this.id = id;
        this.loadEngines(this.filteringGroup, parent.getForm().getToolkit());
        this.createAdvancedLink(this.filteringGroup, parent.getForm().getToolkit());
        parent.hookFormText(this.searchWordText);
        if (memento != null) {
            this.restorePart(memento);
        }
    }

    private void restorePart(IMemento memento) {
        String expression;
        ScopeSet sset;
        String setName = memento.getString("activeSet");
        if (setName != null && (sset = this.scopeSetManager.findSet(setName)) != null) {
            this.scopeSetManager.setActiveSet(sset);
        }
        if ((expression = memento.getString("expression")) != null && expression.length() > 0) {
            this.searchWordCombo.setText(expression);
            this.searchPending = true;
            this.markStale();
        }
    }

    public void refresh() {
        super.refresh();
        if (this.searchPending) {
            this.searchPending = false;
            this.doSearch(this.searchWordCombo.getText());
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setVisible(boolean visible) {
        this.getControl().setVisible(visible);
    }

    @Override
    public boolean fillContextMenu(IMenuManager manager) {
        return this.parent.fillFormContextMenu(this.searchWordText, manager);
    }

    @Override
    public boolean hasFocusControl(Control control) {
        return control == this.searchWordText || control == this.searchWordCombo.getControl() || this.scopeSection.getClient() == control;
    }

    public void setFocus() {
        this.searchWordCombo.getControl().setFocus();
    }

    @Override
    public IAction getGlobalAction(String id) {
        if (id.equals(ActionFactory.COPY.getId())) {
            return this.parent.getCopyAction();
        }
        return null;
    }

    @Override
    public void stop() {
        SearchResultsPart results = (SearchResultsPart)this.parent.findPart("fsearch-result");
        if (results != null) {
            results.canceling();
        }
        Job.getJobManager().cancel((Object)"org.eclipse.help.base.searchEngine");
    }

    @Override
    public void toggleRoleFilter() {
    }

    @Override
    public void refilter() {
    }

    @Override
    public void saveState(IMemento memento) {
        ScopeSet sset = this.scopeSetManager.getActiveSet();
        if (sset != null) {
            memento.putString("activeSet", sset.getName());
        }
        memento.putString("expression", this.searchWordCombo.getText());
    }

    private class JobListener
    implements IJobChangeListener,
    Runnable {
        private boolean searchInProgress = false;

        private JobListener() {
        }

        public void aboutToRun(IJobChangeEvent event) {
        }

        public void awake(IJobChangeEvent event) {
        }

        public void done(IJobChangeEvent event) {
            Job[] searchJobs;
            if (event.getJob().belongsTo((Object)"org.eclipse.help.base.searchEngine") && (searchJobs = Job.getJobManager().find((Object)"org.eclipse.help.base.searchEngine")).length == 0) {
                this.searchInProgress = false;
                if (SearchPart.this.container.isDisposed()) {
                    return;
                }
                SearchPart.this.container.getDisplay().asyncExec((Runnable)this);
                SearchResultsPart results = (SearchResultsPart)SearchPart.this.parent.findPart("fsearch-result");
                results.completed();
            }
        }

        public void running(IJobChangeEvent event) {
        }

        public void scheduled(IJobChangeEvent event) {
            if (!this.searchInProgress && event.getJob().belongsTo((Object)"org.eclipse.help.base.searchEngine")) {
                this.searchInProgress = true;
                SearchPart.this.container.getDisplay().asyncExec((Runnable)this);
            }
        }

        public void sleeping(IJobChangeEvent event) {
        }

        @Override
        public void run() {
            SearchPart.this.searchWordCombo.getControl().setEnabled(!this.searchInProgress);
            if (!this.searchInProgress) {
                SearchPart.this.goButton.setEnabled(true);
            }
            if (this.searchInProgress) {
                SearchPart.this.goButton.setText(Messages.SearchPart_stop);
            } else {
                SearchPart.this.goButton.setText(Messages.SearchPart_go);
            }
            SearchPart.this.parent.getForm().getForm().setBusy(this.searchInProgress);
            SearchPart.this.goButton.getParent().layout();
        }
    }

    public class SearchScopeObserver
    implements Observer {
        @Override
        public void update(Observable arg0, Object arg1) {
            ScopeSet set = SearchPart.this.scopeSetManager.getActiveSet();
            SearchPart.this.scopeSetLink.setText(set.getName());
            SearchPart.this.scopeSetManager.setActiveSet(set);
            SearchPart.this.scopeSection.layout();
            if (SearchPart.this.parent != null) {
                SearchPart.this.parent.reflow();
            }
        }
    }
}

