/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.ResourceBundle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;

public abstract class ResourceAction
extends Action {
    protected static String getString(ResourceBundle bundle, String key, String defaultValue) {
        return bundle.containsKey(key) ? bundle.getString(key) : defaultValue;
    }

    public ResourceAction(ResourceBundle bundle, String prefix, int style) {
        super(null, style);
        this.initialize(bundle, prefix);
    }

    public ResourceAction(ResourceBundle bundle, String prefix) {
        this.initialize(bundle, prefix);
    }

    public final void setHelpContextId(String contextId) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, contextId);
    }

    protected void initialize(ResourceBundle bundle, String prefix) {
        Object labelKey = "label";
        Object tooltipKey = "tooltip";
        Object imageKey = "image";
        Object descriptionKey = "description";
        if (prefix != null && !prefix.isEmpty()) {
            labelKey = prefix + (String)labelKey;
            tooltipKey = prefix + (String)tooltipKey;
            imageKey = prefix + (String)imageKey;
            descriptionKey = prefix + (String)descriptionKey;
        }
        this.setText(ResourceAction.getString(bundle, (String)labelKey, (String)labelKey));
        this.setToolTipText(ResourceAction.getString(bundle, (String)tooltipKey, null));
        this.setDescription(ResourceAction.getString(bundle, (String)descriptionKey, null));
        String file = ResourceAction.getString(bundle, (String)imageKey, null);
        if (file != null && !file.isBlank()) {
            this.setImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)file));
        }
    }
}

