/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.node;

import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.node.DisplayableComponentNode;
import com.sun.enterprise.deployment.node.XMLElement;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.webservices.connector.LogUtils;
import org.glassfish.webservices.node.AddressingNode;
import org.glassfish.webservices.node.RespectBindingNode;
import org.glassfish.webservices.node.WebServiceHandlerChainNode;
import org.glassfish.webservices.node.WebServiceHandlerNode;
import org.w3c.dom.Node;

public class WebServiceEndpointNode
extends DisplayableComponentNode<WebServiceEndpoint> {
    private static final Logger LOG = LogUtils.getLogger();
    private static final XMLElement TAG = new XMLElement("port-component");

    public WebServiceEndpointNode() {
        this.registerElementHandler(new XMLElement("handler"), WebServiceHandlerNode.class, "addHandler");
        this.registerElementHandler(new XMLElement("addressing"), AddressingNode.class, "setAddressing");
        this.registerElementHandler(new XMLElement("respect-binding"), RespectBindingNode.class, "setRespectBinding");
        this.registerElementHandler(new XMLElement("handler-chain"), WebServiceHandlerChainNode.class, "addHandlerChain");
    }

    protected XMLElement getXMLRootTag() {
        return TAG;
    }

    protected WebServiceEndpoint createDescriptor() {
        return new WebServiceEndpoint();
    }

    protected Map<String, String> getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("port-component-name", "setEndpointName");
        table.put("service-endpoint-interface", "setServiceEndpointInterface");
        table.put("protocol-binding", "setProtocolBinding");
        table.put("enable-mtom", "setMtomEnabled");
        table.put("mtom-threshold", "setMtomThreshold");
        return table;
    }

    public void setElementValue(XMLElement element, String value) {
        String elementName = element.getQName();
        WebServiceEndpoint endpoint = (WebServiceEndpoint)this.getDescriptor();
        if ("ejb-link".equals(elementName)) {
            endpoint.setEjbLink(value);
        } else if ("servlet-link".equals(elementName)) {
            endpoint.setWebComponentLink(value);
        } else if ("wsdl-port".equals(elementName)) {
            String prefix = this.getPrefixFromQName(value);
            String localPart = this.getLocalPartFromQName(value);
            String namespaceUri = this.resolvePrefix(element, prefix);
            if (namespaceUri == null) {
                LOG.log(Level.SEVERE, "AS-WSCONNECTOR-00046", new Object[]{prefix, value});
            } else {
                QName wsdlPort = new QName(namespaceUri, localPart);
                endpoint.setWsdlPort(wsdlPort, prefix);
            }
        } else if ("wsdl-service".equals(elementName)) {
            String prefix = this.getPrefixFromQName(value);
            String localPart = this.getLocalPartFromQName(value);
            String namespaceUri = this.resolvePrefix(element, prefix);
            if (namespaceUri == null) {
                LOG.log(Level.SEVERE, "AS-WSCONNECTOR-00046", new Object[]{prefix, value});
            } else {
                QName wsdlSvc = new QName(namespaceUri, localPart);
                endpoint.setWsdlService(wsdlSvc, prefix);
            }
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, WebServiceEndpoint descriptor) {
        QName wsdlPort;
        Node wseNode = super.writeDescriptor(parent, nodeName, (Descriptor)descriptor);
        this.writeDisplayableComponentInfo(wseNode, (Descriptor)descriptor);
        WebServiceEndpointNode.appendTextChild((Node)wseNode, (String)"port-component-name", (String)descriptor.getEndpointName());
        QName wsdlService = descriptor.getWsdlService();
        if (wsdlService != null && !wsdlService.getLocalPart().isEmpty()) {
            this.appendQNameChild("wsdl-service", wseNode, wsdlService.getNamespaceURI(), wsdlService.getLocalPart(), descriptor.getWsdlServiceNamespacePrefix());
        }
        if ((wsdlPort = descriptor.getWsdlPort()) != null && !wsdlPort.getLocalPart().isEmpty()) {
            this.appendQNameChild("wsdl-port", wseNode, wsdlPort.getNamespaceURI(), wsdlPort.getLocalPart(), descriptor.getWsdlPortNamespacePrefix());
        }
        WebServiceEndpointNode.appendTextChild((Node)wseNode, (String)"enable-mtom", (String)descriptor.getMtomEnabled());
        WebServiceEndpointNode.appendTextChild((Node)wseNode, (String)"mtom-threshold", (String)descriptor.getMtomThreshold());
        if (descriptor.hasUserSpecifiedProtocolBinding()) {
            WebServiceEndpointNode.appendTextChild((Node)wseNode, (String)"protocol-binding", (String)descriptor.getProtocolBinding());
        }
        WebServiceEndpointNode.appendTextChild((Node)wseNode, (String)"service-endpoint-interface", (String)descriptor.getServiceEndpointInterface());
        if (descriptor.implementedByWebComponent()) {
            linkNode = WebServiceEndpointNode.appendChild((Node)wseNode, (String)"service-impl-bean");
            WebServiceEndpointNode.appendTextChild((Node)linkNode, (String)"servlet-link", (String)descriptor.getWebComponentLink());
        } else if (descriptor.implementedByEjbComponent()) {
            linkNode = WebServiceEndpointNode.appendChild((Node)wseNode, (String)"service-impl-bean");
            WebServiceEndpointNode.appendTextChild((Node)linkNode, (String)"ejb-link", (String)descriptor.getEjbLink());
        } else {
            LOG.log(Level.INFO, "AS-WSCONNECTOR-00203", descriptor.getEndpointName());
        }
        WebServiceHandlerNode handlerNode = new WebServiceHandlerNode();
        handlerNode.writeWebServiceHandlers(wseNode, descriptor.getHandlers());
        WebServiceHandlerChainNode handlerChainNode = new WebServiceHandlerChainNode();
        handlerChainNode.writeWebServiceHandlerChains(wseNode, descriptor.getHandlerChain());
        return wseNode;
    }
}

