/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.corba.ee.org.omg.CSIIOP.AS_ContextSec;
import com.sun.corba.ee.org.omg.CSIIOP.CompoundSecMech;
import com.sun.corba.ee.org.omg.CSIIOP.SAS_ContextSec;
import com.sun.corba.ee.org.omg.CSIIOP.TLS_SEC_TRANS;
import com.sun.corba.ee.org.omg.CSIIOP.TransportAddress;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.iiop.IIOPAddress;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.ee.spi.transport.SocketInfo;
import com.sun.enterprise.common.iiop.security.AnonCredential;
import com.sun.enterprise.common.iiop.security.GSSUPName;
import com.sun.enterprise.common.iiop.security.SecurityContext;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbIORConfigurationDescriptor;
import com.sun.enterprise.iiop.security.CSIV2TaggedComponentInfo;
import com.sun.enterprise.iiop.security.ConnectionContext;
import com.sun.enterprise.iiop.security.ConnectionExecutionContext;
import com.sun.enterprise.iiop.security.GSSUtils;
import com.sun.enterprise.iiop.security.IORToSocketInfoImpl;
import com.sun.enterprise.iiop.security.InvalidIdentityTokenException;
import com.sun.enterprise.iiop.security.InvalidMechanismException;
import com.sun.enterprise.iiop.security.Lookups;
import com.sun.enterprise.iiop.security.SecurityMechanismException;
import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.auth.login.LoginContextDriver;
import com.sun.enterprise.security.auth.login.common.LoginException;
import com.sun.enterprise.security.auth.login.common.PasswordCredential;
import com.sun.enterprise.security.auth.login.common.X509CertificateCredential;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.common.ClientSecurityContext;
import com.sun.enterprise.security.ssl.SSLUtils;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.x500.X500Principal;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.enterprise.iiop.api.GlassFishORBHelper;
import org.glassfish.enterprise.iiop.api.ProtocolManager;
import org.glassfish.hk2.api.PostConstruct;
import org.ietf.jgss.Oid;
import org.jvnet.hk2.annotations.Service;
import org.omg.CORBA.ORB;

@Service
@Singleton
public final class SecurityMechanismSelector
implements PostConstruct {
    private static final Logger LOG = LogDomains.getLogger(SecurityMechanismSelector.class, (String)"jakarta.enterprise.system.core.security", (boolean)false);
    public static final String CLIENT_CONNECTION_CONTEXT = "ClientConnContext";
    private Set<EjbIORConfigurationDescriptor> corbaIORDescSet;
    private boolean sslRequired;
    private ProtocolManager protocolMgr;
    @Inject
    private SSLUtils sslUtils;
    private GlassFishORBHelper orbHelper;
    private ORB orb;
    private CSIV2TaggedComponentInfo ctc;
    @Inject
    private InvocationManager invMgr;
    @Inject
    private ProcessEnvironment processEnv;
    private static final String traceIORsProperty = "com.sun.enterprise.iiop.security.traceIORS";
    private static final boolean _traceIORs = Boolean.getBoolean("com.sun.enterprise.iiop.security.traceIORS");
    private static final Hashtable<Integer, String> assocOptions = new Hashtable();
    private static final Hashtable<Integer, String> identityTokenTypes;

    public void postConstruct() {
        try {
            String clientAuthReq;
            this.orbHelper = Lookups.getGlassFishORBHelper();
            String s = this.orbHelper.getCSIv2Props().getProperty("com.sun.CSIV2.ssl.client.required");
            if (s != null && s.equals("true")) {
                this.sslRequired = true;
            }
            this.corbaIORDescSet = new HashSet<EjbIORConfigurationDescriptor>();
            EjbIORConfigurationDescriptor iorDesc = new EjbIORConfigurationDescriptor();
            EjbIORConfigurationDescriptor iorDesc2 = new EjbIORConfigurationDescriptor();
            String serverSslReqd = this.orbHelper.getCSIv2Props().getProperty("com.sun.CSIV2.ssl.server.required");
            if (serverSslReqd != null && serverSslReqd.equals("true")) {
                iorDesc.setIntegrity("REQUIRED");
                iorDesc.setConfidentiality("REQUIRED");
                iorDesc2.setIntegrity("REQUIRED");
                iorDesc2.setConfidentiality("REQUIRED");
            }
            if ((clientAuthReq = this.orbHelper.getCSIv2Props().getProperty("com.sun.CSIV2.client.auth.required")) != null && clientAuthReq.equals("true")) {
                iorDesc.setEstablishTrustInClient("REQUIRED");
                iorDesc2.setAuthMethodRequired(true);
                this.getCorbaIORDescSet().add(iorDesc2);
            }
            this.getCorbaIORDescSet().add(iorDesc);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "IIOP1005: An exception has occured in the ejb security initialization.", e);
        }
    }

    public ConnectionContext getClientConnectionContext() {
        Hashtable h = ConnectionExecutionContext.getContext();
        ConnectionContext scc = (ConnectionContext)h.get(CLIENT_CONNECTION_CONTEXT);
        return scc;
    }

    public void setClientConnectionContext(ConnectionContext scc) {
        Hashtable h = ConnectionExecutionContext.getContext();
        h.put(CLIENT_CONNECTION_CONTEXT, scc);
    }

    public SocketInfo getSSLPort(IOR ior, ConnectionContext ctx) {
        SocketInfo info = null;
        CompoundSecMech mechanism = null;
        try {
            mechanism = this.selectSecurityMechanism(ior);
        }
        catch (SecurityMechanismException sme) {
            throw new RuntimeException(sme.getMessage());
        }
        ctx.setIOR(ior);
        ctx.setMechanism(mechanism);
        TLS_SEC_TRANS ssl = null;
        if (mechanism != null) {
            ssl = this.getCtc().getSSLInformation(mechanism);
        }
        if (ssl == null) {
            if (this.isSslRequired()) {
                IIOPProfileTemplate templ = (IIOPProfileTemplate)ior.getProfile().getTaggedProfileTemplate();
                IIOPAddress addr = templ.getPrimaryAddress();
                info = IORToSocketInfoImpl.createSocketInfo("SecurityMechanismSelector1", "SSL", addr.getHost(), this.orbHelper.getORBPort(this.orbHelper.getORB()));
                return info;
            }
            return null;
        }
        short targetRequires = ssl.target_requires;
        short targetSupports = ssl.target_supports;
        if (SecurityMechanismSelector.isSet(targetRequires, 2) || SecurityMechanismSelector.isSet(targetRequires, 4) || SecurityMechanismSelector.isSet(targetRequires, 64)) {
            LOG.log(Level.FINE, "Target requires SSL");
            ctx.setSSLUsed(true);
            String type = "SSL";
            if (SecurityMechanismSelector.isSet(targetRequires, 64)) {
                type = "SSL_MUTUALAUTH";
                ctx.setSSLClientAuthenticationOccurred(true);
            }
            short sslport = ssl.addresses[0].port;
            int ssl_port = Utility.shortToInt((short)sslport);
            String host_name = ssl.addresses[0].host_name;
            info = IORToSocketInfoImpl.createSocketInfo("SecurityMechanismSelector2", type, host_name, ssl_port);
            return info;
        }
        if (SecurityMechanismSelector.isSet(targetSupports, 2) || SecurityMechanismSelector.isSet(targetSupports, 4) || SecurityMechanismSelector.isSet(targetSupports, 64)) {
            LOG.log(Level.FINE, "Target supports SSL");
            if (!this.isSslRequired()) {
                return null;
            }
            LOG.log(Level.FINE, "Client is configured to require SSL for the target");
            ctx.setSSLUsed(true);
            short sslport = ssl.addresses[0].port;
            String host_name = ssl.addresses[0].host_name;
            int ssl_port = Utility.shortToInt((short)sslport);
            info = IORToSocketInfoImpl.createSocketInfo("SecurityMechanismSelector3", "SSL", host_name, ssl_port);
            return info;
        }
        if (this.isSslRequired()) {
            throw new RuntimeException("SSL required by client but not supported by server.");
        }
        return null;
    }

    public ORB getOrb() {
        return this.orb;
    }

    public void setOrb(ORB val) {
        this.orb = val;
    }

    public synchronized CSIV2TaggedComponentInfo getCtc() {
        if (this.ctc == null) {
            this.ctc = new CSIV2TaggedComponentInfo(this.orbHelper.getORB());
        }
        return this.ctc;
    }

    public List<SocketInfo> getSSLPorts(IOR ior, ConnectionContext ctx) {
        CompoundSecMech mechanism = null;
        try {
            mechanism = this.selectSecurityMechanism(ior);
        }
        catch (SecurityMechanismException sme) {
            throw new RuntimeException(sme.getMessage());
        }
        ctx.setIOR(ior);
        ctx.setMechanism(mechanism);
        TLS_SEC_TRANS ssl = null;
        if (mechanism != null) {
            ssl = this.getCtc().getSSLInformation(mechanism);
        }
        if (ssl == null) {
            if (this.isSslRequired()) {
                IIOPProfileTemplate templ = (IIOPProfileTemplate)ior.getProfile().getTaggedProfileTemplate();
                IIOPAddress addr = templ.getPrimaryAddress();
                SocketInfo info = IORToSocketInfoImpl.createSocketInfo("SecurityMechanismSelector1", "SSL", addr.getHost(), this.orbHelper.getORBPort(this.orbHelper.getORB()));
                ArrayList<SocketInfo> sInfos = new ArrayList<SocketInfo>();
                sInfos.add(info);
                return sInfos;
            }
            return null;
        }
        short targetRequires = ssl.target_requires;
        short targetSupports = ssl.target_supports;
        if (SecurityMechanismSelector.isSet(targetRequires, 2) || SecurityMechanismSelector.isSet(targetRequires, 4) || SecurityMechanismSelector.isSet(targetRequires, 64)) {
            LOG.log(Level.FINE, "Target requires SSL");
            ctx.setSSLUsed(true);
            String type = "SSL";
            if (SecurityMechanismSelector.isSet(targetRequires, 64)) {
                type = "SSL_MUTUALAUTH";
                ctx.setSSLClientAuthenticationOccurred(true);
            }
            ArrayList<SocketInfo> socketInfos = new ArrayList<SocketInfo>();
            for (TransportAddress element : ssl.addresses) {
                short sslport = element.port;
                int ssl_port = Utility.shortToInt((short)sslport);
                String host_name = element.host_name;
                SocketInfo sInfo = IORToSocketInfoImpl.createSocketInfo("SecurityMechanismSelector2", type, host_name, ssl_port);
                socketInfos.add(sInfo);
            }
            return socketInfos;
        }
        if (SecurityMechanismSelector.isSet(targetSupports, 2) || SecurityMechanismSelector.isSet(targetSupports, 4) || SecurityMechanismSelector.isSet(targetSupports, 64)) {
            LOG.log(Level.FINE, "Target supports SSL");
            if (!this.isSslRequired()) {
                return null;
            }
            LOG.log(Level.FINE, "Client is configured to require SSL for the target");
            ctx.setSSLUsed(true);
            ArrayList<SocketInfo> socketInfos = new ArrayList<SocketInfo>();
            for (TransportAddress element : ssl.addresses) {
                short sslport = element.port;
                int ssl_port = Utility.shortToInt((short)sslport);
                String host_name = element.host_name;
                SocketInfo sInfo = IORToSocketInfoImpl.createSocketInfo("SecurityMechanismSelector3", "SSL", host_name, ssl_port);
                socketInfos.add(sInfo);
            }
            return socketInfos;
        }
        if (this.isSslRequired()) {
            throw new RuntimeException("SSL required by client but not supported by server.");
        }
        return null;
    }

    public SecurityContext selectSecurityContext(IOR ior) throws InvalidIdentityTokenException, InvalidMechanismException, SecurityMechanismException {
        SecurityContext context = null;
        ConnectionContext cc = new ConnectionContext();
        if (SecurityMechanismSelector.traceIORs()) {
            LOG.info("\nCSIv2 Mechanism List: " + this.getSecurityMechanismString(this.ctc, ior));
        }
        this.getSSLPort(ior, cc);
        this.setClientConnectionContext(cc);
        CompoundSecMech mechanism = cc.getMechanism();
        if (mechanism == null) {
            return null;
        }
        boolean sslUsed = cc.getSSLUsed();
        boolean clientAuthOccurred = cc.getSSLClientAuthenticationOccurred();
        if (this.isNotServerOrACC()) {
            context = this.getSecurityContextForAppClient(null, sslUsed, clientAuthOccurred, mechanism);
            return context;
        }
        LOG.log(Level.FINE, "SSL used: {0}, SSL Mutual auth: {1}", new Object[]{sslUsed, clientAuthOccurred});
        ComponentInvocation ci = null;
        context = this.isACC() ? this.getSecurityContextForAppClient(ci, sslUsed, clientAuthOccurred, mechanism) : this.getSecurityContextForWebOrEJB(ci, sslUsed, clientAuthOccurred, mechanism);
        return context;
    }

    public SecurityContext getSecurityContextForAppClient(ComponentInvocation ci, boolean sslUsed, boolean clientAuthOccurred, CompoundSecMech mechanism) throws InvalidMechanismException, InvalidIdentityTokenException, SecurityMechanismException {
        return this.sendUsernameAndPassword(ci, sslUsed, clientAuthOccurred, mechanism);
    }

    public SecurityContext getSecurityContextForWebOrEJB(ComponentInvocation ci, boolean sslUsed, boolean clientAuthOccurred, CompoundSecMech mechanism) throws InvalidMechanismException, InvalidIdentityTokenException, SecurityMechanismException {
        SecurityContext ctx = null;
        ctx = !sslUsed ? this.propagateIdentity(false, ci, mechanism) : this.propagateIdentity(clientAuthOccurred, ci, mechanism);
        return ctx;
    }

    Object getSSLSocketInfo(Object ior) {
        ConnectionContext ctx = new ConnectionContext();
        List<SocketInfo> socketInfo = this.getSSLPorts((IOR)ior, ctx);
        this.setClientConnectionContext(ctx);
        return socketInfo;
    }

    private boolean isMechanismSupported(SAS_ContextSec sas) {
        byte[][] mechanisms = sas.supported_naming_mechanisms;
        byte[] mechSupported = GSSUtils.getMechanism();
        if (mechanisms == null) {
            return false;
        }
        for (byte[] mechanism : mechanisms) {
            if (!Arrays.equals(mechSupported, mechanism)) continue;
            return true;
        }
        return false;
    }

    public boolean isIdentityTypeSupported(SAS_ContextSec sas) {
        int ident_token = sas.supported_identity_types;
        int value = ident_token & 0xF;
        return value != 0;
    }

    private SecurityContext sendUsernameAndPassword(ComponentInvocation ci, boolean sslUsed, boolean clientAuthOccurred, CompoundSecMech mechanism) throws SecurityMechanismException {
        SecurityContext ctx = null;
        if (mechanism == null) {
            return null;
        }
        AS_ContextSec asContext = mechanism.as_context_mech;
        if (!(SecurityMechanismSelector.isSet(asContext.target_requires, 64) || SecurityMechanismSelector.isSet(mechanism.target_requires, 64) && !clientAuthOccurred)) {
            return null;
        }
        ctx = this.getUsernameAndPassword(ci, mechanism);
        LOG.log(Level.FINE, "Sending Username/Password");
        return ctx;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SecurityContext propagateIdentity(boolean clientAuth, ComponentInvocation ci, CompoundSecMech mechanism) throws InvalidIdentityTokenException, InvalidMechanismException, SecurityMechanismException {
        SecurityContext ctx = null;
        if (mechanism == null) {
            return null;
        }
        AS_ContextSec asContext = mechanism.as_context_mech;
        SAS_ContextSec sasContext = mechanism.sas_context_mech;
        LOG.log(Level.FINE, "SAS CONTEXT's target_requires={0}", sasContext.target_requires);
        LOG.log(Level.FINE, "SAS CONTEXT's target_supports={1}", sasContext.target_supports);
        if (SecurityMechanismSelector.isSet(asContext.target_requires, 64)) {
            ctx = this.getUsernameAndPassword(ci, mechanism);
            if (ctx.authcls != null) return ctx;
            throw new SecurityMechanismException("Cannot propagate username/password required by target when using run as identity");
        }
        if (SecurityMechanismSelector.isSet(sasContext.target_supports, 1024) || SecurityMechanismSelector.isSet(sasContext.target_requires, 1024)) {
            if (!this.isIdentityTypeSupported(sasContext)) {
                throw new InvalidIdentityTokenException("The given identity token is unsupported.");
            }
            if (sasContext.target_supports != 1024) return this.getIdentity();
            if (this.isMechanismSupported(sasContext)) return this.getIdentity();
            throw new InvalidMechanismException("The given mechanism type is unsupported.");
        }
        if (!SecurityMechanismSelector.isSet(asContext.target_supports, 64)) return null;
        if (!clientAuth) return null;
        ctx = this.getUsernameAndPassword(ci, mechanism);
        if (ctx.authcls != null) return ctx;
        return null;
    }

    private SecurityContext getUsernameAndPassword(ComponentInvocation ci, CompoundSecMech mechanism) throws SecurityMechanismException {
        try {
            Subject s = null;
            if (this.isNotServerOrACC()) {
                sc = ClientSecurityContext.getCurrent();
                if (sc == null) {
                    return null;
                }
                s = sc.getSubject();
                LOG.log(Level.FINE, "SUBJECT: {0}", s);
            } else {
                s = this.isACC() ? ((sc = ClientSecurityContext.getCurrent()) == null ? LoginContextDriver.doClientLogin((int)1, (CallbackHandler)SecurityServicesUtil.getInstance().getCallbackHandler()) : sc.getSubject()) : this.getSubjectFromSecurityCurrent();
            }
            SecurityContext ctx = new SecurityContext();
            Subject sub = s;
            ctx.subject = s;
            PrivilegedAction<Set> action = () -> sub.getPrivateCredentials(PasswordCredential.class);
            Set privateCredSet = AccessController.doPrivileged(action);
            if (privateCredSet.isEmpty()) {
                LOG.log(Level.FINE, "No private credential run as mode");
                ctx.authcls = null;
                ctx.identcls = GSSUPName.class;
            } else {
                AS_ContextSec asContext = mechanism.as_context_mech;
                byte[] target_name = asContext.target_name;
                byte[] _realm = null;
                _realm = target_name == null || target_name.length == 0 ? Realm.getDefaultRealm().getBytes() : GSSUtils.importName(GSSUtils.GSSUP_MECH_OID, target_name);
                String realm_name = new String(_realm);
                Iterator it = privateCredSet.iterator();
                while (it.hasNext()) {
                    PrivilegedAction<Void> action2 = () -> {
                        PasswordCredential pc = (PasswordCredential)it.next();
                        pc.setRealm(realm_name);
                        return null;
                    };
                    AccessController.doPrivileged(action2);
                }
                ctx.authcls = PasswordCredential.class;
            }
            return ctx;
        }
        catch (LoginException le) {
            throw le;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "IIOP1001: Exception getting username and password", e);
            return null;
        }
    }

    private SecurityContext getIdentity() throws SecurityMechanismException {
        Subject s;
        SecurityContext ctx;
        LOG.log(Level.FINE, "Getting PRINCIPAL/DN from TLS");
        SecurityContext sCtx = ctx = new SecurityContext();
        com.sun.enterprise.security.SecurityContext scontext = com.sun.enterprise.security.SecurityContext.getCurrent();
        if (scontext == null || scontext.didServerGenerateCredentials()) {
            sCtx.identcls = AnonCredential.class;
            PrivilegedAction<Void> action = () -> {
                Subject sub;
                sCtx.subject = sub = new Subject();
                sCtx.subject.getPublicCredentials().add(new AnonCredential());
                return null;
            };
            AccessController.doPrivileged(action);
            return sCtx;
        }
        ctx.subject = s = this.getSubjectFromSecurityCurrent();
        Subject sub = s;
        PrivilegedAction<Set> action = () -> sub.getPrivateCredentials(PasswordCredential.class);
        Set credSet = AccessController.doPrivileged(action);
        if (credSet.size() == 1) {
            Subject subj;
            ctx.identcls = GSSUPName.class;
            Set cs = credSet;
            PrivilegedAction<Subject> action2 = () -> {
                Subject ss = new Subject();
                Iterator iter = cs.iterator();
                PasswordCredential pc = (PasswordCredential)iter.next();
                GSSUPName gssname = new GSSUPName(pc.getUser(), pc.getRealm());
                ss.getPublicCredentials().add(gssname);
                return ss;
            };
            ctx.subject = subj = AccessController.doPrivileged(action2);
            return ctx;
        }
        Set<Object> pubCredSet = s.getPublicCredentials();
        if (pubCredSet.size() != 1) {
            LOG.log(Level.SEVERE, "IIOP1002: Principal propagation: Cannot find principal information in subject");
            return null;
        }
        Iterator<Object> credIter = pubCredSet.iterator();
        if (credIter.hasNext()) {
            Object o = credIter.next();
            ctx.identcls = o instanceof GSSUPName ? GSSUPName.class : (o instanceof X500Principal ? X500Principal.class : X509CertificateCredential.class);
        } else {
            LOG.log(Level.SEVERE, "IIOP1003: Principal propagation: Cannot find credential information in subject.");
            return null;
        }
        return ctx;
    }

    private Subject getSubjectFromSecurityCurrent() throws SecurityMechanismException {
        com.sun.enterprise.security.SecurityContext sc = null;
        sc = com.sun.enterprise.security.SecurityContext.getCurrent();
        if (sc == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, " SETTING GUEST ---");
            }
            sc = com.sun.enterprise.security.SecurityContext.init();
        }
        if (sc == null) {
            throw new SecurityMechanismException("Could not find  security information");
        }
        Subject s = sc.getSubject();
        if (s == null) {
            throw new SecurityMechanismException("Could not find  subject information in the security context.");
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Subject in security current:" + String.valueOf(s));
        }
        return s;
    }

    public CompoundSecMech selectSecurityMechanism(IOR ior) throws SecurityMechanismException {
        CompoundSecMech[] mechList = this.getCtc().getSecurityMechanisms(ior);
        CompoundSecMech mech = this.selectSecurityMechanism(mechList);
        return mech;
    }

    private CompoundSecMech selectSecurityMechanism(CompoundSecMech[] mechList) throws SecurityMechanismException {
        if (mechList == null || mechList.length == 0) {
            return null;
        }
        CompoundSecMech mech = null;
        for (CompoundSecMech element : mechList) {
            mech = element;
            boolean useMech = this.useMechanism(mech);
            if (!useMech) continue;
            return mech;
        }
        throw new SecurityMechanismException("Cannot use any of the  target's supported mechanisms");
    }

    private boolean useMechanism(CompoundSecMech mech) {
        boolean val = true;
        TLS_SEC_TRANS tls = this.getCtc().getSSLInformation(mech);
        if (mech.sas_context_mech.supported_naming_mechanisms.length > 0 && !this.isMechanismSupported(mech.sas_context_mech)) {
            return false;
        }
        if (mech.as_context_mech.client_authentication_mech.length > 0 && !this.isMechanismSupportedAS(mech.as_context_mech)) {
            return false;
        }
        if (tls == null) {
            return true;
        }
        short targetRequires = tls.target_requires;
        if (SecurityMechanismSelector.isSet(targetRequires, 64) && !this.sslUtils.isKeyAvailable()) {
            val = false;
        }
        return val;
    }

    private boolean isMechanismSupportedAS(AS_ContextSec as) {
        byte[] mechanism = as.client_authentication_mech;
        byte[] mechSupported = GSSUtils.getMechanism();
        if (mechanism == null) {
            return false;
        }
        return Arrays.equals(mechanism, mechSupported);
    }

    private byte[] getTargetName(Subject subj) {
        byte[] tgt_name = new byte[]{};
        final Subject sub = subj;
        final Set credset = AccessController.doPrivileged(new PrivilegedAction<Set>(){

            @Override
            public Set run() {
                return sub.getPrivateCredentials(PasswordCredential.class);
            }
        });
        if (credset.size() == 1) {
            tgt_name = AccessController.doPrivileged(new PrivilegedAction<byte[]>(){

                @Override
                public byte[] run() {
                    Iterator iter = credset.iterator();
                    PasswordCredential pc = (PasswordCredential)iter.next();
                    return pc.getTargetName();
                }
            });
        }
        return tgt_name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean evaluate_client_conformance_ssl(EjbIORConfigurationDescriptor iordesc, boolean ssl_used, X509Certificate[] certchain) {
        try {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "SecurityMechanismSelector.evaluate_client_conformance_ssl->:");
            }
            boolean ssl_required = false;
            boolean ssl_supported = false;
            int ssl_target_requires = 0;
            int ssl_target_supports = 0;
            ssl_target_requires = this.getCtc().getTargetRequires(iordesc);
            ssl_target_supports = this.getCtc().getTargetSupports(iordesc);
            ssl_required = SecurityMechanismSelector.isSet(ssl_target_requires, 2) || SecurityMechanismSelector.isSet(ssl_target_requires, 4) || SecurityMechanismSelector.isSet(ssl_target_requires, 64);
            ssl_supported = ssl_target_supports != 0;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "SecurityMechanismSelector.evaluate_client_conformance_ssl: " + SecurityMechanismSelector.isSet(ssl_target_requires, 2) + " " + SecurityMechanismSelector.isSet(ssl_target_requires, 4) + " " + SecurityMechanismSelector.isSet(ssl_target_requires, 64) + " " + ssl_required + " " + ssl_supported + " " + ssl_used);
            }
            if (ssl_used) {
                if (!ssl_required && !ssl_supported) {
                    boolean bl = false;
                    return bl;
                }
            } else if (ssl_required) {
                boolean bl = false;
                return bl;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "SecurityMechanismSelector.evaluate_client_conformance_ssl: " + SecurityMechanismSelector.isSet(ssl_target_requires, 64) + " " + SecurityMechanismSelector.isSet(ssl_target_supports, 64));
            }
            if (certchain != null) {
                if (!SecurityMechanismSelector.isSet(ssl_target_requires, 64) && !SecurityMechanismSelector.isSet(ssl_target_supports, 64)) {
                    boolean bl = false;
                    return bl;
                }
            } else if (SecurityMechanismSelector.isSet(ssl_target_requires, 64)) {
                boolean bl = false;
                return bl;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "SecurityMechanismSelector.evaluate_client_conformance_ssl: true");
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "SecurityMechanismSelector.evaluate_client_conformance_ssl<-:");
            }
        }
    }

    private boolean evaluate_client_conformance_ascontext(SecurityContext ctx, EjbIORConfigurationDescriptor iordesc, String realmName) {
        boolean client_authenticated = false;
        AS_ContextSec ascontext = null;
        try {
            ascontext = this.getCtc().createASContextSec(iordesc, realmName);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "IIOP1000: Exception creating ASContext", e);
            return false;
        }
        client_authenticated = ctx != null && ctx.authcls != null && ctx.subject != null;
        if (client_authenticated) {
            if (!SecurityMechanismSelector.isSet(ascontext.target_requires, 64) && !SecurityMechanismSelector.isSet(ascontext.target_supports, 64)) {
                return false;
            }
            byte[] client_tgtname = this.getTargetName(ctx.subject);
            if (ascontext.target_name.length != client_tgtname.length) {
                return false;
            }
            for (int i = 0; i < ascontext.target_name.length; ++i) {
                if (ascontext.target_name[i] == client_tgtname[i]) continue;
                return false;
            }
        } else if (SecurityMechanismSelector.isSet(ascontext.target_requires, 64)) {
            return false;
        }
        return true;
    }

    private boolean evaluate_client_conformance_sascontext(SecurityContext ctx, EjbIORConfigurationDescriptor iordesc) {
        boolean caller_propagated = false;
        SAS_ContextSec sascontext = null;
        try {
            sascontext = this.getCtc().createSASContextSec(iordesc);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to create SAS_ContextSec", e);
            return false;
        }
        caller_propagated = ctx != null && ctx.identcls != null && ctx.subject != null;
        if (caller_propagated) {
            return SecurityMechanismSelector.isSet(sascontext.target_supports, 1024);
        }
        return true;
    }

    private boolean evaluate_client_conformance(SecurityContext ctx, byte[] object_id, boolean ssl_used, X509Certificate[] certchain) {
        if (object_id == null) {
            return true;
        }
        if (this.protocolMgr == null) {
            this.protocolMgr = this.orbHelper.getProtocolManager();
        }
        if (this.protocolMgr == null) {
            return true;
        }
        EjbDescriptor ejbDesc = this.protocolMgr.getEjbDescriptor(object_id);
        Set<EjbIORConfigurationDescriptor> iorDescSet = null;
        iorDescSet = ejbDesc != null ? ejbDesc.getIORConfigurationDescriptors() : this.getCorbaIORDescSet();
        LOG.log(Level.FINE, "SecurityMechanismSelector.evaluate_client_conformance: iorDescSet: {0}", iorDescSet);
        if (iorDescSet.isEmpty()) {
            return true;
        }
        boolean checkSkipped = false;
        for (EjbIORConfigurationDescriptor element : iorDescSet) {
            EjbIORConfigurationDescriptor iorDesc = element;
            if (this.skip_client_conformance(iorDesc)) {
                LOG.log(Level.FINE, "skip_client_conformance");
                checkSkipped = true;
                continue;
            }
            if (!this.evaluate_client_conformance_ssl(iorDesc, ssl_used, certchain)) {
                LOG.log(Level.FINE, "evaluate_client_conformance_ssl");
                checkSkipped = false;
                continue;
            }
            String realmName = "default";
            if (ejbDesc != null && ejbDesc.getApplication() != null) {
                realmName = ejbDesc.getApplication().getRealm();
            }
            if (realmName == null) {
                realmName = iorDesc.getRealmName();
            }
            if (realmName == null) {
                realmName = "default";
            }
            if (!this.evaluate_client_conformance_ascontext(ctx, iorDesc, realmName)) {
                LOG.log(Level.FINE, "evaluate_client_conformance_ascontext");
                checkSkipped = false;
                continue;
            }
            if (!this.evaluate_client_conformance_sascontext(ctx, iorDesc)) {
                LOG.log(Level.FINE, " evaluate_client_conformance_sascontext");
                checkSkipped = false;
                continue;
            }
            return true;
        }
        return checkSkipped;
    }

    private boolean skip_client_conformance(EjbIORConfigurationDescriptor ior) {
        String none = "NONE";
        if (ior == null) {
            return false;
        }
        if (!none.equalsIgnoreCase(ior.getIntegrity())) {
            return false;
        }
        if (!none.equalsIgnoreCase(ior.getConfidentiality())) {
            return false;
        }
        if (!none.equalsIgnoreCase(ior.getEstablishTrustInClient())) {
            return false;
        }
        if (ior.isAuthMethodRequired()) {
            return false;
        }
        return none.equalsIgnoreCase(ior.getCallerPropagation());
    }

    public SecurityContext evaluateTrust(SecurityContext ctx, byte[] object_id, Socket socket) throws SecurityMechanismException {
        Long ClientID;
        SecurityContext ssc = null;
        boolean ssl_used = false;
        X509Certificate[] certChain = null;
        if (socket != null && socket instanceof SSLSocket) {
            ssl_used = true;
            SSLSocket sslSock = (SSLSocket)socket;
            SSLSession sslSession = sslSock.getSession();
            try {
                certChain = (X509Certificate[])sslSession.getPeerCertificates();
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "Cannot retrieve peer certificates", e);
            }
        }
        if ((ClientID = ConnectionExecutionContext.readClientThreadID()) != null && ClientID.longValue() == Thread.currentThread().getId() && ctx == null) {
            return null;
        }
        if (!this.evaluate_client_conformance(ctx, object_id, ssl_used, certChain)) {
            throw new SecurityMechanismException("Trust evaluation failed because client does not conform to configured security policies");
        }
        if (ctx == null) {
            if (socket == null || !ssl_used || certChain == null) {
                return null;
            }
            ssc = new SecurityContext();
            X500Principal x500principal = certChain[0].getSubjectX500Principal();
            ssc.subject = new Subject();
            ssc.subject.getPublicCredentials().add(x500principal);
            ssc.identcls = X500Principal.class;
            ssc.authcls = null;
            return ssc;
        }
        ssc = ctx;
        Class authCls = ctx.authcls;
        Class identCls = ctx.identcls;
        ssc.authcls = null;
        ssc.identcls = null;
        if (identCls != null) {
            ssc.identcls = identCls;
        } else if (authCls != null) {
            ssc.authcls = authCls;
        } else {
            ssc.identcls = AnonCredential.class;
        }
        return ssc;
    }

    private static boolean isSet(int val1, int val2) {
        return (val1 & val2) == val2;
    }

    private Set<EjbIORConfigurationDescriptor> getCorbaIORDescSet() {
        return this.corbaIORDescSet;
    }

    public boolean isSslRequired() {
        return this.sslRequired;
    }

    private boolean isNotServerOrACC() {
        return this.processEnv.getProcessType().equals((Object)ProcessEnvironment.ProcessType.Other);
    }

    private boolean isACC() {
        return this.processEnv.getProcessType().equals((Object)ProcessEnvironment.ProcessType.ACC);
    }

    public static boolean traceIORs() {
        return _traceIORs;
    }

    public String getSecurityMechanismString(CSIV2TaggedComponentInfo tCI, IOR ior) {
        String typeId = ior.getTypeId();
        CompoundSecMech[] mechList = tCI.getSecurityMechanisms(ior);
        return SecurityMechanismSelector.getSecurityMechanismString(tCI, mechList, typeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSecurityMechanismString(CSIV2TaggedComponentInfo tCI, CompoundSecMech[] list, String name) {
        StringBuffer b = new StringBuffer();
        b.append("\ntypeId: " + name);
        try {
            for (int i = 0; list != null && i < list.length; ++i) {
                Integer j;
                SAS_ContextSec sasContext;
                AS_ContextSec asContext;
                CompoundSecMech m = list[i];
                b.append("\nCSIv2 CompoundSecMech[" + i + "]\n\tTarget Requires:");
                Enumeration<Integer> keys = assocOptions.keys();
                while (keys.hasMoreElements()) {
                    Integer j2 = keys.nextElement();
                    if (!SecurityMechanismSelector.isSet(m.target_requires, j2)) continue;
                    b.append("\n\t\t" + assocOptions.get(j2));
                }
                TLS_SEC_TRANS ssl = tCI.getSSLInformation(m);
                if (ssl != null) {
                    Integer j3;
                    b.append("\n\tTLS_SEC_TRANS\n\t\tTarget Requires:");
                    keys = assocOptions.keys();
                    while (keys.hasMoreElements()) {
                        j3 = keys.nextElement();
                        if (!SecurityMechanismSelector.isSet(ssl.target_requires, j3)) continue;
                        b.append("\n\t\t\t" + assocOptions.get(j3));
                    }
                    b.append("\n\t\tTarget Supports:");
                    keys = assocOptions.keys();
                    while (keys.hasMoreElements()) {
                        j3 = keys.nextElement();
                        if (!SecurityMechanismSelector.isSet(ssl.target_supports, j3)) continue;
                        b.append("\n\t\t\t" + assocOptions.get(j3));
                    }
                    TransportAddress[] aList = ssl.addresses;
                    for (int j4 = 0; j4 < aList.length; ++j4) {
                        TransportAddress a = aList[j4];
                        b.append("\n\t\tAddress[" + j4 + "] Host Name: " + a.host_name + " port: " + a.port);
                    }
                }
                if ((asContext = m.as_context_mech) != null) {
                    b.append("\n\tAS_ContextSec\n\t\tTarget Requires:");
                    keys = assocOptions.keys();
                    while (keys.hasMoreElements()) {
                        Integer j5 = keys.nextElement();
                        if (!SecurityMechanismSelector.isSet(asContext.target_requires, j5)) continue;
                        b.append("\n\t\t\t" + assocOptions.get(j5));
                    }
                    b.append("\n\t\tTarget Supports:");
                    keys = assocOptions.keys();
                    while (keys.hasMoreElements()) {
                        Integer j6 = keys.nextElement();
                        if (!SecurityMechanismSelector.isSet(asContext.target_supports, j6)) continue;
                        b.append("\n\t\t\t" + assocOptions.get(j6));
                    }
                    try {
                        if (asContext.client_authentication_mech.length > 0) {
                            Oid oid = new Oid(asContext.client_authentication_mech);
                            b.append("\n\t\tclient_auth_mech_OID:" + String.valueOf(oid));
                        } else {
                            b.append("\n\t\tclient_auth_mech_OID: undefined");
                        }
                    }
                    catch (Exception e) {
                        b.append("\n\t\tclient_auth_mech_OID: (invalid)" + e.getMessage());
                    }
                    finally {
                        b.append("\n\t\ttarget_name:" + new String(asContext.target_name));
                    }
                }
                if ((sasContext = m.sas_context_mech) == null) continue;
                b.append("\n\tSAS_ContextSec\n\t\tTarget Requires:");
                keys = assocOptions.keys();
                while (keys.hasMoreElements()) {
                    j = keys.nextElement();
                    if (!SecurityMechanismSelector.isSet(sasContext.target_requires, j)) continue;
                    b.append("\n\t\t\t" + assocOptions.get(j));
                }
                b.append("\n\t\tTarget Supports:");
                keys = assocOptions.keys();
                while (keys.hasMoreElements()) {
                    j = keys.nextElement();
                    if (!SecurityMechanismSelector.isSet(sasContext.target_supports, j)) continue;
                    b.append("\n\t\t\t" + assocOptions.get(j));
                }
                b.append("\n\t\tprivilege authorities:" + Arrays.toString(sasContext.privilege_authorities));
                byte[][] nameTypes = sasContext.supported_naming_mechanisms;
                for (int j7 = 0; j7 < nameTypes.length; ++j7) {
                    try {
                        if (nameTypes[j7].length > 0) {
                            Oid oid = new Oid(nameTypes[j7]);
                            b.append("\n\t\tSupported Naming Mechanim[" + j7 + "]: " + String.valueOf(oid));
                            continue;
                        }
                        b.append("\n\t\tSupported Naming Mechanim[" + j7 + "]:  undefined");
                        continue;
                    }
                    catch (Exception e) {
                        b.append("\n\t\tSupported Naming Mechanism[" + j7 + "]: (invalid)" + e.getMessage());
                    }
                }
                b.append("\n\t\tsupported Identity Types:");
                long map = sasContext.supported_identity_types;
                keys = identityTokenTypes.keys();
                while (keys.hasMoreElements()) {
                    Integer j8 = keys.nextElement();
                    if (!SecurityMechanismSelector.isSet(sasContext.supported_identity_types, j8)) continue;
                    b.append("\n\t\t\t" + identityTokenTypes.get(j8));
                    map -= (long)j8.intValue();
                }
                if (map <= 0L) continue;
                b.append("\n\t\t\tcustom bits set: " + map);
            }
            b.append("\n\n");
        }
        catch (Exception e) {
            String msg = "Unexpected exception during IOR tracing - unset Property: com.sun.enterprise.iiop.security.traceIORS";
            LOG.log(Level.SEVERE, msg, e);
            return msg;
        }
        return b.toString();
    }

    static {
        assocOptions.put(2, "Integrity");
        assocOptions.put(4, "Confidentiality");
        assocOptions.put(32, "EstablishTrustInTarget");
        assocOptions.put(64, "EstablishTrustInClient");
        assocOptions.put(1024, "IdentityAssertion");
        assocOptions.put(2048, "DelegationByClient");
        identityTokenTypes = new Hashtable();
        identityTokenTypes.put(1, "Anonymous");
        identityTokenTypes.put(2, "PrincipalName");
        identityTokenTypes.put(4, "X509CertChain");
        identityTokenTypes.put(8, "DistinguishedName");
    }
}

