/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.policy.mls;

import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.policy.MLSPolicy;
import com.sun.xml.wss.impl.policy.mls.SignatureTarget;
import com.sun.xml.wss.impl.policy.mls.Target;
import com.sun.xml.wss.impl.policy.mls.WSSKeyBindingExtension;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import java.util.ArrayList;

public class SignaturePolicy
extends WSSKeyBindingExtension {
    public SignaturePolicy() {
        this.setPolicyIdentifier("SignaturePolicy");
        this._featureBinding = new FeatureBinding();
    }

    @Override
    public Object clone() {
        SignaturePolicy policy = new SignaturePolicy();
        try {
            WSSPolicy fBinding = (WSSPolicy)this.getFeatureBinding();
            WSSPolicy kBinding = (WSSPolicy)this.getKeyBinding();
            if (fBinding != null) {
                policy.setFeatureBinding((MLSPolicy)fBinding.clone());
            }
            if (kBinding != null) {
                policy.setKeyBinding((MLSPolicy)kBinding.clone());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return policy;
    }

    @Override
    public boolean equals(WSSPolicy policy) {
        boolean _assert = false;
        try {
            return this.equalsIgnoreTargets(policy);
        }
        catch (Exception exception) {
            return _assert;
        }
    }

    @Override
    public boolean equalsIgnoreTargets(WSSPolicy policy) {
        boolean _assert = false;
        try {
            if (!PolicyTypeUtil.signaturePolicy(policy)) {
                return false;
            }
            SignaturePolicy sPolicy = (SignaturePolicy)policy;
            _assert = ((WSSPolicy)this.getFeatureBinding()).equalsIgnoreTargets((WSSPolicy)sPolicy.getFeatureBinding());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return _assert;
    }

    @Override
    public String getType() {
        return "SignaturePolicy";
    }

    public static class FeatureBinding
    extends WSSPolicy {
        String _canonicalizationAlgorithm = "";
        private SignatureTarget timestamp = null;
        final ArrayList _targets = new ArrayList();
        private boolean isEndorsingSignature = false;
        private boolean isPrimarySignature = false;
        private boolean disableInclusivePrefix = false;

        public FeatureBinding() {
            this.setPolicyIdentifier("SignaturePolicy.FeatureBinding");
        }

        public FeatureBinding(String canonicalization) {
            this();
            this._canonicalizationAlgorithm = canonicalization;
        }

        public String getCanonicalizationAlgorithm() {
            return this._canonicalizationAlgorithm;
        }

        public void setCanonicalizationAlgorithm(String canonicalization) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set CanonicalizationAlgorithm : Policy is ReadOnly");
            }
            if (this.isBSP() && canonicalization != "http://www.w3.org/2001/10/xml-exc-c14n#") {
                throw new RuntimeException("Does not meet BSP requirement: 5404. C14n algorithm must be exc-c14n");
            }
            this._canonicalizationAlgorithm = canonicalization;
        }

        public boolean includeTimestamp() {
            return this.timestamp != null;
        }

        public void includeTimestamp(boolean include) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set includeTimestamp Flag : Policy is ReadOnly");
            }
            if (include) {
                if (this.timestamp == null) {
                    this.timestamp = new SignatureTarget();
                    this.timestamp.setType("qname");
                    this.timestamp.setValue("{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Timestamp");
                    this.timestamp.setDigestAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1");
                    this._targets.add(0, this.timestamp);
                }
            } else if (this.timestamp != null) {
                int idx = this._targets.indexOf(this.timestamp);
                this._targets.remove(idx);
                this.timestamp = null;
            }
        }

        public void isEndorsingSignature(boolean isEndorsingSignature) {
            this.isEndorsingSignature = isEndorsingSignature;
        }

        public boolean isEndorsingSignature() {
            return this.isEndorsingSignature;
        }

        public void isPrimarySignature(boolean isPrimarySignature) {
            this.isPrimarySignature = isPrimarySignature;
        }

        public boolean isPrimarySignature() {
            return this.isPrimarySignature;
        }

        public boolean getDisableInclusivePrefix() {
            return this.disableInclusivePrefix;
        }

        public void setDisbaleInclusivePrefix(boolean disableInclusivePrefix) {
            this.disableInclusivePrefix = disableInclusivePrefix;
        }

        public ArrayList getTargetBindings() {
            return this._targets;
        }

        public void addTargetBinding(SignatureTarget target) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not add Target : Policy is ReadOnly");
            }
            this._targets.add(target);
        }

        public void addTargetBinding(Target target) {
            this.addTargetBinding(new SignatureTarget(target));
        }

        public void removeTargetBindings(ArrayList targets) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not remove Target : Policy is ReadOnly");
            }
            this._targets.removeAll(targets);
        }

        @Override
        public boolean equals(WSSPolicy binding) {
            try {
                boolean b1;
                if (!PolicyTypeUtil.signaturePolicyFeatureBinding(binding)) {
                    return false;
                }
                FeatureBinding policy = (FeatureBinding)binding;
                boolean bl = b1 = this._canonicalizationAlgorithm.equals("") || this._canonicalizationAlgorithm.equals(policy.getCanonicalizationAlgorithm());
                if (!b1) {
                    return false;
                }
                boolean b2 = this._targets.equals(policy.getTargetBindings());
                if (!b2) {
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }

        @Override
        public boolean equalsIgnoreTargets(WSSPolicy binding) {
            boolean assrt = false;
            if (!PolicyTypeUtil.signaturePolicyFeatureBinding(binding)) {
                return false;
            }
            try {
                FeatureBinding policy = (FeatureBinding)binding;
                assrt = this._canonicalizationAlgorithm.equals(policy.getCanonicalizationAlgorithm());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return assrt;
        }

        @Override
        public Object clone() {
            FeatureBinding binding = new FeatureBinding();
            try {
                WSSPolicy kBinding = (WSSPolicy)this.getKeyBinding();
                WSSPolicy fBinding = (WSSPolicy)this.getFeatureBinding();
                if (fBinding != null) {
                    binding.setFeatureBinding((MLSPolicy)fBinding.clone());
                }
                if (kBinding != null) {
                    binding.setKeyBinding((MLSPolicy)kBinding.clone());
                }
                binding.setCanonicalizationAlgorithm(this.getCanonicalizationAlgorithm());
                for (SignatureTarget target : this.getTargetBindings()) {
                    binding.addTargetBinding((SignatureTarget)target.clone());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return binding;
        }

        @Override
        public String getType() {
            return "SignaturePolicy.FeatureBinding";
        }
    }
}

