/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.queries.DatabaseQueryMechanism;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.ConstructorReportItem;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.UpdateAllQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;

public class DatasourceCallQueryMechanism
extends DatabaseQueryMechanism {
    protected DatasourceCall call;
    protected List<DatasourceCall> calls;

    public DatasourceCallQueryMechanism() {
    }

    public DatasourceCallQueryMechanism(DatabaseQuery query) {
        super(query);
    }

    public DatasourceCallQueryMechanism(DatabaseQuery query, DatasourceCall call) {
        super(query);
        this.call = call;
        call.setQuery(query);
    }

    public void addCall(DatasourceCall call) {
        this.getCalls().add(call);
        call.setQuery(this.getQuery());
    }

    @Override
    public DatabaseQueryMechanism clone(DatabaseQuery queryClone) {
        DatasourceCallQueryMechanism clone = (DatasourceCallQueryMechanism)super.clone(queryClone);
        if (this.call != null) {
            DatasourceCall callclone = this.call.clone();
            clone.setCall(callclone);
        }
        if (this.calls != null) {
            List callsclone = (List)((ArrayList)this.calls).clone();
            clone.setCalls(callsclone);
        }
        return clone;
    }

    @Override
    public DatabaseCall cursorSelectAllRows() throws DatabaseException {
        try {
            return (DatabaseCall)this.executeCall();
        }
        catch (ClassCastException e) {
            throw QueryException.mustUseCursorStreamPolicy();
        }
    }

    public DatabaseCall selectResultSet() throws DatabaseException {
        try {
            AbstractSession sessionToUse = this.query.getExecutionSession();
            DatabaseCall clonedCall = (DatabaseCall)this.call.clone();
            clonedCall.setQuery(this.query);
            clonedCall.translate(this.query.getTranslationRow(), this.getModifyRow(), sessionToUse);
            clonedCall.returnCursor();
            return (DatabaseCall)sessionToUse.executeCall(clonedCall, this.query.getTranslationRow(), this.query);
        }
        catch (ClassCastException e) {
            throw QueryException.invalidDatabaseCall(this.call);
        }
    }

    @Override
    public Integer deleteAll() throws DatabaseException {
        if (((DeleteAllQuery)this.query).isPreparedUsingTempStorage()) {
            return this.deleteAllUsingTempTables();
        }
        if (this.hasMultipleCalls()) {
            Integer returnedRowCount = null;
            for (int index = this.getCalls().size() - 1; index >= 0; --index) {
                DatasourceCall databseCall = this.getCalls().get(index);
                returnedRowCount = (Integer)this.executeCall(databseCall);
            }
            return returnedRowCount;
        }
        return (Integer)this.executeCall();
    }

    public Integer deleteAllUsingTempTables() throws DatabaseException {
        DatasourceCall databseCall2;
        DatabaseException ex = null;
        Integer returnedRowCount = null;
        try {
            databseCall2 = this.getCalls().get(this.getCalls().size() - 1);
            this.executeCall(databseCall2);
        }
        catch (DatabaseException databseCall2) {
            // empty catch block
        }
        try {
            databseCall2 = this.getCalls().get(this.getCalls().size() - 2);
            this.executeCall(databseCall2);
        }
        catch (DatabaseException databaseEx) {
            ex = databaseEx;
        }
        for (int index = this.getCalls().size() - 3; index >= 1 && ex == null; --index) {
            DatasourceCall databseCall3 = this.getCalls().get(index);
            try {
                returnedRowCount = (Integer)this.executeCall(databseCall3);
                continue;
            }
            catch (DatabaseException databaseEx) {
                ex = databaseEx;
            }
        }
        try {
            DatasourceCall databseCall4 = this.getCalls().get(0);
            this.executeCall(databseCall4);
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
        if (ex != null) {
            throw ex;
        }
        return returnedRowCount;
    }

    @Override
    public Integer deleteObject() throws DatabaseException {
        if (this.hasMultipleCalls()) {
            Integer returnedRowCount = null;
            for (int index = this.getCalls().size() - 1; index >= 0; --index) {
                DatasourceCall databseCall = this.getCalls().get(index);
                Integer rowCount = (Integer)this.executeCall(databseCall);
                if (index != this.getCalls().size() - 1 && rowCount > 0) continue;
                returnedRowCount = rowCount;
            }
            return returnedRowCount;
        }
        return (Integer)this.executeCall();
    }

    @Override
    public Object execute() throws DatabaseException {
        return this.executeCall();
    }

    protected Object executeCall() throws DatabaseException {
        return this.executeCall(this.call);
    }

    protected Object executeCall(DatasourceCall databaseCall) throws DatabaseException {
        AbstractSession sessionToUse = this.query.getExecutionSession();
        DatasourceCall clonedCall = databaseCall.clone();
        clonedCall.setQuery(this.query);
        clonedCall.translate(this.query.getTranslationRow(), this.getModifyRow(), sessionToUse);
        return sessionToUse.executeCall(clonedCall, this.query.getTranslationRow(), this.query);
    }

    @Override
    public Object executeNoSelect() throws DatabaseException {
        if (((DatabaseCall)this.call).shouldReturnGeneratedKeys()) {
            return this.generateKeysExecuteNoSelect();
        }
        return this.executeNoSelectCall();
    }

    @Override
    public DatabaseCall generateKeysExecuteNoSelect() throws DatabaseException {
        return (DatabaseCall)this.executeCall();
    }

    public Integer executeNoSelectCall() throws DatabaseException {
        if (this.hasMultipleCalls()) {
            Integer returnedRowCount = null;
            for (int index = 0; index < this.getCalls().size(); ++index) {
                DatasourceCall databseCall = this.getCalls().get(index);
                Integer rowCount = (Integer)this.executeCall(databseCall);
                if (index != 0 && rowCount > 0) continue;
                returnedRowCount = rowCount;
            }
            return returnedRowCount;
        }
        return (Integer)this.executeCall();
    }

    @Override
    public Vector executeSelect() throws DatabaseException {
        return this.executeSelectCall();
    }

    public Vector executeSelectCall() throws DatabaseException {
        if (this.hasMultipleCalls()) {
            Vector results = new Vector();
            for (DatasourceCall databseCall : this.getCalls()) {
                results.addAll((Vector)this.executeCall(databseCall));
            }
            return results;
        }
        return (Vector)this.executeCall();
    }

    public DatasourceCall getCall() {
        return this.call;
    }

    public List<DatasourceCall> getCalls() {
        if (this.calls == null) {
            this.calls = new ArrayList<DatasourceCall>(3);
        }
        return this.calls;
    }

    public boolean hasMultipleCalls() {
        return this.calls != null && !this.calls.isEmpty();
    }

    @Override
    public void insertObject() throws DatabaseException {
        ClassDescriptor descriptor = this.getDescriptor();
        boolean usesSequencing = descriptor.usesSequenceNumbers();
        boolean shouldAcquireValueAfterInsert = false;
        if (usesSequencing) {
            shouldAcquireValueAfterInsert = descriptor.getSequence().shouldAcquireValueAfterInsert();
        }
        List<DatabaseField> returnFields = null;
        if (descriptor.getReturnFieldsToMergeInsert() != null) {
            returnFields = descriptor.getReturnFieldsToMergeInsert();
        }
        if (usesSequencing && !shouldAcquireValueAfterInsert && this.getWriteObjectQuery().getObjectChangeSet() == null) {
            this.updateObjectAndRowWithSequenceNumber();
        }
        if (this.hasMultipleCalls()) {
            int size = this.calls.size();
            for (int index = 0; index < size; ++index) {
                DatasourceCall databseCall = this.calls.get(index);
                if (index > 0 && this.isExpressionQueryMechanism() && this.query.shouldCascadeOnlyDependentParts() && !descriptor.hasMultipleTableConstraintDependecy() && this.query.getSession().getProject().allowSQLDeferral()) {
                    DatabaseTable table = descriptor.getMultipleTableInsertOrder().get(index);
                    this.query.getSession().getCommitManager().addDeferredCall(table, databseCall, this);
                    continue;
                }
                Object result = this.executeCall(databseCall);
                if (result instanceof AbstractRecord) {
                    this.query.setProperty("output", result);
                }
                if (returnFields != null) {
                    this.updateObjectAndRowWithReturnRow(returnFields, index == 0);
                }
                if (index != 0 || !usesSequencing || !shouldAcquireValueAfterInsert) continue;
                if (result instanceof DatabaseCall) {
                    this.updateObjectAndRowWithSequenceNumber((DatabaseCall)result);
                    continue;
                }
                this.updateObjectAndRowWithSequenceNumber();
            }
        } else {
            Object result = this.executeCall();
            if (result instanceof AbstractRecord) {
                this.query.setProperty("output", result);
            }
            if (returnFields != null) {
                this.updateObjectAndRowWithReturnRow(returnFields, true);
            }
            if (usesSequencing && shouldAcquireValueAfterInsert) {
                if (result instanceof DatabaseCall) {
                    this.updateObjectAndRowWithSequenceNumber((DatabaseCall)result);
                } else {
                    this.updateObjectAndRowWithSequenceNumber();
                }
            }
        }
        AbstractSession executionSession = this.query.getExecutionSession();
        for (Accessor accessor : executionSession.getAccessors()) {
            accessor.flushSelectCalls(executionSession);
        }
    }

    @Override
    public void executeDeferredCall(DatasourceCall call) {
        Object result = this.executeCall(call);
        if (result instanceof AbstractRecord) {
            this.query.setProperty("output", result);
        }
        Collection<DatabaseField> returnFields = null;
        if (this.query.getDescriptor().hasReturningPolicy()) {
            returnFields = this.query.getDescriptor().getReturningPolicy().getFieldsToMergeInsert();
        }
        if (returnFields != null) {
            this.updateObjectAndRowWithReturnRow(returnFields, false);
        }
    }

    @Override
    public boolean isCallQueryMechanism() {
        return true;
    }

    @Override
    public void prepare() {
        if (!this.hasMultipleCalls() && this.getCall() == null) {
            throw QueryException.sqlStatementNotSetProperly(this.getQuery());
        }
    }

    public void prepareCall() throws QueryException {
        DatabaseQuery query = this.getQuery();
        AbstractSession executionSession = query.getExecutionSession();
        if (this.hasMultipleCalls()) {
            for (DatasourceCall call : this.getCalls()) {
                call.prepare(executionSession);
            }
        } else if (this.getCall() != null) {
            this.getCall().prepare(executionSession);
        }
    }

    @Override
    public void prepareCursorSelectAllRows() throws QueryException {
        this.getCall().returnCursor();
        this.prepareCall();
    }

    @Override
    public void prepareDeleteAll() {
        if (this.hasMultipleCalls()) {
            for (DatasourceCall call : this.getCalls()) {
                call.returnNothing();
            }
        } else {
            this.getCall().returnNothing();
        }
        this.prepareCall();
    }

    @Override
    public void prepareDeleteObject() {
        if (this.hasMultipleCalls()) {
            for (DatasourceCall call : this.getCalls()) {
                call.returnNothing();
            }
        } else {
            this.getCall().returnNothing();
        }
        this.prepareCall();
    }

    @Override
    public void prepareDoesExist(DatabaseField field) {
        if (this.hasMultipleCalls()) {
            Iterator<DatasourceCall> iterator = this.getCalls().iterator();
            while (iterator.hasNext()) {
                iterator.next().returnOneRow();
            }
        } else {
            this.getCall().returnOneRow();
        }
        this.prepareCall();
    }

    @Override
    public void prepareExecuteNoSelect() {
        if (this.hasMultipleCalls()) {
            Iterator<DatasourceCall> iterator = this.getCalls().iterator();
            while (iterator.hasNext()) {
                iterator.next().returnNothing();
            }
        } else {
            this.getCall().returnNothing();
        }
        this.prepareCall();
    }

    @Override
    public void prepareExecute() {
        this.getCall().setExecuteUpdate();
        this.prepareCall();
    }

    @Override
    public void prepareExecuteSelect() {
        if (this.hasMultipleCalls()) {
            for (DatasourceCall databseCall : this.getCalls()) {
                databseCall.returnManyRows();
            }
        } else {
            this.getCall().returnManyRows();
        }
        this.prepareCall();
    }

    @Override
    public void prepareInsertObject() {
        if (this.hasMultipleCalls()) {
            int size = this.calls.size();
            for (int index = 0; index < size; ++index) {
                DatasourceCall call = this.calls.get(index);
                if (call.isReturnSet()) continue;
                call.returnNothing();
            }
        } else if (!this.call.isReturnSet()) {
            this.call.returnNothing();
        }
        this.prepareCall();
    }

    protected void prepareReportQueryItems() {
        ReportQuery query = (ReportQuery)this.getQuery();
        this.computeAndSetItemOffset(query, query.getItems(), query.getQueryExpressions().size());
    }

    protected int computeAndSetItemOffset(ReportQuery query, List<ReportItem> items, int itemOffset) {
        for (ReportItem item : items) {
            if (item.isConstructorItem()) {
                List<ReportItem> reportItems = ((ConstructorReportItem)item).getReportItems();
                itemOffset = this.computeAndSetItemOffset(query, reportItems, itemOffset);
                continue;
            }
            item.setResultIndex(itemOffset);
            if (item.getAttributeExpression() == null) continue;
            if (item.hasJoining()) {
                itemOffset = item.getJoinedAttributeManager().computeJoiningMappingIndexes(true, this.getSession(), itemOffset);
                continue;
            }
            if (item.getDescriptor() != null) {
                itemOffset += item.getDescriptor().getAllSelectionFields(query).size();
                continue;
            }
            if (item.getMapping() != null && item.getMapping().isAggregateObjectMapping()) {
                itemOffset += item.getMapping().getFields().size();
                continue;
            }
            ++itemOffset;
        }
        return itemOffset;
    }

    @Override
    public void prepareReportQuerySelectAllRows() {
        this.prepareReportQueryItems();
        this.prepareExecuteSelect();
    }

    @Override
    public void prepareReportQuerySubSelect() {
        this.prepareReportQueryItems();
        this.prepareCall();
    }

    @Override
    public void prepareSelectAllRows() {
        if (this.hasMultipleCalls()) {
            for (DatasourceCall databseCall : this.getCalls()) {
                databseCall.returnManyRows();
            }
        } else {
            this.getCall().returnManyRows();
        }
        this.prepareCall();
    }

    @Override
    public void prepareSelectOneRow() {
        if (this.hasMultipleCalls()) {
            for (DatasourceCall databseCall : this.getCalls()) {
                databseCall.returnOneRow();
            }
        } else {
            this.getCall().returnOneRow();
        }
        this.prepareCall();
    }

    @Override
    public void prepareUpdateObject() {
        if (this.hasMultipleCalls()) {
            int size = this.calls.size();
            for (int index = 0; index < size; ++index) {
                DatasourceCall call = this.calls.get(index);
                if (call.isReturnSet()) continue;
                call.returnNothing();
            }
        } else if (this.getCall() != null && !this.call.isReturnSet()) {
            this.call.returnNothing();
        }
        this.prepareCall();
    }

    @Override
    public void prepareUpdateAll() {
        if (this.getCall() != null) {
            this.getCall().returnNothing();
        }
        this.prepareCall();
    }

    @Override
    public Vector selectAllReportQueryRows() throws DatabaseException {
        return this.executeSelect();
    }

    @Override
    public Vector selectAllRows() throws DatabaseException {
        return this.executeSelectCall();
    }

    @Override
    public AbstractRecord selectOneRow() throws DatabaseException {
        if (this.hasMultipleCalls()) {
            for (DatasourceCall databaseCall : this.getCalls()) {
                AbstractRecord result = (AbstractRecord)this.executeCall(databaseCall);
                if (result == null) continue;
                return result;
            }
            return null;
        }
        return (AbstractRecord)this.executeCall();
    }

    @Override
    public AbstractRecord selectRowForDoesExist(DatabaseField field) throws DatabaseException {
        if (this.hasMultipleCalls()) {
            for (DatasourceCall databaseCall : this.getCalls()) {
                AbstractRecord result = (AbstractRecord)this.executeCall(databaseCall);
                if (result == null) continue;
                return result;
            }
            return null;
        }
        return (AbstractRecord)this.executeCall();
    }

    public void setCall(DatasourceCall call) {
        this.call = call;
        if (call != null) {
            call.setQuery(this.getQuery());
        }
    }

    protected void setCalls(List<DatasourceCall> calls) {
        this.calls = calls;
    }

    @Override
    public Integer updateObject() throws DatabaseException {
        ClassDescriptor descriptor = this.getDescriptor();
        List<DatabaseField> returnFields = null;
        if (descriptor.getReturnFieldsToMergeUpdate() != null) {
            returnFields = descriptor.getReturnFieldsToMergeUpdate();
        }
        Integer returnedRowCount = null;
        if (this.hasMultipleCalls()) {
            int size = this.calls.size();
            for (int index = 0; index < size; ++index) {
                Integer rowCount;
                DatasourceCall databseCall = this.calls.get(index);
                if (index > 0 && this.isExpressionQueryMechanism() && this.query.shouldCascadeOnlyDependentParts() && !descriptor.hasMultipleTableConstraintDependecy() && this.query.getSession().getProject().allowSQLDeferral()) {
                    DatabaseTable table = descriptor.getMultipleTableInsertOrder().get(index);
                    this.query.getSession().getCommitManager().addDeferredCall(table, databseCall, this);
                    continue;
                }
                Object result = this.executeCall(databseCall);
                if (result instanceof AbstractRecord) {
                    this.query.setProperty("output", result);
                    rowCount = 1;
                } else {
                    rowCount = (Integer)result;
                }
                if (index == 0 || rowCount <= 0) {
                    returnedRowCount = rowCount;
                }
                if (returnFields == null) continue;
                this.updateObjectAndRowWithReturnRow(returnFields, false);
            }
        } else {
            Object result = this.executeCall();
            if (result instanceof AbstractRecord) {
                this.query.setProperty("output", result);
                returnedRowCount = 1;
            } else {
                returnedRowCount = (Integer)result;
            }
            if (returnFields != null) {
                this.updateObjectAndRowWithReturnRow(returnFields, false);
            }
        }
        AbstractSession executionSession = this.query.getExecutionSession();
        for (Accessor accessor : executionSession.getAccessors()) {
            accessor.flushSelectCalls(executionSession);
        }
        return returnedRowCount;
    }

    @Override
    public Integer updateAll() throws DatabaseException {
        if (((UpdateAllQuery)this.query).isPreparedUsingTempStorage() && this.getExecutionSession().getPlatform().supportsTempTables()) {
            return this.updateAllUsingTempTables();
        }
        Integer rowCount = this.executeNoSelectCall();
        if (((UpdateAllQuery)this.query).isPreparedUsingTempStorage()) {
            AbstractRecord outputRow = (AbstractRecord)this.query.getProperty("output");
            rowCount = (Integer)outputRow.get("ROW_COUNT");
        }
        return rowCount;
    }

    public Integer updateAllUsingTempTables() throws DatabaseException {
        DatasourceCall databseCall2;
        int index;
        int nTables = this.getCalls().size() / 4;
        DatabaseException ex = null;
        Integer returnedRowCount = null;
        for (index = 0; index < nTables; ++index) {
            try {
                databseCall2 = this.getCalls().get(index);
                this.executeCall(databseCall2);
                continue;
            }
            catch (DatabaseException databseCall2) {
                // empty catch block
            }
        }
        for (index = nTables; index < nTables * 2 && ex == null; ++index) {
            try {
                databseCall2 = this.getCalls().get(index);
                this.executeCall(databseCall2);
                continue;
            }
            catch (DatabaseException databaseEx) {
                ex = databaseEx;
            }
        }
        for (index = nTables * 2; index < nTables * 3 && ex == null; ++index) {
            try {
                databseCall2 = this.getCalls().get(index);
                Integer rowCount = (Integer)this.executeCall(databseCall2);
                if (index != nTables * 2 && rowCount > 0) continue;
                returnedRowCount = rowCount;
                continue;
            }
            catch (DatabaseException databaseEx) {
                ex = databaseEx;
            }
        }
        for (index = nTables * 3; index < nTables * 4; ++index) {
            try {
                databseCall2 = this.getCalls().get(index);
                this.executeCall(databseCall2);
                continue;
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
        }
        if (ex != null) {
            throw ex;
        }
        return returnedRowCount;
    }

    @Override
    protected void updateForeignKeyFieldAfterInsert(WriteObjectQuery writeQuery) {
        writeQuery.setModifyRow(this.getDescriptor().getObjectBuilder().buildRow(writeQuery.getObject(), this.getSession(), DatabaseMapping.WriteType.INSERT));
        AbstractSession sessionToUse = this.query.getExecutionSession();
        List<DatasourceCall> calls = ((DatasourceCallQueryMechanism)this.getDescriptor().getQueryManager().getUpdateQuery().getQueryMechanism()).getCalls();
        Iterator<DatasourceCall> iterator = calls.iterator();
        while (iterator.hasNext()) {
            DatasourceCall call = iterator.next().clone();
            call.setQuery(writeQuery);
            sessionToUse.executeCall(call, this.getTranslationRow(), writeQuery);
        }
    }
}

