/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.HexFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.expressions.ExpressionJavaPrinter;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.ExtractOperator;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.RelationExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class OraclePlatform
extends DatabasePlatform {
    protected static DataModifyQuery vpdSetIdentifierQuery;
    protected static DataModifyQuery vpdClearIdentifierQuery;
    protected boolean shouldPrintForUpdateClause;
    protected boolean supportsIdentity;
    protected String SELECT = "SELECT * FROM (SELECT ";
    protected String HINT_START = "/*+ FIRST_ROWS";
    protected String HINT_END = " */ ";
    protected String FROM = "a.*, ROWNUM rnum  FROM (";
    protected String END_FROM = ") a ";
    protected String MAX_ROW = "WHERE ROWNUM <= ";
    protected String MIN_ROW = ") WHERE rnum > ";
    protected String LOCK_START_PREFIX = " AND (";
    protected String LOCK_START_PREFIX_WHERE = " WHERE (";
    protected String LOCK_START_SUFFIX = ") IN (";
    protected String LOCK_END = " FOR UPDATE";
    protected String SELECT_ID_PREFIX = "SELECT ";
    protected String SELECT_ID_SUFFIX = " FROM (SELECT ";
    protected String FROM_ID = ", ROWNUM rnum  FROM (";
    protected String END_FROM_ID = ") ";
    protected String ORDER_BY_ID = " ORDER BY ";
    protected String BRACKET_END = " ) ";

    public OraclePlatform() {
        this.cursorCode = -10;
        this.pingSQL = "SELECT 1 FROM DUAL";
        this.storedProcedureTerminationToken = "";
        this.shouldPrintForUpdateClause = true;
    }

    @Override
    public void initializeConnectionData(Connection connection) throws SQLException {
        DatabaseMetaData dmd = connection.getMetaData();
        this.driverSupportsNationalCharacterVarying = Helper.compareVersions(dmd.getDriverVersion(), "11.1") >= 0;
    }

    @Override
    public boolean allowsSizeInProcedureArguments() {
        return false;
    }

    @Override
    protected void appendByteArray(byte[] bytes, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write(39);
            writer.write(HexFormat.of().formatHex(bytes));
            writer.write(39);
        } else {
            super.appendByteArray(bytes, writer);
        }
    }

    @Override
    protected void appendDate(Date date, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("to_date('");
            writer.write(Helper.printDate(date));
            writer.write("','yyyy-mm-dd')");
        } else {
            super.appendDate(date, writer);
        }
    }

    @Override
    protected void appendTime(Time time, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("to_date('");
            writer.write(Helper.printTime(time));
            writer.write("','hh24:mi:ss')");
        } else {
            super.appendTime(time, writer);
        }
    }

    @Override
    protected void appendTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("to_date('");
            writer.write(Helper.printTimestampWithoutNanos(timestamp));
            writer.write("','yyyy-mm-dd hh24:mi:ss')");
        } else {
            super.appendTimestamp(timestamp, writer);
        }
    }

    @Override
    protected void appendCalendar(Calendar calendar, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("to_date('");
            writer.write(Helper.printCalendarWithoutNanos(calendar));
            writer.write("','yyyy-mm-dd hh24:mi:ss')");
        } else {
            super.appendCalendar(calendar, writer);
        }
    }

    @Override
    protected Hashtable<Class<?>, FieldTypeDefinition> buildFieldTypes() {
        Hashtable fieldTypeMapping = new Hashtable();
        fieldTypeMapping.put(Boolean.class, new FieldTypeDefinition("NUMBER(1) default 0", false));
        fieldTypeMapping.put(Integer.class, new FieldTypeDefinition("NUMBER", 10));
        fieldTypeMapping.put(Long.class, new FieldTypeDefinition("NUMBER", 19));
        fieldTypeMapping.put(Float.class, new FieldTypeDefinition("NUMBER", 19, 4));
        fieldTypeMapping.put(Double.class, new FieldTypeDefinition("NUMBER", 19, 4));
        fieldTypeMapping.put(Short.class, new FieldTypeDefinition("NUMBER", 5));
        fieldTypeMapping.put(Byte.class, new FieldTypeDefinition("NUMBER", 3));
        fieldTypeMapping.put(BigInteger.class, new FieldTypeDefinition("NUMBER", 38));
        fieldTypeMapping.put(BigDecimal.class, new FieldTypeDefinition("NUMBER", 38).setLimits(38, -38, 38));
        fieldTypeMapping.put(Number.class, new FieldTypeDefinition("NUMBER", 38).setLimits(38, -38, 38));
        if (this.getUseNationalCharacterVaryingTypeForString()) {
            fieldTypeMapping.put(String.class, new FieldTypeDefinition("NVARCHAR2", 255));
        } else {
            fieldTypeMapping.put(String.class, new FieldTypeDefinition("VARCHAR2", 255));
        }
        fieldTypeMapping.put(Character.class, new FieldTypeDefinition("CHAR", 1));
        fieldTypeMapping.put(Byte[].class, new FieldTypeDefinition("BLOB", false));
        fieldTypeMapping.put(Character[].class, new FieldTypeDefinition("CLOB", false));
        fieldTypeMapping.put(byte[].class, new FieldTypeDefinition("BLOB", false));
        fieldTypeMapping.put(char[].class, new FieldTypeDefinition("CLOB", false));
        fieldTypeMapping.put(Blob.class, new FieldTypeDefinition("BLOB", false));
        fieldTypeMapping.put(Clob.class, new FieldTypeDefinition("CLOB", false));
        fieldTypeMapping.put(Date.class, new FieldTypeDefinition("DATE", false));
        fieldTypeMapping.put(Time.class, new FieldTypeDefinition("TIMESTAMP", false));
        fieldTypeMapping.put(Timestamp.class, new FieldTypeDefinition("TIMESTAMP", false));
        fieldTypeMapping.put(Calendar.class, new FieldTypeDefinition("TIMESTAMP"));
        fieldTypeMapping.put(java.util.Date.class, new FieldTypeDefinition("TIMESTAMP"));
        fieldTypeMapping.put(LocalDate.class, new FieldTypeDefinition("DATE"));
        fieldTypeMapping.put(LocalDateTime.class, new FieldTypeDefinition("TIMESTAMP"));
        fieldTypeMapping.put(LocalTime.class, new FieldTypeDefinition("TIMESTAMP"));
        fieldTypeMapping.put(OffsetDateTime.class, new FieldTypeDefinition("TIMESTAMP"));
        fieldTypeMapping.put(OffsetTime.class, new FieldTypeDefinition("TIMESTAMP"));
        fieldTypeMapping.put(Instant.class, new FieldTypeDefinition("TIMESTAMP", false));
        return fieldTypeMapping;
    }

    protected String buildFirstRowsHint(int max) {
        return this.HINT_START + this.HINT_END;
    }

    @Override
    public DatabaseCall buildCallWithReturning(SQLCall sqlCall, List<DatabaseField> returnFields) {
        SQLCall call = new SQLCall();
        call.setParameters(sqlCall.getParameters());
        call.setParameterTypes(sqlCall.getParameterTypes());
        CharArrayWriter writer = new CharArrayWriter(200);
        try {
            DatabaseField field;
            int i;
            writer.write("BEGIN ");
            writer.write(sqlCall.getSQLString());
            writer.write(" RETURNING ");
            for (i = 0; i < returnFields.size(); ++i) {
                field = returnFields.get(i);
                writer.write(field.getNameDelimited(this));
                if (i + 1 >= returnFields.size()) continue;
                writer.write(", ");
            }
            writer.write(" INTO ");
            for (i = 0; i < returnFields.size(); ++i) {
                field = returnFields.get(i);
                call.appendOut(writer, field);
                if (i + 1 >= returnFields.size()) continue;
                writer.write(", ");
            }
            writer.write("; END;");
            call.setQueryString(((Object)writer).toString());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        return call;
    }

    @Override
    public boolean canBuildCallWithReturning() {
        return true;
    }

    public void clearOracleConnectionCache(Connection conn) {
    }

    @Override
    public String getAssignmentString() {
        return ":= ";
    }

    public String getDeclareBeginString() {
        return "DECLARE ";
    }

    @Override
    public String getBatchBeginString() {
        return "BEGIN ";
    }

    @Override
    public String getBatchEndString() {
        return "END;";
    }

    @Override
    public String getBatchRowCountDeclareString() {
        return "DECLARE EL_COUNTER NUMBER := 0; ";
    }

    @Override
    public boolean isRowCountOutputParameterRequired() {
        return true;
    }

    @Override
    public String getBatchRowCountReturnString() {
        return "? := EL_COUNTER; ";
    }

    @Override
    public String getDropDatabaseSchemaString(String schema) {
        return "DROP SCHEMA " + schema + " RESTRICT";
    }

    @Override
    public String getBatchRowCountAssignString() {
        return "EL_COUNTER := EL_COUNTER + SQL%ROWCOUNT; ";
    }

    @Override
    public int getMaxFieldNameSize() {
        return 30;
    }

    public Vector getNativeTableInfo(String table, String creator, AbstractSession session) {
        Object query = "SELECT * FROM ALL_TABLES WHERE OWNER NOT IN ('SYS', 'SYSTEM')";
        if (table != null) {
            query = table.indexOf(37) != -1 ? (String)query + " AND TABLE_NAME LIKE " + table : (String)query + " AND TABLE_NAME = " + table;
        }
        if (creator != null) {
            query = creator.indexOf(37) != -1 ? (String)query + " AND OWNER LIKE " + creator : (String)query + " AND OWNER = " + creator;
        }
        return session.executeSelectingCall(new SQLCall((String)query));
    }

    @Override
    public String getProcedureCallHeader() {
        return this.useJDBCStoredProcedureSyntax() ? "{CALL " : "BEGIN ";
    }

    @Override
    public String getProcedureCallTail() {
        return this.useJDBCStoredProcedureSyntax() ? "}" : "; END;";
    }

    @Override
    public String getDropCascadeString() {
        return " CASCADE CONSTRAINTS";
    }

    @Override
    public String getSelectForUpdateString() {
        return " FOR UPDATE";
    }

    @Override
    public String getSelectForUpdateWaitString(Integer waitTimeout) {
        return " FOR UPDATE WAIT " + waitTimeout;
    }

    @Override
    public String getStoredProcedureParameterPrefix() {
        return "P_";
    }

    public ValueReadQuery getSystemChangeNumberQuery() {
        ValueReadQuery sCNQuery = new ValueReadQuery();
        sCNQuery.setSQLString("SELECT DBMS_FLASHBACK.GET_SYSTEM_CHANGE_NUMBER FROM DUAL");
        return sCNQuery;
    }

    @Override
    public ValueReadQuery getTimestampQuery() {
        if (this.timestampQuery == null) {
            this.timestampQuery = new ValueReadQuery();
            this.timestampQuery.setSQLString("SELECT SYSDATE FROM DUAL");
            this.timestampQuery.setAllowNativeSQLQuery(true);
        }
        return this.timestampQuery;
    }

    @Override
    public DatabaseQuery getVPDClearIdentifierQuery(String vpdIdentifier) {
        if (vpdClearIdentifierQuery == null) {
            vpdClearIdentifierQuery = new DataModifyQuery("CALL DBMS_SESSION.CLEAR_IDENTIFIER()");
        }
        return vpdClearIdentifierQuery;
    }

    @Override
    public String getVPDCreationFunctionString(String tableName, String tenantFieldName) {
        String functionName = tableName + "_ident_func";
        return "CREATE OR REPLACE FUNCTION " + functionName + " (p_schema in VARCHAR2 default NULL, p_object in VARCHAR2 default NULL) RETURN VARCHAR2 AS BEGIN return '" + tenantFieldName + " = sys_context(''userenv'', ''client_identifier'')'; END;";
    }

    @Override
    public String getVPDCreationPolicyString(String tableName, AbstractSession session) {
        String functionName = tableName + "_ident_func";
        String schemaName = session.getDatasourceLogin().getUserName();
        String policyName = tableName + "_todo_list_policy";
        return "\nCALL DBMS_RLS.ADD_POLICY ('" + schemaName + "', '" + tableName + "', '" + policyName + "', '" + schemaName + "', '" + functionName + "', 'select, update, delete')\n";
    }

    @Override
    public String getVPDDeletionString(String tableName, AbstractSession session) {
        String schemaName = session.getDatasourceLogin().getUserName();
        String policyName = tableName + "_todo_list_policy";
        return "\nCALL DBMS_RLS.DROP_POLICY ('" + schemaName + "', '" + tableName + "', '" + policyName + "')";
    }

    @Override
    public DatabaseQuery getVPDSetIdentifierQuery(String vpdIdentifier) {
        if (vpdSetIdentifierQuery == null) {
            vpdSetIdentifierQuery = new DataModifyQuery("CALL DBMS_SESSION.SET_IDENTIFIER(#" + vpdIdentifier + ")");
        }
        return vpdSetIdentifierQuery;
    }

    @Override
    public Object getObjectFromResultSet(ResultSet resultSet, int columnNumber, int type, AbstractSession session) throws SQLException {
        if (type == 93 || type == 91) {
            return resultSet.getTimestamp(columnNumber);
        }
        return super.getObjectFromResultSet(resultSet, columnNumber, type, session);
    }

    @Override
    protected void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addOperator(OraclePlatform.operatorOuterJoin());
        this.addOperator(OraclePlatform.logOperator());
        this.addOperator(ExpressionOperator.simpleTwoArgumentFunction(31, "CONCAT"));
        this.addOperator(ExpressionOperator.simpleFunctionNoParentheses(54, "SYSDATE"));
        this.addOperator(ExpressionOperator.simpleFunctionNoParentheses(123, "TO_DATE(CURRENT_DATE)"));
        this.addOperator(ExpressionOperator.simpleFunctionNoParentheses(128, "SYSDATE"));
        this.addOperator(ExpressionOperator.simpleFunctionNoParentheses(150, "SYSDATE"));
        this.addOperator(ExpressionOperator.simpleFunctionNoParentheses(151, "SYSDATE"));
        this.addOperator(ExpressionOperator.truncateDate());
        this.addOperator(ExpressionOperator.newTime());
        this.addOperator(ExpressionOperator.ifNull());
        this.addOperator(ExpressionOperator.simpleTwoArgumentFunction(91, "ATAN2"));
        this.addOperator(OraclePlatform.oracleDateName());
        this.addOperator(OraclePlatform.operatorLocate());
        this.addOperator(OraclePlatform.operatorLocate2());
        this.addOperator(OraclePlatform.regexpOperator());
        this.addOperator(OraclePlatform.exceptOperator());
        this.addOperator(OraclePlatform.oracleExtractOperator());
        this.addOperator(OraclePlatform.oracleLeft());
        this.addOperator(OraclePlatform.oracleRight());
    }

    protected static ExpressionOperator operatorOuterJoin() {
        ExpressionOperator result = new ExpressionOperator();
        result.setSelector(6);
        ArrayList<String> v = new ArrayList<String>(2);
        v.add(" (+) = ");
        result.printsAs(v);
        result.bePostfix();
        result.setNodeClass(RelationExpression.class);
        return result;
    }

    protected static ExpressionOperator exceptOperator() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(146);
        exOperator.printsAs("MINUS ");
        exOperator.bePostfix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    protected static ExpressionOperator regexpOperator() {
        ExpressionOperator result = new ExpressionOperator();
        result.setSelector(141);
        result.setType(5);
        ArrayList<String> v = new ArrayList<String>(3);
        v.add("REGEXP_LIKE(");
        v.add(", ");
        v.add(")");
        result.printsAs(v);
        result.bePrefix();
        result.setNodeClass(ClassConstants.FunctionExpression_Class);
        v = new ArrayList(2);
        v.add(".regexp(");
        v.add(")");
        result.printsJavaAs(v);
        return result;
    }

    protected static ExpressionOperator operatorLocate() {
        ExpressionOperator result = new ExpressionOperator();
        result.setSelector(112);
        ArrayList<String> v = new ArrayList<String>(3);
        v.add("INSTR(");
        v.add(", ");
        v.add(")");
        result.printsAs(v);
        result.bePrefix();
        result.setNodeClass(RelationExpression.class);
        return result;
    }

    protected static ExpressionOperator operatorLocate2() {
        ExpressionOperator result = new ExpressionOperator();
        result.setSelector(113);
        ArrayList<String> v = new ArrayList<String>(4);
        v.add("INSTR(");
        v.add(", ");
        v.add(", ");
        v.add(")");
        result.printsAs(v);
        result.bePrefix();
        result.setNodeClass(RelationExpression.class);
        return result;
    }

    protected static ExpressionOperator logOperator() {
        ExpressionOperator result = new ExpressionOperator();
        result.setSelector(66);
        ArrayList<String> v = new ArrayList<String>(2);
        v.add("LOG(10,");
        v.add(")");
        result.printsAs(v);
        result.bePrefix();
        result.setNodeClass(FunctionExpression.class);
        return result;
    }

    protected static ExpressionOperator oracleDateName() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(92);
        ArrayList<String> v = new ArrayList<String>(3);
        v.add("TO_CHAR(");
        v.add(", '");
        v.add("')");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        int[] indices = new int[]{1, 0};
        exOperator.setArgumentIndices(indices);
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    protected static ExpressionOperator oracleLeft() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(153);
        ArrayList<String> v = new ArrayList<String>(3);
        v.add("SUBSTR(");
        v.add(", 1, ");
        v.add(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        int[] indices = new int[]{0, 1};
        exOperator.setArgumentIndices(indices);
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    protected static ExpressionOperator oracleRight() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(101);
        ArrayList<String> v = new ArrayList<String>(3);
        v.add("SUBSTR(");
        v.add(", -");
        v.add(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        int[] indices = new int[]{0, 1};
        exOperator.setArgumentIndices(indices);
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    private static ExpressionOperator oracleExtractOperator() {
        return new OracleExtractOperator();
    }

    public boolean isNativeConnectionRequiredForLobLocator() {
        return false;
    }

    @Override
    public boolean isOracle() {
        return true;
    }

    @Override
    public Hashtable<Class<? extends Number>, ? super Number> maximumNumericValues() {
        Hashtable<Class, Number> values = new Hashtable<Class, Number>();
        values.put(Integer.class, Integer.MAX_VALUE);
        values.put(Long.class, Long.MAX_VALUE);
        values.put(Double.class, 9.9999E125);
        values.put(Short.class, (short)Short.MAX_VALUE);
        values.put(Byte.class, (byte)127);
        values.put(Float.class, Float.valueOf(Float.MAX_VALUE));
        values.put(BigInteger.class, new BigInteger("0"));
        values.put(BigDecimal.class, new BigDecimal(new BigInteger("0"), 38));
        return values;
    }

    @Override
    public Hashtable<Class<? extends Number>, ? super Number> minimumNumericValues() {
        Hashtable<Class, Number> values = new Hashtable<Class, Number>();
        values.put(Integer.class, Integer.MIN_VALUE);
        values.put(Long.class, Long.MIN_VALUE);
        values.put(Double.class, -1.0E-129);
        values.put(Short.class, (short)Short.MIN_VALUE);
        values.put(Byte.class, (byte)-128);
        values.put(Float.class, Float.valueOf(Float.MIN_VALUE));
        values.put(BigInteger.class, new BigInteger("0"));
        values.put(BigDecimal.class, new BigDecimal(new BigInteger("0"), 38));
        return values;
    }

    @Override
    public ValueReadQuery buildSelectQueryForSequenceObject(String qualifiedSeqName, Integer size) {
        return new ValueReadQuery("SELECT " + qualifiedSeqName + ".NEXTVAL FROM DUAL");
    }

    @Override
    public ValueReadQuery buildSelectQueryForIdentity(String qualifiedSeqName, Integer size) {
        return new ValueReadQuery("SELECT " + qualifiedSeqName + ".CURRVAL FROM DUAL");
    }

    @Override
    public void printFieldNullClause(Writer writer) throws ValidationException {
        try {
            writer.write(" NULL");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    public String serverTimestampString() {
        return "SYSDATE";
    }

    @Override
    public boolean shouldPrintStoredProcedureArgumentNameInCall() {
        return false;
    }

    @Override
    public String getProcedureArgument(String name, Object parameter, DatasourceCall.ParameterType parameterType, StoredProcedureCall call, AbstractSession session) {
        if (name != null && DatasourceCall.ParameterType.IN.equals((Object)parameterType) && !call.usesBinding(session)) {
            return name + "=>?";
        }
        return "?";
    }

    @Override
    public boolean shouldUseJDBCOuterJoinSyntax() {
        return false;
    }

    @Override
    public boolean supportsAutoConversionToNumericForArithmeticOperations() {
        return true;
    }

    @Override
    public boolean supportsSequenceObjects() {
        return true;
    }

    @Override
    public boolean supportsIdentity() {
        return this.supportsIdentity;
    }

    public void setSupportsIdentity(boolean supportsIdentity) {
        this.supportsIdentity = supportsIdentity;
    }

    @Override
    public boolean supportsStoredFunctions() {
        return true;
    }

    @Override
    public boolean supportsVPD() {
        return true;
    }

    @Override
    public boolean supportsWaitForUpdate() {
        return true;
    }

    public boolean supportsSelectForUpdateNoWait() {
        return true;
    }

    public boolean canUnwrapOracleConnection() {
        return false;
    }

    public Connection unwrapOracleConnection(Connection connection) {
        return connection;
    }

    public boolean useJDBCStoredProcedureSyntax() {
        if (this.useJDBCStoredProcedureSyntax == null) {
            this.useJDBCStoredProcedureSyntax = this.driverName != null && Pattern.compile("Oracle", 2).matcher(this.driverName).find();
        }
        return this.useJDBCStoredProcedureSyntax;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void printSQLSelectStatement(DatabaseCall call, ExpressionSQLPrinter printer, SQLSelectStatement statement) {
        int max = 0;
        int firstRow = 0;
        ReadQuery query = statement.getQuery();
        if (query != null) {
            max = query.getMaxRows();
            firstRow = query.getFirstResult();
        }
        if (!this.shouldUseRownumFiltering() || max <= 0 && firstRow <= 0) {
            super.printSQLSelectStatement(call, printer, statement);
            return;
        }
        statement.setUseUniqueFieldAliases(true);
        if (query.isObjectBuildingQuery() && (((ObjectBuildingQuery)query).getLockMode() == 1 || ((ObjectBuildingQuery)query).getLockMode() == 2)) {
            if (!query.isReadAllQuery() && !query.isReadObjectQuery()) throw new UnsupportedOperationException(ExceptionLocalization.buildMessage("ora_pessimistic_locking_with_rownum"));
            ArrayList<DatabaseField> fields = new ArrayList<DatabaseField>();
            statement.enableFieldAliasesCaching();
            String queryString = this.printOmittingOrderByForUpdateUnion(statement, printer, fields);
            this.duplicateCallParameters(call);
            call.setFields(fields);
            printer.printString(queryString);
            this.printLockStartWithPrimaryKeyFields(statement, printer);
            printer.printString(this.SELECT_ID_PREFIX);
            this.printPrimaryKeys(statement, printer);
            printer.printString(this.SELECT_ID_SUFFIX);
            printer.printString(this.buildFirstRowsHint(max));
            this.printPrimaryKeys(statement, printer);
            printer.printString(this.FROM_ID);
            printer.printString(queryString);
            if (statement.hasOrderByExpressions()) {
                try {
                    statement.printSQLOrderByClause(printer);
                }
                catch (IOException exception) {
                    throw ValidationException.fileError(exception);
                }
            } else {
                printer.printString(this.ORDER_BY_ID);
                this.printPrimaryKeys(statement, printer);
            }
            printer.printString(this.END_FROM_ID);
            printer.printString(this.MAX_ROW);
            printer.printParameter(DatabaseCall.MAXROW_FIELD);
            printer.printString(this.MIN_ROW);
            printer.printParameter(DatabaseCall.FIRSTRESULT_FIELD);
            printer.printString(this.BRACKET_END);
            try {
                statement.printSQLOrderByClause(printer);
                statement.printSQLUnionClause(printer);
            }
            catch (IOException exception) {
                throw ValidationException.fileError(exception);
            }
            printer.printString(this.LOCK_END);
        } else if (max > 0) {
            printer.printString(this.SELECT);
            printer.printString(this.buildFirstRowsHint(max));
            printer.printString(this.FROM);
            call.setFields(statement.printSQL(printer));
            printer.printString(this.END_FROM);
            printer.printString(this.MAX_ROW);
            printer.printParameter(DatabaseCall.MAXROW_FIELD);
            printer.printString(this.MIN_ROW);
            printer.printParameter(DatabaseCall.FIRSTRESULT_FIELD);
        } else {
            printer.printString(this.SELECT);
            printer.printString(this.FROM);
            call.setFields(statement.printSQL(printer));
            printer.printString(this.END_FROM);
            printer.printString(this.MIN_ROW);
            printer.printParameter(DatabaseCall.FIRSTRESULT_FIELD);
        }
        call.setIgnoreFirstRowSetting(true);
        call.setIgnoreMaxResultsSetting(true);
    }

    private void duplicateCallParameters(DatabaseCall call) {
        ArrayList<Object> newParameterList = new ArrayList<Object>(call.getParameters());
        newParameterList.addAll(call.getParameters());
        call.setParameters(newParameterList);
        ArrayList<DatasourceCall.ParameterType> newParameterTypesList = new ArrayList<DatasourceCall.ParameterType>(call.getParameterTypes());
        newParameterTypesList.addAll(call.getParameterTypes());
        call.setParameterTypes(newParameterTypesList);
    }

    private String printOmittingOrderByForUpdateUnion(SQLSelectStatement statement, ExpressionSQLPrinter printer, List<DatabaseField> fields) {
        boolean originalShouldPrintForUpdate = this.shouldPrintForUpdateClause;
        Writer originalWriter = printer.getWriter();
        List<DatabaseField> selectFields = null;
        this.shouldPrintForUpdateClause = false;
        printer.setWriter(new StringWriter());
        try {
            selectFields = statement.printSQLSelect(printer);
            statement.printSQLWhereKeyWord(printer);
            statement.printSQLWhereClause(printer);
            statement.printSQLHierarchicalQueryClause(printer);
            statement.printSQLGroupByClause(printer);
            statement.printSQLHavingClause(printer);
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        fields.addAll(selectFields);
        String query = printer.getWriter().toString();
        this.shouldPrintForUpdateClause = originalShouldPrintForUpdate;
        printer.setWriter(originalWriter);
        return query;
    }

    private void printLockStartWithPrimaryKeyFields(SQLSelectStatement statement, ExpressionSQLPrinter printer) {
        if (statement.getWhereClause() == null) {
            printer.printString(this.LOCK_START_PREFIX_WHERE);
        } else {
            printer.printString(this.LOCK_START_PREFIX);
        }
        Iterator<DatabaseField> iterator = statement.getQuery().getDescriptor().getPrimaryKeyFields().iterator();
        while (iterator.hasNext()) {
            DatabaseField field = iterator.next();
            DatabaseTable alias = statement.getExpressionBuilder().aliasForTable(field.getTable());
            printer.printField(field, alias);
            if (!iterator.hasNext()) continue;
            printer.printString(",");
        }
        printer.printString(this.LOCK_START_SUFFIX);
    }

    private void printPrimaryKeys(SQLSelectStatement statement, ExpressionSQLPrinter printer) {
        Iterator<DatabaseField> iterator = statement.getQuery().getDescriptor().getPrimaryKeyFields().iterator();
        while (iterator.hasNext()) {
            DatabaseField field = iterator.next();
            String alias = statement.getAliasFor(field);
            if (alias != null) {
                printer.printString(alias);
            } else {
                printer.printField(field);
            }
            if (!iterator.hasNext()) continue;
            printer.printString(",");
        }
    }

    @Override
    public boolean isAlterSequenceObjectSupported() {
        return true;
    }

    @Override
    public boolean isForUpdateCompatibleWithDistinct() {
        return false;
    }

    @Override
    public boolean isLobCompatibleWithDistinct() {
        return false;
    }

    @Override
    public boolean isLockTimeoutException(DatabaseException e) {
        return e.getInternalException() instanceof SQLException && ((SQLException)e.getInternalException()).getErrorCode() == 30006;
    }

    @Override
    public boolean wasFailureCommunicationBased(SQLException exception, Connection connection, AbstractSession sessionForProfile) {
        if (exception != null) {
            if (exception.getErrorCode() == 17410) {
                return true;
            }
            if (exception.getErrorCode() == 17002) {
                return true;
            }
            if (exception.getErrorCode() == 2399) {
                return true;
            }
            if (exception.getErrorCode() == 2396) {
                return true;
            }
        }
        return super.wasFailureCommunicationBased(exception, connection, sessionForProfile);
    }

    @Override
    public boolean shouldPrintForUpdateClause() {
        return this.shouldPrintForUpdateClause;
    }

    @Override
    public Expression createExpressionFor(DatabaseField field, Expression builder, String fieldClassificationClassName) {
        if (field.getType() == Clob.class || field.getType() == Blob.class || "java.sql.Clob".equals(fieldClassificationClassName) || "java.sql.Blob".equals(fieldClassificationClassName)) {
            Expression subExp1 = builder.getField(field);
            Expression subExp2 = builder.getParameter(field);
            subExp1 = subExp1.getFunction("dbms_lob.compare", subExp2);
            return subExp1.equal(0);
        }
        return super.createExpressionFor(field, builder, fieldClassificationClassName);
    }

    @Override
    protected DataReadQuery getTableExistsQuery(TableDefinition table) {
        DataReadQuery query = new DataReadQuery("SELECT table_name FROM user_tables WHERE table_name='" + table.getFullName() + "'");
        query.setMaxRows(1);
        return query;
    }

    @Override
    public boolean checkTableExists(AbstractSession session, TableDefinition table, boolean suppressLogging) {
        try {
            session.setLoggingOff(suppressLogging);
            Vector result = (Vector)session.executeQuery(this.getTableExistsQuery(table));
            return !result.isEmpty();
        }
        catch (Exception notFound) {
            return false;
        }
    }

    @Override
    public int getINClauseLimit() {
        return 1000;
    }

    private static final class OracleExtractOperator
    extends ExtractOperator {
        private static final String[] QUARTER_STRINGS = new String[]{"TO_NUMBER(TO_CHAR(", ", 'Q'))"};
        private static final String[] WEEK_STRINGS = new String[]{"TO_NUMBER(TO_CHAR(", ", 'IW'))"};
        private static final String[] DATE_STRINGS = new String[]{"TRUNC(", ")"};
        private static final String[] TIME_STRINGS = new String[]{"TO_TIMESTAMP(", ")"};

        private OracleExtractOperator() {
        }

        @Override
        protected void printQuarterSQL(Expression first, Expression second, ExpressionSQLPrinter printer) {
            printer.printString(QUARTER_STRINGS[0]);
            first.printSQL(printer);
            printer.printString(QUARTER_STRINGS[1]);
        }

        @Override
        protected void printQuarterJava(Expression first, Expression second, ExpressionJavaPrinter printer) {
            printer.printString(QUARTER_STRINGS[0]);
            first.printJava(printer);
            printer.printString(QUARTER_STRINGS[1]);
        }

        @Override
        protected void printWeekSQL(Expression first, Expression second, ExpressionSQLPrinter printer) {
            printer.printString(WEEK_STRINGS[0]);
            first.printSQL(printer);
            printer.printString(WEEK_STRINGS[1]);
        }

        @Override
        protected void printWeekJava(Expression first, Expression second, ExpressionJavaPrinter printer) {
            printer.printString(WEEK_STRINGS[0]);
            first.printJava(printer);
            printer.printString(WEEK_STRINGS[1]);
        }

        @Override
        protected void printDateSQL(Expression first, Expression second, ExpressionSQLPrinter printer) {
            printer.printString(DATE_STRINGS[0]);
            first.printSQL(printer);
            printer.printString(DATE_STRINGS[1]);
        }

        @Override
        protected void printDateJava(Expression first, Expression second, ExpressionJavaPrinter printer) {
            printer.printString(DATE_STRINGS[0]);
            first.printJava(printer);
            printer.printString(DATE_STRINGS[1]);
        }

        @Override
        protected void printTimeSQL(Expression first, Expression second, ExpressionSQLPrinter printer) {
            printer.printString(TIME_STRINGS[0]);
            first.printSQL(printer);
            printer.printString(TIME_STRINGS[1]);
        }

        @Override
        protected void printTimeJava(Expression first, Expression second, ExpressionJavaPrinter printer) {
            printer.printString(TIME_STRINGS[0]);
            first.printJava(printer);
            printer.printString(TIME_STRINGS[1]);
        }
    }
}

