/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.commons.ha.HaContext;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rx.rm.protocol.AcknowledgementData;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.InboundAcceptedImpl;
import com.sun.xml.ws.rx.rm.runtime.JaxwsApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.RedeliveryTaskExecutor;
import com.sun.xml.ws.rx.rm.runtime.RuntimeContext;
import com.sun.xml.ws.rx.rm.runtime.delivery.Postman;
import com.sun.xml.ws.rx.util.AbstractResponseHandler;
import java.util.concurrent.TimeUnit;

class ServerDestinationDeliveryCallback
implements Postman.Callback {
    private static final Logger LOGGER = Logger.getLogger(ServerDestinationDeliveryCallback.class);
    private final RuntimeContext rc;

    public ServerDestinationDeliveryCallback(RuntimeContext rc) {
        this.rc = rc;
    }

    @Override
    public void deliver(ApplicationMessage message) {
        if (!(message instanceof JaxwsApplicationMessage)) {
            throw (RxRuntimeException)((Object)LOGGER.logSevereException((Throwable)((Object)new RxRuntimeException(LocalizationMessages.WSRM_1141_UNEXPECTED_MESSAGE_CLASS(message.getClass().getName(), JaxwsApplicationMessage.class.getName())))));
        }
        this.deliver((JaxwsApplicationMessage)message);
    }

    private void deliver(JaxwsApplicationMessage message) {
        boolean internalRmFeatureExists;
        ResponseCallbackHandler responseCallback = new ResponseCallbackHandler(message, this.rc);
        Packet request = message.getPacket().copy(true);
        boolean bl = internalRmFeatureExists = this.rc.configuration.getInternalRmFeature() != null;
        if (internalRmFeatureExists) {
            InboundAcceptedImpl inboundAccepted = new InboundAcceptedImpl(message, this.rc);
            request.addSatellite(inboundAccepted);
        }
        this.rc.communicator.sendAsync(request, responseCallback, null);
    }

    @Override
    public RuntimeContext getRuntimeContext() {
        return this.rc;
    }

    private static class ResponseCallbackHandler
    extends AbstractResponseHandler
    implements Fiber.CompletionCallback {
        private static final String RM_ACK_PROPERTY_KEY = "RM_ACK";
        private final JaxwsApplicationMessage request;
        private final RuntimeContext rc;

        public ResponseCallbackHandler(JaxwsApplicationMessage request, RuntimeContext rc) {
            super(rc.suspendedFiberStorage, request.getCorrelationId());
            this.request = request;
            this.rc = rc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompletion(Packet response) {
            try {
                HaContext.initFrom(response);
                String rmAckPropertyValue = (String)response.invocationProperties.remove(RM_ACK_PROPERTY_KEY);
                if (rmAckPropertyValue == null || Boolean.parseBoolean(rmAckPropertyValue)) {
                    boolean internalRmFeatureExists;
                    boolean bl = internalRmFeatureExists = this.rc.configuration.getInternalRmFeature() != null;
                    if (!internalRmFeatureExists) {
                        this.rc.destinationMessageHandler.acknowledgeApplicationLayerDelivery(this.request);
                    }
                } else {
                    LOGGER.finer(String.format("Value of the '%s' property is '%s'. The request has not been acknowledged.", RM_ACK_PROPERTY_KEY, rmAckPropertyValue));
                    RedeliveryTaskExecutor.deliverUsingCurrentThread(this.request, this.rc.configuration.getRmFeature().getRetransmissionBackoffAlgorithm().getDelayInMillis(this.request.getNextResendCount(), this.rc.configuration.getRmFeature().getMessageRetransmissionInterval()), TimeUnit.MILLISECONDS, this.rc.destinationMessageHandler);
                    return;
                }
                if (response.getMessage() == null) {
                    AcknowledgementData ackData = this.rc.destinationMessageHandler.getAcknowledgementData(this.request.getSequenceId());
                    if (ackData.getAckReqestedSequenceId() != null || ackData.containsSequenceAcknowledgementData()) {
                        response = this.rc.communicator.setEmptyResponseMessage(response, this.request.getPacket(), this.rc.rmVersion.protocolVersion.sequenceAcknowledgementAction);
                        this.rc.protocolHandler.appendAcknowledgementHeaders(response, ackData);
                    }
                    this.resumeParentFiber(response);
                } else {
                    JaxwsApplicationMessage message = new JaxwsApplicationMessage(response, this.getCorrelationId());
                    this.rc.sourceMessageHandler.registerMessage(message, this.rc.getBoundSequenceId(this.request.getSequenceId()), true);
                    this.rc.sourceMessageHandler.putToDeliveryQueue(message);
                }
            }
            catch (Throwable t) {
                this.onCompletion(t);
            }
            finally {
                HaContext.clear();
            }
        }

        @Override
        public void onCompletion(Throwable error) {
            this.resumeParentFiber(error);
        }
    }
}

