/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.auth.jaas;

import com.sun.messaging.jmq.auth.api.server.model.UserRepository;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.jaas.CallbackHandlerImpl;
import com.sun.messaging.jmq.jmsserver.auth.jaas.SubjectHelper;
import com.sun.messaging.jmq.util.StringUtil;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Destroyable;
import javax.security.auth.Refreshable;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class UserRepositoryImpl
implements UserRepository {
    private static boolean DEBUG = false;
    public static final String TYPE = "jaas";
    public static final String PROP_NAME_SUFFIX = ".name";
    public static final String SUBJECT_HELPER_SUFFIX = ".subjectHelperClass";
    public static final String SUBJECT_HELPER_PROPS_SUFFIX = ".subjectHelperClass.props";
    public static final String SUBJECT_HELPER_EMBEDDED_PROP = "imq.embedded";
    public static final String SUBJECT_HELPER_JMSRA_MANAGED_PROP = "imq.jmsra.managed";
    private Logger logger = Globals.getLogger();
    private String authType = null;
    private Properties authProps = null;
    private String name = null;
    private SubjectHelper subjectHelper = null;
    private LoginContext lc = null;
    private Object lock = new Object();
    private boolean login = false;
    private boolean logout = false;

    @Override
    public void open(String authType, Properties authProperties, Refreshable cacheData) throws LoginException {
        this.authType = authType;
        this.authProps = authProperties;
        String rep = this.authProps.getProperty("imq.authentication." + authType + ".user_repository");
        if (rep == null) {
            throw new LoginException(Globals.getBrokerResources().getKString("B4041", authType));
        }
        if (!rep.equals(TYPE)) {
            Object[] args = new String[]{rep, TYPE, this.getClass().getName()};
            throw new LoginException(Globals.getBrokerResources().getKString("B4070", args));
        }
        String prefix = "imq.user_repository." + rep;
        this.name = this.authProps.getProperty(prefix + PROP_NAME_SUFFIX);
        if (this.name == null) {
            throw new LoginException(Globals.getBrokerResources().getKString("B4211"));
        }
        String subjectHelperc = this.authProps.getProperty(prefix + SUBJECT_HELPER_SUFFIX);
        if (subjectHelperc != null) {
            try {
                this.subjectHelper = (SubjectHelper)Class.forName(subjectHelperc).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                String pstr = this.authProps.getProperty(prefix + SUBJECT_HELPER_PROPS_SUFFIX);
                Properties props = new Properties();
                props = StringUtil.toProperties((String)pstr, (Properties)props);
                if (Broker.isInProcess()) {
                    props.setProperty(SUBJECT_HELPER_EMBEDDED_PROP, "true");
                }
                if (Globals.isJMSRAManagedBroker()) {
                    props.setProperty(SUBJECT_HELPER_JMSRA_MANAGED_PROP, "true");
                }
                this.subjectHelper.init(this.name, props, null);
            }
            catch (Exception e) {
                this.logger.logStack(32, "Unable to instantiate class " + subjectHelperc, (Throwable)e);
                throw new LoginException(e.getMessage());
            }
        }
        if (DEBUG) {
            this.logger.log(8, "Using JAAS authentication " + this.name + (String)(subjectHelperc == null ? "" : " with subject helper class " + subjectHelperc));
        }
    }

    @Override
    public Subject findMatch(String user, Object credential, Object extra, String matchType) throws LoginException {
        if (matchType != null && matchType.equals("basic")) {
            return this.basicFindMatch(user, (String)credential);
        }
        String matchtyp = matchType == null ? "null" : matchType;
        Object[] args = new String[]{matchtyp, this.authType, TYPE, "basic"};
        throw new LoginException(Globals.getBrokerResources().getKString("B4079", args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Subject basicFindMatch(String user, String userpwd) throws LoginException {
        if (DEBUG) {
            this.logger.log(4, "Authentication type basic - " + user + ":" + userpwd);
        }
        CallbackHandlerImpl cbh = new CallbackHandlerImpl(this.authProps, user, userpwd);
        Subject sub = null;
        if (this.subjectHelper != null) {
            try {
                sub = this.subjectHelper.makeSubject(user, userpwd);
            }
            catch (Exception e) {
                String emsg = "Failed to make subject of user " + user;
                this.logger.logStack(32, emsg, (Throwable)e);
                LoginException ex = new LoginException(emsg);
                ex.initCause(e);
                throw ex;
            }
        }
        this.lc = sub != null ? new LoginContext(this.name, sub, cbh) : new LoginContext(this.name, cbh);
        Object object = this.lock;
        synchronized (object) {
            if (this.logout) {
                throw new LoginException(Globals.getBrokerResources().getKString("B4108"));
            }
            this.lc.login();
            this.login = true;
            cbh.destroy();
            Subject subject = this.lc.getSubject();
            Set<Object> creds = subject.getPrivateCredentials();
            Iterator<Object> itr = creds.iterator();
            Object cred = null;
            while (itr.hasNext()) {
                try {
                    cred = itr.next();
                    if (cred == null || !(cred instanceof Destroyable) || ((Destroyable)cred).isDestroyed()) continue;
                    ((Destroyable)cred).destroy();
                }
                catch (Exception e) {
                    this.logger.log(16, "XXX Unable to destroy private credential:" + cred.getClass().getName() + " for " + user);
                }
            }
            return subject;
        }
    }

    @Override
    public Refreshable getCacheData() {
        if (this.subjectHelper == null) {
            return null;
        }
        return this.subjectHelper.getCacheData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws LoginException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.logout && this.login) {
                this.lc.logout();
                this.logout = true;
            }
        }
    }
}

