/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.convert;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import jakarta.faces.convert.MessageFactory;

public class ShortConverter
implements Converter {
    public static final String CONVERTER_ID = "jakarta.faces.Short";
    public static final String SHORT_ID = "jakarta.faces.converter.ShortConverter.SHORT";
    public static final String STRING_ID = "jakarta.faces.converter.STRING";

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() < 1) {
            return null;
        }
        try {
            return Short.valueOf(value);
        }
        catch (NumberFormatException nfe) {
            throw new ConverterException(MessageFactory.getMessage(context, SHORT_ID, value, "32456", MessageFactory.getLabel(context, component)), (Throwable)nfe);
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        try {
            return Short.toString(((Number)value).shortValue());
        }
        catch (Exception e) {
            throw new ConverterException(MessageFactory.getMessage(context, STRING_ID, value, MessageFactory.getLabel(context, component)), (Throwable)e);
        }
    }
}

