/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.generator.model;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;
import javax.lang.model.util.Types;
import org.jboss.jdeparser.JAssignableExpr;
import org.jboss.jdeparser.JBlock;
import org.jboss.jdeparser.JCall;
import org.jboss.jdeparser.JClassDef;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JExprs;
import org.jboss.jdeparser.JIf;
import org.jboss.jdeparser.JLambda;
import org.jboss.jdeparser.JMethodDef;
import org.jboss.jdeparser.JParamDeclaration;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.JTypes;
import org.jboss.jdeparser.JVarDeclaration;
import org.jboss.logging.annotations.Field;
import org.jboss.logging.annotations.Fields;
import org.jboss.logging.annotations.Pos;
import org.jboss.logging.annotations.Producer;
import org.jboss.logging.annotations.Properties;
import org.jboss.logging.annotations.Property;
import org.jboss.logging.annotations.Suppressed;
import org.jboss.logging.annotations.Transform;
import org.jboss.logging.annotations.TransformException;
import org.jboss.logging.processor.apt.ProcessingException;
import org.jboss.logging.processor.generator.model.ClassModel;
import org.jboss.logging.processor.generator.model.ClassModelHelper;
import org.jboss.logging.processor.model.MessageInterface;
import org.jboss.logging.processor.model.MessageMethod;
import org.jboss.logging.processor.model.Parameter;
import org.jboss.logging.processor.model.ThrowableType;
import org.jboss.logging.processor.util.ElementHelper;

abstract class ImplementationClassModel
extends ClassModel {
    private final AtomicBoolean messageFormatMethodGenerated = new AtomicBoolean(false);
    private final AtomicBoolean copyStackTraceMethodGenerated = new AtomicBoolean(false);
    private final TypeMirror stringType;

    ImplementationClassModel(ProcessingEnvironment processingEnv, MessageInterface messageInterface) {
        super(processingEnv, messageInterface, ClassModelHelper.implementationClassName(messageInterface), null);
        this.stringType = ElementHelper.toType(processingEnv, String.class);
    }

    void createBundleMethod(JClassDef classDef, JCall localeGetter, MessageMethod messageMethod) {
        JExpr result;
        JLambda lambda;
        JCall formatterCall;
        this.addMessageMethod(messageMethod);
        TypeMirror returnTypeMirror = messageMethod.returnType().asType();
        JType returnType = JTypes.typeOf(returnTypeMirror);
        JMethodDef method = classDef.method(34, returnType, messageMethod.name());
        method.annotate(Override.class);
        this.addThrownTypes(messageMethod, method);
        this.addMethodTypeParameters(method, returnTypeMirror);
        if (returnTypeMirror.getKind() == TypeKind.DECLARED) {
            this.sourceFile._import(returnType);
        }
        JBlock body = method.body();
        MessageMethod.Message message = messageMethod.message();
        switch (message.format()) {
            case MESSAGE_FORMAT: {
                if (messageMethod.formatParameterCount() > 0) {
                    formatterCall = this.getFormatMethod(classDef, localeGetter);
                    formatterCall.arg(JExprs.call(messageMethod.messageMethodName()));
                    break;
                }
                formatterCall = JExprs.call(messageMethod.messageMethodName());
                break;
            }
            case PRINTF: {
                JType formatter = JTypes.$t(String.class);
                formatterCall = formatter.call("format").arg(localeGetter).arg(JExprs.call(messageMethod.messageMethodName()));
                break;
            }
            default: {
                formatterCall = JExprs.call(messageMethod.messageMethodName());
            }
        }
        Set<Parameter> allParameters = messageMethod.parameters();
        LinkedHashMap<String, JParamDeclaration> fields = new LinkedHashMap<String, JParamDeclaration>();
        LinkedHashMap<String, JParamDeclaration> properties = new LinkedHashMap<String, JParamDeclaration>();
        ArrayList<String> parameterNames = new ArrayList<String>(allParameters.size());
        for (Parameter parameter : allParameters) {
            parameterNames.add(parameter.name());
        }
        ArrayList<JExpr> args = new ArrayList<JExpr>();
        for (Parameter param : allParameters) {
            JParamDeclaration var = this.addMethodParameter(method, param);
            String formatterClass = param.formatterClass();
            if (param.isFormatParameter()) {
                boolean added = false;
                if (param.isAnnotatedWith(Transform.class)) {
                    if (formatterCall == null) {
                        throw new IllegalStateException("No format parameters are allowed when NO_FORMAT is specified.");
                    }
                    JAssignableExpr transformVar = this.createTransformVar(parameterNames, body, param, JExprs.$v(var));
                    if (formatterClass == null) {
                        args.add(transformVar);
                    } else {
                        args.add(JTypes.$t(formatterClass)._new().arg(transformVar));
                    }
                    added = true;
                }
                if (param.isAnnotatedWith(Pos.class)) {
                    if (formatterCall == null) {
                        throw new IllegalStateException("No format parameters are allowed when NO_FORMAT is specified.");
                    }
                    Pos pos = param.getAnnotation(Pos.class);
                    int[] positions = pos.value();
                    Transform[] transform = pos.transform();
                    for (int i = 0; i < positions.length; ++i) {
                        int index = positions[i] - 1;
                        if (transform != null && transform.length > 0) {
                            JAssignableExpr tVar = this.createTransformVar(parameterNames, method.body(), param, transform[i], JExprs.$v(var));
                            if (index < args.size()) {
                                args.add(index, tVar);
                                continue;
                            }
                            args.add(tVar);
                            continue;
                        }
                        if (index < args.size()) {
                            args.add(index, JExprs.$v(var));
                            continue;
                        }
                        args.add(JExprs.$v(var));
                    }
                    added = true;
                }
                if (param.isAnnotatedWith(TransformException.class)) {
                    args.add(JExprs.$v(var).call("getLocalizedMessage"));
                    added = true;
                }
                if (!added) {
                    if (formatterCall == null) {
                        throw new ProcessingException(messageMethod, "No format parameters are allowed when NO_FORMAT is specified.");
                    }
                    if (formatterClass == null) {
                        if (param.isArray() || param.isVarArgs()) {
                            JType arrays = JTypes.$t(Arrays.class);
                            this.sourceFile._import(arrays);
                            args.add(arrays.call("toString").arg(JExprs.$v(var)));
                        } else {
                            args.add(JExprs.$v(var));
                        }
                    } else {
                        args.add(JTypes.$t(formatterClass)._new().arg(JExprs.$v(var)));
                    }
                }
            }
            if (param.isAnnotatedWith(Field.class)) {
                fields.put(param.targetName(), var);
            }
            if (!param.isAnnotatedWith(Property.class)) continue;
            properties.put(param.targetName(), var);
        }
        for (JExpr arg : args) {
            formatterCall.arg(arg);
        }
        boolean bl = messageMethod.returnType().isSubtypeOf(Supplier.class);
        if (messageMethod.returnType().isThrowable()) {
            if (bl) {
                lambda = JExprs.lambda();
                JBlock lambdaBody = lambda.body();
                lambdaBody._return(this.createReturnType(classDef, messageMethod, lambdaBody, formatterCall, fields, properties));
                result = lambda;
            } else {
                result = this.createReturnType(classDef, messageMethod, body, formatterCall, fields, properties);
            }
        } else if (bl) {
            lambda = JExprs.lambda();
            lambda.body()._return(formatterCall);
            result = lambda;
        } else {
            result = formatterCall;
        }
        body._return(result);
    }

    JAssignableExpr createTransformVar(List<String> parameterNames, JBlock methodBody, Parameter param, JExpr var) {
        return this.createTransformVar(parameterNames, methodBody, param, param.getAnnotation(Transform.class), var);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    JAssignableExpr createTransformVar(List<String> parameterNames, JBlock methodBody, Parameter param, Transform transform, JExpr var) {
        JAssignableExpr result;
        List<Transform.TransformType> transformTypes = Arrays.asList(transform.value());
        if (transformTypes.contains((Object)Transform.TransformType.GET_CLASS)) {
            if (transformTypes.size() == 1) {
                String paramName = this.getUniqueName(parameterNames, param, "Class");
                parameterNames.add(paramName);
                result = JExprs.$v(methodBody.var(2, JTypes.$t(Class.class).typeArg(JType.WILDCARD), paramName));
                JIf stmt = methodBody._if(var.eq(JExpr.NULL));
                stmt.block(JBlock.Braces.REQUIRED).assign(result, JExpr.NULL);
                stmt._else().assign(result, var.call("getClass"));
                return result;
            } else {
                String paramName = this.getUniqueName(parameterNames, param, "HashCode");
                parameterNames.add(paramName);
                result = JExprs.$v(methodBody.var(2, JType.INT, paramName));
                JIf stmt = methodBody._if(var.eq(JExpr.NULL));
                stmt.assign(result, JExpr.ZERO);
                if (transformTypes.contains((Object)Transform.TransformType.HASH_CODE)) {
                    stmt._else().assign(result, var.call("getClass").call("hashCode"));
                    return result;
                } else {
                    if (!transformTypes.contains((Object)Transform.TransformType.IDENTITY_HASH_CODE)) throw new IllegalStateException(String.format("Invalid transform type combination: %s", transformTypes));
                    stmt._else().assign(result, JTypes.$t(System.class).call("identityHashCode").arg(var.call("getClass")));
                }
            }
            return result;
        } else if (transformTypes.contains((Object)Transform.TransformType.HASH_CODE)) {
            String paramName = this.getUniqueName(parameterNames, param, "HashCode");
            parameterNames.add(paramName);
            result = JExprs.$v(methodBody.var(2, JType.INT, paramName));
            JIf stmt = methodBody._if(var.eq(JExpr.NULL));
            stmt.assign(result, JExpr.ZERO);
            if (param.isArray() || param.isVarArgs()) {
                JType arrays = JTypes.$t(Arrays.class);
                this.sourceFile._import(arrays);
                stmt._else().assign(result, arrays.call("hashCode").arg(var));
                return result;
            } else {
                stmt._else().assign(result, var.call("hashCode"));
            }
            return result;
        } else if (transformTypes.contains((Object)Transform.TransformType.IDENTITY_HASH_CODE)) {
            String paramName = this.getUniqueName(parameterNames, param, "HashCode");
            parameterNames.add(paramName);
            result = JExprs.$v(methodBody.var(2, JType.INT, paramName));
            JIf stmt = methodBody._if(var.eq(JExpr.NULL));
            stmt.assign(result, JExpr.ZERO);
            stmt._else().assign(result, JTypes.$t(System.class).call("identityHashCode").arg(var));
            return result;
        } else {
            if (!transformTypes.contains((Object)Transform.TransformType.SIZE)) throw new IllegalStateException(String.format("Invalid transform type: %s", transformTypes));
            String paramName = this.getUniqueName(parameterNames, param, "Size");
            parameterNames.add(paramName);
            result = JExprs.$v(methodBody.var(2, JType.INT, paramName));
            JIf stmt = methodBody._if(var.eq(JExpr.NULL));
            stmt.assign(result, JExpr.ZERO);
            if (param.isArray() || param.isVarArgs()) {
                stmt._else().assign(result, var.field("length"));
                return result;
            } else if (param.isSubtypeOf(Map.class) || param.isSubtypeOf(Collection.class)) {
                stmt._else().assign(result, var.call("size"));
                return result;
            } else {
                if (!param.isSubtypeOf(CharSequence.class)) throw new IllegalStateException(String.format("Invalid type for %s. Must be an array, %s, %s or %s.", new Object[]{Transform.TransformType.SIZE, Collection.class.getName(), Map.class.getName(), CharSequence.class.getName()}));
                stmt._else().assign(result, var.call("length"));
            }
        }
        return result;
    }

    private String getUniqueName(List<String> parameterNames, Parameter parameter, String suffix) {
        String result;
        String string = result = suffix == null ? parameter.name() : parameter.name().concat(suffix);
        if (parameterNames.contains(result)) {
            return this.getUniqueName(parameterNames, result, 0);
        }
        return result;
    }

    protected String getUniqueName(List<String> parameterNames, String name, int index) {
        if (parameterNames.contains(name)) {
            return this.getUniqueName(parameterNames, name + index, index + 1);
        }
        return name;
    }

    private void addMethodTypeParameters(JMethodDef method, TypeMirror type) {
        Types types = this.processingEnv.getTypeUtils();
        if (type.getKind() == TypeKind.TYPEVAR) {
            TypeMirror resolved = types.erasure(type);
            JType resolvedType = JTypes.typeOf(resolved);
            this.sourceFile._import(resolvedType);
            method.typeParam(type.toString())._extends(resolvedType);
        } else if (type.getKind() == TypeKind.DECLARED) {
            List<? extends TypeMirror> typeArgs = ElementHelper.getTypeArguments(type);
            for (TypeMirror typeMirror : typeArgs) {
                this.addMethodTypeParameters(method, typeMirror);
            }
        }
    }

    private JExpr createReturnType(JClassDef classDef, MessageMethod messageMethod, JBlock body, JCall format, Map<String, JParamDeclaration> fields, Map<String, JParamDeclaration> properties) {
        JVarDeclaration resultField;
        JType type;
        Set<Parameter> producers = messageMethod.parametersAnnotatedWith(Producer.class);
        Parameter teParameter = messageMethod.parametersAnnotatedWith(TransformException.class).stream().findFirst().orElse(null);
        if (producers.isEmpty()) {
            ThrowableType returnType = messageMethod.returnType().throwableReturnType();
            type = JTypes.typeOf(returnType.asType());
            this.sourceFile._import(type);
            Collection<ThrowableType> suggestions = returnType.suggestions();
            if (teParameter == null || suggestions.isEmpty()) {
                resultField = this.constructReturnType(messageMethod, returnType, format, body, null);
            } else {
                resultField = body.var(2, type, "result");
                JIf ifBody = null;
                for (ThrowableType suggested : suggestions) {
                    ifBody = ifBody == null ? body._if(JExprs.$v(teParameter.name())._instanceof(JTypes.typeOf(suggested.asType()))) : ifBody.elseIf(JExprs.$v(teParameter.name())._instanceof(JTypes.typeOf(suggested.asType())));
                    this.constructReturnType(messageMethod, suggested, format, ifBody, resultField);
                }
                this.constructReturnType(messageMethod, returnType, format, ifBody._else(), resultField);
            }
        } else {
            boolean callInitCause = false;
            TypeMirror returnType = messageMethod.returnType().resolvedType();
            Parameter producer = producers.iterator().next();
            type = JTypes.typeOf(returnType);
            JCall result = JExprs.$v(producer.name()).call("apply");
            if (producer.isSubtypeOf(BiFunction.class)) {
                List<? extends TypeMirror> typeArguments = ElementHelper.getTypeArguments(producer);
                if (typeArguments.isEmpty()) {
                    result = result.arg(format);
                    result = result.arg(JExprs.$v(messageMethod.cause().name()));
                } else {
                    TypeMirror typeArg = typeArguments.get(0);
                    if (this.processingEnv.getTypeUtils().isAssignable(typeArg, this.stringType)) {
                        result = result.arg(format);
                        result = messageMethod.hasCause() ? result.arg(JExprs.$v(messageMethod.cause().name())) : result.arg(JExpr.NULL);
                    } else {
                        result = messageMethod.hasCause() ? result.arg(JExprs.$v(messageMethod.cause().name())) : result.arg(JExpr.NULL);
                        result = result.arg(format);
                    }
                }
            } else {
                result = result.arg(format);
                callInitCause = messageMethod.hasCause();
            }
            resultField = body.var(2, type, "result", (JExpr)result);
            if (callInitCause) {
                body.add(JExprs.$v(resultField).call("initCause").arg(JExprs.$v(messageMethod.cause().name())));
            }
        }
        this.addDefultProperties(messageMethod, ElementHelper.getAnnotations(messageMethod, Properties.class, Property.class), body, JExprs.$v(resultField), false);
        this.addDefultProperties(messageMethod, ElementHelper.getAnnotations(messageMethod, Fields.class, Field.class), body, JExprs.$v(resultField), true);
        if (teParameter != null && teParameter.getAnnotation(TransformException.class).copyStackTrace()) {
            body.add(JExprs.$v(resultField).call("setStackTrace").arg(JExprs.$v(teParameter.name()).call("getStackTrace")));
        } else {
            body.add(this.getCopyStackMethod(classDef).arg(JExprs.$v(resultField)));
        }
        Set<Parameter> suppressed = messageMethod.parametersAnnotatedWith(Suppressed.class);
        for (Parameter p : suppressed) {
            String name;
            if (p.isArray() || p.isVarArgs()) {
                name = String.format("$%sVar", p.name());
                body.forEach(0, JTypes.typeOf(((ArrayType)p.asType()).getComponentType()), " " + name, (JExpr)JExprs.$v(p.name())).block(JBlock.Braces.REQUIRED).add(JExprs.$v(resultField).call("addSuppressed").arg(JExprs.$v(name)));
                continue;
            }
            if (p.isAssignableFrom(Collection.class)) {
                name = String.format("$%sVar", p.name());
                body.add(JExprs.$v(p.name()).call("forEach").arg(JExprs.lambda().param(name).body(JExprs.$v(resultField).call("addSuppressed").arg(JExprs.$v(name)))));
                continue;
            }
            body.add(JExprs.$v(resultField).call("addSuppressed").arg(JExprs.$v(p.name())));
        }
        JAssignableExpr resultExpr = JExprs.$v(resultField);
        fields.forEach((key, value) -> body.assign(resultExpr.field((String)key), JExprs.$v(value)));
        properties.forEach((key, value) -> body.add(resultExpr.call((String)key).arg(JExprs.$v(value))));
        return resultExpr;
    }

    private JVarDeclaration constructReturnType(MessageMethod messageMethod, ThrowableType returnType, JCall format, JBlock body, JVarDeclaration resultField) {
        JVarDeclaration returnField;
        JType type = JTypes.typeOf(returnType.asType());
        this.sourceFile._import(type);
        boolean callInitCause = false;
        JCall result = type._new();
        if (returnType.useConstructionParameters()) {
            for (Parameter param : returnType.constructionParameters()) {
                if (param.isMessageMethod()) {
                    result.arg(format);
                    continue;
                }
                result.arg(JExprs.$v(param.name()));
            }
            callInitCause = messageMethod.hasCause() && !returnType.causeSetInConstructor();
        } else if (returnType.hasStringAndThrowableConstructor() && messageMethod.hasCause()) {
            result.arg(format).arg(JExprs.$v(messageMethod.cause().name()));
        } else if (returnType.hasThrowableAndStringConstructor() && messageMethod.hasCause()) {
            result.arg(JExprs.$v(messageMethod.cause().name())).arg(format);
        } else if (returnType.hasStringConstructor()) {
            result.arg(format);
            if (messageMethod.hasCause()) {
                callInitCause = true;
            }
        } else if (returnType.hasThrowableConstructor() && messageMethod.hasCause()) {
            result.arg(JExprs.$v(messageMethod.cause().name()));
        } else if (returnType.hasStringAndThrowableConstructor() && !messageMethod.hasCause()) {
            result.arg(format).arg(JExpr.NULL);
        } else if (returnType.hasThrowableAndStringConstructor() && !messageMethod.hasCause()) {
            result.arg(JExpr.NULL).arg(format);
        } else if (messageMethod.hasCause()) {
            callInitCause = true;
        }
        if (resultField == null) {
            returnField = body.var(2, type, "result", (JExpr)result);
        } else {
            returnField = resultField;
            body.assign(JExprs.$v(returnField), result);
        }
        if (callInitCause) {
            body.add(JExprs.$v(returnField).call("initCause").arg(JExprs.$v(messageMethod.cause().name())));
        }
        return returnField;
    }

    protected final void addThrownTypes(MessageMethod messageMethod, JMethodDef jMethod) {
        for (ThrowableType thrownType : messageMethod.thrownTypes()) {
            jMethod._throws(thrownType.name());
        }
    }

    protected JParamDeclaration addMethodParameter(JMethodDef method, Parameter param) {
        JType paramType = JTypes.typeOf(param.asType());
        if (!param.isPrimitive()) {
            this.sourceFile._import(paramType);
        }
        if (param.isVarArgs()) {
            return method.varargParam(2, paramType.elementType(), param.name());
        }
        return method.param(2, paramType, param.name());
    }

    private void addDefultProperties(MessageMethod messageMethod, Collection<AnnotationMirror> annotations, JBlock body, JAssignableExpr resultField, boolean field) {
        for (AnnotationMirror propertyAnnotation : annotations) {
            String name = null;
            AnnotationValue annotationValue = null;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : propertyAnnotation.getElementValues().entrySet()) {
                ExecutableElement attribute = entry.getKey();
                AnnotationValue attributeValue = entry.getValue();
                if ("name".contentEquals(attribute.getSimpleName())) {
                    name = String.valueOf(attributeValue.getValue());
                    continue;
                }
                annotationValue = attributeValue;
            }
            if (name == null) {
                throw new ProcessingException((Element)messageMethod, propertyAnnotation, "The name attribute is required for the annotation.");
            }
            if (annotationValue == null || annotationValue.getValue() == null) {
                throw new ProcessingException((Element)messageMethod, propertyAnnotation, "A value for one of the default attributes is required.");
            }
            JExpr resultValue = annotationValue.accept(JExprAnnotationValueVisitor.INSTANCE, null);
            if (resultValue == null) {
                Object value = annotationValue.getValue();
                throw new ProcessingException((Element)messageMethod, propertyAnnotation, annotationValue, "Could not resolve value type for %s (%s)", value, value.getClass());
            }
            if (field) {
                body.add(resultField.field(name).assign(resultValue));
                continue;
            }
            body.add(resultField.call("set" + Character.toUpperCase(name.charAt(0)) + name.substring(1)).arg(resultValue));
        }
    }

    private JCall getFormatMethod(JClassDef classDef, JCall localeGetter) {
        String methodName = "_formatMessage";
        if (this.messageFormatMethodGenerated.compareAndSet(false, true)) {
            JMethodDef method = classDef.method(8, String.class, "_formatMessage");
            JParamDeclaration format = method.param(2, String.class, "format");
            JParamDeclaration args = method.varargParam(2, Object.class, "args");
            JBlock body = method.body();
            JType formatterType = JTypes.$t(MessageFormat.class);
            JCall initializer = formatterType._new().arg(JExprs.$v(format)).arg(localeGetter);
            JVarDeclaration formatter = body.var(2, formatterType, "formatter", (JExpr)initializer);
            body._return(JExprs.$v(formatter).call("format").arg(JExprs.$v(args)).arg(JTypes.$t(StringBuffer.class)._new()).arg(JTypes.$t(FieldPosition.class)._new().arg(JExpr.ZERO)).call("toString"));
        }
        return JExprs.call("_formatMessage");
    }

    private JCall getCopyStackMethod(JClassDef classDef) {
        String methodName = "_copyStackTraceMinusOne";
        if (this.copyStackTraceMethodGenerated.compareAndSet(false, true)) {
            JMethodDef method = classDef.method(72, JType.VOID, "_copyStackTraceMinusOne");
            JParamDeclaration param = method.param(2, Throwable.class, "e");
            JBlock body = method.body();
            JType arrays = JTypes.$t(Arrays.class);
            this.sourceFile._import(arrays);
            JAssignableExpr e = JExprs.$v(param);
            JVarDeclaration st = body.var(2, JTypes.$t(StackTraceElement.class).array(), "st", (JExpr)e.call("getStackTrace"));
            body._if(JExprs.$v(st).field("length").gt(JExpr.ZERO)).add(e.call("setStackTrace").arg(arrays.call("copyOfRange").arg(JExprs.$v(st)).arg(JExpr.ONE).arg(JExprs.$v(st).field("length"))));
        }
        return JExprs.call("_copyStackTraceMinusOne");
    }

    private static class JExprAnnotationValueVisitor
    extends SimpleAnnotationValueVisitor8<JExpr, Void> {
        private static final JExprAnnotationValueVisitor INSTANCE = new JExprAnnotationValueVisitor();

        private JExprAnnotationValueVisitor() {
        }

        @Override
        public JExpr visitBoolean(boolean b, Void v) {
            return b ? JExpr.TRUE : JExpr.FALSE;
        }

        @Override
        public JExpr visitByte(byte b, Void v) {
            return JExprs.decimal(b).cast(JType.BYTE);
        }

        @Override
        public JExpr visitChar(char c, Void v) {
            return JExprs.ch(c);
        }

        @Override
        public JExpr visitDouble(double d, Void v) {
            return JExprs.$v(String.format("%ad", d));
        }

        @Override
        public JExpr visitFloat(float f, Void v) {
            return JExprs.hex(f);
        }

        @Override
        public JExpr visitInt(int i, Void v) {
            return JExprs.decimal(i);
        }

        @Override
        public JExpr visitLong(long i, Void v) {
            return JExprs.decimal(i);
        }

        @Override
        public JExpr visitShort(short s, Void v) {
            return JExprs.decimal(s).cast(JType.SHORT);
        }

        @Override
        public JExpr visitString(String s, Void v) {
            return JExprs.str(s);
        }

        @Override
        public JExpr visitType(TypeMirror t, Void v) {
            return JExprs.$v(t.toString() + ".class");
        }
    }
}

