/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.common_impl;

import com.sun.enterprise.module.ModuleMetadata;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipException;

public abstract class Jar {
    protected Jar() {
    }

    public abstract Manifest getManifest() throws IOException;

    public abstract void loadMetadata(ModuleMetadata var1);

    public abstract String getBaseName();

    public static Jar create(File file) throws IOException {
        if (file.isDirectory()) {
            return new Directory(file);
        }
        return new Archive(file);
    }

    private static final class Directory
    extends Jar {
        private final File dir;

        public Directory(File dir) {
            this.dir = dir;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Manifest getManifest() throws IOException {
            File mf = new File(this.dir, "META-INF/MANIFEST.MF");
            if (mf.exists()) {
                try (FileInputStream in = new FileInputStream(mf);){
                    Manifest manifest = new Manifest(in);
                    return manifest;
                }
            }
            return null;
        }

        private File[] fixNull(File[] f) {
            if (f == null) {
                return new File[0];
            }
            return f;
        }

        @Override
        public void loadMetadata(ModuleMetadata result) {
        }

        @Override
        public String getBaseName() {
            return this.dir.getName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] readFully(File f) throws IOException {
            byte[] buf = new byte[(int)f.length()];
            try (DataInputStream in = new DataInputStream(new FileInputStream(f));){
                in.readFully(buf);
                byte[] byArray = buf;
                return byArray;
            }
        }
    }

    private static final class Archive
    extends Jar {
        private final JarFile jar;
        private final File file;

        public Archive(File jar) throws IOException {
            try {
                this.jar = new JarFile(jar);
                this.file = jar;
            }
            catch (ZipException e) {
                IOException x = new IOException("Failed to open " + jar);
                x.initCause(e);
                throw x;
            }
        }

        @Override
        public Manifest getManifest() throws IOException {
            return this.jar.getManifest();
        }

        @Override
        public void loadMetadata(ModuleMetadata result) {
        }

        @Override
        public String getBaseName() {
            String name = this.file.getName();
            int idx = name.lastIndexOf(46);
            if (idx >= 0) {
                name = name.substring(0, idx);
            }
            return name;
        }
    }
}

