/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.XAConnectionFactory;
import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.jmsclient.XAConnectionImpl;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jmq.util.service.PortMapperClientHandler;
import com.sun.messaging.jms.blc.LifecycleManagedBroker;
import com.sun.messaging.jms.notification.Event;
import com.sun.messaging.jms.notification.EventListener;
import com.sun.messaging.jms.ra.ConcurrentEndpointConsumer;
import com.sun.messaging.jms.ra.ConnectionManager;
import com.sun.messaging.jms.ra.EndpointConsumer;
import com.sun.messaging.jms.ra.api.JMSRAResourceAdapter;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.resource.NotSupportedException;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ActivationSpec;
import jakarta.resource.spi.BootstrapContext;
import jakarta.resource.spi.ResourceAdapterInternalException;
import jakarta.resource.spi.endpoint.MessageEndpointFactory;
import jakarta.resource.spi.work.Work;
import jakarta.resource.spi.work.WorkManager;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAResource;

public class ResourceAdapter
implements jakarta.resource.spi.ResourceAdapter,
Serializable,
EventListener {
    boolean manageBrokerLifecycle = true;
    private String raUID = null;
    private transient BootstrapContext b_context = null;
    protected transient WorkManager workMgr = null;
    private transient boolean started;
    private transient HashMap<Integer, MessageEndpointFactory> epFactories = null;
    private transient HashMap<Integer, EndpointConsumer> epConsumers = null;
    private transient HashMap<Integer, Integer> epFactoryToConsumer = null;
    private transient int _factoryID = 0;
    private transient int _consumerID = 0;
    private transient XAConnectionFactory xacf = null;
    private transient Method onMessage = null;
    private static final transient String _className = "com.sun.messaging.jms.ra.ResourceAdapter";
    protected static final transient String _lgrNameBase = "javax.resourceadapter.mqjmsra";
    protected static final transient String _lgrNameLifecycle = "javax.resourceadapter.mqjmsra.lifecycle";
    protected static final transient String _lgrNameInboundMessage = "javax.resourceadapter.mqjmsra.inbound.message";
    protected static final transient Logger _loggerB = Logger.getLogger("javax.resourceadapter.mqjmsra");
    protected static final transient Logger _loggerL = Logger.getLogger("javax.resourceadapter.mqjmsra.lifecycle");
    protected static final transient Logger _loggerIM = Logger.getLogger("javax.resourceadapter.mqjmsra.inbound.message");
    protected static final transient String _lgrMIDPrefix = "MQJMSRA_RA";
    protected static final transient String _lgrMID_EET = "MQJMSRA_RA1001: ";
    protected static final transient String _lgrMID_INF = "MQJMSRA_RA1101: ";
    protected static final transient String _lgrMID_WRN = "MQJMSRA_RA2001: ";
    protected static final transient String _lgrMID_ERR = "MQJMSRA_RA3001: ";
    protected static final transient String _lgrMID_EXC = "MQJMSRA_RA4001: ";
    protected static final transient ConnectionManager _cm = new ConnectionManager();
    protected static final transient Version _version = new Version();
    protected String userName = "guest";
    protected String password = "guest";
    private boolean reconnectEnabled = false;
    private int reconnectInterval = 5000;
    private int reconnectAttempts = 6;
    private String addressListBehavior = "PRIORITY";
    private int addressListIterations = 1;
    private boolean inAppClientContainer = false;
    private boolean inClusteredContainer = false;
    public static final String BROKER_TYPE_REMOTE = "REMOTE";
    public static final String BROKER_TYPE_LOCAL = "LOCAL";
    public static final String BROKER_TYPE_EMBEDDED = "EMBEDDED";
    public static final String BROKER_TYPE_DIRECT = "DIRECT";
    protected static final String BROKER_TYPE_SOMEDIRECT = "DIRECT";
    protected static final String BROKER_TYPE_APIDIRECT = "APIDIRECT";
    protected static final String BROKER_TYPE_RADIRECT = "RADIRECT";
    private static final String DIRECT_MODE_DEFAULT_STANDALONE = "true";
    private static final String DIRECT_MODE_DEFAULT_CLUSTERED = "false";
    private static final String APIDIRECT_MODE_DEFAULT = "false";
    private String groupName = null;
    private transient LifecycleManagedBroker lmb;
    private int brokerPort = 7676;
    private String brokerType = "REMOTE";
    private String connectionURL = "";

    public LifecycleManagedBroker getLifecycleManagedBroker() {
        if (this.lmb == null) {
            this.lmb = new LifecycleManagedBroker();
        }
        return this.lmb;
    }

    public ResourceAdapter() {
        _loggerL.entering(_className, "constructor()");
        this.started = false;
    }

    public synchronized void start(BootstrapContext ctx) throws ResourceAdapterInternalException {
        _loggerL.entering(_className, "start()", ctx);
        JMSRAResourceAdapter.init();
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: start:Previously started:Ignoring");
        } else {
            this.fixBrokerType();
            Version version = new Version();
            _loggerL.info("MQJMSRA_RA1101: Eclipse OpenMQ JMS Resource Adapter: " + version.getRAVersion());
            _loggerL.info("MQJMSRA_RA1101: Eclipse OpenMQ JMS Resource Adapter starting: broker is " + this.getPublicBrokerType() + ", connection mode is " + this.getPublicConnectionType());
            this.b_context = ctx;
            if (this.b_context != null) {
                this.workMgr = this.b_context.getWorkManager();
            }
            this._adjustInAppClientContainer();
            this.xacf = new XAConnectionFactory();
            AccessController.doPrivileged(new PrivilegedAction<Object>(this){

                @Override
                public Object run() {
                    System.setProperty("imq.DaemonThreads", ResourceAdapter.DIRECT_MODE_DEFAULT_STANDALONE);
                    return null;
                }
            });
            if (this.isManageBrokerLifecycle() && !this._isRemote()) {
                this.getLifecycleManagedBroker().start();
            }
            try {
                this.configureFactory();
            }
            catch (JMSException jmse) {
                if (this.getLifecycleManagedBroker().isStarted() && this.getLifecycleManagedBroker().isLocal()) {
                    this.getLifecycleManagedBroker().stop();
                }
                ResourceAdapterInternalException raie = new ResourceAdapterInternalException("MQJMSRA_RA4001: start:Aborting:JMSException on createConnection=" + jmse.getMessage());
                raie.initCause((Throwable)jmse);
                _loggerL.severe(raie.getMessage());
                jmse.printStackTrace();
                _loggerL.throwing(_className, "start()", (Throwable)raie);
                throw raie;
            }
            this.epFactories = new HashMap(10);
            this.epConsumers = new HashMap(10);
            this.epFactoryToConsumer = new HashMap(10);
            this._setOnMessageMethod();
            this.started = true;
            _loggerL.config(_lgrMID_INF + this.toString());
            _loggerL.config("MQJMSRA_RA1101: start:SJSMQ JMSRA Connection Factory Config=" + String.valueOf(this.xacf.getCurrentConfiguration()));
            _loggerL.info("MQJMSRA_RA1101: Eclipse OpenMQ JMS Resource Adapter Started:" + this.getPublicBrokerType());
        }
        _loggerL.exiting(_className, "start()");
    }

    public synchronized void stop() {
        _loggerL.entering(_className, "stop()");
        if (!this.started) {
            _loggerL.warning("MQJMSRA_RA2001: stop:Previously stopped:Ignoring");
        } else {
            _loggerL.info("MQJMSRA_RA1101: Eclipse OpenMQ JMS Resource Adapter stopping...");
            this.removeAllConsumers();
            if (this.isManageBrokerLifecycle() && !this._isRemote()) {
                this.getLifecycleManagedBroker().stop();
            }
            this.started = false;
        }
        _loggerL.info("MQJMSRA_RA1101: Eclipse OpenMQ JMS Resource Adapter stopped.");
        _loggerL.exiting(_className, "stop()");
    }

    public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) throws ResourceException {
        Object[] params = new Object[]{endpointFactory, spec};
        _loggerIM.entering(_className, "endpointActivation()", params);
        if (!this.started) {
            _loggerIM.logp(Level.SEVERE, _className, "endpointActivation()", "MQJMSRA_RA4001: MQJMSRA not started:Aborting:", params);
            NotSupportedException nse = new NotSupportedException("MQJMSRA-endpointActivation:Error:RA not started:aborting");
            _loggerIM.throwing(_className, "endpointActivation()", (Throwable)nse);
            throw nse;
        }
        EndpointConsumer ec = System.getProperty("imq.jmsra.endpoint.concurrent", "false").equals(DIRECT_MODE_DEFAULT_STANDALONE) ? new ConcurrentEndpointConsumer(this, endpointFactory, spec) : new EndpointConsumer(this, endpointFactory, spec);
        try {
            ec.startMessageConsumer();
            if (_loggerIM.isLoggable(Level.FINER)) {
                _loggerIM.finer("MQJMSRA_RA1101: endpointActivation:createMessageConsumer:DONE:fID=" + ec.getFactoryID() + " cID=" + ec.getConsumerID());
            }
        }
        catch (Exception ex) {
            _loggerIM.logp(Level.SEVERE, _className, "endpointActivation()", "MQJMSRA_RA4001: :Failed due to:" + ex.getMessage(), params);
            NotSupportedException nse = new NotSupportedException("MQJMSRA-endpointActivation:Exception on createMessageConsumer:");
            nse.initCause((Throwable)ex);
            _loggerIM.throwing(_className, "endpointActivation()", (Throwable)nse);
            throw nse;
        }
        _loggerIM.exiting(_className, "endpointActivation()");
    }

    public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) {
        Object[] params = new Object[]{endpointFactory, spec};
        _loggerIM.entering(_className, "endpointDeactivation()", params);
        if (!this.started) {
            _loggerIM.logp(Level.SEVERE, _className, "endpointDeactivation()", "MQJMSRA_RA4001: MQJMSRA not started:Aborting:", params);
        } else {
            int factoryID = this.matchMessageFactory(endpointFactory);
            if (factoryID != -1) {
                int consumerID = this._getConsumerIDbyFactoryID(factoryID);
                EndpointConsumer ec = this._getEndpointConsumer(consumerID);
                ec.setDeactivated();
                try {
                    if (_loggerIM.isLoggable(Level.FINER)) {
                        _loggerIM.finer("MQJMSRA_RA1101: endpointDeactivation:stopMessageConsumer:fID=" + factoryID + " cID=" + consumerID);
                    }
                    ec.stopMessageConsumer();
                }
                catch (Exception ex) {
                    _loggerIM.logp(Level.WARNING, _className, "endpointDeactivation()", "MQJMSRA_RA2001: Exception on stopMessageConsumer:Ignoring:", ex);
                    ex.printStackTrace();
                }
                this.removeFromMaps(factoryID);
            } else {
                _loggerIM.log(Level.WARNING, "MQJMSRA_RA2001: endpointDeactivation:Ignoring:Not found:" + spec.toString());
            }
        }
        _loggerIM.exiting(_className, "endpointDeactivation()");
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException {
        _loggerL.entering(_className, "getXAResources()");
        XAResource[] xar = new XAResource[]{};
        _loggerL.exiting(_className, "getXAResources()");
        return xar;
    }

    @Override
    public void onEvent(Event evnt) {
        _loggerL.entering(_className, "onEvent()", evnt);
        _loggerL.info("MQJMSRA_RA1101: onEvent:Connection Event:" + (evnt == null ? "null" : evnt.toString()));
    }

    public synchronized void setUserName(String userName) {
        _loggerL.entering(_className, "setUserName()", userName);
        this.userName = userName;
    }

    public synchronized String getUserName() {
        _loggerL.entering(_className, "getUserName()", this.userName);
        return this.userName;
    }

    public synchronized void setPassword(String password) {
        _loggerL.entering(_className, "setPassword()");
        this.password = password;
    }

    public synchronized String getPassword() {
        _loggerL.entering(_className, "getPassword()");
        return this.password;
    }

    public synchronized void setReconnectEnabled(boolean reconnectEnabled) {
        _loggerL.entering(_className, "setReconnectEnabled()", Boolean.toString(reconnectEnabled));
        this.reconnectEnabled = reconnectEnabled;
    }

    public synchronized boolean getReconnectEnabled() {
        _loggerL.entering(_className, "getReconnectEnabled()", Boolean.toString(this.reconnectEnabled));
        return this.reconnectEnabled;
    }

    public synchronized void setReconnectInterval(int reconnectInterval) {
        _loggerL.entering(_className, "setReconnectInterval()", Integer.toString(reconnectInterval));
        this.reconnectInterval = reconnectInterval;
    }

    public synchronized int getReconnectInterval() {
        _loggerL.entering(_className, "getReconnectInterval()", Integer.toString(this.reconnectInterval));
        return this.reconnectInterval;
    }

    public synchronized void setReconnectAttempts(int reconnectAttempts) {
        _loggerL.entering(_className, "setReconnectAttempts()", Integer.toString(reconnectAttempts));
        this.reconnectAttempts = reconnectAttempts;
    }

    public synchronized int getReconnectAttempts() {
        _loggerL.entering(_className, "getReconnectAttempts()", Integer.toString(this.reconnectAttempts));
        return this.reconnectAttempts;
    }

    public synchronized void setAddressListBehavior(String addressListBehavior) {
        _loggerL.entering(_className, "setAddressListBehavior()", addressListBehavior);
        this.addressListBehavior = "RANDOM".equalsIgnoreCase(addressListBehavior) ? "RANDOM" : "PRIORITY";
    }

    public synchronized String getAddressListBehavior() {
        _loggerL.entering(_className, "getAddressListBehavior()", this.addressListBehavior);
        return this.addressListBehavior;
    }

    public synchronized void setAddressListIterations(int addressListIterations) {
        _loggerL.entering(_className, "setAddressListIterations()", Integer.toString(addressListIterations));
        if (addressListIterations < 1) {
            _loggerL.warning("MQJMSRA_RA2001: setAddressListIterations:Invalid value:" + Integer.toString(addressListIterations) + ":Setting to 1");
            this.addressListIterations = 1;
        } else {
            this.addressListIterations = addressListIterations;
        }
    }

    public synchronized int getAddressListIterations() {
        _loggerL.entering(_className, "getAddressListIterations()", Integer.toString(this.addressListIterations));
        return this.addressListIterations;
    }

    public synchronized void setInAppClientContainer(boolean inAppClientContainer) {
        _loggerL.entering(_className, "setInAppClientContainer()", Boolean.toString(inAppClientContainer));
        this.inAppClientContainer = inAppClientContainer;
        this._adjustInAppClientContainer();
    }

    public synchronized boolean getInAppClientContainer() {
        _loggerL.entering(_className, "getInAppClientContainer()", Boolean.toString(this.inAppClientContainer));
        return this.inAppClientContainer;
    }

    public synchronized void setInClusteredContainer(boolean inClusteredContainer) {
        _loggerL.entering(_className, "setInClusteredContainer()", Boolean.toString(inClusteredContainer));
        this.inClusteredContainer = inClusteredContainer;
    }

    public synchronized boolean getInClusteredContainer() {
        _loggerL.entering(_className, "getInClusteredContainer()", Boolean.toString(this.inClusteredContainer));
        return this.inClusteredContainer;
    }

    public synchronized void setGroupName(String groupName) {
        _loggerL.entering(_className, "setGroupName()", groupName);
        this.groupName = groupName;
    }

    public synchronized String getGroupName() {
        _loggerL.entering(_className, "getGroupName()", this.groupName);
        return this.groupName;
    }

    public synchronized void setBrokerType(String brokerType) {
        _loggerL.entering(_className, "setBrokerType()", brokerType);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerType:RA already started:Disallowing change from:" + this.brokerType + ":to:" + brokerType);
            return;
        }
        this.brokerType = brokerType;
        if (this.isManageBrokerLifecycle()) {
            this.getLifecycleManagedBroker().setBrokerType(brokerType);
        }
    }

    private void fixBrokerType() {
        if ("DIRECT".equals(this.brokerType) || BROKER_TYPE_EMBEDDED.equals(this.brokerType)) {
            this.brokerType = this.getInClusteredContainer() ? (ResourceAdapter._isDirectDefaultWhenClustered() ? "DIRECT" : BROKER_TYPE_EMBEDDED) : (ResourceAdapter._isDirectDefaultWhenStandalone() ? "DIRECT" : BROKER_TYPE_EMBEDDED);
            if ("DIRECT".equals(this.brokerType)) {
                if (ResourceAdapter._useAPIDirectImplementation()) {
                    _loggerL.fine("MQJMSRA_RA1101:  Using new API DIRECT mode");
                    this.brokerType = BROKER_TYPE_APIDIRECT;
                } else {
                    _loggerL.fine("MQJMSRA_RA1101:  Using old JMSRA DIRECT mode");
                    this.brokerType = BROKER_TYPE_RADIRECT;
                }
            }
        } else if (!BROKER_TYPE_LOCAL.equals(this.brokerType) && !BROKER_TYPE_REMOTE.equals(this.brokerType)) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerType:Invalid value:" + this.brokerType + ":remaining at brokerType=" + this.brokerType);
        }
    }

    public synchronized String getBrokerType() {
        _loggerL.entering(_className, "getBrokerType()", this.brokerType);
        return this.brokerType;
    }

    private synchronized String getPublicBrokerType() {
        String result = this._isInProcessBroker() ? BROKER_TYPE_EMBEDDED : this.getBrokerType();
        return result;
    }

    public synchronized String getPublicConnectionType() {
        String result = this._isRADirect() ? "Direct" : (this._isAPIDirect() ? "Direct (APIDirect)" : "TCP");
        return result;
    }

    public synchronized void setBrokerInstanceName(String brokerInstanceName) {
        this.checkManaged();
        _loggerL.entering(_className, "setBrokerInstanceName()", brokerInstanceName);
        this.getLifecycleManagedBroker().setBrokerInstanceName(brokerInstanceName);
    }

    public synchronized String getBrokerInstanceName() {
        this.checkManaged();
        String result = this.getLifecycleManagedBroker().getBrokerInstanceName();
        _loggerL.entering(_className, "getBrokerInstanceName()", result);
        return result;
    }

    public synchronized void setBrokerBindAddress(String brokerBindAddress) {
        this.checkManaged();
        _loggerL.entering(_className, "setBrokerBindAddress()", brokerBindAddress);
        this.getLifecycleManagedBroker().setBrokerBindAddress(brokerBindAddress);
    }

    public synchronized String getBrokerBindAddress() {
        this.checkManaged();
        String brokerBindAddress = this.getLifecycleManagedBroker().getBrokerBindAddress();
        _loggerL.entering(_className, "getBrokerBindAddress()", brokerBindAddress);
        return brokerBindAddress;
    }

    public synchronized void setBrokerPort(int brokerPort) {
        this.checkManaged();
        _loggerL.entering(_className, "setBrokerPort()", brokerPort);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerPort:RA already started:Disallowing change from:" + this.brokerPort + ":to:" + brokerPort);
            return;
        }
        this.brokerPort = brokerPort;
        if (this.isManageBrokerLifecycle()) {
            this.getLifecycleManagedBroker().setBrokerPort(brokerPort);
        }
    }

    public synchronized int getBrokerPort() {
        this.checkManaged();
        _loggerL.entering(_className, "getBrokerPort()", this.brokerPort);
        return this.brokerPort;
    }

    public synchronized void setConnectionURL(String connectionURL) {
        String tConnectionURL = connectionURL;
        _loggerL.entering(_className, "setConnectionURL()", tConnectionURL);
        this.connectionURL = connectionURL;
        if (this.isManageBrokerLifecycle()) {
            this.getLifecycleManagedBroker().setConnectionURL(connectionURL);
        }
    }

    public synchronized String getConnectionURL() {
        _loggerL.entering(_className, "getConnectionURL()", this.connectionURL);
        return this.connectionURL;
    }

    public synchronized void setBrokerHomeDir(String brokerHomeDir) {
        this.checkManaged();
        _loggerL.entering(_className, "setBrokerHomeDir()", brokerHomeDir);
        this.getLifecycleManagedBroker().setBrokerHomeDir(brokerHomeDir);
    }

    public synchronized String getBrokerHomeDir() {
        this.checkManaged();
        String result = this.getLifecycleManagedBroker().getBrokerHomeDir();
        _loggerL.entering(_className, "getBrokerHomeDir()", result);
        return result;
    }

    public synchronized void setBrokerVarDir(String brokerVarDir) {
        this.checkManaged();
        _loggerL.entering(_className, "setBrokerVarDir()", brokerVarDir);
        this.getLifecycleManagedBroker().setBrokerVarDir(brokerVarDir);
    }

    public synchronized String getBrokerVarDir() {
        this.checkManaged();
        String result = this.getLifecycleManagedBroker().getBrokerVarDir();
        _loggerL.entering(_className, "getBrokerVarDir()", result);
        return result;
    }

    public synchronized void setBrokerLibDir(String brokerLibDir) {
        this.checkManaged();
        _loggerL.entering(_className, "setBrokerLibDir()", brokerLibDir);
        this.getLifecycleManagedBroker().setBrokerLibDir(brokerLibDir);
    }

    public synchronized String getBrokerLibDir() {
        this.checkManaged();
        String result = this.getLifecycleManagedBroker().getBrokerLibDir();
        _loggerL.entering(_className, "getBrokerLibDir()", result);
        return result;
    }

    public synchronized void setBrokerJavaDir(String brokerJavaDir) {
        this.checkManaged();
        _loggerL.entering(_className, "setBrokerJavaDir()", brokerJavaDir);
        this.getLifecycleManagedBroker().setBrokerJavaDir(brokerJavaDir);
    }

    public synchronized String getBrokerJavaDir() {
        this.checkManaged();
        String result = this.getLifecycleManagedBroker().getBrokerJavaDir();
        _loggerL.entering(_className, "getBrokerJavaDir()", result);
        return result;
    }

    public synchronized void setBrokerArgs(String brokerArgs) {
        this.checkManaged();
        _loggerL.entering(_className, "setBrokerArgs()", brokerArgs);
        this.getLifecycleManagedBroker().setBrokerArgs(brokerArgs);
    }

    public synchronized String getBrokerArgs() {
        this.checkManaged();
        String result = this.getLifecycleManagedBroker().getBrokerArgs();
        _loggerL.entering(_className, "getBrokerArgs()", result);
        return result;
    }

    public synchronized void setMasterBroker(String masterBroker) {
        this.checkManaged();
        _loggerL.entering(_className, "setMasterBroker()", masterBroker);
        this.getLifecycleManagedBroker().setMasterBroker(masterBroker);
    }

    public synchronized String getMasterBroker() {
        this.checkManaged();
        String result = this.getLifecycleManagedBroker().getMasterBroker();
        _loggerL.entering(_className, "getMasterBroker()", result);
        return result;
    }

    public synchronized void setBrokerStartTimeout(int brokerStartTimeout) {
        this.checkManaged();
        _loggerL.entering(_className, "setBrokerStartTimeout()", brokerStartTimeout);
        this.getLifecycleManagedBroker().setBrokerStartTimeout(brokerStartTimeout);
    }

    public synchronized int getBrokerStartTimeout() {
        this.checkManaged();
        int result = this.getLifecycleManagedBroker().getBrokerStartTimeout();
        _loggerL.entering(_className, "getBrokerStartTimeout()", result);
        return result;
    }

    public synchronized void setAdminUsername(String adminUsername) {
        this.checkManaged();
        _loggerL.entering(_className, "setAdminUsername()", adminUsername);
        this.getLifecycleManagedBroker().setAdminUsername(adminUsername);
    }

    public synchronized String getAdminUsername() {
        this.checkManaged();
        String adminUsername = this.getLifecycleManagedBroker().getAdminUsername();
        _loggerL.entering(_className, "getAdminUsername()", adminUsername);
        return adminUsername;
    }

    public synchronized void setAdminPassword(String adminPassword) {
        this.checkManaged();
        _loggerL.entering(_className, "setAdminPassword()", adminPassword);
        this.getLifecycleManagedBroker().setAdminPassword(adminPassword);
    }

    public synchronized String getAdminPassword() {
        String adminPassword = this.getLifecycleManagedBroker().getAdminPassword();
        _loggerL.entering(_className, "getAdminUsername()", adminPassword);
        return adminPassword;
    }

    public synchronized HashMap getJMXConnectorEnv() {
        this.checkManaged();
        HashMap result = this.getLifecycleManagedBroker().getJMXConnectorEnv();
        _loggerL.entering(_className, "getJMXConnectorEnv()", result);
        return result;
    }

    public synchronized String getJMXServiceURLList() {
        this.checkManaged();
        _loggerL.entering(_className, "getJMXServiceURLList()", "For addressList = " + this.getConnectionURL());
        String jmxServiceURLList = this.getLifecycleManagedBroker().getJMXServiceURLList();
        _loggerL.exiting(_className, "getJMXServiceURLList()", jmxServiceURLList);
        return jmxServiceURLList;
    }

    public synchronized String getJMXServiceURL() {
        this.checkManaged();
        _loggerL.entering(_className, "getJMXServiceURL()");
        return this.getLifecycleManagedBroker().getJMXServiceURL();
    }

    public synchronized void setUseJNDIRmiServiceURL(boolean useJNDIRmiServiceURL) {
        this.checkManaged();
        _loggerL.entering(_className, "setUseJNDIRmiServiceURL()", useJNDIRmiServiceURL);
        this.getLifecycleManagedBroker().setUseJNDIRmiServiceURL(useJNDIRmiServiceURL);
    }

    public synchronized boolean getUseJNDIRmiServiceURL() {
        this.checkManaged();
        boolean result = this.getLifecycleManagedBroker().getUseJNDIRmiServiceURL();
        _loggerL.entering(_className, "getUseJNDIRmiServiceURL()", result);
        return result;
    }

    public synchronized void setStartRmiRegistry(boolean startRmiRegistry) {
        this.checkManaged();
        _loggerL.entering(_className, "setStartRmiRegistry()", startRmiRegistry);
        this.getLifecycleManagedBroker().setStartRmiRegistry(startRmiRegistry);
    }

    public synchronized boolean getStartRmiRegistry() {
        this.checkManaged();
        boolean result = this.getLifecycleManagedBroker().getStartRmiRegistry();
        _loggerL.entering(_className, "getStartRmiRegistry()", result);
        return result;
    }

    public synchronized void setRmiRegistryPort(int rmiRegistryPort) {
        this.checkManaged();
        _loggerL.entering(_className, "setRmiRegistryPort()", rmiRegistryPort);
        this.getLifecycleManagedBroker().setRmiRegistryPort(rmiRegistryPort);
    }

    public synchronized int getRmiRegistryPort() {
        this.checkManaged();
        int result = this.getLifecycleManagedBroker().getRmiRegistryPort();
        _loggerL.entering(_className, "getRmiRegistryPort()", result);
        return result;
    }

    public synchronized void setUseSSLJMXConnector(boolean useSSLJMXConnector) {
        this.checkManaged();
        _loggerL.entering(_className, "setUseSSLJMXConnector()", useSSLJMXConnector);
        this.getLifecycleManagedBroker().setUseSSLJMXConnector(useSSLJMXConnector);
    }

    public synchronized boolean getUseSSLJMXConnector() {
        this.checkManaged();
        boolean result = this.getLifecycleManagedBroker().getUseSSLJMXConnector();
        _loggerL.entering(_className, "getUseSSLJMXConnector()", result);
        return result;
    }

    public synchronized void setBrokerEnableHA(boolean brokerEnableHA) {
        this.checkManaged();
        _loggerL.entering(_className, "setBrokerEnableHA()", brokerEnableHA);
        this.getLifecycleManagedBroker().setBrokerEnableHA(brokerEnableHA);
    }

    public synchronized boolean getBrokerEnableHA() {
        this.checkManaged();
        boolean result = this.getLifecycleManagedBroker().getBrokerEnableHA();
        _loggerL.entering(_className, "getBrokerEnableHA()", result);
        return result;
    }

    public synchronized void setNowaitForMasterBrokerTimeoutInSeconds(int i) {
        this.checkManaged();
        _loggerL.entering(_className, "setNowaitForMasterBrokerTimeoutInSeconds()", i);
        this.getLifecycleManagedBroker().setNowaitForMasterBrokerTimeoutInSeconds(i);
    }

    public synchronized int getNowaitForMasterBrokerTimeoutInSeconds() {
        this.checkManaged();
        int result = this.getLifecycleManagedBroker().getNowaitForMasterBrokerTimeoutInSeconds();
        _loggerL.entering(_className, "getNowaitForMasterBrokerTimeoutInSeconds()", result);
        return result;
    }

    public synchronized void setClusterId(String clusterId) {
        this.checkManaged();
        _loggerL.entering(_className, "setClusterId()", clusterId);
        this.getLifecycleManagedBroker().setClusterId(clusterId);
    }

    public synchronized String getClusterId() {
        this.checkManaged();
        String result = this.getLifecycleManagedBroker().getClusterId();
        _loggerL.entering(_className, "getClusterId()", result);
        return result;
    }

    public synchronized void setBrokerId(String brokerId) {
        this.checkManaged();
        _loggerL.entering(_className, "setBrokerId()", brokerId);
        this.getLifecycleManagedBroker().setBrokerId(brokerId);
    }

    public synchronized String getBrokerId() {
        this.checkManaged();
        String result = this.getLifecycleManagedBroker().getBrokerId();
        _loggerL.entering(_className, "getBrokerId()", result);
        return result;
    }

    public synchronized void setBrokerProps(Properties brokerProps) {
        this.checkManaged();
        _loggerL.entering(_className, "setBrokerProps()");
        this.getLifecycleManagedBroker().setBrokerProps(brokerProps);
    }

    public synchronized void setBrokerProps(String aString) {
        this.getLifecycleManagedBroker().setBrokerProps(aString);
    }

    public synchronized Properties getBrokerProps() {
        this.checkManaged();
        _loggerL.entering(_className, "getBrokerProps()");
        Properties result = this.getLifecycleManagedBroker().getBrokerProps();
        return result;
    }

    public synchronized void setClusterBrokerList(String clusterBrokerList) {
        this.checkManaged();
        _loggerL.entering(_className, "setClusterBrokerList()", clusterBrokerList);
        this.getLifecycleManagedBroker().setClusterBrokerList(clusterBrokerList);
    }

    public synchronized String getClusterBrokerList() {
        this.checkManaged();
        String result = this.getLifecycleManagedBroker().getClusterBrokerList();
        _loggerL.entering(_className, "getClusterBrokerList()", result);
        return result;
    }

    public synchronized boolean isDoBind() {
        this.checkManaged();
        return this.getLifecycleManagedBroker().isDoBind();
    }

    public synchronized void setDoBind(boolean doBind) {
        this.checkManaged();
        this.getLifecycleManagedBroker().setDoBind(doBind);
    }

    public PortMapperClientHandler getPortMapperClientHandler() {
        this.checkManaged();
        return this.getLifecycleManagedBroker().getPortMapperClientHandler();
    }

    BootstrapContext getBootstrapContext() {
        return this.b_context;
    }

    protected String _getEffectiveConnectionURL() {
        _loggerL.entering(_className, "_getEffectiveConnectionURL()");
        Object eConnectionURL = null;
        if (this._isAPIDirect()) {
            eConnectionURL = "mq://localhost/direct";
        } else if (this.isManageBrokerLifecycle() && (this._isLocal() || this._isEmbedded() || this._isRADirect())) {
            eConnectionURL = (this.getBrokerBindAddress() != null ? this.getBrokerBindAddress() : "localhost") + ":" + Integer.toString(this.getBrokerPort());
            if (this.getConnectionURL() != null && !"".equals(this.getConnectionURL())) {
                eConnectionURL = (String)eConnectionURL + "," + this.getConnectionURL();
            }
        } else {
            eConnectionURL = this.getConnectionURL();
        }
        _loggerL.exiting(_className, "_getEffectiveConnectionURL()", eConnectionURL);
        return eConnectionURL;
    }

    protected String _getRAUID() {
        if (this.raUID == null && !this._isRADirect()) {
            try {
                XAConnectionImpl xaci = (XAConnectionImpl)this.xacf.createXAConnection();
                this.raUID = Long.toString(xaci.generateUID());
                xaci.close();
            }
            catch (JMSException jmse) {
                _loggerB.severe("Unable to generate UID:" + jmse.getMessage());
            }
        }
        return this.raUID;
    }

    protected Method _getOnMessageMethod() {
        if (this.onMessage == null) {
            this._setOnMessageMethod();
        }
        return this.onMessage;
    }

    private void configureFactory() throws JMSException {
        if (!BROKER_TYPE_REMOTE.equals(this.brokerType)) {
            this.xacf.setProperty("imqAddressList", this._getEffectiveConnectionURL());
            this.xacf.setProperty("imqAddressListBehavior", "PRIORITY");
        } else {
            this.xacf.setProperty("imqAddressList", this.getConnectionURL());
            this.xacf.setProperty("imqAddressListBehavior", this.addressListBehavior);
        }
        this.xacf.setProperty("imqDefaultUsername", this.userName);
        this.xacf.setProperty("imqDefaultPassword", this.password);
        this.xacf.setProperty("imqAddressListIterations", Integer.toString(this.addressListIterations));
        this.xacf.setProperty("imqReconnectEnabled", Boolean.toString(false));
        this.xacf.setProperty("imqReconnectInterval", Integer.toString(this.reconnectInterval));
        this.xacf.setProperty("imqReconnectAttempts", Integer.toString(this.reconnectAttempts));
    }

    private int createFactoryID() {
        return ++this._factoryID;
    }

    private int createConsumerID() {
        return ++this._consumerID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int addMessageFactory(MessageEndpointFactory endpointFactory) {
        int factoryID = this.createFactoryID();
        HashMap<Integer, MessageEndpointFactory> hashMap = this.epFactories;
        synchronized (hashMap) {
            this.epFactories.put(factoryID, endpointFactory);
        }
        return factoryID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMessageFactory(int factoryID) {
        HashMap<Integer, MessageEndpointFactory> hashMap = this.epFactories;
        synchronized (hashMap) {
            this.epFactories.remove(factoryID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageEndpointFactory _getMessageFactory(int factoryID) {
        HashMap<Integer, MessageEndpointFactory> hashMap = this.epFactories;
        synchronized (hashMap) {
            MessageEndpointFactory epFactory = this.epFactories.get(factoryID);
            return epFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int matchMessageFactory(MessageEndpointFactory endpointFactory) {
        int key = -1;
        if (endpointFactory != null) {
            HashMap<Integer, MessageEndpointFactory> hashMap = this.epFactories;
            synchronized (hashMap) {
                Set<Map.Entry<Integer, MessageEndpointFactory>> factories = this.epFactories.entrySet();
                if (factories != null) {
                    for (Map.Entry<Integer, MessageEndpointFactory> thisEntry : factories) {
                        if (!endpointFactory.equals((Object)thisEntry.getValue())) continue;
                        Integer iKey = thisEntry.getKey();
                        key = iKey;
                        break;
                    }
                }
            }
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFactorytoConsumerLink(int factoryID, int consumerID) {
        HashMap<Integer, Integer> hashMap = this.epFactoryToConsumer;
        synchronized (hashMap) {
            this.epFactoryToConsumer.put(factoryID, consumerID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFactorytoConsumerLink(int factoryID) {
        HashMap<Integer, Integer> hashMap = this.epFactoryToConsumer;
        synchronized (hashMap) {
            this.epFactoryToConsumer.remove(factoryID);
        }
    }

    private int _getConsumerIDbyFactoryID(int factoryID) {
        return this.epFactoryToConsumer.get(factoryID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int addEndpointConsumer(EndpointConsumer endpointConsumer) {
        int consumerID = this.createConsumerID();
        HashMap<Integer, EndpointConsumer> hashMap = this.epConsumers;
        synchronized (hashMap) {
            this.epConsumers.put(consumerID, endpointConsumer);
        }
        return consumerID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEndpointConsumer(int consumerID) {
        HashMap<Integer, EndpointConsumer> hashMap = this.epConsumers;
        synchronized (hashMap) {
            this.epConsumers.remove(consumerID);
        }
    }

    private EndpointConsumer _getEndpointConsumer(int consumerID) {
        EndpointConsumer endpointConsumer = this.epConsumers.get(consumerID);
        return endpointConsumer;
    }

    private void removeFromMaps(int factoryID) {
        int consumerID = this._getConsumerIDbyFactoryID(factoryID);
        this.removeEndpointConsumer(consumerID);
        this.removeMessageFactory(factoryID);
        this.removeFactorytoConsumerLink(factoryID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllConsumers() {
        HashMap<Integer, MessageEndpointFactory> hashMap = this.epFactories;
        synchronized (hashMap) {
            Set<Map.Entry<Integer, MessageEndpointFactory>> factories = this.epFactories.entrySet();
            if (factories != null) {
                for (Map.Entry<Integer, MessageEndpointFactory> entry : factories) {
                    int factoryID = entry.getKey();
                    int consumerID = this._getConsumerIDbyFactoryID(factoryID);
                    EndpointConsumer ec = this._getEndpointConsumer(consumerID);
                    try {
                        ec.stopMessageConsumer();
                    }
                    catch (Exception ex) {
                        System.err.println("MQJMSRA:RA::Error:stopMessageConsumer exception:ignoring");
                    }
                }
                this.clearMaps();
            }
        }
    }

    private void clearMaps() {
        this.epFactories.clear();
        this.epConsumers.clear();
        this.epFactoryToConsumer.clear();
    }

    private void _setOnMessageMethod() {
        Method onMessageMethod = null;
        try {
            Class[] paramTypes = new Class[]{Message.class};
            onMessageMethod = MessageListener.class.getMethod("onMessage", paramTypes);
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        this.onMessage = onMessageMethod;
    }

    private void _adjustInAppClientContainer() {
        String inACC_SysProp = System.getProperty("imq.jmsra.inACC");
        if (inACC_SysProp != null) {
            System.err.println("MQJMSRA:RA:AIACC:SystemProp imq.jmsra.inACC is NOT null!!");
            if (DIRECT_MODE_DEFAULT_STANDALONE.equals(inACC_SysProp)) {
                System.err.println("MQJMSRA:RA:AIACC:setting inACC true");
                this.inAppClientContainer = true;
            } else {
                System.err.println("MQJMSRA:RA:AIACC:setting inACC false");
                this.inAppClientContainer = false;
            }
        } else if (this.workMgr != null) {
            try {
                this.workMgr.doWork(new Work(this){

                    public void run() {
                    }

                    public void release() {
                    }
                });
            }
            catch (Exception we) {
                this.inAppClientContainer = true;
            }
        } else {
            this.inAppClientContainer = true;
        }
    }

    private static boolean _isDirectDefaultWhenStandalone() {
        return Boolean.valueOf(System.getProperty("imq.jmsra.direct", DIRECT_MODE_DEFAULT_STANDALONE));
    }

    private static boolean _isDirectDefaultWhenClustered() {
        return Boolean.valueOf(System.getProperty("imq.jmsra.direct.clustered", "false"));
    }

    protected static boolean _useAPIDirectImplementation() {
        return Boolean.valueOf(System.getProperty("imq.jmsra.apidirect", "false"));
    }

    public String toString() {
        return "SJSMQ JMSRA ResourceAdapter configuration=\n\traUID                    =" + this.raUID + "\n\tGroupName                =" + this.groupName + "\n\tbrokerType               =" + this.brokerType + "\tbrokerPort               =" + this.brokerPort + "\n\tConnectionURL            =" + this.connectionURL + "\n\tRADIRECT Mode allowed    =" + this._isRADirectAllowed() + "\n\tAPIDIRECT Mode allowed   =" + this._isAPIDirectAllowed() + "\n\tDIRECT Mode default      =" + ResourceAdapter._isDirectDefaultWhenStandalone() + "\n\tUse APIDIRECT impl       =" + ResourceAdapter._useAPIDirectImplementation() + "\n\tUserName                 =" + this.userName + "\n\tPassword                 =" + ("guest".equals(this.password) ? "<default>" : "<modified>") + "\n\tReconnectEnabled         =" + this.reconnectEnabled + "\n\tReconnectInterval        =" + this.reconnectInterval + "\n\tReconnectAttempts        =" + this.reconnectAttempts + "\n\tAddressListBehavior      =" + this.addressListBehavior + "\n\tAddressListIterations    =" + this.addressListIterations + "\n\tInAppClientContainer     =" + this.inAppClientContainer + "\n\tInClusteredContainer     =" + this.inClusteredContainer + "\n" + this.getLifecycleManagedBroker().toString();
    }

    protected static ConnectionManager _getConnectionManager() {
        return _cm;
    }

    public JMSService _getJMSService() {
        JMSService result = null;
        if (this.getLifecycleManagedBroker() != null) {
            result = this.getLifecycleManagedBroker()._getJMSService();
        }
        return result;
    }

    protected static JMSService _getRAJMSService() {
        return LifecycleManagedBroker._getRAJMSService();
    }

    public boolean _isInProcessBroker() {
        return BROKER_TYPE_RADIRECT.equals(this.brokerType) | BROKER_TYPE_APIDIRECT.equals(this.brokerType) | "DIRECT".equals(this.brokerType) | BROKER_TYPE_EMBEDDED.equals(this.brokerType);
    }

    public boolean _isRADirect() {
        return BROKER_TYPE_RADIRECT.equals(this.brokerType);
    }

    public boolean _isAPIDirect() {
        return BROKER_TYPE_APIDIRECT.equals(this.brokerType);
    }

    public boolean _isEmbedded() {
        return BROKER_TYPE_EMBEDDED.equals(this.brokerType);
    }

    public boolean _isLocal() {
        return BROKER_TYPE_LOCAL.equals(this.brokerType);
    }

    public boolean _isRemote() {
        return BROKER_TYPE_REMOTE.equals(this.brokerType);
    }

    public boolean _isRADirectAllowed() {
        return this._isRADirect() && !this.inAppClientContainer;
    }

    public boolean _isAPIDirectAllowed() {
        return this._isAPIDirect() && !this.inAppClientContainer;
    }

    public void setDoInitOnlyOnStart(boolean start) {
        if (start) {
            throw new RuntimeException("setDoInitOnlyOnStart(true) is not supported any more");
        }
    }

    private void checkManaged() {
        if (!this.isManageBrokerLifecycle()) {
            throw new IllegalStateException("com.sun.messaging.jms.ra.ResourceAdapter: cannot perform broker lifecycle operations if manageBrokerLifecycle=true");
        }
    }

    public boolean isManageBrokerLifecycle() {
        return this.manageBrokerLifecycle;
    }

    public void setManageBrokerLifecycle(boolean manageBrokerLifecycle) {
        this.manageBrokerLifecycle = manageBrokerLifecycle;
    }
}

