/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jnosql.nosql.metadata.reflection;

import jakarta.nosql.AttributeConverter;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jnosql.mapping.metadata.MappingType;
import org.eclipse.jnosql.mapping.metadata.ParameterMetaData;
import org.glassfish.main.jnosql.nosql.metadata.reflection.Reflections;

class DefaultParameterMetaData
implements ParameterMetaData {
    private final String name;
    private final Class<?> type;
    private final boolean id;
    private final MappingType mappingType;
    private final Class<? extends AttributeConverter<?, ?>> converter;

    DefaultParameterMetaData(String name, Class<?> type, boolean id, Class<? extends AttributeConverter<?, ?>> converter, MappingType mappingType) {
        this.name = name;
        this.type = type;
        this.id = id;
        this.converter = converter;
        this.mappingType = mappingType;
    }

    public MappingType mappingType() {
        return this.mappingType;
    }

    public String name() {
        return this.name;
    }

    public Class<?> type() {
        return this.type;
    }

    public boolean isId() {
        return this.id;
    }

    public <X, Y, T extends AttributeConverter<X, Y>> Optional<Class<T>> converter() {
        return Optional.ofNullable(this.converter);
    }

    public <X, Y, T extends AttributeConverter<X, Y>> Optional<T> newConverter() {
        return Optional.ofNullable(this.converter).map(c -> (AttributeConverter)Reflections.newInstance(c));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultParameterMetaData that = (DefaultParameterMetaData)o;
        return this.id == that.id && Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.converter, that.converter);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.id, this.converter);
    }

    public String toString() {
        return "ParameterMetaData{name='" + this.name + "', type=" + String.valueOf(this.type) + ", id=" + this.id + ", converter=" + String.valueOf(this.converter) + "}";
    }
}

