/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.time.LocalDateTime;
import org.eclipse.persistence.descriptors.JavaTimeLockingPolicy;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.ModifyQuery;

public class LocalDateTimeLockingPolicy
extends JavaTimeLockingPolicy<LocalDateTime> {
    public LocalDateTimeLockingPolicy() {
    }

    public LocalDateTimeLockingPolicy(DatabaseField field) {
        super(field);
    }

    @Override
    int compareJavaTimeLockValues(LocalDateTime value1, LocalDateTime value2) {
        return value1.compareTo(value2);
    }

    @Override
    Class<LocalDateTime> getDefaultJavaTimeLockFieldType() {
        return CoreClassConstants.LOCAL_DATETIME;
    }

    @Override
    LocalDateTime getBaseJavaTimeValue() {
        return LocalDateTime.MIN;
    }

    @Override
    LocalDateTime getInitialJavaTimeWriteValue(AbstractSession session) {
        switch (this.getTimeSource()) {
            case Local: {
                return LocalDateTime.now();
            }
            case Server: {
                AbstractSession readSession = session.getSessionForClass(this.getDescriptor().getJavaClass());
                Platform platform = session.getDatasourcePlatform();
                while (readSession.isUnitOfWork()) {
                    readSession = readSession.getParent().getSessionForClass(this.getDescriptor().getJavaClass());
                }
                return platform.convertObject(session.executeQuery(platform.getTimestampQuery()), CoreClassConstants.LOCAL_DATETIME);
            }
        }
        return null;
    }

    @Override
    LocalDateTime getNewJavaTimeLockValue(ModifyQuery query) {
        return this.getInitialJavaTimeWriteValue(query.getSession());
    }

    @Override
    LocalDateTime getJavaTimeValueToPutInCache(AbstractRecord row, AbstractSession session) {
        if (this.isStoredInCache()) {
            return session.getDatasourcePlatform().convertObject(row.get(this.getWriteLockField()), CoreClassConstants.LOCAL_DATETIME);
        }
        return null;
    }

    @Override
    LocalDateTime getWriteJavaTimeLockValue(Object domainObject, Object primaryKey, AbstractSession session) {
        LocalDateTime writeLockFieldValue = null;
        if (this.isStoredInCache()) {
            writeLockFieldValue = (LocalDateTime)session.getIdentityMapAccessorInstance().getWriteLockValue(primaryKey, domainObject.getClass(), this.getDescriptor());
        } else {
            Object lockValue = this.lockValueFromObject(domainObject);
            if (lockValue != null) {
                if (lockValue instanceof LocalDateTime) {
                    writeLockFieldValue = (LocalDateTime)this.lockValueFromObject(domainObject);
                } else {
                    throw OptimisticLockException.needToMapJavaSqlTimestampWhenStoredInObject();
                }
            }
        }
        return writeLockFieldValue;
    }

    @Override
    boolean isNewerJavaTimeVersion(LocalDateTime current, Object domainObject, Object primaryKey, AbstractSession session) {
        LocalDateTime writeLockFieldValue = this.isStoredInCache() ? (LocalDateTime)session.getIdentityMapAccessorInstance().getWriteLockValue(primaryKey, domainObject.getClass(), this.getDescriptor()) : (LocalDateTime)this.lockValueFromObject(domainObject);
        return this.isNewerJavaTimeVersion(current, writeLockFieldValue);
    }

    @Override
    boolean isNewerJavaTimeVersion(AbstractRecord row, Object domainObject, Object primaryKey, AbstractSession session) {
        LocalDateTime newWriteLockFieldValue = session.getDatasourcePlatform().convertObject(row.get(this.getWriteLockField()), CoreClassConstants.LOCAL_DATETIME);
        LocalDateTime writeLockFieldValue = this.isStoredInCache() ? (LocalDateTime)session.getIdentityMapAccessorInstance().getWriteLockValue(primaryKey, domainObject.getClass(), this.getDescriptor()) : (LocalDateTime)this.lockValueFromObject(domainObject);
        return this.isNewerJavaTimeVersion(newWriteLockFieldValue, writeLockFieldValue);
    }

    @Override
    boolean isNewerJavaTimeVersion(LocalDateTime first, LocalDateTime second) {
        if (first == null) {
            return false;
        }
        if (second == null) {
            return true;
        }
        return first.isAfter(second);
    }

    @Override
    public int getVersionDifference(Object currentValue, Object domainObject, Object primaryKeys, AbstractSession session) {
        LocalDateTime newWriteLockFieldValue = (LocalDateTime)currentValue;
        if (newWriteLockFieldValue == null) {
            return 0;
        }
        LocalDateTime writeLockFieldValue = this.isStoredInCache() ? (LocalDateTime)session.getIdentityMapAccessorInstance().getWriteLockValue(primaryKeys, domainObject.getClass(), this.getDescriptor()) : (LocalDateTime)this.lockValueFromObject(domainObject);
        if (newWriteLockFieldValue.equals(writeLockFieldValue)) {
            return 0;
        }
        if (writeLockFieldValue != null && !newWriteLockFieldValue.isAfter(writeLockFieldValue)) {
            return -1;
        }
        return 1;
    }
}

