/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.codegen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.codegen.CodeGenerator;
import org.eclipse.persistence.internal.codegen.MethodDefinition;

public class ReflectiveMethodDefinition
extends MethodDefinition {
    protected List<Class<?>> argumentTypes = new ArrayList(5);
    protected Class<?> type = null;

    public void addArgument(Class<?> argumentType, String argumentName) {
        this.getArgumentNames().add(argumentName);
        this.argumentTypes.add(argumentType);
    }

    @Override
    protected boolean argumentsEqual(MethodDefinition methodDefinition) {
        Object[] args2;
        Object[] args1 = this.getArgumentTypes().toArray();
        if (args1.length == (args2 = methodDefinition.getArgumentTypes().toArray()).length) {
            for (int i = 0; i < args1.length; ++i) {
                if (args1[i] == args2[i]) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    protected List<String> getArgumentTypeNames() {
        ArrayList<String> argumentTypeNames = new ArrayList<String>();
        for (Class<?> argumentType : this.argumentTypes) {
            argumentTypeNames.add(argumentType.getName());
        }
        return argumentTypeNames;
    }

    @Override
    public List<String> getArgumentTypes() {
        return this.getArgumentTypeNames();
    }

    @Override
    protected void writeArguments(CodeGenerator generator) throws IOException {
        boolean isFirst = true;
        for (int index = 0; index < this.argumentTypes.size(); ++index) {
            Class<?> argument = this.argumentTypes.get(index);
            if (isFirst) {
                isFirst = false;
            } else {
                generator.write(", ");
            }
            if (argument.isArray()) {
                String componentType = argument.getComponentType().getName();
                if (componentType.indexOf(36) != -1) {
                    componentType = componentType.replace('$', '.');
                }
                String componentTypeArrays = componentType + "[]";
                generator.write(componentTypeArrays);
            } else {
                String name = argument.getName();
                if (name.indexOf(36) != -1) {
                    name = name.replace('$', '.');
                }
                generator.write(name);
            }
            generator.write(" ");
            generator.write(this.getArgumentNames().get(index));
        }
    }

    public Class<?> getReturnTypeClass() {
        return this.type;
    }

    public void setReturnTypeClass(Class<?> type) {
        this.type = type;
    }

    @Override
    public String getReturnType() {
        if (this.getReturnTypeClass() != null) {
            if (this.getReturnTypeClass().isArray()) {
                return this.getReturnTypeClass().getComponentType().getName() + "[]";
            }
            return this.getReturnTypeClass().getName();
        }
        return this.returnType;
    }
}

