/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.persistence.core.descriptors.CoreDescriptor;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.DescriptorCompare;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.internal.queries.DatabaseQueryMechanism;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.CommitOrderCalculator;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.UpdateObjectQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;

public class CommitManager {
    protected List<Class<?>> commitOrder;
    protected Map<Object, Integer> commitState;
    protected static final Integer PRE = 1;
    protected static final Integer POST = 2;
    protected static final Integer COMPLETE = 3;
    protected static final Integer IGNORE = 4;
    protected Map shallowCommits;
    protected AbstractSession session;
    protected boolean isActive;
    protected Map<DatabaseMapping, List<Object[]>> dataModifications;
    protected Map<DatabaseTable, List<Object[]>> deferredCalls;
    protected List objectsToDelete;
    protected int commitDepth;

    public CommitManager(AbstractSession session) {
        this.session = session;
    }

    public void addDataModificationEvent(DatabaseMapping mapping, Object[] event) {
        if (!this.getDataModifications().containsKey(mapping)) {
            this.dataModifications.put(mapping, new ArrayList());
        }
        this.dataModifications.get(mapping).add(event);
    }

    public void addDeferredCall(DatabaseTable table, DatasourceCall call, DatabaseQueryMechanism mechanism) {
        if (!this.getDeferredCalls().containsKey(table)) {
            this.deferredCalls.put(table, new ArrayList());
        }
        Object[] arguments = new Object[]{call, mechanism};
        this.deferredCalls.get(table).add(arguments);
    }

    public void addObjectToDelete(Object objectToDelete) {
        this.getObjectsToDelete().add(objectToDelete);
    }

    public void commitAllObjectsWithChangeSet(UnitOfWorkChangeSet uowChangeSet) throws RuntimeException, DatabaseException, OptimisticLockException {
        this.reinitialize();
        this.isActive = true;
        this.session.beginTransaction();
        try {
            int index;
            if (uowChangeSet.getObjectChanges().size() + uowChangeSet.getNewObjectChangeSets().size() <= 1) {
                Iterator<Class<?>> classes = uowChangeSet.getNewObjectChangeSets().keySet().iterator();
                if (classes.hasNext()) {
                    Class<?> clazz = classes.next();
                    this.commitNewObjectsForClassWithChangeSet(uowChangeSet, clazz);
                }
                if ((classes = uowChangeSet.getObjectChanges().keySet().iterator()).hasNext()) {
                    Class<?> clazz = classes.next();
                    this.commitChangedObjectsForClassWithChangeSet(uowChangeSet, clazz);
                }
            } else {
                Iterator<Map.Entry<DatabaseMapping, List<Object[]>>> commitOrder = this.getCommitOrder();
                int n = commitOrder.size();
                for (index = 0; index < n; ++index) {
                    Class<?> theClass = commitOrder.get(index);
                    this.commitAllObjectsForClassWithChangeSet(uowChangeSet, theClass);
                }
            }
            if (this.hasDeferredCalls()) {
                for (List list : this.deferredCalls.values()) {
                    for (Object[] argument : list) {
                        ((DatabaseQueryMechanism)argument[1]).executeDeferredCall((DatasourceCall)argument[0]);
                    }
                }
            }
            if (this.hasDataModifications()) {
                for (Map.Entry<DatabaseMapping, List<Object[]>> entry : this.dataModifications.entrySet()) {
                    List<Object[]> events = entry.getValue();
                    int size = events.size();
                    DatabaseMapping mapping = entry.getKey();
                    for (int index2 = 0; index2 < size; ++index2) {
                        Object[] event = events.get(index2);
                        mapping.performDataModificationEvent(event, this.getSession());
                    }
                }
            }
            if (this.hasObjectsToDelete()) {
                List objects = this.getObjectsToDelete();
                int n = objects.size();
                this.reinitialize();
                for (index = 0; index < n; ++index) {
                    this.session.deleteObject(objects.get(index));
                }
            }
            this.session.commitTransaction();
        }
        catch (RuntimeException exception) {
            this.session.rollbackTransaction();
            throw exception;
        }
        finally {
            this.reinitialize();
            this.isActive = false;
        }
    }

    protected void commitAllObjectsForClassWithChangeSet(UnitOfWorkChangeSet uowChangeSet, Class<?> theClass) {
        this.commitChangedObjectsForClassWithChangeSet(uowChangeSet, theClass);
        this.commitNewObjectsForClassWithChangeSet(uowChangeSet, theClass);
    }

    protected void commitNewObjectsForClassWithChangeSet(UnitOfWorkChangeSet uowChangeSet, Class<?> theClass) {
        Map<ObjectChangeSet, ObjectChangeSet> newObjectChangesList = uowChangeSet.getNewObjectChangeSets().get(theClass);
        if (newObjectChangesList != null) {
            AbstractSession session = this.getSession();
            CoreDescriptor descriptor = session.getDescriptor((Class)theClass);
            ArrayList<ObjectChangeSet> newChangeSets = new ArrayList<ObjectChangeSet>(newObjectChangesList.values());
            int size = newChangeSets.size();
            for (int index = 0; index < size; ++index) {
                ObjectChangeSet changeSetToWrite = (ObjectChangeSet)newChangeSets.get(index);
                Object objectToWrite = changeSetToWrite.getUnitOfWorkClone();
                if (!this.isProcessedCommit(objectToWrite)) {
                    InsertObjectQuery commitQuery = ((ClassDescriptor)descriptor).getQueryManager().getInsertQuery();
                    if (commitQuery == null) {
                        commitQuery = new InsertObjectQuery();
                        commitQuery.setDescriptor((ClassDescriptor)descriptor);
                    } else {
                        commitQuery.checkPrepare(session, commitQuery.getTranslationRow());
                        commitQuery = (InsertObjectQuery)commitQuery.clone();
                    }
                    commitQuery.setIsExecutionClone(true);
                    commitQuery.setObjectChangeSet(changeSetToWrite);
                    commitQuery.setObject(objectToWrite);
                    commitQuery.cascadeOnlyDependentParts();
                    commitQuery.setModifyRow(null);
                    session.executeQuery(commitQuery);
                }
                uowChangeSet.putNewObjectInChangesList(changeSetToWrite, session);
            }
        }
    }

    protected void commitChangedObjectsForClassWithChangeSet(UnitOfWorkChangeSet uowChangeSet, Class<?> theClass) {
        Map<ObjectChangeSet, ObjectChangeSet> objectChangesList = uowChangeSet.getObjectChanges().get(theClass);
        if (objectChangesList != null) {
            ClassDescriptor descriptor = null;
            AbstractSession session = this.getSession();
            Collection<ObjectChangeSet> changes = objectChangesList.values();
            UnitOfWork.CommitOrderType order = ((UnitOfWorkImpl)session).getCommitOrder();
            if (order != UnitOfWork.CommitOrderType.NONE) {
                changes = new ArrayList<ObjectChangeSet>(objectChangesList.values());
                if (order == UnitOfWork.CommitOrderType.CHANGES) {
                    ((List)changes).sort(new ObjectChangeSet.ObjectChangeSetComparator());
                } else {
                    Collections.sort((List)changes);
                }
            }
            for (ObjectChangeSet changeSetToWrite : changes) {
                Object objectToWrite = changeSetToWrite.getUnitOfWorkClone();
                if (descriptor == null) {
                    descriptor = session.getDescriptor(objectToWrite);
                }
                if (this.isProcessedCommit(objectToWrite)) continue;
                WriteObjectQuery commitQuery = null;
                commitQuery = changeSetToWrite.isNew() ? new InsertObjectQuery() : new UpdateObjectQuery();
                commitQuery.setIsExecutionClone(true);
                commitQuery.setDescriptor(descriptor);
                commitQuery.setObjectChangeSet(changeSetToWrite);
                commitQuery.setObject(objectToWrite);
                commitQuery.cascadeOnlyDependentParts();
                session.executeQuery(commitQuery);
            }
        }
    }

    public void deleteAllObjects(List objects) throws RuntimeException, DatabaseException, OptimisticLockException {
        this.isActive = true;
        AbstractSession session = this.getSession();
        session.beginTransaction();
        try {
            if (objects.size() == 1) {
                this.deleteAllObjects(objects.get(0).getClass(), objects, session);
            } else {
                List<Class<?>> commitOrder = this.getCommitOrder();
                for (int orderIndex = commitOrder.size() - 1; orderIndex >= 0; --orderIndex) {
                    Class<?> theClass = commitOrder.get(orderIndex);
                    this.deleteAllObjects(theClass, objects, session);
                }
            }
            session.commitTransaction();
        }
        catch (RuntimeException exception) {
            try {
                session.rollbackTransaction();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
        finally {
            this.reinitialize();
            this.isActive = false;
        }
    }

    public void deleteAllObjects(Class<?> theClass, List objects, AbstractSession session) {
        CoreDescriptor descriptor = null;
        if (((UnitOfWorkImpl)session).getCommitOrder() != UnitOfWork.CommitOrderType.NONE) {
            objects = this.sort(theClass, objects);
        }
        int size = objects.size();
        for (int index = 0; index < size; ++index) {
            DeleteObjectQuery deleteQuery;
            Object objectToDelete = objects.get(index);
            if (objectToDelete.getClass() != theClass) continue;
            if (descriptor == null) {
                descriptor = session.getDescriptor((Class)theClass);
            }
            if ((deleteQuery = descriptor.getQueryManager().getDeleteQuery()) == null) {
                deleteQuery = new DeleteObjectQuery();
                deleteQuery.setDescriptor((ClassDescriptor)descriptor);
            } else {
                deleteQuery.checkPrepare(session, deleteQuery.getTranslationRow());
                deleteQuery = (DeleteObjectQuery)deleteQuery.clone();
            }
            deleteQuery.setIsExecutionClone(true);
            deleteQuery.setObject(objectToDelete);
            session.executeQuery(deleteQuery);
        }
    }

    private List sort(Class<?> theClass, List objects) {
        CoreDescriptor descriptor = this.session.getDescriptor((Class)theClass);
        ObjectBuilder objectBuilder = ((ClassDescriptor)descriptor).getObjectBuilder();
        int size = objects.size();
        TreeMap sortedObjects = new TreeMap();
        for (int index = 0; index < size; ++index) {
            Object objectToDelete = objects.get(index);
            if (objectToDelete.getClass() != theClass) continue;
            sortedObjects.put(objectBuilder.extractPrimaryKeyFromObject(objectToDelete, this.session), objectToDelete);
        }
        return new ArrayList(sortedObjects.values());
    }

    public List<Class<?>> getCommitOrder() {
        if (this.commitOrder == null) {
            this.commitOrder = new ArrayList();
        }
        return this.commitOrder;
    }

    protected Map<Object, Integer> getCommitState() {
        if (this.commitState == null) {
            this.commitState = new IdentityHashMap<Object, Integer>();
        }
        return this.commitState;
    }

    protected boolean hasDataModifications() {
        return this.dataModifications != null && !this.dataModifications.isEmpty();
    }

    protected Map<DatabaseMapping, List<Object[]>> getDataModifications() {
        if (this.dataModifications == null) {
            this.dataModifications = new LinkedHashMap<DatabaseMapping, List<Object[]>>();
        }
        return this.dataModifications;
    }

    protected boolean hasDeferredCalls() {
        return this.deferredCalls != null && !this.deferredCalls.isEmpty();
    }

    protected Map<DatabaseTable, List<Object[]>> getDeferredCalls() {
        if (this.deferredCalls == null) {
            this.deferredCalls = new LinkedHashMap<DatabaseTable, List<Object[]>>();
        }
        return this.deferredCalls;
    }

    protected boolean hasObjectsToDelete() {
        return this.objectsToDelete != null && !this.objectsToDelete.isEmpty();
    }

    public List getObjectsToDelete() {
        if (this.objectsToDelete == null) {
            this.objectsToDelete = new ArrayList();
        }
        return this.objectsToDelete;
    }

    protected AbstractSession getSession() {
        return this.session;
    }

    protected Map getShallowCommits() {
        if (this.shallowCommits == null) {
            this.shallowCommits = new IdentityHashMap();
        }
        return this.shallowCommits;
    }

    public void initializeCommitOrder() {
        int index;
        Vector<ClassDescriptor> descriptors = new Vector<ClassDescriptor>(this.getSession().getDescriptors().values());
        descriptors = Helper.addAllUniqueToVector(new Vector(descriptors.size()), descriptors);
        ClassDescriptor[] descriptorsArray = new ClassDescriptor[descriptors.size()];
        for (index = 0; index < descriptors.size(); ++index) {
            descriptorsArray[index] = descriptors.get(index);
        }
        Arrays.sort(descriptorsArray, new DescriptorCompare());
        descriptors = new Vector(descriptors.size());
        for (index = 0; index < descriptorsArray.length; ++index) {
            descriptors.add(descriptorsArray[index]);
        }
        CommitOrderCalculator calculator = new CommitOrderCalculator(this.getSession());
        calculator.addNodes(descriptors);
        calculator.calculateMappingDependencies();
        calculator.orderCommits();
        descriptors = calculator.getOrderedDescriptors();
        calculator = new CommitOrderCalculator(this.getSession());
        calculator.addNodes(descriptors);
        calculator.calculateSpecifiedDependencies();
        calculator.orderCommits();
        this.setCommitOrder(calculator.getOrderedClasses());
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isProcessedCommit(Object object) {
        return this.getCommitState().get(object) != null;
    }

    public boolean isCommitCompleted(Object object) {
        return this.getCommitState().get(object) == COMPLETE;
    }

    public boolean isCommitCompletedInPostOrIgnore(Object object) {
        Integer state = this.getCommitState().get(object);
        return state == COMPLETE || state == POST || state == IGNORE;
    }

    public boolean isCommitInPostModify(Object object) {
        return this.getCommitState().get(object) == POST;
    }

    public boolean isCommitInPreModify(Object objectOrChangeSet) {
        return this.getCommitState().get(objectOrChangeSet) == PRE;
    }

    public boolean isShallowCommitted(Object object) {
        if (this.shallowCommits == null) {
            return false;
        }
        return this.shallowCommits.containsKey(object);
    }

    public void markCommitCompleted(Object object) {
        --this.commitDepth;
        this.getCommitState().put(object, COMPLETE);
        if (!this.isActive && this.commitDepth == 0) {
            this.reinitialize();
            return;
        }
    }

    public void markIgnoreCommit(Object object) {
        this.getCommitState().put(object, IGNORE);
    }

    public void markPostModifyCommitInProgress(Object object) {
        this.getCommitState().put(object, POST);
    }

    public void markPreModifyCommitInProgress(Object object) {
        ++this.commitDepth;
        this.getCommitState().put(object, PRE);
    }

    public void markShallowCommit(Object object) {
        this.getShallowCommits().put(object, object);
    }

    public void reinitialize() {
        this.commitState = null;
        this.commitDepth = 0;
        this.shallowCommits = null;
        this.objectsToDelete = null;
        this.dataModifications = null;
        this.deferredCalls = null;
    }

    public void setCommitOrder(List<Class<?>> commitOrder) {
        this.commitOrder = commitOrder;
    }

    protected void setDataModifications(Map<DatabaseMapping, List<Object[]>> dataModifications) {
        this.dataModifications = dataModifications;
    }

    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }

    protected void setObjectsToDelete(List objectsToDelete) {
        this.objectsToDelete = objectsToDelete;
    }

    protected void setSession(AbstractSession session) {
        this.session = session;
    }

    protected void setShallowCommits(Map shallowCommits) {
        this.shallowCommits = shallowCommits;
    }

    public String toString() {
        Object[] args = new Object[]{this.commitDepth};
        return this.getClass().getSimpleName() + ToStringLocalization.buildMessage("commit_depth", args);
    }
}

