/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.logging;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.security.AccessController;
import java.text.MessageFormat;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.function.Supplier;
import org.eclipse.persistence.internal.localization.LoggingLocalization;
import org.eclipse.persistence.internal.localization.TraceLocalization;
import org.eclipse.persistence.logging.DefaultSessionLog;
import org.eclipse.persistence.logging.LogLevel;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.logging.SessionLogEntry;

public abstract class AbstractSessionLog
implements SessionLog,
Cloneable {
    private static final String LOGGING_LEVEL = "eclipselink.logging.level";
    protected int level;
    protected static SessionLog defaultLog;
    private String sessionName;
    protected static String SEVERE_PREFIX;
    protected static String WARNING_PREFIX;
    protected static String INFO_PREFIX;
    protected static String CONFIG_PREFIX;
    protected static String FINE_PREFIX;
    protected static String FINER_PREFIX;
    protected static String FINEST_PREFIX;
    protected static String TOPLINK_PREFIX;
    protected static final String CONNECTION_STRING = "Connection";
    protected static final String THREAD_STRING = "Thread";
    protected Writer writer = new PrintWriter(System.out);
    protected static String DATE_FORMAT_STR;
    protected DateTimeFormatter timeStampFormatter;
    private Boolean shouldLogExceptionStackTrace;
    private Boolean shouldPrintDate;
    private Boolean shouldPrintThread;
    private Boolean shouldPrintSession;
    private Boolean shouldPrintConnection;
    private Boolean shouldDisplayData;

    private static String getDefaultLoggingLevelProperty() {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(() -> System.getProperty(LOGGING_LEVEL, null));
        }
        return System.getProperty(LOGGING_LEVEL, null);
    }

    public static int getDefaultLoggingLevel() {
        return AbstractSessionLog.translateStringToLoggingLevel(AbstractSessionLog.getDefaultLoggingLevelProperty());
    }

    protected AbstractSessionLog() {
        this.level = AbstractSessionLog.getDefaultLoggingLevel();
    }

    @Override
    public int getLevel() {
        return this.getLevel(null);
    }

    @Override
    public String getLevelString() {
        return LogLevel.toValue(this.getLevel(), LogLevel.INFO).getName();
    }

    @Override
    public int getLevel(String category) {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.setLevel(level, null);
    }

    @Override
    public void setLevel(int level, String category) {
        this.level = level;
    }

    @Override
    public boolean shouldLog(int level) {
        return this.shouldLog(level, null);
    }

    @Override
    public boolean shouldLog(int level, String category) {
        return this.level <= level && !this.isOff();
    }

    public static SessionLog getLog() {
        if (defaultLog == null) {
            defaultLog = new DefaultSessionLog();
        }
        return defaultLog;
    }

    public static void setLog(SessionLog sessionLog) {
        defaultLog = sessionLog;
        defaultLog.setSessionName(null);
    }

    @Override
    public String getSessionName() {
        return this.sessionName;
    }

    @Override
    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    @Override
    public void log(int level, Supplier<String> messageSupplier) {
        this.log(level, null, messageSupplier);
    }

    @Override
    public void log(int level, String category, Supplier<String> messageSupplier) {
        if (!this.shouldLog(level, category)) {
            return;
        }
        this.log(new SessionLogEntry(level, category, null, messageSupplier.get(), null, null, false));
    }

    @Override
    public void log(int level, String message) {
        this.log(level, null, message, null, false);
    }

    @Override
    public void log(int level, String message, Object param) {
        this.log(level, (String)null, message, new Object[]{param}, true);
    }

    @Override
    public void log(int level, String category, String message, Object param) {
        this.log(level, category, message, new Object[]{param}, true);
    }

    @Override
    public void log(int level, String message, Object param1, Object param2) {
        this.log(level, (String)null, message, new Object[]{param1, param2}, true);
    }

    @Override
    public void log(int level, String category, String message, Object param1, Object param2) {
        this.log(level, category, message, new Object[]{param1, param2}, true);
    }

    @Override
    public void log(int level, String message, Object param1, Object param2, Object param3) {
        this.log(level, (String)null, message, new Object[]{param1, param2, param3}, true);
    }

    @Override
    public void log(int level, String category, String message, Object param1, Object param2, Object param3) {
        this.log(level, category, message, new Object[]{param1, param2, param3}, true);
    }

    @Override
    public void log(int level, String message, Object param1, Object param2, Object param3, Object param4) {
        this.log(level, (String)null, message, new Object[]{param1, param2, param3, param4}, true);
    }

    @Override
    public void log(int level, String category, String message, Object param1, Object param2, Object param3, Object param4) {
        this.log(level, category, message, new Object[]{param1, param2, param3, param4}, true);
    }

    @Override
    public void log(int level, String message, Object[] params) {
        this.log(level, (String)null, message, params, true);
    }

    @Override
    public void log(int level, String category, String message, Object[] params) {
        this.log(level, category, message, params, true);
    }

    @Override
    @Deprecated(forRemoval=true, since="4.0.9")
    public void log(int level, String message, Object[] params, boolean shouldTranslate) {
        this.log(level, (String)null, message, params, shouldTranslate);
    }

    @Override
    @Deprecated(forRemoval=true, since="4.0.9")
    public void log(int level, String category, String message, Object[] params, boolean shouldTranslate) {
        if (!this.shouldLog(level, category)) {
            return;
        }
        this.log(new SessionLogEntry(level, category, null, message, params, null, shouldTranslate));
    }

    private void logTranslated(int level, String message) {
        this.log(level, null, message, null, true);
    }

    @Override
    public boolean shouldPrintSession() {
        return this.shouldPrintSession == null || this.shouldPrintSession != false;
    }

    @Override
    public void setShouldPrintSession(boolean shouldPrintSession) {
        this.shouldPrintSession = shouldPrintSession;
    }

    @Override
    public boolean shouldPrintConnection() {
        return this.shouldPrintConnection == null || this.shouldPrintConnection != false;
    }

    @Override
    public void setShouldPrintConnection(boolean shouldPrintConnection) {
        this.shouldPrintConnection = shouldPrintConnection;
    }

    @Override
    public boolean shouldLogExceptionStackTrace() {
        return this.shouldLogExceptionStackTrace == null ? this.getLevel() <= 2 : this.shouldLogExceptionStackTrace;
    }

    @Override
    public void setShouldLogExceptionStackTrace(boolean shouldLogExceptionStackTrace) {
        this.shouldLogExceptionStackTrace = shouldLogExceptionStackTrace;
    }

    @Override
    public boolean shouldDisplayData() {
        return this.shouldDisplayData == null ? this.getLevel() <= 3 : this.shouldDisplayData;
    }

    @Override
    public void setShouldDisplayData(Boolean shouldDisplayData) {
        this.shouldDisplayData = shouldDisplayData;
    }

    @Override
    public boolean shouldPrintDate() {
        return this.shouldPrintDate == null || this.shouldPrintDate != false;
    }

    @Override
    public void setShouldPrintDate(boolean shouldPrintDate) {
        this.shouldPrintDate = shouldPrintDate;
    }

    @Override
    public boolean shouldPrintThread() {
        return this.shouldPrintThread == null ? this.getLevel() <= 3 : this.shouldPrintThread;
    }

    @Override
    public void setShouldPrintThread(boolean shouldPrintThread) {
        this.shouldPrintThread = shouldPrintThread;
    }

    @Override
    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public void setWriter(OutputStream outputstream) {
        this.writer = new OutputStreamWriter(outputstream);
    }

    public DateTimeFormatter getTimeStampFormatter() {
        if (this.timeStampFormatter == null) {
            this.timeStampFormatter = DateTimeFormatter.ofPattern(DATE_FORMAT_STR).withZone(ZoneId.systemDefault());
        }
        return this.timeStampFormatter;
    }

    protected String getTimeStampString(TemporalAccessor temporalAccessor) {
        if (temporalAccessor == null) {
            return null;
        }
        return this.getTimeStampFormatter().format(temporalAccessor);
    }

    protected String getSupplementDetailString(SessionLogEntry entry) {
        StringWriter writer = new StringWriter();
        if (this.shouldPrintDate()) {
            writer.write(this.getTimeStampString(entry.getTimeStamp()));
            writer.write("--");
        }
        if (this.shouldPrintSession() && entry.getSessionId() != null) {
            writer.write(entry.getSessionId());
            writer.write("--");
        }
        if (this.shouldPrintConnection() && entry.getConnectionId() != null) {
            writer.write(this.getConnectionString(entry.getConnectionId()));
            writer.write("--");
        }
        if (this.shouldPrintThread()) {
            writer.write(this.getThreadString(entry.getThread()));
            writer.write("--");
        }
        if (entry.getSourceClassName() != null) {
            writer.write(entry.getSourceClassName());
            writer.write("--");
        }
        if (entry.getSourceMethodName() != null) {
            writer.write(entry.getSourceMethodName());
            writer.write("--");
        }
        return writer.toString();
    }

    protected String getConnectionString(int connectionId) {
        return "Connection(" + connectionId + ")";
    }

    protected String getThreadString(Thread thread) {
        return "Thread(" + String.valueOf(thread) + ")";
    }

    protected void printPrefixString(int level, String category) {
        try {
            this.getWriter().write(this.getPrefixString(level, category));
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    protected String getPrefixString(int level, String category) {
        StringBuilder sb = new StringBuilder();
        switch (level) {
            case 7: {
                if (SEVERE_PREFIX == null) {
                    SEVERE_PREFIX = LoggingLocalization.buildMessage("toplink_severe");
                }
                sb.append(SEVERE_PREFIX);
                break;
            }
            case 6: {
                if (WARNING_PREFIX == null) {
                    WARNING_PREFIX = LoggingLocalization.buildMessage("toplink_warning");
                }
                sb.append(WARNING_PREFIX);
                break;
            }
            case 5: {
                if (INFO_PREFIX == null) {
                    INFO_PREFIX = LoggingLocalization.buildMessage("toplink_info");
                }
                sb.append(INFO_PREFIX);
                break;
            }
            case 4: {
                if (CONFIG_PREFIX == null) {
                    CONFIG_PREFIX = LoggingLocalization.buildMessage("toplink_config");
                }
                sb.append(CONFIG_PREFIX);
                break;
            }
            case 3: {
                if (FINE_PREFIX == null) {
                    FINE_PREFIX = LoggingLocalization.buildMessage("toplink_fine");
                }
                sb.append(FINE_PREFIX);
                break;
            }
            case 2: {
                if (FINER_PREFIX == null) {
                    FINER_PREFIX = LoggingLocalization.buildMessage("toplink_finer");
                }
                sb.append(FINER_PREFIX);
                break;
            }
            case 1: {
                if (FINEST_PREFIX == null) {
                    FINEST_PREFIX = LoggingLocalization.buildMessage("toplink_finest");
                }
                sb.append(FINEST_PREFIX);
                break;
            }
            default: {
                if (TOPLINK_PREFIX == null) {
                    TOPLINK_PREFIX = LoggingLocalization.buildMessage("toplink");
                }
                sb.append(TOPLINK_PREFIX);
            }
        }
        if (category != null) {
            sb.append(category);
            sb.append(": ");
        }
        return sb.toString();
    }

    public void setTimeStampFormatter(DateTimeFormatter timeStampFormatter) {
        this.timeStampFormatter = timeStampFormatter;
    }

    protected String formatMessage(SessionLogEntry entry) {
        String message = entry.getMessage();
        if (entry.shouldTranslate()) {
            message = entry.getLevel() > 3 ? LoggingLocalization.buildMessage(message, entry.getParameters()) : TraceLocalization.buildMessage(message, entry.getParameters(), true);
        } else if (entry.getParameters() != null && entry.getParameters().length > 0 && message.contains("{0")) {
            message = MessageFormat.format(message, entry.getParameters());
        }
        return message;
    }

    public static int translateStringToLoggingLevel(String loggingLevel) {
        LogLevel logLevel = LogLevel.toValue(loggingLevel);
        return logLevel != null ? logLevel.getId() : LogLevel.INFO.getId();
    }

    @Override
    public void throwing(Throwable throwable) {
        if (this.shouldLog(2)) {
            this.log(new SessionLogEntry(2, null, null, "", throwable));
        }
    }

    @Override
    public void severe(String message) {
        this.logTranslated(7, message);
    }

    @Override
    public void severe(Supplier<String> messageSupplier) {
        this.log(7, messageSupplier);
    }

    @Override
    public void warning(String message) {
        this.logTranslated(6, message);
    }

    @Override
    public void warning(Supplier<String> messageSupplier) {
        this.log(6, messageSupplier);
    }

    @Override
    public void info(String message) {
        this.logTranslated(5, message);
    }

    @Override
    public void info(Supplier<String> messageSupplier) {
        this.log(5, messageSupplier);
    }

    @Override
    public void config(String message) {
        this.logTranslated(4, message);
    }

    @Override
    public void config(Supplier<String> messageSupplier) {
        this.log(4, messageSupplier);
    }

    @Override
    public void fine(String message) {
        this.logTranslated(3, message);
    }

    @Override
    public void fine(Supplier<String> messageSupplier) {
        this.log(3, messageSupplier);
    }

    @Override
    public void finer(String message) {
        this.logTranslated(2, message);
    }

    @Override
    public void finer(Supplier<String> messageSupplier) {
        this.log(2, messageSupplier);
    }

    @Override
    public void finest(String message) {
        this.logTranslated(1, message);
    }

    @Override
    public void finest(Supplier<String> messageSupplier) {
        this.log(1, messageSupplier);
    }

    @Override
    public void logThrowable(int level, Throwable throwable) {
        if (this.shouldLog(level)) {
            this.log(new SessionLogEntry(level, null, null, "", throwable));
        }
    }

    @Override
    public void logThrowable(int level, String category, Throwable throwable) {
        if (this.shouldLog(level, category)) {
            this.log(new SessionLogEntry(level, category, null, "", throwable));
        }
    }

    public boolean isOff() {
        return this.level == 8;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    static {
        SEVERE_PREFIX = null;
        WARNING_PREFIX = null;
        INFO_PREFIX = null;
        CONFIG_PREFIX = null;
        FINE_PREFIX = null;
        FINER_PREFIX = null;
        FINEST_PREFIX = null;
        TOPLINK_PREFIX = null;
        DATE_FORMAT_STR = "yyyy.MM.dd HH:mm:ss.SSS";
    }
}

