/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.logging;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.SessionLogEntry;

public class DefaultSessionLog
extends AbstractSessionLog
implements Serializable {
    protected String fileName;
    private final Map<String, Integer> categoryLogLevelMap = new HashMap<String, Integer>();

    public DefaultSessionLog() {
        for (int i = 0; i < loggerCatagories.length; ++i) {
            String loggerCategory = loggerCatagories[i];
            this.categoryLogLevelMap.put(loggerCategory, null);
        }
    }

    public DefaultSessionLog(Writer writer) {
        this();
        this.initialize(writer);
    }

    @Override
    public void setLevel(int level, String category) {
        if (category == null) {
            this.level = level;
        } else if (this.categoryLogLevelMap.containsKey(category)) {
            this.categoryLogLevelMap.put(category, level);
        }
    }

    @Override
    public int getLevel(String category) {
        Integer level;
        if (category != null && (level = this.categoryLogLevelMap.get(category)) != null) {
            return level;
        }
        return super.getLevel(category);
    }

    @Override
    public boolean shouldLog(int level, String category) {
        return this.getLevel(category) <= level;
    }

    protected void initialize() {
        this.setShouldPrintSession(true);
        this.setShouldPrintConnection(true);
    }

    protected void initialize(Writer writer) {
        this.writer = writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(SessionLogEntry entry) {
        if (!this.shouldLog(entry.getLevel(), entry.getNameSpace())) {
            return;
        }
        DefaultSessionLog defaultSessionLog = this;
        synchronized (defaultSessionLog) {
            try {
                this.printPrefixString(entry.getLevel(), entry.getNameSpace());
                this.getWriter().write(this.getSupplementDetailString(entry));
                if (entry.hasMessage()) {
                    this.writeMessage(this.formatMessage(entry));
                    this.getWriter().write(System.lineSeparator());
                    this.getWriter().flush();
                }
                if (entry.hasException()) {
                    if (this.shouldLogExceptionStackTrace()) {
                        entry.getException().printStackTrace(new PrintWriter(this.getWriter()));
                    } else {
                        this.writeMessage(entry.getException().toString());
                    }
                    this.getWriter().write(System.lineSeparator());
                    this.getWriter().flush();
                }
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public void setWriter(String aFileName) {
        if (aFileName != null) {
            try {
                this.writer = new FileWriter(aFileName);
                this.fileName = aFileName;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String getWriterFilename() {
        return this.fileName;
    }

    protected void writeMessage(String message) throws IOException {
        this.getWriter().write(message);
    }

    protected void writeSeparator() throws IOException {
        this.getWriter().write("--");
    }
}

