/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console.util;

import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LabelledComponent
extends JPanel {
    private static final long serialVersionUID = -5448387956016714457L;
    public static final int NORTH = 0;
    public static final int CENTER = 1;
    public static final int SOUTH = 2;
    private JLabel label;
    private JLabel label2;
    private JComponent component;
    private int align = 1;
    private Object userData = null;

    public LabelledComponent(String s, JComponent c) {
        this(s, c, 1);
    }

    public LabelledComponent(String s, JComponent c, int align) {
        this(new JLabel(s, 4), c, null, align);
    }

    public LabelledComponent(String s, JComponent c, String s2) {
        this(s, c, s2, 1);
    }

    public LabelledComponent(String s, JComponent c, String s2, int align) {
        this(new JLabel(s, 4), c, new JLabel(s2, 4), align);
    }

    public LabelledComponent(JLabel l, JComponent c, JLabel l2, int align) {
        this.label = l;
        this.label2 = l2;
        this.component = c;
        this.align = align;
        this.initPanel();
    }

    public JLabel getLabel() {
        return this.label;
    }

    public JComponent getComponent() {
        return this.component;
    }

    public int getLabelWidth() {
        return this.label.getPreferredSize().width;
    }

    public int getComponentWidth() {
        return this.component.getPreferredSize().width;
    }

    public void setClientData(Object userData) {
        this.userData = userData;
    }

    public Object getClientData() {
        return this.userData;
    }

    public void setLabelText(String s) {
        if (this.label == null || s == null) {
            return;
        }
        this.label.setText(s);
    }

    public void setLabelFont(Font f) {
        if (this.label == null || f == null) {
            return;
        }
        this.label.setFont(f);
    }

    @Override
    public void setEnabled(boolean b) {
        if (this.label != null) {
            this.label.setEnabled(b);
        }
        if (this.label2 != null) {
            this.label2.setEnabled(b);
        }
        if (this.component != null) {
            this.enableComponents(this.component, b);
        }
    }

    private void enableComponents(JComponent comp, boolean b) {
        for (int i = 0; i < comp.getComponentCount(); ++i) {
            comp.getComponent(i).setEnabled(b);
        }
    }

    private void initPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints gbc = new GridBagConstraints();
        this.label.setHorizontalAlignment(4);
        gbc.gridx = 0;
        gbc.gridy = 0;
        int labelAnchor = switch (this.align) {
            case 0 -> 12;
            case 1 -> 10;
            case 2 -> 14;
            default -> 10;
        };
        gbc.anchor = labelAnchor;
        gridbag.setConstraints(this.label, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 10;
        gbc.insets = new Insets(0, 5, 0, 0);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gridbag.setConstraints(this.component, gbc);
        this.add(this.label);
        this.add(this.component);
        if (this.label2 != null) {
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.insets = new Insets(0, 5, 0, 0);
            gbc.anchor = labelAnchor;
            gbc.weightx = 0.0;
            gridbag.setConstraints(this.label2, gbc);
            this.add(this.label2);
        }
    }
}

