/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.util.io.FileUtils;
import jakarta.inject.Singleton;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import org.glassfish.embeddable.GlassFishVariable;
import org.glassfish.main.jdke.props.EnvToPropsConverter;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class ACCStartupContext
extends StartupContext {
    public ACCStartupContext() {
        super(ACCStartupContext.accEnvironment());
    }

    private static Properties accEnvironment() {
        File rootDirectory = ACCStartupContext.getRootDirectory();
        Map<String, String> pairs = Map.of(GlassFishVariable.DERBY_ROOT.getEnvName(), GlassFishVariable.DERBY_ROOT.getPropertyName(), GlassFishVariable.IMQ_LIB.getEnvName(), GlassFishVariable.IMQ_LIB.getPropertyName(), GlassFishVariable.IMQ_BIN.getEnvName(), GlassFishVariable.IMQ_BIN.getPropertyName(), GlassFishVariable.CONFIG_ROOT.getEnvName(), GlassFishVariable.CONFIG_ROOT.getPropertyName(), GlassFishVariable.INSTALL_ROOT.getEnvName(), GlassFishVariable.INSTALL_ROOT.getPropertyName(), GlassFishVariable.JAVA_ROOT.getEnvName(), GlassFishVariable.JAVA_ROOT.getPropertyName(), GlassFishVariable.DOMAINS_ROOT.getEnvName(), GlassFishVariable.DOMAINS_ROOT.getPropertyName(), GlassFishVariable.NODES_ROOT.getEnvName(), GlassFishVariable.NODES_ROOT.getEnvName());
        Map files = new EnvToPropsConverter(rootDirectory.toPath()).convert(pairs);
        Properties env = new Properties();
        files.entrySet().forEach(e -> env.put(e.getKey(), ((File)e.getValue()).getPath()));
        return env;
    }

    private static File getRootDirectory() {
        URI jarURI;
        try {
            jarURI = ACCStartupContext.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Could not resolve URI of the current JAR!", e);
        }
        if (jarURI.getScheme().startsWith("http")) {
            return FileUtils.USER_HOME;
        }
        return new File(jarURI).getParentFile().getParentFile();
    }
}

