/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms;

import com.sun.messaging.bridge.api.BridgeContext;
import com.sun.messaging.bridge.service.jms.JMSBridge;
import com.sun.messaging.bridge.service.jms.Refable;
import com.sun.messaging.jms.MQRuntimeException;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import java.util.Properties;

public class ConnectionFactoryImpl
implements ConnectionFactory,
Refable {
    private ConnectionFactory _cf = null;
    private String _ref = null;
    private boolean _isEmbeded = false;
    private boolean _firstTime = true;
    private BridgeContext _bc = null;
    private Properties _jmsprop = null;
    private boolean _isadmin = false;

    public ConnectionFactoryImpl(ConnectionFactory cf, String ref) {
        this._cf = cf;
        this._ref = ref;
    }

    public ConnectionFactoryImpl(BridgeContext bc, Properties jmsprop, boolean isEmbeded, String ref) throws Exception {
        this(bc, jmsprop, false, isEmbeded, ref);
    }

    public ConnectionFactoryImpl(BridgeContext bc, Properties jmsprop, boolean isadmin, boolean isEmbeded, String ref) throws Exception {
        this._bc = bc;
        this._jmsprop = jmsprop;
        this._isadmin = isadmin;
        this._cf = !isadmin ? this._bc.getConnectionFactory(this._jmsprop) : this._bc.getAdminConnectionFactory(this._jmsprop);
        this._ref = ref;
        this._isEmbeded = isEmbeded;
    }

    public Connection createConnection() throws JMSException {
        return this.getConnectionFactory().createConnection();
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        return this.getConnectionFactory().createConnection(userName, password);
    }

    public JMSContext createContext() {
        try {
            return this.getConnectionFactory().createContext();
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    public JMSContext createContext(String userName, String password) {
        try {
            return this.getConnectionFactory().createContext(userName, password);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    public JMSContext createContext(String userName, String password, int sessionMode) {
        try {
            return this.getConnectionFactory().createContext(userName, password, sessionMode);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    public JMSContext createContext(int sessionMode) {
        try {
            return this.getConnectionFactory().createContext(sessionMode);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    private ConnectionFactory getConnectionFactory() throws JMSException {
        if (this._bc != null) {
            ConnectionFactory cf = null;
            try {
                cf = !this._isadmin ? this._bc.getConnectionFactory(this._jmsprop) : this._bc.getAdminConnectionFactory(this._jmsprop);
            }
            catch (Exception e) {
                String string = e.getMessage();
                JMSBridge.getJMSBridgeResources();
                JMSException jmse = new JMSException(string, "BSJ3009", e);
                throw jmse;
            }
            return cf;
        }
        return this._cf;
    }

    @Override
    public String getRef() {
        return this._ref;
    }

    @Override
    public Object getRefed() {
        return this._cf;
    }

    @Override
    public boolean isEmbeded() {
        return this._isEmbeded;
    }

    @Override
    public boolean isMultiRM() {
        return false;
    }

    public String toString() {
        String refs = this._ref + (this._isEmbeded ? ", embeded" : "");
        String s = null;
        if (this._firstTime) {
            s = "[" + refs + "]" + this._cf.toString();
            this._firstTime = false;
        } else {
            s = "[" + refs + "]" + this._cf.getClass().getName();
        }
        return s;
    }
}

