/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import jakarta.ws.rs.Produces;
import jakarta.ws.rs.ext.Provider;
import java.util.List;
import java.util.logging.Level;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.admin.rest.Constants;
import org.glassfish.admin.rest.RestLogging;
import org.glassfish.admin.rest.composite.RestModel;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.admin.rest.utils.JsonUtil;

@Provider
@Produces(value={"application/vnd.oracle.glassfish+json"})
public class RestModelWriter
extends BaseProvider<RestModel> {
    public RestModelWriter() {
        super(RestModel.class, Constants.MEDIA_TYPE_JSON_TYPE);
    }

    @Override
    public String getContent(RestModel proxy) {
        StringBuilder sb = new StringBuilder();
        List wrapObjectHeader = this.requestHeaders.getRequestHeader("X-Wrap-Object");
        boolean wrapObject = wrapObjectHeader != null && wrapObjectHeader.size() > 0;
        try {
            JSONObject object = (JSONObject)JsonUtil.getJsonObject(proxy);
            sb.append(object.toString(this.getFormattingIndentLevel()));
        }
        catch (JSONException ex) {
            RestLogging.restLogger.log(Level.SEVERE, null, ex);
        }
        return (wrapObject ? " { item : " : "") + sb.toString() + (wrapObject ? "}" : "");
    }
}

