/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.ejbc;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.ejb.deployment.descriptor.EjbCMPEntityDescriptor;
import org.glassfish.ejb.deployment.descriptor.PersistenceDescriptor;
import org.glassfish.ejb.deployment.descriptor.QueryDescriptor;

public abstract class AbstractMethodHelper {
    public static final int LOCAL_RETURN = 0;
    public static final int REMOTE_RETURN = 1;
    public static final int NO_RETURN = 2;
    private final EjbCMPEntityDescriptor _cmpDescriptor;
    private List<Method> finders = new ArrayList<Method>();
    private List<Method> selectors = new ArrayList<Method>();
    private final List<Method> createMethods = new ArrayList<Method>();
    private final Map<String, Method> methodNames = new HashMap<String, Method>();

    public AbstractMethodHelper(EjbCMPEntityDescriptor descriptor) {
        this._cmpDescriptor = descriptor;
        this.categorizeMethods();
    }

    protected EjbCMPEntityDescriptor getDescriptor() {
        return this._cmpDescriptor;
    }

    protected void categorizeMethods() {
        EjbCMPEntityDescriptor descriptor = this.getDescriptor();
        for (MethodDescriptor methodDescriptor : descriptor.getMethodDescriptors()) {
            Method method = methodDescriptor.getMethod((EjbDescriptor)descriptor);
            String methodName = methodDescriptor.getName();
            if (methodName.startsWith("find")) {
                this.finders.add(method);
            } else if (methodName.startsWith("ejbSelect")) {
                this.selectors.add(method);
            } else if (methodName.startsWith("create")) {
                this.createMethods.add(method);
            } else if (methodName.startsWith("get") || methodName.startsWith("set")) {
                // empty if block
            }
            this.methodNames.put(methodName, method);
        }
    }

    public List<Method> getFinders() {
        return this.finders;
    }

    protected void setFinders(List<Method> finderList) {
        this.finders = finderList;
    }

    public List<Method> getSelectors() {
        return this.selectors;
    }

    protected void setSelectors(List<Method> selectorList) {
        this.selectors = selectorList;
    }

    public List<Method> getCreateMethods() {
        return this.createMethods;
    }

    public Map<String, Method> getMethodNames() {
        return this.methodNames;
    }

    public String getLocalHome() {
        return this.getDescriptor().getLocalHomeClassName();
    }

    public String getRemoteHome() {
        return this.getDescriptor().getHomeClassName();
    }

    protected QueryDescriptor getQueryDescriptor(Method method) {
        PersistenceDescriptor persistenceDescriptor = this.getDescriptor().getPersistenceDescriptor();
        return persistenceDescriptor.getQueryFor(method);
    }

    public String getQueryString(Method method) {
        QueryDescriptor queryDescriptor = this.getQueryDescriptor(method);
        return queryDescriptor == null ? null : queryDescriptor.getQuery();
    }

    public int getQueryReturnType(Method method) {
        QueryDescriptor queryDescriptor = this.getQueryDescriptor(method);
        if (queryDescriptor != null) {
            if (queryDescriptor.getHasLocalReturnTypeMapping()) {
                return 0;
            }
            if (queryDescriptor.getHasRemoteReturnTypeMapping()) {
                return 1;
            }
        }
        return 2;
    }

    public abstract boolean isQueryPrefetchEnabled(Method var1);

    public abstract String getJDOFilterExpression(Method var1);

    public abstract String getJDOParameterDeclaration(Method var1);

    public abstract String getJDOVariableDeclaration(Method var1);

    public abstract String getJDOOrderingSpecification(Method var1);
}

