/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.ConfigKeyImpl;
import io.helidon.config.ValueNodeImpl;
import io.helidon.config.spi.ConfigNode;
import java.util.AbstractMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class ConfigHelper {
    private ConfigHelper() {
        throw new AssertionError((Object)"Instantiation not allowed.");
    }

    public static Map<String, String> flattenNodes(ConfigNode.ObjectNode objectNode) {
        return ConfigHelper.flattenNodes(ConfigKeyImpl.of(), (ConfigNode)objectNode).filter(e -> e.getValue() instanceof ValueNodeImpl).collect(Collectors.toMap(e -> ((ConfigKeyImpl)e.getKey()).toString(), e -> ((ValueNodeImpl)e.getValue()).get()));
    }

    static Map<ConfigKeyImpl, ConfigNode> createFullKeyToNodeMap(ConfigNode.ObjectNode objectNode) {
        Stream flattenNodes = objectNode.entrySet().stream().map(node -> ConfigHelper.flattenNodes(ConfigKeyImpl.of((String)node.getKey()), (ConfigNode)node.getValue())).reduce(Stream.empty(), Stream::concat);
        Map<ConfigKeyImpl, ConfigNode> result = flattenNodes.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        result.put(ConfigKeyImpl.of(), (ConfigNode)objectNode);
        return result;
    }

    static Stream<Map.Entry<ConfigKeyImpl, ConfigNode>> flattenNodes(ConfigKeyImpl key, ConfigNode node) {
        switch (node.nodeType()) {
            case OBJECT: {
                return ((ConfigNode.ObjectNode)node).entrySet().stream().map(e -> ConfigHelper.flattenNodes(key.child((String)e.getKey()), (ConfigNode)e.getValue())).reduce(Stream.of(new AbstractMap.SimpleEntry<ConfigKeyImpl, ConfigNode>(key, node)), Stream::concat);
            }
            case LIST: {
                return IntStream.range(0, ((ConfigNode.ListNode)node).size()).boxed().map(i -> ConfigHelper.flattenNodes(key.child(Integer.toString(i)), (ConfigNode)((ConfigNode.ListNode)node).get(i.intValue()))).reduce(Stream.of(new AbstractMap.SimpleEntry<ConfigKeyImpl, ConfigNode>(key, node)), Stream::concat);
            }
            case VALUE: {
                return Stream.of(new AbstractMap.SimpleEntry<ConfigKeyImpl, ConfigNode>(key, node));
            }
        }
        throw new IllegalArgumentException("Invalid node type.");
    }
}

