/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.MessageGroup;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.FacesMessageUtils;
import com.sun.webui.jsf.util.MessageUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.beans.Beans;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;

public final class MessageGroupRenderer
extends AbstractRenderer {
    @Override
    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Iterator<FacesMessage> msgIt;
        MessageGroup msgGrp = (MessageGroup)component;
        String forComponentId = null;
        if (Beans.isDesignTime() && (msgGrp.isShowDetail() || msgGrp.isShowSummary())) {
            StringBuilder resourceNameBuffer = new StringBuilder();
            resourceNameBuffer.append("MessageGroup.");
            if (msgGrp.isShowGlobalOnly()) {
                resourceNameBuffer.append("global.");
            } else {
                resourceNameBuffer.append("default.");
            }
            if (msgGrp.isShowDetail() && msgGrp.isShowSummary()) {
                resourceNameBuffer.append("both");
            } else if (msgGrp.isShowDetail()) {
                resourceNameBuffer.append("detail");
            } else if (msgGrp.isShowSummary()) {
                resourceNameBuffer.append("summary");
            }
            String summary = MessageUtil.getMessage(context, "com.sun.webui.jsf.renderkit.html.Bundle", resourceNameBuffer.toString());
            FacesMessage defaultMessage = new FacesMessage();
            defaultMessage.setSummary(summary);
            msgIt = Collections.singletonList(defaultMessage).iterator();
        } else {
            if (msgGrp.isShowGlobalOnly()) {
                forComponentId = "";
            }
            msgIt = FacesMessageUtils.getMessageIterator(context, forComponentId, (UIComponent)msgGrp);
        }
        if (msgIt.hasNext()) {
            this.renderMessageGroup(context, (UIComponent)msgGrp, writer, msgIt);
        }
    }

    public void renderMessageGroup(FacesContext context, UIComponent component, ResponseWriter writer, Iterator msgIt) throws IOException {
        MessageGroup msgGrp = (MessageGroup)component;
        Theme theme = ThemeUtilities.getTheme(context);
        this.renderMessageGroupIdElement(context, msgGrp, writer);
        this.renderOpeningTable(msgGrp, writer, theme);
        boolean showSummary = msgGrp.isShowSummary();
        boolean showDetail = msgGrp.isShowDetail();
        String summaryStyle = theme.getStyleClass("MESSAGE_GROUP_SUMMARY_TEXT");
        String detailStyle = theme.getStyleClass("MESSAGE_GROUP_TEXT");
        String summary = null;
        String detail = null;
        StringBuilder detailBuf = new StringBuilder().append(" ");
        while (msgIt.hasNext()) {
            FacesMessage fMsg = (FacesMessage)msgIt.next();
            if (showSummary && (summary = fMsg.getSummary()) != null && summary.length() <= 0) {
                summary = null;
            }
            if (showDetail && (detail = fMsg.getDetail()) != null && detail.length() <= 0) {
                detail = null;
            }
            if (summary == null && detail == null) continue;
            String summaryStyleTmp = summaryStyle;
            String detailStyleTmp = detailStyle;
            writer.startElement("div", (UIComponent)msgGrp);
            writer.writeAttribute("class", (Object)theme.getStyleClass("MESSAGE_GROUP_DIV"), null);
            writer.startElement("ul", (UIComponent)msgGrp);
            writer.startElement("li", (UIComponent)msgGrp);
            String severityStyleClass = this.getSeverityStyleClass(fMsg, theme);
            if (severityStyleClass != null) {
                writer.writeAttribute("class", (Object)severityStyleClass, "styleClass");
                summaryStyleTmp = null;
                detailStyleTmp = null;
            }
            if (summary != null) {
                this.renderMessageText(msgGrp, writer, summary, summaryStyleTmp);
            }
            if (detail != null) {
                if (summary != null) {
                    detail = detailBuf.append(detail).toString();
                }
                this.renderMessageText(msgGrp, writer, detail, detailStyleTmp);
                detailBuf.setLength(1);
            }
            writer.endElement("li");
            writer.endElement("ul");
            writer.endElement("div");
        }
        this.renderClosingTable(writer);
        writer.endElement("div");
    }

    public void renderOpeningTable(MessageGroup msgGrp, ResponseWriter writer, Theme theme) throws IOException {
        writer.startElement("table", (UIComponent)msgGrp);
        writer.writeAttribute("class", (Object)theme.getStyleClass("MESSAGE_GROUP_TABLE"), null);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        if (msgGrp.getToolTip() != null) {
            writer.writeAttribute("title", (Object)msgGrp.getToolTip(), null);
        } else {
            writer.writeAttribute("title", (Object)"", null);
        }
        writer.writeText((Object)"\n", null);
        writer.startElement("tr", (UIComponent)msgGrp);
        writer.startElement("th", (UIComponent)msgGrp);
        writer.writeAttribute("class", (Object)theme.getStyleClass("MESSAGE_GROUP_TABLE_TITLE"), null);
        String title = msgGrp.getTitle();
        if (title != null) {
            writer.writeText((Object)title, null);
        } else {
            writer.writeText((Object)theme.getMessage("messageGroup.heading"), null);
        }
        writer.endElement("th");
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
        writer.startElement("tr", (UIComponent)msgGrp);
        writer.startElement("td", (UIComponent)msgGrp);
    }

    public void renderClosingTable(ResponseWriter writer) throws IOException {
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
        writer.writeText((Object)"\n", null);
    }

    public void renderMessageText(MessageGroup msgGrp, ResponseWriter writer, String msgText, String textStyle) throws IOException {
        writer.startElement("span", (UIComponent)msgGrp);
        if (textStyle != null && textStyle.length() > 0) {
            writer.writeAttribute("class", (Object)textStyle, "class");
        }
        writer.writeText((Object)msgText, null);
        writer.endElement("span");
    }

    private void renderMessageGroupIdElement(FacesContext context, MessageGroup msgGrp, ResponseWriter writer) throws IOException {
        String userStyle = msgGrp.getStyle();
        String userStyleClass = msgGrp.getStyleClass();
        String id = msgGrp.getClientId(context);
        writer.startElement("div", (UIComponent)msgGrp);
        writer.writeAttribute("id", (Object)id, "id");
        if (userStyle != null && userStyle.length() > 0) {
            writer.writeAttribute("style", (Object)userStyle, "style");
        }
        RenderingUtilities.renderStyleClass(context, writer, (UIComponent)msgGrp, null);
    }

    protected String getSeverityStyleClass(FacesMessage facesMessage, Theme theme) {
        String severityStyleClass = null;
        FacesMessage.Severity severity = facesMessage.getSeverity();
        if (severity == FacesMessage.SEVERITY_INFO) {
            severityStyleClass = theme.getStyleClass("MESSAGE_GROUP_INFO");
        } else if (severity == FacesMessage.SEVERITY_WARN) {
            severityStyleClass = theme.getStyleClass("MESSAGE_GROUP_WARN");
        } else if (severity == FacesMessage.SEVERITY_ERROR) {
            severityStyleClass = theme.getStyleClass("MESSAGE_GROUP_ERROR");
        } else if (severity == FacesMessage.SEVERITY_FATAL) {
            severityStyleClass = theme.getStyleClass("MESSAGE_GROUP_FATAL");
        }
        if (severityStyleClass == null || severityStyleClass.length() == 0) {
            return null;
        }
        return severityStyleClass;
    }
}

