/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository.impl;

import java.io.InputStream;
import java.io.Reader;
import org.apache.felix.bundlerepository.impl.Activator;
import org.apache.felix.bundlerepository.impl.CapabilityImpl;
import org.apache.felix.bundlerepository.impl.PropertyImpl;
import org.apache.felix.bundlerepository.impl.PullParser;
import org.apache.felix.bundlerepository.impl.RepositoryImpl;
import org.apache.felix.bundlerepository.impl.RequirementImpl;
import org.apache.felix.bundlerepository.impl.ResourceImpl;

public abstract class RepositoryParser {
    public static final String REPOSITORY = "repository";
    public static final String NAME = "name";
    public static final String LASTMODIFIED = "lastmodified";
    public static final String REFERRAL = "referral";
    public static final String RESOURCE = "resource";
    public static final String DEPTH = "depth";
    public static final String URL = "url";
    public static final String CATEGORY = "category";
    public static final String ID = "id";
    public static final String CAPABILITY = "capability";
    public static final String REQUIRE = "require";
    public static final String P = "p";
    public static final String N = "n";
    public static final String T = "t";
    public static final String V = "v";
    public static final String FILTER = "filter";
    public static final String EXTEND = "extend";
    public static final String MULTIPLE = "multiple";
    public static final String OPTIONAL = "optional";
    public static final String OBR_PARSER_CLASS = "obr.xml.class";

    public static RepositoryParser getParser() {
        RepositoryParser parser = null;
        try {
            String className;
            String string = className = Activator.getContext() != null ? Activator.getContext().getProperty(OBR_PARSER_CLASS) : System.getProperty(OBR_PARSER_CLASS);
            if (className != null && className.length() > 0) {
                parser = (RepositoryParser)Class.forName(className).newInstance();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (parser == null) {
            parser = new PullParser();
        }
        return parser;
    }

    public abstract RepositoryImpl parseRepository(InputStream var1, String var2) throws Exception;

    public abstract RepositoryImpl parseRepository(Reader var1) throws Exception;

    public abstract ResourceImpl parseResource(Reader var1) throws Exception;

    public abstract CapabilityImpl parseCapability(Reader var1) throws Exception;

    public abstract PropertyImpl parseProperty(Reader var1) throws Exception;

    public abstract RequirementImpl parseRequirement(Reader var1) throws Exception;
}

