/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.faces;

import com.sun.data.provider.RowKey;
import com.sun.data.provider.SortCriteria;
import com.sun.data.provider.TableDataProvider;
import com.sun.data.provider.impl.TableRowDataProvider;
import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;

public final class ValueBindingSortCriteria
extends SortCriteria {
    private static final long serialVersionUID = 3213170928687846906L;
    private transient ValueExpression valueExpression;
    private String requestMapKey = "currentRow";
    private transient TableRowDataProvider rowProvider;
    private String rowProviderLock = "rowProviderLock";

    public ValueBindingSortCriteria() {
    }

    public ValueBindingSortCriteria(ValueExpression newValueExpression) {
        this.valueExpression = newValueExpression;
    }

    public ValueBindingSortCriteria(ValueExpression newValueExpression, boolean newAscending) {
        this.valueExpression = newValueExpression;
        this.setAscending(newAscending);
    }

    public ValueExpression getValueExpression() {
        return this.valueExpression;
    }

    public void setValueExpression(ValueExpression newValueExpression) {
        this.valueExpression = newValueExpression;
    }

    public String getRequestMapKey() {
        return this.requestMapKey;
    }

    public void setRequestMapKey(String newRequestMapKey) {
        this.requestMapKey = newRequestMapKey;
    }

    public String getDisplayName() {
        String name = super.getDisplayName();
        if ((name == null || "".equals(name)) && this.valueExpression != null) {
            return this.valueExpression.getExpressionString();
        }
        return name;
    }

    public String getCriteriaKey() {
        if (this.valueExpression != null) {
            return this.valueExpression.getExpressionString();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSortValue(TableDataProvider provider, RowKey row) {
        Object value;
        if (this.valueExpression == null) {
            return null;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        String string = this.rowProviderLock;
        synchronized (string) {
            Object storedRequestMapValue = null;
            if (this.requestMapKey != null && !"".equals(this.requestMapKey)) {
                storedRequestMapValue = requestMap.get(this.requestMapKey);
                if (this.rowProvider == null) {
                    this.rowProvider = new TableRowDataProvider();
                }
                this.rowProvider.setTableDataProvider(provider);
                this.rowProvider.setTableRow(row);
                requestMap.put(this.requestMapKey, this.rowProvider);
            }
            value = this.valueExpression.getValue(facesContext.getELContext());
            if (this.requestMapKey != null && !"".equals(this.requestMapKey)) {
                if (this.rowProvider != null) {
                    this.rowProvider.setTableDataProvider(null);
                    this.rowProvider.setTableRow(null);
                }
                requestMap.put(this.requestMapKey, storedRequestMapValue);
            }
        }
        return value;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.requestMapKey);
        out.writeObject(this.rowProviderLock);
        if (this.valueExpression != null) {
            out.writeObject(this.valueExpression.getExpressionString());
        } else {
            out.writeObject(null);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.requestMapKey = (String)in.readObject();
        this.rowProviderLock = (String)in.readObject();
        String s = (String)in.readObject();
        if (s != null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = FacesContext.getCurrentInstance().getELContext();
            this.valueExpression = facesContext.getApplication().getExpressionFactory().createValueExpression(elContext, s, Object.class);
        } else {
            this.valueExpression = null;
        }
    }
}

