/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.io;

import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.io.FileListerRelative;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.glassfish.api.deployment.archive.WritableArchiveEntry;

public final class FileUtils {
    public static final File USER_HOME = new File(System.getProperty("user.home"));
    private static final System.Logger LOG = System.getLogger(FileUtils.class.getName());
    private static final char[] ILLEGAL_FILENAME_CHARS = new char[]{'/', '\\', ':', '*', '?', '\"', '<', '>', '|'};
    private static final char REPLACEMENT_CHAR = '_';
    private static final char BLANK = ' ';
    private static final char DOT = '.';
    private static final int FILE_OPERATION_MAX_RETRIES = Integer.getInteger("com.sun.appserv.winFileLockRetryLimit", 5);
    private static final int FILE_OPERATION_SLEEP_DELAY_MS = Integer.getInteger("com.sun.appserv.winFileLockRetryDelay", 1000);

    private FileUtils() {
    }

    public static void ensureWritableDir(File dir) {
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new IllegalStateException("The configured temporary directory is not a directory: " + String.valueOf(dir));
            }
            if (!dir.canWrite()) {
                throw new IllegalStateException("The configured temporary directory is not writeable: " + String.valueOf(dir));
            }
            return;
        }
        if (dir.mkdirs()) {
            LOG.log(System.Logger.Level.DEBUG, "The directory {0} has been created.", dir);
            return;
        }
        throw new IllegalStateException("The configured directory does not exist and could not be created: " + String.valueOf(dir));
    }

    public static boolean mkdirsMaybe(File f) {
        return f != null && (f.isDirectory() || f.mkdirs());
    }

    public static boolean deleteFileMaybe(File f) {
        return f != null && (!f.exists() || f.delete());
    }

    public static File[] listFiles(File f) {
        try {
            File[] files = f.listFiles();
            if (files != null) {
                return files;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new File[0];
    }

    public static File[] listFiles(File f, FileFilter ff) {
        try {
            File[] files = f.listFiles(ff);
            if (files != null) {
                return files;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new File[0];
    }

    public static File[] listFiles(File f, FilenameFilter fnf) {
        try {
            File[] files = f.listFiles(fnf);
            if (files != null) {
                return files;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new File[0];
    }

    public static boolean safeIsDirectory(File f) {
        return f != null && f.exists() && f.isDirectory();
    }

    public static boolean safeIsRealDirectory(File f) {
        String absolute;
        if (!FileUtils.safeIsDirectory(f)) {
            return false;
        }
        String canonical = FileUtils.safeGetCanonicalPath(f);
        if (canonical.equals(absolute = f.getAbsolutePath())) {
            return true;
        }
        return OS.isWindows() && canonical.equalsIgnoreCase(absolute);
    }

    public static String safeGetCanonicalPath(File f) {
        if (f == null) {
            return null;
        }
        try {
            return f.getCanonicalPath();
        }
        catch (IOException e) {
            return f.getAbsolutePath();
        }
    }

    public static File safeGetCanonicalFile(File f) {
        if (f == null) {
            return null;
        }
        try {
            return f.getCanonicalFile();
        }
        catch (IOException e) {
            return f.getAbsoluteFile();
        }
    }

    public static boolean hasExtension(File f, String ext) {
        if (f == null || !f.exists()) {
            return false;
        }
        return f.getName().endsWith(ext);
    }

    public static boolean hasExtensionIgnoreCase(File f, String ext) {
        if (f == null || !f.exists()) {
            return false;
        }
        return f.getName().toLowerCase(Locale.ENGLISH).endsWith(ext.toLowerCase(Locale.ENGLISH));
    }

    public static String getExtension(File file) {
        if (file == null) {
            return null;
        }
        String fileName = file.getName();
        int extensionIndex = fileName.lastIndexOf(46);
        if (extensionIndex == -1) {
            return "";
        }
        return fileName.substring(extensionIndex);
    }

    public static String removeExtension(File file) {
        if (file == null) {
            return null;
        }
        String fileName = file.getName();
        int extensionIndex = fileName.lastIndexOf(46);
        if (extensionIndex == -1) {
            return fileName;
        }
        return fileName.substring(0, extensionIndex);
    }

    public static boolean isLegalFilename(String filename) {
        if (!FileUtils.isValidString(filename)) {
            return false;
        }
        for (char element : ILLEGAL_FILENAME_CHARS) {
            if (filename.indexOf(element) < 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isFriendlyFilename(String filename) {
        if (!FileUtils.isValidString(filename)) {
            return false;
        }
        if (filename.indexOf(32) >= 0 || filename.indexOf(46) >= 0) {
            return false;
        }
        return FileUtils.isLegalFilename(filename);
    }

    public static String makeLegalFilename(String filename) {
        if (FileUtils.isLegalFilename(filename)) {
            return filename;
        }
        filename = filename.replaceAll("[/" + Pattern.quote("\\") + "]", "__");
        for (char element : ILLEGAL_FILENAME_CHARS) {
            filename = filename.replace(element, '_');
        }
        return filename;
    }

    public static String makeLegalNoBlankFileName(String filename) {
        return FileUtils.makeLegalFilename(filename).replace(' ', '_');
    }

    public static String makeFriendlyFilename(String filename) {
        if (FileUtils.isFriendlyFilename(filename)) {
            return filename;
        }
        String ret = FileUtils.makeLegalFilename(filename).replace(' ', '_');
        ret = ret.replace('.', '_');
        return ret;
    }

    public static String makeFriendlyFilenameExtension(String filename) {
        String extension;
        if (filename == null) {
            return null;
        }
        if ((filename = FileUtils.makeLegalNoBlankFileName(filename)).endsWith(".ear")) {
            filename = filename.substring(0, filename.indexOf(".ear"));
            extension = "_ear";
        } else if (filename.endsWith(".war")) {
            filename = filename.substring(0, filename.indexOf(".war"));
            extension = "_war";
        } else if (filename.endsWith(".jar")) {
            filename = filename.substring(0, filename.indexOf(".jar"));
            extension = "_jar";
        } else if (filename.endsWith(".rar")) {
            filename = filename.substring(0, filename.indexOf(".rar"));
            extension = "_rar";
        } else {
            extension = "";
        }
        return filename + extension;
    }

    public static String revertFriendlyFilenameExtension(String filename) {
        String extension;
        if (filename == null || !filename.endsWith("_ear") && !filename.endsWith("_war") && !filename.endsWith("_jar") && !filename.endsWith("_rar")) {
            return filename;
        }
        if (filename.endsWith("_ear")) {
            filename = filename.substring(0, filename.indexOf("_ear"));
            extension = ".ear";
        } else if (filename.endsWith("_war")) {
            filename = filename.substring(0, filename.indexOf("_war"));
            extension = ".war";
        } else if (filename.endsWith("_jar")) {
            filename = filename.substring(0, filename.indexOf("_jar"));
            extension = ".jar";
        } else if (filename.endsWith("_rar")) {
            filename = filename.substring(0, filename.indexOf("_rar"));
            extension = ".rar";
        } else {
            extension = "";
        }
        return filename + extension;
    }

    public static String revertFriendlyFilename(String filename) {
        String name = FileUtils.revertFriendlyFilenameExtension(filename);
        return name.replaceAll("__", "/");
    }

    public static void liquidate(File parent) {
        FileUtils.whack(parent);
    }

    public static boolean isJar(File f) {
        return FileUtils.hasExtension(f, ".jar");
    }

    public static boolean isZip(File f) {
        return FileUtils.hasExtensionIgnoreCase(f, ".zip");
    }

    public static boolean whack(File parent) {
        return FileUtils.whack(parent, null);
    }

    public static boolean whack(File parent, Collection<File> undeletedFiles) {
        try {
            return FileUtils.whackResolvedDirectory(parent.getCanonicalFile(), undeletedFiles);
        }
        catch (IOException ioe) {
            LOG.log(System.Logger.Level.ERROR, "Could not recursively delete the directory " + String.valueOf(parent), (Throwable)ioe);
            return false;
        }
    }

    private static boolean whackResolvedDirectory(File parent, Collection<File> undeletedFiles) {
        if (FileUtils.safeIsRealDirectory(parent)) {
            File[] kids;
            for (File f : kids = FileUtils.listFiles(parent)) {
                if (f.isDirectory()) {
                    FileUtils.whackResolvedDirectory(f, undeletedFiles);
                    continue;
                }
                if (FileUtils.deleteFile(f) || undeletedFiles == null) continue;
                undeletedFiles.add(f);
            }
        }
        return FileUtils.deleteFile(parent);
    }

    @Deprecated
    public static void deleteFileNowOrLater(File f) {
        if (!FileUtils.deleteFile(f)) {
            f.deleteOnExit();
        }
    }

    public static boolean deleteFileWithWaitLoop(File f) {
        return FileUtils.internalDeleteFile(f, true);
    }

    public static boolean deleteFile(File f) {
        return FileUtils.internalDeleteFile(f, false);
    }

    private static boolean internalDeleteFile(File f, boolean doWaitLoop) {
        if (doWaitLoop) {
            DeleteFileWork work = new DeleteFileWork(f);
            FileUtils.doWithRetry(work);
            if (work.workComplete()) {
                return true;
            }
        } else if (f.delete()) {
            return true;
        }
        if (f.exists()) {
            LOG.log(System.Logger.Level.WARNING, "Error attempting to delete {0}", f);
            return false;
        }
        LOG.log(System.Logger.Level.TRACE, "Attempt to delete {0} failed; the file is reported as non-existent", f);
        return true;
    }

    public static FileOutputStream openFileOutputStream(File out) throws IOException {
        FileOutputStreamWork work = new FileOutputStreamWork(out);
        int retries = FileUtils.doWithRetry(work);
        if (retries > 0) {
            LOG.log(System.Logger.Level.DEBUG, "Retried {0} times the output to {1}", retries, out);
        }
        if (work.workComplete()) {
            return work.getStream();
        }
        throw new IOException("Failed opening file for output: " + String.valueOf(out), work.getLastError());
    }

    public static Set<File> getAllFilesAndDirectoriesUnder(File directory) throws IOException {
        if (!directory.exists() || !directory.isDirectory()) {
            throw new IOException("Problem with: " + String.valueOf(directory) + ". You must supply a directory that exists");
        }
        TreeSet<File> allFiles = new TreeSet<File>();
        FileUtils.recursiveGetFilesUnder(directory, directory, null, allFiles, true);
        return allFiles;
    }

    private static void recursiveGetFilesUnder(File relativizingRoot, File directory, FilenameFilter filenameFilter, Set<File> set, boolean returnDirectories) {
        File[] files;
        for (File file : files = FileUtils.listFiles(directory, filenameFilter)) {
            if (file.isDirectory()) {
                FileUtils.recursiveGetFilesUnder(relativizingRoot, file, filenameFilter, set, returnDirectories);
                if (!returnDirectories) continue;
                if (relativizingRoot != null) {
                    set.add(FileUtils.relativize(relativizingRoot, file));
                    continue;
                }
                set.add(file);
                continue;
            }
            if (relativizingRoot != null) {
                set.add(FileUtils.relativize(relativizingRoot, file));
                continue;
            }
            set.add(file);
        }
    }

    private static File relativize(File parent, File child) {
        String baseDir = parent.getAbsolutePath();
        String baseDirAndChild = child.getAbsolutePath();
        String relative = baseDirAndChild.substring(baseDir.length(), baseDirAndChild.length());
        if (relative.startsWith(File.separator)) {
            relative = relative.substring(1);
        }
        return new File(relative);
    }

    @Deprecated
    private static int doWithRetry(RetriableWork work) {
        int retries = 0;
        work.run();
        if (!work.workComplete() && OS.isWindows()) {
            while (!work.workComplete() && retries++ < FILE_OPERATION_MAX_RETRIES) {
                try {
                    Thread.sleep(FILE_OPERATION_SLEEP_DELAY_MS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                LOG.log(System.Logger.Level.DEBUG, "Performing gc to try to force file closures");
                System.gc();
                work.run();
            }
        }
        return retries;
    }

    public static void copyTree(File din, File dout) throws IOException {
        String[] files;
        if (!FileUtils.safeIsDirectory(din)) {
            throw new IllegalArgumentException("Source isn't a directory");
        }
        if (!FileUtils.mkdirsMaybe(dout)) {
            throw new IllegalArgumentException("Can't create destination directory");
        }
        FileListerRelative flr = new FileListerRelative(din);
        for (String file : files = flr.getFiles()) {
            File fin = new File(din, file);
            File fout = new File(dout, file);
            FileUtils.copy(fin, fout);
        }
    }

    public static File copyResourceToDirectory(String resourcePath, File outputDirectory) throws IOException {
        int slashIndex = resourcePath.lastIndexOf(47);
        String fileName = slashIndex < 0 ? resourcePath : resourcePath.substring(slashIndex + 1);
        File output = new File(outputDirectory, fileName);
        if (output.exists()) {
            return output;
        }
        return FileUtils.copyResource(resourcePath, output);
    }

    public static File copyResource(String resourcePath, File outputFile) throws IOException {
        LOG.log(System.Logger.Level.DEBUG, "copyResource(resourcePath={0}, outputFile={1})", resourcePath, outputFile);
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourcePath);){
            if (is == null) {
                File file = null;
                return file;
            }
            if (!FileUtils.mkdirsMaybe(outputFile.getParentFile())) {
                throw new IOException("Can't create parent dir of output file: " + String.valueOf(outputFile));
            }
            FileUtils.copy(is, outputFile);
            File file = outputFile;
            return file;
        }
    }

    public static void copy(File fin, File fout) throws IOException {
        if (FileUtils.safeIsDirectory(fin)) {
            FileUtils.copyTree(fin, fout);
            return;
        }
        if (!fin.exists()) {
            throw new IllegalArgumentException("File source doesn't exist");
        }
        if (!FileUtils.mkdirsMaybe(fout.getParentFile())) {
            throw new RuntimeException("Can't create parent dir of output file: " + String.valueOf(fout));
        }
        Files.copy(fin.toPath(), fout.toPath(), StandardCopyOption.REPLACE_EXISTING);
        LOG.log(System.Logger.Level.DEBUG, "Successfully copyied file {0} to {1}", fin, fout);
    }

    public static long getSize(File fileOrDirectory) throws IOException {
        try {
            return Files.walk(fileOrDirectory.getCanonicalFile().toPath(), new FileVisitOption[0]).filter(p -> Files.isRegularFile(p, LinkOption.NOFOLLOW_LINKS)).mapToLong(FileUtils::getRegularFileSize).sum();
        }
        catch (IllegalStateException e) {
            throw new IOException("Could not read size of " + String.valueOf(fileOrDirectory), e);
        }
    }

    private static long getRegularFileSize(Path path) {
        try {
            return Files.size(path);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read file size for " + String.valueOf(path), e);
        }
    }

    public static String makeForwardSlashes(String inputStr) {
        if (inputStr == null) {
            throw new IllegalArgumentException("null String FileUtils.makeForwardSlashes");
        }
        return inputStr.replace('\\', '/');
    }

    static boolean isValidString(String s) {
        return s != null && !s.isEmpty();
    }

    public static void copy(File in, OutputStream out) throws IOException {
        try (FileInputStream input = new FileInputStream(in);){
            input.transferTo(out);
        }
    }

    public static void copy(InputStream in, File out, long byteCount) throws IOException, IllegalArgumentException {
        if (byteCount < 0L || byteCount >= Long.MAX_VALUE) {
            throw new IllegalArgumentException("If you don't know the byte count, don't use this method!");
        }
        try (ReadableByteChannel inputChannel = Channels.newChannel(in);
             FileOutputStream output = new FileOutputStream(out);){
            output.getChannel().transferFrom(inputChannel, 0L, byteCount);
        }
    }

    public static void copy(InputStream in, File out) throws IOException {
        if (out.getParentFile().mkdirs()) {
            LOG.log(System.Logger.Level.DEBUG, "Created directory {0}", out.getCanonicalPath());
        }
        long bytes = Files.copy(in, out.toPath(), StandardCopyOption.REPLACE_EXISTING);
        LOG.log(System.Logger.Level.DEBUG, "Copyied {0} bytes to {1}", bytes, out);
    }

    public static void copy(InputStream in, OutputStream os) throws IOException {
        int read;
        ReadableByteChannel inputChannel = Channels.newChannel(in);
        WritableByteChannel outputChannel = FileUtils.getChannel(os);
        if (outputChannel instanceof FileChannel) {
            FileChannel foch = (FileChannel)outputChannel;
            long transferred = foch.transferFrom(inputChannel, 0L, Long.MAX_VALUE);
            LOG.log(System.Logger.Level.TRACE, "Copyied {0} B via {1}", transferred, foch);
            os.flush();
            return;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(8192);
        long transferred = 0L;
        do {
            if ((read = inputChannel.read(byteBuffer)) < 0) continue;
            byteBuffer.flip();
            outputChannel.write(byteBuffer);
            byteBuffer.clear();
            transferred += (long)read;
        } while (read != -1);
        LOG.log(System.Logger.Level.TRACE, "Copyied {0} B via {1}", transferred, outputChannel);
        os.flush();
    }

    private static WritableByteChannel getChannel(OutputStream stream) {
        if (stream instanceof WritableArchiveEntry) {
            return ((WritableArchiveEntry)stream).getChannel();
        }
        return Channels.newChannel(stream);
    }

    public static boolean renameFile(File fromFile, File toFile) {
        RenameFileWork renameWork = new RenameFileWork(fromFile, toFile);
        int retries = FileUtils.doWithRetry(renameWork);
        boolean result = renameWork.workComplete();
        if (result) {
            LOG.log(System.Logger.Level.DEBUG, "Attempt to rename {0} to {1} succeeded after {2} retries", fromFile, toFile, retries);
        } else {
            LOG.log(System.Logger.Level.WARNING, "Attempt to rename {0} to {1} failed after {2} retries", fromFile, toFile, retries);
        }
        return result;
    }

    public static String readSmallFile(File file, Charset charset) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader bf = new BufferedReader(new FileReader(file, charset));){
            String line;
            while ((line = bf.readLine()) != null) {
                sb.append(line);
                sb.append(System.lineSeparator());
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(String s, File f, Charset charset) throws IOException {
        try (PrintWriter writer = new PrintWriter(f, charset);){
            ((Writer)writer).write(s);
        }
        finally {
            f.setReadable(true);
            f.setWritable(true);
        }
    }

    public static File[] findFilesInDir(File dir, String regexp) {
        File[] matches = dir.listFiles((dir1, name) -> name.matches(regexp));
        if (matches == null) {
            LOG.log(System.Logger.Level.WARNING, "Could not list files in {0}. Check permissions!", dir);
            return new File[0];
        }
        return matches;
    }

    public static File toFile(URL resourceUrl) throws IllegalArgumentException {
        try {
            return new File(resourceUrl.toURI()).getAbsoluteFile();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot convert URL to File: " + String.valueOf(resourceUrl), e);
        }
    }

    private static final class DeleteFileWork
    implements RetriableWork {
        private final File deleteMe;
        private boolean complete;

        private DeleteFileWork(File deleteMe) {
            this.deleteMe = deleteMe;
        }

        @Override
        public void run() {
            if (this.complete) {
                return;
            }
            if (this.deleteMe.delete()) {
                this.complete = true;
            }
        }

        @Override
        public boolean workComplete() {
            return this.complete;
        }
    }

    private static interface RetriableWork
    extends Runnable {
        public boolean workComplete();
    }

    private static class FileOutputStreamWork
    implements RetriableWork {
        private FileOutputStream fos;
        private Throwable lastError;
        private final File out;

        private FileOutputStreamWork(File out) {
            this.out = out;
        }

        @Override
        public boolean workComplete() {
            return this.fos != null;
        }

        @Override
        public void run() {
            try {
                this.fos = new FileOutputStream(this.out);
                this.lastError = null;
            }
            catch (IOException ioe) {
                this.lastError = ioe;
            }
        }

        public FileOutputStream getStream() {
            return this.fos;
        }

        public Throwable getLastError() {
            return this.lastError;
        }
    }

    private static class RenameFileWork
    implements RetriableWork {
        private final File originalFile;
        private final File newFile;
        private boolean renameResult;

        public RenameFileWork(File originalFile, File newFile) {
            this.originalFile = originalFile;
            this.newFile = newFile;
        }

        @Override
        public boolean workComplete() {
            return this.renameResult;
        }

        @Override
        public void run() {
            this.renameResult = this.originalFile.renameTo(this.newFile);
        }
    }
}

