/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ssl;

import com.sun.enterprise.security.SecurityLoggerInfo;
import com.sun.enterprise.security.auth.login.common.PasswordCredential;
import com.sun.enterprise.security.auth.login.common.X509CertificateCredential;
import com.sun.enterprise.security.common.ClientSecurityContext;
import com.sun.enterprise.security.common.Util;
import com.sun.enterprise.security.ssl.manager.UnifiedX509KeyManager;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public final class J2EEKeyManager
extends X509ExtendedKeyManager {
    private static final Logger LOG = SecurityLoggerInfo.getLogger();
    private final X509KeyManager x509KeyManager;
    private final String alias;
    private Map<String, X509KeyManager> tokenName2MgrMap;
    private boolean supportTokenAlias;

    public J2EEKeyManager(X509KeyManager mgr, String alias) {
        this.x509KeyManager = mgr;
        this.alias = alias;
        if (mgr instanceof UnifiedX509KeyManager) {
            UnifiedX509KeyManager umgr = (UnifiedX509KeyManager)mgr;
            X509KeyManager[] mgrs = umgr.getX509KeyManagers();
            String[] tokenNames = umgr.getTokenNames();
            this.tokenName2MgrMap = new HashMap<String, X509KeyManager>();
            for (int i = 0; i < mgrs.length; ++i) {
                if (tokenNames[i] == null) continue;
                this.tokenName2MgrMap.put(tokenNames[i], mgrs[i]);
            }
            this.supportTokenAlias = this.tokenName2MgrMap.size() > 0;
        }
    }

    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        return this.x509KeyManager.chooseClientAlias(keyType, issuers, null);
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        return this.alias;
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        String clientAlias = null;
        if (this.alias == null) {
            if (Util.getInstance().isNotServerOrACC()) {
                clientAlias = this.x509KeyManager.chooseClientAlias(keyType, issuers, socket);
            } else if (Util.getInstance().isACC()) {
                ClientSecurityContext ctx = ClientSecurityContext.getCurrent();
                Subject s = ctx.getSubject();
                if (s == null) {
                    J2EEKeyManager.doClientLogin(2, Util.getInstance().getCallbackHandler());
                    s = ctx.getSubject();
                }
                for (Object o : s.getPrivateCredentials()) {
                    if (!(o instanceof X509CertificateCredential)) continue;
                    X509CertificateCredential crt = (X509CertificateCredential)o;
                    clientAlias = crt.getAlias();
                    break;
                }
            }
        } else {
            clientAlias = this.alias;
        }
        LOG.log(Level.FINE, "Choose client Alias :{0}", clientAlias);
        return clientAlias;
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        String serverAlias = null;
        serverAlias = this.alias != null ? this.alias : this.x509KeyManager.chooseServerAlias(keyType, issuers, socket);
        LOG.log(Level.FINE, "Choosing server alias :{0}", serverAlias);
        return serverAlias;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        LOG.log(Level.FINE, "Getting certificate chain");
        X509KeyManager keyManager = this.getManagerFromToken(alias);
        if (keyManager != null) {
            String aliasName = alias.substring(alias.indexOf(58) + 1);
            return keyManager.getCertificateChain(aliasName);
        }
        return this.x509KeyManager.getCertificateChain(alias);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        LOG.log(Level.FINE, "Getting client aliases");
        return this.x509KeyManager.getClientAliases(keyType, issuers);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        LOG.log(Level.FINE, "Getting server aliases");
        return this.x509KeyManager.getServerAliases(keyType, issuers);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        LOG.log(Level.FINE, "Getting private key for alias: {0}", alias);
        X509KeyManager keyManager = this.getManagerFromToken(alias);
        if (keyManager != null) {
            String aliasName = alias.substring(alias.indexOf(58) + 1);
            return keyManager.getPrivateKey(aliasName);
        }
        return this.x509KeyManager.getPrivateKey(alias);
    }

    private X509KeyManager getManagerFromToken(String tokenAlias) {
        X509KeyManager keyManager = null;
        int ind = -1;
        if (this.supportTokenAlias && tokenAlias != null && (ind = tokenAlias.indexOf(58)) != -1) {
            String tokenName = this.alias.substring(0, ind);
            keyManager = this.tokenName2MgrMap.get(tokenName);
        }
        return keyManager;
    }

    public static Subject doClientLogin(int type, CallbackHandler handler) throws com.sun.enterprise.security.auth.login.common.LoginException {
        Subject subject = new Subject();
        if (type == 1) {
            try {
                LoginContext lg = new LoginContext("default", subject, handler);
                lg.login();
            }
            catch (LoginException e) {
                throw new com.sun.enterprise.security.auth.login.common.LoginException(e.getMessage(), e);
            }
            J2EEKeyManager.postClientAuth(subject, PasswordCredential.class);
            return subject;
        }
        if (type == 2) {
            try {
                LoginContext lg = new LoginContext("certificate", subject, handler);
                lg.login();
            }
            catch (LoginException e) {
                throw new com.sun.enterprise.security.auth.login.common.LoginException(e.getMessage(), e);
            }
            J2EEKeyManager.postClientAuth(subject, X509CertificateCredential.class);
            return subject;
        }
        if (type == 3) {
            try {
                LoginContext lgup = new LoginContext("default", subject, handler);
                LoginContext lgc = new LoginContext("certificate", subject, handler);
                lgup.login();
                J2EEKeyManager.postClientAuth(subject, PasswordCredential.class);
                lgc.login();
                J2EEKeyManager.postClientAuth(subject, X509CertificateCredential.class);
            }
            catch (LoginException e) {
                throw new com.sun.enterprise.security.auth.login.common.LoginException(e.getMessage(), e);
            }
            return subject;
        }
        try {
            LoginContext lg = new LoginContext("default", subject, handler);
            lg.login();
            J2EEKeyManager.postClientAuth(subject, PasswordCredential.class);
        }
        catch (LoginException e) {
            throw new com.sun.enterprise.security.auth.login.common.LoginException(e.getMessage(), e);
        }
        return subject;
    }

    private static void postClientAuth(Subject subject, Class<?> clazz) {
        Set<?> credentials = subject.getPrivateCredentials(clazz);
        for (Object obj : credentials) {
            if (obj instanceof PasswordCredential) {
                PasswordCredential passwordCredential = (PasswordCredential)obj;
                String user = passwordCredential.getUser();
                LOG.log(Level.FINEST, "In LCD user-pass login:{0} realm :{1}", new Object[]{user, passwordCredential.getRealm()});
                J2EEKeyManager.setClientSecurityContext(user, subject);
                return;
            }
            if (!(obj instanceof X509CertificateCredential)) continue;
            X509CertificateCredential certificateCredential = (X509CertificateCredential)obj;
            String user = certificateCredential.getAlias();
            LOG.log(Level.FINEST, "In LCD cert-login::{0} realm :{1}", new Object[]{user, certificateCredential.getRealm()});
            J2EEKeyManager.setClientSecurityContext(user, subject);
            return;
        }
    }

    private static void setClientSecurityContext(String username, Subject subject) {
        ClientSecurityContext.setCurrent(new ClientSecurityContext(username, subject));
    }
}

