/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.util.Properties;
import javax.security.auth.Subject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.Job;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.jdbc.admin.cli.JDBCConnectionPoolManager;
import org.glassfish.jdbc.admin.cli.JDBCResourceManager;
import org.glassfish.resourcebase.resources.api.ResourceStatus;
import org.glassfish.resources.api.ResourceAttributes;
import org.jvnet.hk2.annotations.Service;

@ExecuteOn(value={RuntimeType.ALL})
@Service(name="create-jdbc-connection-pool")
@PerLookup
@I18n(value="create.jdbc.connection.pool")
public class CreateJdbcConnectionPool
implements AdminCommand {
    private static final LocalStringManagerImpl I18N = new LocalStringManagerImpl(CreateJdbcConnectionPool.class);
    @Param(name="datasourceClassname", optional=true)
    private String datasourceclassname;
    @Param(optional=true, name="resType", acceptableValues="javax.sql.DataSource,javax.sql.XADataSource,javax.sql.ConnectionPoolDataSource,java.sql.Driver")
    private String restype;
    @Param(name="steadyPoolSize", optional=true, defaultValue="8")
    private String steadypoolsize = "8";
    @Param(name="maxPoolSize", optional=true, defaultValue="32")
    private String maxpoolsize = "32";
    @Param(name="maxWait", alias="maxWaitTimeInMillis", optional=true, defaultValue="60000")
    private String maxwait = "60000";
    @Param(name="poolResize", alias="poolResizeQuantity", optional=true, defaultValue="2")
    private String poolresize = "2";
    @Param(name="idleTimeout", alias="idleTimeoutInSeconds", optional=true, defaultValue="300")
    private String idletimeout = "300";
    @Param(name="initSql", optional=true)
    private String initsql;
    @Param(name="isolationLevel", alias="transactionIsolationLevel", optional=true)
    private String isolationlevel;
    @Param(name="isIsolationGuaranteed", alias="isIsolationLevelGuaranteed", optional=true, defaultValue="true")
    private Boolean isisolationguaranteed;
    @Param(name="isConnectValidateReq", alias="isConnectionValidationRequired", optional=true, defaultValue="false")
    private Boolean isconnectvalidatereq;
    @Param(name="validationMethod", optional=true, alias="connectionValidationMethod", acceptableValues="auto-commit,meta-data,table,custom-validation", defaultValue="table")
    private String validationmethod = "table";
    @Param(name="validationTable", alias="validationTableName", optional=true)
    private String validationtable;
    @Param(name="failConnection", alias="failAllConnections", optional=true, defaultValue="false")
    private Boolean failconnection;
    @Param(name="allowNonComponentCallers", optional=true, defaultValue="false")
    private Boolean allownoncomponentcallers;
    @Param(name="nonTransactionalConnections", optional=true, defaultValue="false")
    private Boolean nontransactionalconnections;
    @Param(name="validateAtMostOncePeriod", alias="validateAtmostOncePeriodInSeconds", optional=true, defaultValue="0")
    private String validateatmostonceperiod = "0";
    @Param(name="leakTimeout", alias="connectionLeakTimeoutInSeconds", optional=true, defaultValue="0")
    private String leaktimeout = "0";
    @Param(name="leakReclaim", alias="connectionLeakReclaim", optional=true, defaultValue="false")
    private Boolean leakreclaim;
    @Param(name="creationRetryAttempts", alias="connectionCreationRetryAttempts", optional=true, defaultValue="0")
    private String creationretryattempts = "0";
    @Param(name="creationRetryInterval", alias="connectionCreationRetryIntervalInSeconds", optional=true, defaultValue="10")
    private String creationretryinterval = "10";
    @Param(name="sqlTraceListeners", optional=true)
    private String sqltracelisteners;
    @Param(name="statementTimeout", alias="statementTimeoutInSeconds", optional=true, defaultValue="-1")
    private String statementtimeout = "-1";
    @Param(name="statementLeakTimeout", alias="statementLeakTimeoutInSeconds", optional=true, defaultValue="0")
    private String statementLeaktimeout = "0";
    @Param(name="statementLeakReclaim", alias="statementLeakReclaim", optional=true, defaultValue="false")
    private Boolean statementLeakreclaim;
    @Param(name="lazyConnectionEnlistment", optional=true, defaultValue="false")
    private Boolean lazyconnectionenlistment;
    @Param(name="lazyConnectionAssociation", optional=true, defaultValue="false")
    private Boolean lazyconnectionassociation;
    @Param(name="associateWithThread", optional=true, defaultValue="false")
    private Boolean associatewiththread;
    @Param(name="driverClassname", optional=true)
    private String driverclassname;
    @Param(name="matchConnections", optional=true, defaultValue="false")
    private Boolean matchconnections;
    @Param(name="maxConnectionUsageCount", optional=true, defaultValue="0")
    private String maxconnectionusagecount = "0";
    @Param(optional=true, defaultValue="false")
    private Boolean ping;
    @Param(optional=true, defaultValue="true")
    private Boolean pooling;
    @Param(optional=true, name="statementCacheSize", defaultValue="0")
    private String statementcachesize;
    @Param(name="validationClassname", optional=true)
    private String validationclassname;
    @Param(name="wrapJdbcObjects", optional=true, defaultValue="true")
    private Boolean wrapjdbcobjects;
    @Param(name="description", optional=true)
    private String description;
    @Param(name="property", optional=true, separator=58)
    private Properties properties;
    @Param(optional=true, obsolete=true)
    private String target = "server";
    @Param(optional=true, separator=58)
    private String[] resourceNames;
    @Param(optional=true)
    private String sqlFileName;
    @Param(name="jdbc_connection_pool_id", alias="name", primary=true)
    private String jdbc_connection_pool_id;
    @Inject
    private Domain domain;
    @Inject
    private CommandRunner<Job> commandRunner;
    @Inject
    private JDBCResourceManager jdbcResourceManager;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        this.createPool(report);
        if (report.hasFailures()) {
            return;
        }
        if (this.resourceNames != null && this.resourceNames.length > 0) {
            this.createResources(report);
            if (report.hasFailures()) {
                return;
            }
            if (this.sqlFileName != null) {
                this.execSqlFile(this.resourceNames[0], report);
            }
        }
        if (report.hasFailures()) {
            return;
        }
        if (this.ping == Boolean.TRUE) {
            this.pingPool(context.getSubject(), report);
        }
    }

    private void pingPool(Subject subject, ActionReport report) {
        ActionReport subReport = report.addSubActionsReport();
        ParameterMap parameters = new ParameterMap();
        parameters.set((Object)"pool_name", (Object)this.jdbc_connection_pool_id);
        this.commandRunner.getCommandInvocation("ping-connection-pool", subReport, subject).parameters(parameters).execute();
        if (ActionReport.ExitCode.FAILURE.equals((Object)subReport.getActionExitCode())) {
            subReport.setMessage(I18N.getLocalString("ping.create.jdbc.connection.pool.fail", "\nAttempting to ping during JDBC Connection Pool Creation : {0} - Failed.", new Object[]{this.jdbc_connection_pool_id}));
            subReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
        } else {
            subReport.setMessage(I18N.getLocalString("ping.create.jdbc.connection.pool.success", "\nAttempting to ping during JDBC Connection Pool Creation : {0} - Succeeded.", new Object[]{this.jdbc_connection_pool_id}));
        }
    }

    private void createPool(ActionReport report) {
        ResourceAttributes attrList = new ResourceAttributes();
        attrList.set("name", this.jdbc_connection_pool_id);
        attrList.set("datasource-classname", this.datasourceclassname);
        attrList.set("description", this.description);
        attrList.set("res-type", this.restype);
        attrList.set("steady-pool-size", this.steadypoolsize);
        attrList.set("max-pool-size", this.maxpoolsize);
        attrList.set("max-wait-time-in-millis", this.maxwait);
        attrList.set("pool-resize-quantity", this.poolresize);
        attrList.set("init-sql", this.initsql);
        attrList.set("idle-timeout-in-seconds", this.idletimeout);
        attrList.set("transaction-isolation-level", this.isolationlevel);
        attrList.set("is-isolation-level-guaranteed", this.isisolationguaranteed.toString());
        attrList.set("is-connection-validation-required", this.isconnectvalidatereq.toString());
        attrList.set("connection-validation-method", this.validationmethod);
        attrList.set("validation-table-name", this.validationtable);
        attrList.set("fail-all-connections", this.failconnection.toString());
        attrList.set("non-transactional-connections", this.nontransactionalconnections.toString());
        attrList.set("allow-non-component-callers", this.allownoncomponentcallers.toString());
        attrList.set("validate-atmost-once-period-in-seconds", this.validateatmostonceperiod);
        attrList.set("connection-leak-timeout-in-seconds", this.leaktimeout);
        attrList.set("connection-leak-reclaim", this.leakreclaim.toString());
        attrList.set("connection-creation-retry-attempts", this.creationretryattempts);
        attrList.set("connection-creation-retry-interval-in-seconds", this.creationretryinterval);
        attrList.set("driver-classname", this.driverclassname);
        attrList.set("sql-trace-listeners", this.sqltracelisteners);
        attrList.set("statement-timeout-in-seconds", this.statementtimeout);
        attrList.set("statement-leak-timeout-in-seconds", this.statementLeaktimeout);
        attrList.set("statement-leak-reclaim", this.statementLeakreclaim.toString());
        attrList.set("statement-cache-size", this.statementcachesize);
        attrList.set("lazy-connection-association", this.lazyconnectionassociation.toString());
        attrList.set("lazy-connection-enlistment", this.lazyconnectionenlistment.toString());
        attrList.set("associate-with-thread", this.associatewiththread.toString());
        attrList.set("match-connections", this.matchconnections.toString());
        attrList.set("max-connection-usage-count", this.maxconnectionusagecount);
        attrList.set("ping", this.ping.toString());
        attrList.set("pooling", this.pooling.toString());
        attrList.set("validation-classname", this.validationclassname);
        attrList.set("wrap-jdbc-objects", this.wrapjdbcobjects.toString());
        try {
            JDBCConnectionPoolManager connPoolMgr = new JDBCConnectionPoolManager();
            ResourceStatus result = connPoolMgr.create(this.domain.getResources(), attrList, this.properties, this.target);
            if (result.getStatus() == 1) {
                report.setMessage(I18N.getLocalString("create.jdbc.connection.pool.fail", "JDBC connection pool {0} creation failed", new Object[]{this.jdbc_connection_pool_id, result.getMessage()}));
                report.setFailureCause(result.getException());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            } else {
                report.setMessage(result.getMessage());
            }
        }
        catch (Exception e) {
            report.setMessage(I18N.getLocalString("create.jdbc.connection.pool.fail", "JDBC connection pool: {0} could not be created, reason: {1}", new Object[]{this.jdbc_connection_pool_id, e.getMessage()}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }

    private void createResources(ActionReport report) {
        for (String resourceName : this.resourceNames) {
            ResourceAttributes attributes = new ResourceAttributes();
            attributes.set("jndi-name", resourceName);
            attributes.set("pool-name", this.jdbc_connection_pool_id);
            attributes.set("description", this.description);
            attributes.set("enabled", "true");
            Resources resources = this.domain.getResources();
            try {
                ResourceStatus result = this.jdbcResourceManager.create(resources, attributes, new Properties(), this.target);
                this.toSubReport(result, report);
            }
            catch (Exception e) {
                report.appendMessage(e.getMessage());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause((Throwable)e);
            }
        }
    }

    private void execSqlFile(String resourceName, ActionReport report) {
        try {
            ResourceStatus execStatus = this.jdbcResourceManager.executeSql(resourceName, this.sqlFileName);
            this.toSubReport(execStatus, report);
        }
        catch (Exception e) {
            report.appendMessage("SQL execution of file " + this.sqlFileName + " failed for jdbc resource " + resourceName + " using pool " + this.jdbc_connection_pool_id + ", due to " + e.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }

    private void toSubReport(ResourceStatus result, ActionReport report) {
        ActionReport subReport = report.addSubActionsReport();
        subReport.setMessage(result.getMessage());
        if (result.getStatus() == 1) {
            subReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            subReport.setFailureCause(result.getException());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        } else {
            subReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
    }
}

