/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jnosql.jakartapersistence;

import jakarta.interceptor.InvocationContext;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.executable.ExecutableValidator;
import java.util.Set;
import org.eclipse.jnosql.jakartapersistence.mapping.spi.MethodInterceptor;

public class EntityValidatorInterceptor
implements MethodInterceptor {
    Validator validator = null;

    public Object intercept(InvocationContext context) throws Exception {
        ExecutableValidator executablesValidator = this.getOrCreateValidator().forExecutables();
        Set parameterViolations = executablesValidator.validateParameters(context.getTarget(), context.getMethod(), context.getParameters(), new Class[0]);
        if (parameterViolations.isEmpty()) {
            Object returnValue = context.proceed();
            Set returnViolations = executablesValidator.validateReturnValue(context.getTarget(), context.getMethod(), returnValue, new Class[0]);
            if (returnViolations.isEmpty()) {
                return returnValue;
            }
            throw new ConstraintViolationException(returnViolations);
        }
        throw new ConstraintViolationException(parameterViolations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Validator getOrCreateValidator() {
        if (this.validator == null) {
            EntityValidatorInterceptor entityValidatorInterceptor = this;
            synchronized (entityValidatorInterceptor) {
                if (this.validator == null) {
                    ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                    this.validator = factory.usingContext().getValidator();
                }
            }
        }
        return this.validator;
    }
}

