/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.Marshaller;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.mappings.Mapping;
import org.eclipse.persistence.internal.oxm.record.MarshalRecord;

public abstract class MappingNodeValue
extends NodeValue {
    public abstract Mapping getMapping();

    @Override
    public boolean isMappingNodeValue() {
        return true;
    }

    protected void updateNamespaces(QName qname, MarshalRecord marshalRecord, Field xmlField) {
        if (qname != null) {
            String prefix;
            if (xmlField != null) {
                if (xmlField.isTypedTextField()) {
                    if (xmlField.getSchemaType() == null ? qname.equals(Constants.STRING_QNAME) : xmlField.isSchemaType(qname)) {
                        return;
                    }
                } else {
                    return;
                }
            }
            if ((prefix = ((NamespaceResolver)marshalRecord.getNamespaceResolver()).resolveNamespaceURI(qname.getNamespaceURI())) == null || prefix.isEmpty()) {
                prefix = "http://www.w3.org/2001/XMLSchema".equals(qname.getNamespaceURI()) ? ((NamespaceResolver)marshalRecord.getNamespaceResolver()).generatePrefix("xsd") : ((NamespaceResolver)marshalRecord.getNamespaceResolver()).generatePrefix();
                marshalRecord.namespaceDeclaration(prefix, qname.getNamespaceURI());
            }
            Object typeValue = null;
            typeValue = ((Marshaller)marshalRecord.getMarshaller()).getJsonTypeConfiguration().useJsonTypeCompatibility() ? (marshalRecord.isNamespaceAware() ? prefix + marshalRecord.getNamespaceSeparator() + qname.getLocalPart() : qname.getLocalPart()) : (marshalRecord.isNamespaceAware() && (((Marshaller)marshalRecord.getMarshaller()).isApplicationXML() || ((Marshaller)marshalRecord.getMarshaller()).getJsonTypeConfiguration().useXsdTypesWithPrefix()) ? prefix + marshalRecord.getNamespaceSeparator() + qname.getLocalPart() : qname.getLocalPart());
            this.addTypeAttribute(marshalRecord, (String)typeValue);
        }
    }

    protected void addTypeAttribute(MarshalRecord marshalRecord, String typeValue) {
        String xsiPrefix = null;
        if (marshalRecord.getNamespaceResolver() != null) {
            xsiPrefix = ((NamespaceResolver)marshalRecord.getNamespaceResolver()).resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
        } else {
            xsiPrefix = "xsi";
            marshalRecord.namespaceDeclaration(xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
        }
        if (xsiPrefix == null) {
            xsiPrefix = ((NamespaceResolver)marshalRecord.getNamespaceResolver()).generatePrefix("xsi");
            marshalRecord.namespaceDeclaration(xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
        }
        marshalRecord.attributeWithoutQName("http://www.w3.org/2001/XMLSchema-instance", "type", xsiPrefix, typeValue);
    }
}

