/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.identitymaps;

import java.io.Serializable;
import java.util.Arrays;
import org.eclipse.persistence.internal.identitymaps.CacheIdComparator;

public class CacheId
implements Serializable,
Comparable<CacheId> {
    public static final CacheId EMPTY = new CacheId(new Object[0]);
    private static final CacheIdComparator COMPARATOR = new CacheIdComparator();
    static final Class<?> APBYTE = byte[].class;
    static final Class<?> APCHAR = char[].class;
    protected Object[] primaryKey;
    protected int hash;
    protected boolean hasArray;

    public CacheId() {
    }

    public CacheId(Object[] primaryKey) {
        this.primaryKey = primaryKey;
        this.hash = this.computeHash(primaryKey);
    }

    public Object[] getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(Object[] primaryKey) {
        this.primaryKey = primaryKey;
        this.hash = this.computeHash(primaryKey);
    }

    public void add(Object value) {
        Object[] array = Arrays.copyOf(this.primaryKey, this.primaryKey.length + 1);
        array[this.primaryKey.length] = value;
        this.setPrimaryKey(array);
    }

    public void set(int index, Object value) {
        this.primaryKey[index] = value;
        this.setPrimaryKey(this.primaryKey);
    }

    protected int computeHash(Object[] primaryKey) {
        int result = 1;
        for (Object value : primaryKey) {
            if (value != null) {
                if (value.getClass().isArray()) {
                    result = this.computeArrayHashCode(result, value);
                    this.hasArray = true;
                    continue;
                }
                result = 31 * result + value.hashCode();
                continue;
            }
            result = 31 * result;
        }
        return result;
    }

    private int computeArrayHashCode(int result, Object obj) {
        if (obj.getClass() == APBYTE) {
            for (byte element : (byte[])obj) {
                result = 31 * result + element;
            }
        } else if (obj.getClass() == APCHAR) {
            for (char element : (char[])obj) {
                result = 31 * result + element;
            }
        } else {
            for (Object element : (Object[])obj) {
                result = 31 * result + (element == null ? 0 : element.hashCode());
            }
        }
        return result;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CacheId)) {
            return false;
        }
        return this.equals((CacheId)object);
    }

    public boolean equals(CacheId id) {
        if (this == id) {
            return true;
        }
        if (this.hash != id.hash) {
            return false;
        }
        if (this.hasArray != id.hasArray) {
            return false;
        }
        return this.compareTo(id) == 0;
    }

    @Override
    public int compareTo(CacheId otherId) {
        return COMPARATOR.compare(this, otherId);
    }

    public boolean hasArray() {
        return this.hasArray;
    }

    public String toString() {
        return "[" + String.valueOf(Arrays.asList(this.primaryKey)) + ": " + this.hash + "]";
    }
}

