/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.deployment.web.LoginConfiguration;
import com.sun.enterprise.security.AppCNonceCacheMap;
import com.sun.enterprise.security.CNonceCacheFactory;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.WebSecurityDeployerProbeProvider;
import com.sun.enterprise.security.auth.digest.api.DigestAlgorithmParameter;
import com.sun.enterprise.security.auth.digest.api.Key;
import com.sun.enterprise.security.auth.login.DigestCredentials;
import com.sun.enterprise.security.auth.login.DistinguishedPrincipalCredential;
import com.sun.enterprise.security.auth.login.LoginContextDriver;
import com.sun.enterprise.security.ee.authentication.glassfish.digest.impl.DigestParameterGenerator;
import com.sun.enterprise.security.ee.authentication.glassfish.digest.impl.HttpAlgorithmParameterImpl;
import com.sun.enterprise.security.ee.authentication.glassfish.digest.impl.NestedDigestAlgoParamImpl;
import com.sun.enterprise.security.ee.authentication.jakarta.AuthMessagePolicy;
import com.sun.enterprise.security.ee.authentication.jakarta.ConfigDomainParser;
import com.sun.enterprise.security.ee.authentication.jakarta.callback.ServerContainerCallbackHandler;
import com.sun.enterprise.security.ee.authorization.AuthorizationUtil;
import com.sun.enterprise.security.ee.web.integration.WebPrincipal;
import com.sun.enterprise.security.ee.web.integration.WebSecurityManager;
import com.sun.enterprise.security.ee.web.integration.WebSecurityManagerFactory;
import com.sun.enterprise.security.integration.RealmInitializer;
import com.sun.enterprise.util.Utility;
import com.sun.enterprise.util.net.NetUtils;
import com.sun.web.security.HttpRequestWrapper;
import com.sun.web.security.HttpResponseWrapper;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.config.ServerAuthContext;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.x500.X500Principal;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.realm.RealmBase;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.epicyro.config.factory.ConfigParser;
import org.glassfish.epicyro.config.helper.Caller;
import org.glassfish.epicyro.config.helper.CallerPrincipal;
import org.glassfish.epicyro.services.BaseAuthenticationService;
import org.glassfish.epicyro.services.DefaultAuthenticationService;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.NetworkListeners;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.security.common.CNonceCache;
import org.glassfish.security.common.Group;
import org.glassfish.security.common.NonceInfo;
import org.glassfish.security.common.UserNameAndPassword;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public final class RealmAdapter
extends RealmBase
implements RealmInitializer,
PostConstruct {
    public static final String SECURITY_CONTEXT = "SecurityContext";
    public static final String BASIC = "BASIC";
    public static final String FORM = "FORM";
    private static final Logger LOG = Logger.getLogger(RealmAdapter.class.getName(), "org.glassfish.main.web.security.LogMessages");
    private static final ResourceBundle resourceBundle = LOG.getResourceBundle();
    @Deprecated
    private static final String REGISTER_WITH_AUTHENTICATOR = "com.sun.web.RealmAdapter.register";
    private static final String SERVER_AUTH_CONTEXT = "__jakarta.security.auth.message.ServerAuthContext";
    private static final String MESSAGE_INFO = "__jakarta.security.auth.message.MessageInfo";
    private static final WebSecurityDeployerProbeProvider websecurityProbeProvider = new WebSecurityDeployerProbeProvider();
    private static final String SYSTEM_HTTPSERVLET_SECURITY_PROVIDER = "system_httpservlet_security_provider";
    private WebBundleDescriptor webBundleDescriptor;
    private HashMap<String, String> runAsPrincipals;
    private String realmName;
    protected static final String name = "J2EE-RI-RealmAdapter";
    private String contextId;
    private Container virtualServer;
    protected volatile WebSecurityManager webSecurityManager;
    protected boolean isCurrentURIincluded = false;
    protected final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private boolean contextEvaluated = false;
    private String loginPage;
    private String errorPage;
    private static final SecurityConstraint[] emptyConstraints = new SecurityConstraint[0];
    private static String defaultSystemProviderID = RealmAdapter.getDefaultSystemProviderID();
    private String moduleID;
    private boolean isSystemApp;
    private BaseAuthenticationService authenticationService;
    @Inject
    private ServerContext serverContext;
    @Inject
    private Provider<AppCNonceCacheMap> appCNonceCacheMapProvider;
    @Inject
    private Provider<CNonceCacheFactory> cNonceCacheFactoryProvider;
    @Inject
    @Named(value="default-instance-name")
    private NetworkConfig networkConfig;
    @Inject
    protected WebSecurityManagerFactory webSecurityManagerFactory;
    private CNonceCacheFactory cNonceCacheFactory;
    private CNonceCache cnonces;
    private AppCNonceCacheMap haCNonceCacheMap;
    private NetworkListeners networkListeners;
    private static ThreadLocal<byte[]> reentrancyStatus = ThreadLocal.withInitial(() -> new byte[]{0});
    private static final String PROXY_AUTH_TYPE = "PLUGGABLE_PROVIDER";

    public RealmAdapter() {
    }

    public RealmAdapter(String realmName, String moduleID) {
        this.realmName = realmName;
        this.moduleID = moduleID;
    }

    public void initializeRealm(Object descriptor, boolean isSystemApp, String initialRealmName) {
        this.isSystemApp = isSystemApp;
        this.webBundleDescriptor = (WebBundleDescriptor)descriptor;
        this.realmName = this.findRealmName(initialRealmName);
        this.contextId = AuthorizationUtil.getContextID((WebBundleDescriptor)this.webBundleDescriptor);
        this.moduleID = this.webBundleDescriptor.getModuleID();
        this.collectRunAsPrincipals();
    }

    public boolean isSecurityExtensionEnabled(ServletContext context) {
        if (this.authenticationService == null) {
            this.initAuthenticationService(context);
        }
        try {
            return this.authenticationService.getServerAuthConfig() != null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public SecurityConstraint[] findSecurityConstraints(HttpRequest request, Context context) {
        return this.findSecurityConstraints(context);
    }

    public SecurityConstraint[] findSecurityConstraints(String requestPathMB, String httpMethod, Context context) {
        return this.findSecurityConstraints(context);
    }

    public boolean hasUserDataPermission(HttpRequest request, HttpResponse response, SecurityConstraint[] constraints) throws IOException {
        return this.hasUserDataPermission(request, response, constraints, null, null);
    }

    public boolean hasUserDataPermission(HttpRequest request, HttpResponse response, SecurityConstraint[] constraints, String uri, String method) throws IOException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        if (httpServletRequest.getServletPath() == null) {
            request.setServletPath(this.getResourceName(httpServletRequest.getRequestURI(), httpServletRequest.getContextPath()));
        }
        LOG.log(Level.FINE, "hasUserDataPermission called for principal {0} and context path {1}", new Object[]{httpServletRequest.getUserPrincipal(), httpServletRequest.getContextPath()});
        if (request.getRequest().isSecure()) {
            LOG.log(Level.FINE, "request.getRequest().isSecure(): {0}", request.getRequest().isSecure());
            return true;
        }
        WebSecurityManager securityManager = this.getWebSecurityManager(true);
        if (securityManager == null) {
            return false;
        }
        int isGranted = 0;
        try {
            isGranted = securityManager.getAuthorizationService().hasUserDataPermission(httpServletRequest, uri, method);
        }
        catch (IllegalArgumentException e) {
            LOG.log(Level.WARNING, "realmAdapter.badRequestWithId", e);
            ((HttpServletResponse)response.getResponse()).sendError(400, resourceBundle.getString("realmAdapter.badRequestWithId"));
            return false;
        }
        if (isGranted == -1) {
            LOG.log(Level.FINE, "Redirecting using SSL");
            return this.redirect(request, response);
        }
        if (isGranted == 0) {
            ((HttpServletResponse)response.getResponse()).sendError(403, resourceBundle.getString("realmBase.forbidden"));
            return false;
        }
        return true;
    }

    public int preAuthenticateCheck(HttpRequest request, HttpResponse response, SecurityConstraint[] constraints, boolean disableProxyCaching, boolean securePagesWithPragma, boolean ssoEnabled) throws IOException {
        boolean isGranted = false;
        try {
            if (!this.isRequestAuthenticated(request)) {
                SecurityContext.setUnauthenticatedContext();
            }
            if (this.isJakartaAuthenticationEnabled()) {
                return 1;
            }
            isGranted = this.invokeWebSecurityManager(request, response, constraints);
        }
        catch (IOException iex) {
            throw iex;
        }
        catch (Throwable ex) {
            LOG.log(Level.SEVERE, "Authentication passed, but authorization failed.", ex);
            ((HttpServletResponse)response.getResponse()).sendError(503);
            response.setDetailMessage(resourceBundle.getString("realmBase.forbidden"));
            return -1;
        }
        if (isGranted) {
            if (this.isRequestAuthenticated(request)) {
                this.disableProxyCaching(request, response, disableProxyCaching, securePagesWithPragma);
                if (ssoEnabled) {
                    HttpServletRequest httpServletRequest = (HttpServletRequest)request.getRequest();
                    if (!this.getWebSecurityManager(true).getAuthorizationService().permitAll(httpServletRequest)) {
                        httpServletRequest.getSession(true);
                    }
                }
            }
            return 0;
        }
        if (this.isRequestAuthenticated(request)) {
            ((HttpServletResponse)response.getResponse()).sendError(403);
            response.setDetailMessage(resourceBundle.getString("realmBase.forbidden"));
            return -1;
        }
        this.disableProxyCaching(request, response, disableProxyCaching, securePagesWithPragma);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invokeAuthenticateDelegate(HttpRequest request, HttpResponse response, Context context, Authenticator authenticator, boolean calledFromAuthenticate) throws IOException {
        LoginConfig config = context.getLoginConfig();
        if (this.isJakartaAuthenticationEnabled()) {
            SecurityContext securityContext = SecurityContext.getCurrent();
            try {
                context.fireContainerEvent("beforeAuthentication", null);
                RequestFacade requestFacade = (RequestFacade)request.getRequest();
                securityContext.setSessionPrincipal(requestFacade.getRequestPrincipal());
                boolean bl = this.validate(request, response, config, authenticator, calledFromAuthenticate);
                return bl;
            }
            finally {
                securityContext.setSessionPrincipal(null);
                context.fireContainerEvent("afterAuthentication", null);
            }
        }
        return ((AuthenticatorBase)authenticator).authenticate(request, response, config);
    }

    protected String getName() {
        return name;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setVirtualServer(Object container) {
        this.virtualServer = (Container)container;
    }

    public void updateWebSecurityManager() {
        if (this.webSecurityManager == null) {
            this.webSecurityManager = this.getWebSecurityManager(true);
        }
        if (this.webSecurityManager != null) {
            try {
                this.webSecurityManager.release();
                this.webSecurityManager.destroy();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.webSecurityManager = this.webSecurityManagerFactory.createManager(this.webBundleDescriptor, true, this.serverContext);
            LOG.log(Level.FINE, "WebSecurityManager for {0} has been updated", this.contextId);
        }
    }

    public Principal authenticate(HttpRequest request, String username, char[] password) {
        LOG.log(Level.FINE, "Tomcat callback for authenticate user/password. Username: {0}", username);
        if (this.authenticate((HttpServletRequest)request, username, password, null, null)) {
            return new WebPrincipal(username, password, SecurityContext.getCurrent());
        }
        return null;
    }

    public Principal authenticate(HttpServletRequest httpServletRequest) {
        DigestCredentials digestCredentials = this.generateDigestCredentials(httpServletRequest);
        if (digestCredentials != null && this.authenticate(httpServletRequest, null, null, digestCredentials, null)) {
            return new WebPrincipal(digestCredentials.getUserName(), (char[])null, SecurityContext.getCurrent());
        }
        return null;
    }

    public Principal authenticate(HttpRequest request, X509Certificate[] certificates) {
        if (this.authenticate((HttpServletRequest)request, null, null, null, certificates)) {
            return new WebPrincipal(certificates, SecurityContext.getCurrent());
        }
        return null;
    }

    public boolean hasResourcePermission(HttpRequest request, HttpResponse response, SecurityConstraint[] constraints, Context context) throws IOException {
        boolean isGranted = false;
        try {
            isGranted = this.invokeWebSecurityManager(request, response, constraints);
        }
        catch (IOException iex) {
            throw iex;
        }
        catch (Throwable ex) {
            LOG.log(Level.SEVERE, "Authentication passed, but authorization failed.", ex);
            ((HttpServletResponse)response.getResponse()).sendError(503);
            response.setDetailMessage(resourceBundle.getString("realmBase.forbidden"));
            return isGranted;
        }
        if (isGranted) {
            return isGranted;
        }
        ((HttpServletResponse)response.getResponse()).sendError(403);
        response.setDetailMessage(resourceBundle.getString("realmBase.forbidden"));
        this.invokePostAuthenticateDelegate(request, response, context);
        return isGranted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invokePostAuthenticateDelegate(HttpRequest request, HttpResponse response, Context context) throws IOException {
        boolean result;
        block11: {
            result = false;
            ServerAuthContext serverAuthContext = null;
            try {
                HttpServletRequest httpServletRequest;
                MessageInfo messageInfo;
                if (this.authenticationService == null || (messageInfo = (MessageInfo)(httpServletRequest = (HttpServletRequest)request.getRequest()).getAttribute(MESSAGE_INFO)) == null || (serverAuthContext = (ServerAuthContext)messageInfo.getMap().get(SERVER_AUTH_CONTEXT)) == null) break block11;
                try {
                    context.fireContainerEvent("beforePostAuthentication", null);
                    AuthStatus authStatus = serverAuthContext.secureResponse(messageInfo, null);
                    result = AuthStatus.SUCCESS.equals(authStatus);
                }
                finally {
                    context.fireContainerEvent("afterPostAuthentication", null);
                }
            }
            catch (AuthException ex) {
                throw new IOException(ex);
            }
            finally {
                if (this.authenticationService != null && serverAuthContext != null) {
                    if (request instanceof HttpRequestWrapper) {
                        request.removeNote("__jakarta.security.auth.message.request");
                    }
                    if (response instanceof HttpResponseWrapper) {
                        request.removeNote("__jakarta.security.auth.message.response");
                    }
                }
            }
        }
        return result;
    }

    public boolean hasRole(HttpRequest request, HttpResponse response, Principal principal, String role) {
        WebSecurityManager manager = this.getWebSecurityManager(true);
        if (manager == null) {
            return false;
        }
        String servletName = this.getCanonicalName(request);
        boolean isGranted = manager.getAuthorizationService().hasRoleRefPermission(servletName, role, principal);
        LOG.log(Level.FINE, "Checking if servlet {0} with principal {1} has role {2} isGranted: {3}", new Object[]{servletName, principal, role, isGranted});
        return isGranted;
    }

    public void destroy() {
        super.destroy();
        if (this.authenticationService != null) {
            this.authenticationService.disable();
        }
    }

    public WebBundleDescriptor getWebDescriptor() {
        return this.webBundleDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebSecurityManager getWebSecurityManager(boolean logNull) {
        if (this.webSecurityManager == null && this.webSecurityManagerFactory != null) {
            RealmAdapter realmAdapter = this;
            synchronized (realmAdapter) {
                this.webSecurityManager = this.webSecurityManagerFactory.getManager(this.contextId);
            }
            if (this.webSecurityManager == null && logNull) {
                LOG.log(Level.WARNING, "realmAdapter.noWebSecMgr", this.contextId);
            }
        }
        return this.webSecurityManager;
    }

    public boolean hasRole(String servletName, Principal principal, String role) {
        WebSecurityManager secMgr = this.getWebSecurityManager(true);
        if (secMgr == null) {
            return false;
        }
        return secMgr.getAuthorizationService().hasRoleRefPermission(servletName, role, principal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void logout(HttpRequest httpRequest) {
        boolean securityExtensionEnabled = this.isSecurityExtensionEnabled(httpRequest.getRequest().getServletContext());
        byte[] alreadyCalled = reentrancyStatus.get();
        if (securityExtensionEnabled && this.authenticationService != null && alreadyCalled[0] == 0) {
            alreadyCalled[0] = 1;
            MessageInfo messageInfo = (MessageInfo)httpRequest.getRequest().getAttribute(MESSAGE_INFO);
            if (messageInfo == null) {
                messageInfo = new HttpMessageInfo((HttpServletRequest)httpRequest.getRequest(), (HttpServletResponse)httpRequest.getResponse().getResponse());
            }
            messageInfo.getMap().put("jakarta.security.auth.message.MessagePolicy.isMandatory", Boolean.TRUE.toString());
            try {
                Subject subject;
                ServerAuthContext serverAuthContext = this.authenticationService.getServerAuthContext(messageInfo, null);
                if (serverAuthContext == null) return;
                SecurityContext securityContext = SecurityContext.getCurrent();
                Subject subject2 = subject = securityContext.didServerGenerateCredentials() ? new Subject() : securityContext.getSubject();
                if (subject == null) {
                    subject = new Subject();
                }
                if (subject.isReadOnly()) {
                    LOG.log(Level.WARNING, "Read-only subject found during logout processing");
                }
                try {
                    httpRequest.getContext().fireContainerEvent("beforePostAuthentication", null);
                    serverAuthContext.cleanSubject(messageInfo, subject);
                    return;
                }
                finally {
                    httpRequest.getContext().fireContainerEvent("afterPostAuthentication", null);
                }
            }
            catch (AuthException ex) {
                throw new RuntimeException(ex);
            }
            finally {
                this.doLogout(httpRequest, true);
                alreadyCalled[0] = 0;
            }
        } else {
            this.doLogout(httpRequest, alreadyCalled[0] == 1);
        }
    }

    private void doLogout(HttpRequest request, boolean extensionEnabled) {
        Context context = request.getContext();
        Authenticator authenticator = null;
        if (context != null) {
            authenticator = context.getAuthenticator();
        }
        if (authenticator == null) {
            throw new RuntimeException("Context or Authenticator is null");
        }
        try {
            if (extensionEnabled) {
                AuthenticatorProxy proxy = new AuthenticatorProxy(authenticator, null, null);
                proxy.logout(request);
            } else {
                authenticator.logout(request);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.logout();
    }

    public void logout() {
        this.setSecurityContext(null);
        WebSecurityManager webSecurityManager = this.getWebSecurityManager(false);
        if (webSecurityManager != null) {
            webSecurityManager.onLogout();
        }
    }

    public boolean authenticate(HttpServletRequest request, WebPrincipal principal) {
        if (principal.isUsingCertificate()) {
            return this.authenticate(request, null, null, null, principal.getCertificates());
        }
        return this.authenticate(request, principal.getName(), principal.getPassword(), null, null);
    }

    private boolean authenticate(HttpServletRequest request, String username, char[] password, DigestCredentials digestCredentials, X509Certificate[] certificates) {
        try {
            if (certificates != null) {
                LoginContextDriver.doX500Login((Subject)this.generateX500Subject(certificates), (String)this.moduleID);
            } else if (digestCredentials != null) {
                LoginContextDriver.login((DigestCredentials)digestCredentials);
            } else {
                LoginContextDriver.login((String)username, (char[])password, (String)this.realmName);
            }
            LOG.log(Level.FINE, "Web login succeeded for: {0}", SecurityContext.getCurrent().getCallerPrincipal());
            WebSecurityManager manager = this.getWebSecurityManager(false);
            if (manager != null) {
                manager.onLogin(request);
            }
            return true;
        }
        catch (Exception le) {
            LOG.log(Level.WARNING, "WEB9102: Web Login Failed", le);
            return false;
        }
    }

    public void preSetRunAsIdentity(ComponentInvocation componentInvocation) {
        if (Utility.isEmpty(this.runAsPrincipals)) {
            return;
        }
        String servletName = this.getServletName(componentInvocation);
        if (servletName == null) {
            return;
        }
        String runAs = this.runAsPrincipals.get(servletName);
        if (runAs != null) {
            componentInvocation.setOldSecurityContext((Object)this.getSecurityContext());
            this.loginForRunAs(runAs);
            LOG.log(Level.FINE, "The run-as principal for servlet {0} set to {1}", new Object[]{servletName, runAs});
        }
    }

    private String getServletName(ComponentInvocation componentInvocation) {
        HttpServlet thisServlet;
        ServletConfig servletConfig;
        String servletName = componentInvocation.getInstanceName();
        if (servletName != null) {
            return servletName;
        }
        Object invocationInstance = componentInvocation.getInstance();
        if (invocationInstance instanceof HttpServlet && (servletConfig = (thisServlet = (HttpServlet)invocationInstance).getServletConfig()) != null) {
            return thisServlet.getServletName();
        }
        return null;
    }

    public void postSetRunAsIdentity(ComponentInvocation inv) {
        if (this.runAsPrincipals != null && this.runAsPrincipals.isEmpty()) {
            return;
        }
        String servletName = this.getServletName(inv);
        if (servletName == null) {
            return;
        }
        String runAs = this.runAsPrincipals.get(servletName);
        if (runAs != null) {
            this.setSecurityContext((SecurityContext)inv.getOldSecurityContext());
        }
    }

    private void loginForRunAs(String principal) {
        LoginContextDriver.loginPrincipal((String)principal, (String)this.realmName);
    }

    private SecurityContext getSecurityContext() {
        return SecurityContext.getCurrent();
    }

    private void setSecurityContext(SecurityContext sc) {
        SecurityContext.setCurrent((SecurityContext)sc);
    }

    protected char[] getPassword(String username) {
        throw new IllegalStateException("Should not reach here");
    }

    protected Principal getPrincipal(String username) {
        throw new IllegalStateException("Should not reach here");
    }

    public Principal createFailOveredPrincipal(String username) {
        LOG.log(Level.FINEST, "createFailOveredPrincipal(username={0})", username);
        this.loginForRunAs(username);
        SecurityContext securityContext = SecurityContext.getCurrent();
        LOG.log(Level.FINE, "Security context is {0}", securityContext);
        WebPrincipal principal = new WebPrincipal(username, (char[])null, securityContext);
        LOG.log(Level.INFO, "Principal created for FailOvered user {0}", principal);
        return principal;
    }

    private boolean invokeWebSecurityManager(HttpRequest request, HttpResponse response, SecurityConstraint[] constraints) throws IOException {
        if (this.isRequestFormPage(request)) {
            return true;
        }
        this.setServletPath(request);
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        LOG.log(Level.FINE, () -> "[Web-Security] [ hasResourcePermission ] Principal: " + String.valueOf(httpServletRequest.getUserPrincipal()) + " ContextPath: " + httpServletRequest.getContextPath());
        WebSecurityManager webSecurityManager = this.getWebSecurityManager(true);
        if (webSecurityManager == null) {
            return false;
        }
        return webSecurityManager.getAuthorizationService().hasResourcePermission(httpServletRequest);
    }

    private boolean isRequestFormPage(HttpRequest request) {
        this.initFormPages();
        if (Utility.isAllNull((Object[])new Object[]{this.loginPage, this.errorPage})) {
            return false;
        }
        String requestURI = request.getRequestPathMB().toString();
        LOG.log(Level.FINE, "requestURI: {0}, loginPage: {1}, errorPage: {2}", new Object[]{requestURI, this.loginPage, this.errorPage});
        if (this.loginPage != null && this.loginPage.equals(requestURI)) {
            LOG.log(Level.FINE, "Allowed access to login page {0}", this.loginPage);
            return true;
        }
        if (this.errorPage != null && this.errorPage.equals(requestURI)) {
            LOG.log(Level.FINE, "Allowed access to error page {0}", this.errorPage);
            return true;
        }
        if (requestURI.endsWith("/j_security_check")) {
            LOG.log(Level.FINE, "Allowed access to username/password submission ({0})", "/j_security_check");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFormPages() {
        boolean evaluated = false;
        try {
            this.rwLock.readLock().lock();
            evaluated = this.contextEvaluated;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        if (!evaluated) {
            try {
                this.rwLock.writeLock().lock();
                if (!this.contextEvaluated) {
                    Context context = (Context)this.getContainer();
                    LoginConfig config = context.getLoginConfig();
                    if (config != null && FORM.equals(config.getAuthMethod())) {
                        this.loginPage = config.getLoginPage();
                        this.errorPage = config.getErrorPage();
                    }
                    this.contextEvaluated = true;
                }
            }
            finally {
                this.rwLock.writeLock().unlock();
            }
        }
    }

    private void setServletPath(HttpRequest request) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        if (httpServletRequest.getServletPath() == null) {
            request.setServletPath(this.getResourceName(httpServletRequest.getRequestURI(), httpServletRequest.getContextPath()));
        }
    }

    private List<String> getHostAndPort(HttpRequest request) throws IOException {
        boolean isHostPortNullOrEmpty;
        Enumeration headerNames = ((HttpServletRequest)request.getRequest()).getHeaderNames();
        String[] hostPort = null;
        boolean isHeaderPresent = false;
        boolean isWebServerRequest = false;
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            if (!headerName.equalsIgnoreCase("Host")) continue;
            String hostVal = ((HttpServletRequest)request.getRequest()).getHeader(headerName);
            isHeaderPresent = true;
            hostPort = hostVal.split(":");
        }
        if (hostPort == null) {
            throw new ProtocolException(resourceBundle.getString("missing_http_header.host"));
        }
        boolean bl = isHostPortNullOrEmpty = hostPort.length <= 1 || hostPort[1] == null || hostPort[1].isBlank();
        if (!isHeaderPresent) {
            isWebServerRequest = false;
        } else if (isHostPortNullOrEmpty) {
            isWebServerRequest = true;
        } else {
            boolean breakFromLoop = false;
            for (NetworkListener nwListener : this.networkListeners.getNetworkListener()) {
                String nwAddress = nwListener.getAddress();
                if (nwAddress == null || nwAddress.equals("0.0.0.0")) {
                    nwAddress = NetUtils.getCanonicalHostName();
                    if (!nwAddress.equals(hostPort[0])) {
                        InetAddress[] localHostAdresses = NetUtils.getHostAddresses();
                        if (localHostAdresses == null) break;
                        InetAddress hostAddress = InetAddress.getByName(hostPort[0]);
                        for (InetAddress inetAdress : localHostAdresses) {
                            if (!inetAdress.equals(hostAddress)) continue;
                            String nwPort = nwListener.getPort();
                            if (nwPort.equals(hostPort[1])) {
                                isWebServerRequest = false;
                                breakFromLoop = true;
                                break;
                            }
                            isWebServerRequest = true;
                        }
                    } else {
                        String nwPort = nwListener.getPort();
                        if (!nwPort.equals(hostPort[1])) {
                            isWebServerRequest = true;
                        } else {
                            isWebServerRequest = false;
                            breakFromLoop = true;
                        }
                    }
                }
                if (!breakFromLoop || isWebServerRequest) continue;
                break;
            }
        }
        String serverHost = request.getRequest().getServerName();
        int redirectPort = request.getConnector().getRedirectPort();
        if (isWebServerRequest) {
            serverHost = hostPort[0];
            redirectPort = isHostPortNullOrEmpty ? -1 : Integer.parseInt(hostPort[1]);
        }
        ArrayList<String> hostAndPort = new ArrayList<String>();
        hostAndPort.add(serverHost);
        hostAndPort.add(String.valueOf(redirectPort));
        return hostAndPort;
    }

    private boolean redirect(HttpRequest request, HttpResponse response) throws IOException {
        String queryString;
        HttpServletRequest hrequest = (HttpServletRequest)request.getRequest();
        HttpServletResponse hresponse = (HttpServletResponse)response.getResponse();
        int redirectPort = request.getConnector().getRedirectPort();
        if (redirectPort <= 0) {
            LOG.fine("SSL redirect is disabled");
            hresponse.sendError(403, URLEncoder.encode(hrequest.getRequestURI(), StandardCharsets.UTF_8));
            return false;
        }
        String protocol = "https";
        StringBuffer file = new StringBuffer(hrequest.getRequestURI());
        String requestedSessionId = hrequest.getRequestedSessionId();
        if (requestedSessionId != null && hrequest.isRequestedSessionIdFromURL()) {
            file.append(";jsessionid=");
            file.append(requestedSessionId);
        }
        if ((queryString = hrequest.getQueryString()) != null) {
            file.append('?');
            file.append(queryString);
        }
        URL url = null;
        List<String> hostAndPort = this.getHostAndPort(request);
        String serverHost = hostAndPort.get(0);
        redirectPort = Integer.parseInt(hostAndPort.get(1));
        try {
            url = new URL(protocol, serverHost, redirectPort, file.toString());
            hresponse.sendRedirect(url.toString());
            return false;
        }
        catch (MalformedURLException e) {
            hresponse.sendError(500, URLEncoder.encode(hrequest.getRequestURI(), StandardCharsets.UTF_8));
            return false;
        }
    }

    private String getCanonicalName(HttpRequest currentRequest) {
        return currentRequest.getWrapper().getServletName();
    }

    private String getResourceName(String uri, String contextPath) {
        if (contextPath.length() < uri.length()) {
            return uri.substring(contextPath.length());
        }
        return "";
    }

    public void setRealmName(String realmName) {
    }

    private BaseAuthenticationService createAuthenticationService(ServletContext servletContext) throws IOException {
        String authModuleId;
        HashMap<String, String> properties = new HashMap<String, String>();
        String policyContextId = AuthorizationUtil.getContextID((WebBundleDescriptor)this.webBundleDescriptor);
        if (policyContextId != null) {
            properties.put("jakarta.security.jacc.PolicyContext", policyContextId);
        }
        if ((authModuleId = AuthMessagePolicy.getProviderID((SunWebApp)AuthMessagePolicy.getSunWebApp(Map.of("WEB_BUNDLE", this.webBundleDescriptor)))) != null) {
            properties.put("authModuleId", authModuleId);
        }
        String appContextId = this.getAppContextID(servletContext);
        return new DefaultAuthenticationService(appContextId, properties, (ConfigParser)new ConfigDomainParser(), (CallbackHandler)new ServerContainerCallbackHandler(this.realmName));
    }

    private String getAppContextID(ServletContext servletContext) {
        if (!servletContext.getVirtualServerName().equals(this.virtualServer.getName())) {
            LOG.log(Level.WARNING, "Virtual server name from ServletContext: {0} differs from name from virtual.getName(): {1}", new Object[]{servletContext.getVirtualServerName(), this.virtualServer.getName()});
        }
        if (!servletContext.getContextPath().equals(this.webBundleDescriptor.getContextRoot())) {
            LOG.log(Level.WARNING, "Context path from ServletContext: {0} differs from path from bundle: {1}", new Object[]{servletContext.getContextPath(), this.webBundleDescriptor.getContextRoot()});
        }
        return servletContext.getVirtualServerName() + " " + servletContext.getContextPath();
    }

    private boolean validate(HttpRequest request, HttpResponse response, LoginConfig config, Authenticator authenticator, boolean calledFromAuthenticate) throws IOException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request.getRequest(true);
        HttpServletResponse httpServletResponse = (HttpServletResponse)response.getResponse();
        Subject subject = new Subject();
        HttpMessageInfo messageInfo = new HttpMessageInfo(httpServletRequest, httpServletResponse);
        boolean isRequestValidated = false;
        boolean isMandatory = true;
        try {
            ServerAuthContext serverAuthContext;
            boolean bl = isMandatory = !this.getWebSecurityManager(true).getAuthorizationService().permitAll(httpServletRequest);
            if (isMandatory || calledFromAuthenticate) {
                messageInfo.getMap().put("jakarta.security.auth.message.MessagePolicy.isMandatory", Boolean.TRUE.toString());
            }
            if ((serverAuthContext = this.authenticationService.getServerAuthContext((MessageInfo)messageInfo, null)) == null) {
                throw new AuthException("null ServerAuthContext");
            }
            AuthStatus authStatus = serverAuthContext.validateRequest((MessageInfo)messageInfo, subject, null);
            isRequestValidated = AuthStatus.SUCCESS.equals(authStatus);
            if (isRequestValidated) {
                messageInfo.getMap().put(SERVER_AUTH_CONTEXT, serverAuthContext);
                httpServletRequest.setAttribute(MESSAGE_INFO, (Object)messageInfo);
            }
        }
        catch (AuthException ae) {
            LOG.log(Level.SEVERE, "Jakarta Authentication: http msg authentication fail", ae);
            httpServletResponse.setStatus(500);
        }
        catch (RuntimeException e) {
            LOG.log(Level.SEVERE, "Jakarta Authentication: Exception during validateRequest", e);
            httpServletResponse.sendError(500);
        }
        if (isRequestValidated) {
            block22: {
                Caller caller = this.getCaller(subject);
                if (caller != null) {
                    subject = new Subject();
                    Subject sessionSubject = this.reuseSessionSubject(caller);
                    if (sessionSubject != null) {
                        RealmAdapter.copySubject(subject, sessionSubject);
                    } else {
                        Principal glassFishCallerPrincipal = this.getGlassFishCallerPrincipal(caller);
                        RealmAdapter.toSubject(subject, glassFishCallerPrincipal);
                        DistinguishedPrincipalCredential distinguishedPrincipal = new DistinguishedPrincipalCredential(glassFishCallerPrincipal);
                        RealmAdapter.toSubject(subject, (Principal)distinguishedPrincipal);
                        RealmAdapter.toSubjectCredential(subject, distinguishedPrincipal);
                        for (String group : caller.getGroups()) {
                            RealmAdapter.toSubject(subject, (Principal)new Group(group));
                        }
                        if (!glassFishCallerPrincipal.equals(SecurityContext.getDefaultCallerPrincipal())) {
                            LoginContextDriver.jmacLogin((Subject)subject, (Principal)glassFishCallerPrincipal, (String)this.realmName);
                            SecurityContext ctx = new SecurityContext(subject);
                            SecurityContext.setCurrent((SecurityContext)ctx);
                            Principal principal = ctx.getCallerPrincipal();
                            WebPrincipal webPrincipal = new WebPrincipal(principal, ctx);
                            try {
                                String authType = (String)messageInfo.getMap().get("jakarta.servlet.http.authType");
                                if (authType == null && config != null && config.getAuthMethod() != null) {
                                    authType = config.getAuthMethod();
                                }
                                if (this.shouldRegister(messageInfo.getMap())) {
                                    new AuthenticatorProxy(authenticator, (Principal)webPrincipal, authType).authenticate(request, response, config);
                                    break block22;
                                }
                                request.setAuthType(authType == null ? PROXY_AUTH_TYPE : authType);
                                request.setUserPrincipal((Principal)webPrincipal);
                            }
                            catch (LifecycleException le) {
                                LOG.log(Level.SEVERE, "Unable to register session", le);
                            }
                        } else {
                            if (((HttpServletRequest)messageInfo.getRequestMessage()).getUserPrincipal() != null) {
                                request.setUserPrincipal(null);
                                request.setAuthType(null);
                            }
                            if (isMandatory) {
                                isRequestValidated = false;
                            }
                        }
                    }
                }
            }
            if (isRequestValidated) {
                HttpServletResponse newResponse;
                HttpServletRequest newRequest = (HttpServletRequest)messageInfo.getRequestMessage();
                if (newRequest != httpServletRequest) {
                    request.setNote("__jakarta.security.auth.message.request", (Object)new HttpRequestWrapper(request, newRequest));
                }
                if ((newResponse = (HttpServletResponse)messageInfo.getResponseMessage()) != httpServletResponse) {
                    request.setNote("__jakarta.security.auth.message.response", (Object)new HttpResponseWrapper(response, newResponse));
                }
            }
        }
        return isRequestValidated;
    }

    private Caller getCaller(Subject subject) {
        Set<Caller> callers = subject.getPrincipals(Caller.class);
        if (callers.isEmpty()) {
            return null;
        }
        return callers.iterator().next();
    }

    private Principal findPrincipalWrapper(Principal principal) {
        WebPrincipal webPrincipalFromSession;
        Principal sessionPrincipal;
        if (principal != null && !(principal instanceof WebPrincipal) && (sessionPrincipal = SecurityContext.getCurrent().getSessionPrincipal()) instanceof WebPrincipal && (webPrincipalFromSession = (WebPrincipal)sessionPrincipal).getCustomPrincipal() == principal) {
            return webPrincipalFromSession;
        }
        return principal;
    }

    private Subject reuseSessionSubject(Caller caller) {
        Principal returnedPrincipal = this.findPrincipalWrapper(caller.getCallerPrincipal());
        if (returnedPrincipal instanceof WebPrincipal) {
            return this.reuseWebPrincipal((WebPrincipal)returnedPrincipal);
        }
        return null;
    }

    private Subject reuseWebPrincipal(WebPrincipal webPrincipal) {
        Set<DistinguishedPrincipalCredential> distinguishedPrincipals;
        SecurityContext securityContext = webPrincipal.getSecurityContext();
        Subject securityContextSubject = securityContext != null ? securityContext.getSubject() : null;
        Principal callerPrincipal = securityContext != null ? securityContext.getCallerPrincipal() : null;
        Principal defaultPrincipal = SecurityContext.getDefaultCallerPrincipal();
        if (callerPrincipal == null || callerPrincipal.equals(defaultPrincipal) || securityContextSubject == null) {
            return null;
        }
        boolean hasObject = false;
        Set<DistinguishedPrincipalCredential> distinguishedCreds = securityContextSubject.getPublicCredentials(DistinguishedPrincipalCredential.class);
        if (distinguishedCreds.size() == 1) {
            for (DistinguishedPrincipalCredential cred : distinguishedCreds) {
                if (!cred.getPrincipal().equals(callerPrincipal)) continue;
                hasObject = true;
            }
        }
        if (!hasObject && (distinguishedPrincipals = securityContextSubject.getPrincipals(DistinguishedPrincipalCredential.class)).size() == 1) {
            for (DistinguishedPrincipalCredential cred : distinguishedPrincipals) {
                if (!cred.getPrincipal().equals(callerPrincipal)) continue;
                hasObject = true;
            }
        }
        if (!hasObject) {
            return null;
        }
        hasObject = securityContextSubject.getPrincipals().contains(callerPrincipal);
        if (!hasObject) {
            return null;
        }
        if (webPrincipal.getName() == null || !webPrincipal.getName().equals(callerPrincipal.getName())) {
            return null;
        }
        return securityContextSubject;
    }

    private Principal getGlassFishCallerPrincipal(Caller caller) {
        Principal callerPrincipal = caller.getCallerPrincipal();
        if (!(callerPrincipal instanceof CallerPrincipal)) {
            return callerPrincipal;
        }
        if (callerPrincipal.getName() == null) {
            return SecurityContext.getDefaultCallerPrincipal();
        }
        if ("certificate".equals(this.realmName)) {
            return new X500Principal(callerPrincipal.getName());
        }
        return new UserNameAndPassword(callerPrincipal.getName());
    }

    public static void copySubject(Subject target, Subject source) {
        target.getPrincipals().addAll(source.getPrincipals());
        target.getPublicCredentials().addAll(source.getPublicCredentials());
        target.getPrivateCredentials().addAll(source.getPrivateCredentials());
    }

    public static void toSubject(Subject subject, Principal principal) {
        subject.getPrincipals().add(principal);
    }

    public static void toSubject(Subject subject, Set<Principal> principals) {
        subject.getPrincipals().addAll(principals);
    }

    public static void toSubjectCredential(Subject subject, Object credential) {
        subject.getPublicCredentials().add(credential);
    }

    public static void removeFromCredentials(Subject subject, Class<?> typeToRemove) {
        Iterator<Object> credentials = subject.getPublicCredentials().iterator();
        while (credentials.hasNext()) {
            if (!typeToRemove.isInstance(credentials.next())) continue;
            credentials.remove();
        }
    }

    private boolean shouldRegister(Map map) {
        return map.containsKey(REGISTER_WITH_AUTHENTICATOR) || this.mapEntryToBoolean("jakarta.servlet.http.registerSession", map);
    }

    private boolean mapEntryToBoolean(String propName, Map map) {
        Object value;
        if (map.containsKey(propName) && (value = map.get(propName)) != null && value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return false;
    }

    private static String getDefaultSystemProviderID() {
        String p = System.getProperty(SYSTEM_HTTPSERVLET_SECURITY_PROVIDER);
        if (p != null && (p = p.trim()).length() == 0) {
            p = null;
        }
        return p;
    }

    protected void configureSecurity(WebBundleDescriptor webBundleDescriptor, boolean isSystem) {
        try {
            this.webSecurityManagerFactory.createManager(webBundleDescriptor, true, this.serverContext).getAuthorizationService().commitPolicy();
            String contextId = AuthorizationUtil.getContextID((WebBundleDescriptor)webBundleDescriptor);
            if (isSystem && contextId.equals("__admingui/__admingui")) {
                websecurityProbeProvider.policyCreationEvent(contextId);
            }
        }
        catch (Exception ce) {
            throw new RuntimeException("Policy configuration failed!", ce);
        }
    }

    private SecurityContext getSecurityContextForPrincipal(Principal principal) {
        if (principal == null) {
            return null;
        }
        if (principal instanceof WebPrincipal) {
            WebPrincipal webPrincipal = (WebPrincipal)principal;
            return webPrincipal.getSecurityContext();
        }
        Subject subject = new Subject();
        subject.getPrincipals().add(principal);
        return new SecurityContext(principal.getName(), subject);
    }

    public void setCurrentSecurityContextWithWebPrincipal(Principal principal) {
        if (principal instanceof WebPrincipal) {
            SecurityContext.setCurrent((SecurityContext)this.getSecurityContextForPrincipal(principal));
        }
    }

    public void setCurrentSecurityContext(Principal principal) {
        SecurityContext.setCurrent((SecurityContext)this.getSecurityContextForPrincipal(principal));
    }

    public synchronized void initAuthenticationService(ServletContext servletContext) {
        if (this.authenticationService != null) {
            return;
        }
        try {
            this.authenticationService = this.createAuthenticationService(servletContext);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public BaseAuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public void postConstruct() {
        this.networkListeners = this.networkConfig.getNetworkListeners();
    }

    private String findRealmName(String initialRealmName) {
        String candidateRealmName = this.webBundleDescriptor.getApplication().getRealm();
        LoginConfiguration loginConfig = this.webBundleDescriptor.getLoginConfiguration();
        if (candidateRealmName == null && loginConfig != null) {
            candidateRealmName = loginConfig.getRealmName();
        }
        if (initialRealmName != null && Utility.isEmpty((String)candidateRealmName)) {
            candidateRealmName = initialRealmName;
        }
        return candidateRealmName;
    }

    private void collectRunAsPrincipals() {
        this.runAsPrincipals = new HashMap();
        for (WebComponentDescriptor componentDescriptor : this.webBundleDescriptor.getWebComponentDescriptors()) {
            RunAsIdentityDescriptor runAsDescriptor = componentDescriptor.getRunAsIdentity();
            if (runAsDescriptor == null) continue;
            String principal = runAsDescriptor.getPrincipal();
            String servlet = componentDescriptor.getCanonicalName();
            if (Utility.isAnyNull((Object[])new Object[]{principal, servlet})) {
                LOG.warning("WEB8080: Null run-as principal or servlet, ignoring run-as element.");
                continue;
            }
            this.runAsPrincipals.put(servlet, principal);
            LOG.log(Level.FINE, "Servlet {0} will run-as: {1}", new Object[]{servlet, principal});
        }
    }

    private SecurityConstraint[] findSecurityConstraints(Context context) {
        WebSecurityManager manager;
        if (this.authenticationService == null) {
            this.initAuthenticationService(context.getServletContext());
        }
        if ((manager = this.getWebSecurityManager(false)) != null && manager.getAuthorizationService().hasNoConstrainedResources() && !this.isSecurityExtensionEnabled(context.getServletContext())) {
            return null;
        }
        return emptyConstraints;
    }

    private boolean isRequestAuthenticated(HttpRequest httpRequest) {
        return ((HttpServletRequest)httpRequest).getUserPrincipal() != null;
    }

    private boolean isJakartaAuthenticationEnabled() throws IOException {
        try {
            return this.authenticationService != null && this.authenticationService.getServerAuthConfig() != null;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    private Subject generateX500Subject(X509Certificate[] x509Certificates) {
        Subject x500Subject = new Subject();
        x500Subject.getPublicCredentials().add(x509Certificates[0].getSubjectX500Principal());
        x500Subject.getPublicCredentials().add(Arrays.asList(x509Certificates));
        return x500Subject;
    }

    private DigestCredentials generateDigestCredentials(HttpServletRequest httpServletRequest) {
        try {
            DigestAlgorithmParameter[] digestParameters = this.generateDigestParameters(httpServletRequest);
            this.validateDigestParameters(digestParameters);
            Key key = this.findDigestKey(digestParameters);
            return new DigestCredentials(this.realmName, key.getUsername(), digestParameters);
        }
        catch (Exception le) {
            LOG.log(Level.WARNING, "WEB9102: Web Login Failed", le);
            return null;
        }
    }

    private DigestAlgorithmParameter[] generateDigestParameters(HttpServletRequest httpServletRequest) throws InvalidAlgorithmParameterException {
        return DigestParameterGenerator.getInstance((String)"HttpDigest").generateParameters((AlgorithmParameterSpec)new HttpAlgorithmParameterImpl(httpServletRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateDigestParameters(DigestAlgorithmParameter[] digestParameters) {
        NonceInfo nonceInfo;
        if (this.cnonces == null) {
            String appName = this.webBundleDescriptor.getApplication().getAppName();
            RealmAdapter realmAdapter = this;
            synchronized (realmAdapter) {
                if (this.haCNonceCacheMap == null) {
                    this.haCNonceCacheMap = (AppCNonceCacheMap)this.appCNonceCacheMapProvider.get();
                }
                if (this.haCNonceCacheMap != null) {
                    this.cnonces = (CNonceCache)this.haCNonceCacheMap.get((Object)appName);
                }
                if (this.cnonces == null) {
                    if (this.cNonceCacheFactory == null) {
                        this.cNonceCacheFactory = (CNonceCacheFactory)this.cNonceCacheFactoryProvider.get();
                    }
                    this.cnonces = this.cNonceCacheFactory.createCNonceCache(this.webBundleDescriptor.getApplication().getAppName(), null, null, null);
                }
            }
        }
        String cnonce = null;
        String nc = null;
        for (DigestAlgorithmParameter digestParameter : digestParameters) {
            if (digestParameter instanceof NestedDigestAlgoParamImpl) {
                DigestAlgorithmParameter[] nestedParameters;
                NestedDigestAlgoParamImpl np = (NestedDigestAlgoParamImpl)digestParameter;
                for (DigestAlgorithmParameter nestedParameter : nestedParameters = (DigestAlgorithmParameter[])np.getNestedParams()) {
                    if ("cnonce".equals(nestedParameter.getName())) {
                        cnonce = new String(nestedParameter.getValue());
                    } else if ("nc".equals(nestedParameter.getName())) {
                        nc = new String(nestedParameter.getValue());
                    }
                    if (cnonce != null && nc != null) break;
                }
                if (cnonce != null && nc != null) break;
            }
            if ("cnonce".equals(digestParameter.getName())) {
                cnonce = new String(digestParameter.getValue());
                continue;
            }
            if (!"nc".equals(digestParameter.getName())) continue;
            nc = new String(digestParameter.getValue());
        }
        long currentTime = System.currentTimeMillis();
        long count = this.getCount(nc);
        CNonceCache cNonceCache = this.cnonces;
        synchronized (cNonceCache) {
            nonceInfo = (NonceInfo)this.cnonces.get(cnonce);
        }
        if (nonceInfo == null) {
            nonceInfo = new NonceInfo();
        } else if (count <= nonceInfo.getCount()) {
            throw new RuntimeException("Invalid Request : Possible Replay Attack detected ?");
        }
        nonceInfo.setCount(count);
        nonceInfo.setTimestamp(currentTime);
        cNonceCache = this.cnonces;
        synchronized (cNonceCache) {
            this.cnonces.put((Object)cnonce, (Object)nonceInfo);
        }
    }

    private long getCount(String nc) {
        try {
            return Long.parseLong(nc, 16);
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException(nfe);
        }
    }

    private Key findDigestKey(DigestAlgorithmParameter[] digestParameters) {
        for (DigestAlgorithmParameter digestParameter : digestParameters) {
            if (!"A1".equals(digestParameter.getName()) || !(digestParameter instanceof Key)) continue;
            return (Key)digestParameter;
        }
        throw new RuntimeException("No key found in parameters");
    }

    private static class HttpMessageInfo
    implements MessageInfo {
        private Object request = null;
        private Object response = null;
        private final Map map = new HashMap();

        HttpMessageInfo() {
        }

        HttpMessageInfo(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
        }

        public Object getRequestMessage() {
            return this.request;
        }

        public Object getResponseMessage() {
            return this.response;
        }

        public void setRequestMessage(Object request) {
            this.request = request;
        }

        public void setResponseMessage(Object response) {
            this.response = response;
        }

        public Map getMap() {
            return this.map;
        }
    }

    static class AuthenticatorProxy
    extends AuthenticatorBase {
        private final AuthenticatorBase authBase;
        private final Principal principal;
        private final String authType;

        public boolean getCache() {
            return this.authBase.getCache();
        }

        public Container getContainer() {
            return this.authBase.getContainer();
        }

        AuthenticatorProxy(Authenticator authenticator, Principal p, String authType) throws LifecycleException {
            this.authBase = (AuthenticatorBase)authenticator;
            this.principal = p;
            this.authType = authType == null ? RealmAdapter.PROXY_AUTH_TYPE : authType;
            this.setCache(this.authBase.getCache());
            this.setContainer(this.authBase.getContainer());
            this.start();
        }

        public boolean authenticate(HttpRequest request, HttpResponse response, LoginConfig config) throws IOException {
            if (this.cache) {
                this.getSession(request, true);
            }
            this.register(request, response, this.principal, this.authType, this.principal.getName(), null);
            return true;
        }

        public String getAuthMethod() {
            return this.authType;
        }
    }
}

