/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events.configurator;

import jakarta.annotation.Priority;
import jakarta.enterprise.event.ObserverException;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.event.ObservesAsync;
import jakarta.enterprise.event.Reception;
import jakarta.enterprise.event.TransactionPhase;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.EventContext;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ObserverMethod;
import jakarta.enterprise.inject.spi.configurator.ObserverMethodConfigurator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.weld.bootstrap.events.configurator.Configurator;
import org.jboss.weld.bootstrap.events.configurator.Configurators;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.event.SyntheticObserverMethod;
import org.jboss.weld.logging.EventLogger;
import org.jboss.weld.resolution.CovariantTypes;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.reflection.Formats;

public class ObserverMethodConfiguratorImpl<T>
implements ObserverMethodConfigurator<T>,
Configurator<ObserverMethod<T>> {
    private Class<?> beanClass;
    private Type observedType;
    private final Set<Annotation> observedQualifiers;
    private Reception reception = Reception.ALWAYS;
    private TransactionPhase txPhase = TransactionPhase.IN_PROGRESS;
    private int priority = 2500;
    private boolean isAsync;
    private ObserverMethodConfigurator.EventConsumer<T> notifyCallback;
    private final Extension extension;

    public ObserverMethodConfiguratorImpl(Extension extension) {
        this.observedQualifiers = new HashSet<Annotation>();
        this.extension = extension;
        this.beanClass = extension.getClass();
    }

    public ObserverMethodConfiguratorImpl(ObserverMethod<T> observerMethod, Extension extension) {
        this(extension);
        this.read(observerMethod);
        if (observerMethod instanceof ObserverMethodImpl) {
            this.notifyWith(e -> ((ObserverMethodImpl)observerMethod).notify(e.getEvent(), this.reception));
        } else {
            this.notifyWith(e -> observerMethod.notify(e));
        }
    }

    public ObserverMethodConfigurator<T> read(Method method) {
        Preconditions.checkArgumentNotNull(method);
        Set<Parameter> eventParameters = Configurators.getAnnotatedParameters(method, Observes.class, ObservesAsync.class);
        this.checkEventParams(eventParameters, method);
        Parameter eventParameter = eventParameters.iterator().next();
        Observes observesAnnotation = eventParameter.getAnnotation(Observes.class);
        if (observesAnnotation != null) {
            this.reception(observesAnnotation.notifyObserver());
            this.transactionPhase(observesAnnotation.during());
        } else {
            this.reception(eventParameter.getAnnotation(ObservesAsync.class).notifyObserver());
        }
        Priority priority = method.getAnnotation(Priority.class);
        if (priority != null) {
            this.priority(priority.value());
        }
        this.beanClass(eventParameter.getDeclaringExecutable().getDeclaringClass());
        this.observedType(eventParameter.getType());
        this.qualifiers(Configurators.getQualifiers(eventParameter));
        return this;
    }

    public ObserverMethodConfigurator<T> read(AnnotatedMethod<?> method) {
        Preconditions.checkArgumentNotNull(method);
        Set eventParameters = method.getParameters().stream().filter(p -> p.isAnnotationPresent(Observes.class) || p.isAnnotationPresent(ObservesAsync.class)).collect(Collectors.toSet());
        this.checkEventParams(eventParameters, method.getJavaMember());
        AnnotatedParameter eventParameter = (AnnotatedParameter)eventParameters.iterator().next();
        Observes observesAnnotation = (Observes)eventParameter.getAnnotation(Observes.class);
        if (observesAnnotation != null) {
            this.reception(observesAnnotation.notifyObserver());
            this.transactionPhase(observesAnnotation.during());
            this.async(false);
        } else {
            this.reception(((ObservesAsync)eventParameter.getAnnotation(ObservesAsync.class)).notifyObserver());
            this.async(true);
        }
        Priority priority = (Priority)method.getAnnotation(Priority.class);
        if (priority != null) {
            this.priority(priority.value());
        }
        this.beanClass(eventParameter.getDeclaringCallable().getDeclaringType().getJavaClass());
        this.observedType(eventParameter.getBaseType());
        this.qualifiers(Configurators.getQualifiers((Annotated)eventParameter));
        return this;
    }

    public ObserverMethodConfigurator<T> read(ObserverMethod<T> observerMethod) {
        Preconditions.checkArgumentNotNull(observerMethod);
        this.beanClass(observerMethod.getBeanClass());
        this.observedType(observerMethod.getObservedType());
        this.qualifiers(observerMethod.getObservedQualifiers());
        this.reception(observerMethod.getReception());
        this.transactionPhase(observerMethod.getTransactionPhase());
        this.priority(observerMethod.getPriority());
        this.async(observerMethod.isAsync());
        return this;
    }

    public ObserverMethodConfigurator<T> beanClass(Class<?> beanClass) {
        this.beanClass = beanClass;
        return this;
    }

    public ObserverMethodConfigurator<T> observedType(Type type) {
        Preconditions.checkArgumentNotNull(type);
        if (this.observedType != null && !CovariantTypes.isAssignableFrom(this.observedType, type)) {
            EventLogger.LOG.originalObservedTypeIsNotAssignableFrom(this.observedType, type, this.extension);
        }
        this.observedType = type;
        return this;
    }

    public ObserverMethodConfigurator<T> addQualifier(Annotation qualifier) {
        Preconditions.checkArgumentNotNull(qualifier);
        this.observedQualifiers.add(qualifier);
        return this;
    }

    public ObserverMethodConfigurator<T> addQualifiers(Annotation ... qualifiers) {
        Preconditions.checkArgumentNotNull(qualifiers);
        Collections.addAll(this.observedQualifiers, qualifiers);
        return this;
    }

    public ObserverMethodConfigurator<T> addQualifiers(Set<Annotation> qualifiers) {
        Preconditions.checkArgumentNotNull(qualifiers);
        this.observedQualifiers.addAll(qualifiers);
        return this;
    }

    public ObserverMethodConfigurator<T> qualifiers(Annotation ... qualifiers) {
        this.observedQualifiers.clear();
        this.addQualifiers(qualifiers);
        return this;
    }

    public ObserverMethodConfigurator<T> qualifiers(Set<Annotation> qualifiers) {
        this.observedQualifiers.clear();
        this.addQualifiers(qualifiers);
        return this;
    }

    public ObserverMethodConfigurator<T> reception(Reception reception) {
        Preconditions.checkArgumentNotNull(reception);
        this.reception = reception;
        return this;
    }

    public ObserverMethodConfigurator<T> transactionPhase(TransactionPhase transactionPhase) {
        Preconditions.checkArgumentNotNull(transactionPhase);
        this.txPhase = transactionPhase;
        return this;
    }

    public ObserverMethodConfigurator<T> priority(int priority) {
        this.priority = priority;
        return this;
    }

    public ObserverMethodConfigurator<T> notifyWith(ObserverMethodConfigurator.EventConsumer<T> callback) {
        Preconditions.checkArgumentNotNull(callback);
        this.notifyCallback = callback;
        return this;
    }

    public ObserverMethodConfigurator<T> async(boolean async) {
        this.isAsync = async;
        return this;
    }

    @Override
    public ObserverMethod<T> complete() {
        return new ImmutableObserverMethod(this);
    }

    private <P> void checkEventParams(Set<P> eventParams, Method method) {
        if (eventParams.size() != 1) {
            EventLogger.LOG.noneOrMultipleEventParametersDeclared(method, Formats.formatAsStackTraceElement(method));
        }
    }

    static class ImmutableObserverMethod<T>
    implements SyntheticObserverMethod<T> {
        private final Class<?> beanClass;
        private final Type observedType;
        private final Set<Annotation> observedQualifiers;
        private final Reception reception;
        private final TransactionPhase txPhase;
        private final int priority;
        private final boolean isAsync;
        private final ObserverMethodConfigurator.EventConsumer<T> notifyCallback;

        ImmutableObserverMethod(ObserverMethodConfiguratorImpl<T> configurator) {
            if (configurator.notifyCallback == null) {
                throw EventLogger.LOG.notifyMethodNotImplemented(configurator);
            }
            this.beanClass = configurator.beanClass;
            this.observedType = configurator.observedType;
            this.observedQualifiers = ImmutableSet.copyOf(configurator.observedQualifiers);
            this.reception = configurator.reception;
            this.txPhase = configurator.txPhase;
            this.priority = configurator.priority;
            this.isAsync = configurator.isAsync;
            this.notifyCallback = configurator.notifyCallback;
        }

        public int getPriority() {
            return this.priority;
        }

        public Class<?> getBeanClass() {
            return this.beanClass;
        }

        public Type getObservedType() {
            return this.observedType;
        }

        public Set<Annotation> getObservedQualifiers() {
            return this.observedQualifiers;
        }

        public Reception getReception() {
            return this.reception;
        }

        public TransactionPhase getTransactionPhase() {
            return this.txPhase;
        }

        public void notify(EventContext<T> eventContext) {
            try {
                this.notifyCallback.accept(eventContext);
            }
            catch (Exception e) {
                throw new ObserverException((Throwable)e);
            }
        }

        public boolean isAsync() {
            return this.isAsync;
        }

        @Override
        public boolean isEventMetadataRequired() {
            return true;
        }

        public String toString() {
            return "Configurator observer method [Bean class = " + String.valueOf(this.getBeanClass()) + ", type = " + String.valueOf(this.getObservedType()) + ", qualifiers =" + Formats.formatAnnotations(this.getObservedQualifiers()) + ", priority =" + this.getPriority() + ", async =" + this.isAsync() + ", reception =" + String.valueOf(this.getReception()) + ", transaction phase =" + String.valueOf(this.getTransactionPhase()) + "]";
        }
    }
}

