/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.readers;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.StringTokenizer;
import org.glassfish.api.admin.ParameterMap;

@Consumes(value={"application/x-www-form-urlencoded", "application/octet-stream"})
@Provider
public class ParameterMapFormReader
implements MessageBodyReader<ParameterMap> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.equals(ParameterMap.class);
    }

    public ParameterMap readFrom(Class<ParameterMap> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream in) throws IOException {
        String formData = new String(in.readAllBytes(), StandardCharsets.UTF_8);
        ParameterMap map = new ParameterMap();
        StringTokenizer tokenizer = new StringTokenizer(formData, "&");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int idx = token.indexOf(61);
            if (idx < 0) {
                map.add((Object)URLDecoder.decode(token, StandardCharsets.UTF_8), null);
                continue;
            }
            if (idx <= 0) continue;
            map.add((Object)URLDecoder.decode(token.substring(0, idx), StandardCharsets.UTF_8), (Object)URLDecoder.decode(token.substring(idx + 1), StandardCharsets.UTF_8));
        }
        return map;
    }
}

