/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jnosql.hk2types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;
import org.glassfish.hk2.classmodel.reflect.ExtensibleType;
import org.glassfish.hk2.classmodel.reflect.InterfaceModel;
import org.glassfish.hk2.classmodel.reflect.ParameterizedInterfaceModel;

public record GeneralInterfaceModel(InterfaceModel plainInterface, ParameterizedInterfaceModel parameterizedInterface, Collection<ParameterizedInterfaceModel> parameterizedTypes) {
    public GeneralInterfaceModel(InterfaceModel plainInterface) {
        this(plainInterface, null, null);
    }

    public GeneralInterfaceModel(ParameterizedInterfaceModel parameterizedInterfaceModel) {
        this(null, parameterizedInterfaceModel, null);
    }

    public GeneralInterfaceModel(ParameterizedInterfaceModel parameterizedInterfaceModel, Collection<ParameterizedInterfaceModel> parameterizedTypes) {
        this(null, parameterizedInterfaceModel, parameterizedTypes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.plainInterfaceName(), this.parameterizedInterfaceFullName(), this.parameterizedTypes);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeneralInterfaceModel other = (GeneralInterfaceModel)obj;
        if (!Objects.equals(this.plainInterfaceName(), other.plainInterfaceName())) {
            return false;
        }
        if (!Objects.equals(this.parameterizedInterfaceFullName(), other.parameterizedInterfaceFullName())) {
            return false;
        }
        return Objects.equals(this.parameterizedTypes, other.parameterizedTypes);
    }

    private Object plainInterfaceName() {
        return this.plainInterface != null ? this.plainInterface.getName() : null;
    }

    private Object parameterizedInterfaceFullName() {
        return this.parameterizedInterface != null ? this.parameterizedInterface.getName() : null;
    }

    public boolean isParameterized() {
        return this.parameterizedInterface != null;
    }

    public boolean hasTypeParametersWithUnknownType() {
        if (this.isParameterized()) {
            return this.parametizedTypes().isEmpty();
        }
        Map formalTypeParameters = this.plainInterface.getFormalTypeParameters();
        return formalTypeParameters != null && !formalTypeParameters.isEmpty();
    }

    public String interfaceName() {
        if (this.isParameterized()) {
            return this.parameterizedInterface.getRawInterfaceName();
        }
        return this.plainInterface.getName();
    }

    public AnnotationModel getAnnotation(Class<?> annotationClass) {
        if (this.isParameterized()) {
            return this.parameterizedInterface.getRawInterface().getAnnotation(annotationClass.getName());
        }
        return this.plainInterface.getAnnotation(annotationClass.getName());
    }

    public ExtensibleType toTypeModel() {
        return this.isParameterized() ? this.parameterizedInterface.getRawInterface() : this.plainInterface;
    }

    public Stream<GeneralInterfaceModel> interfacesAsStream() {
        ExtensibleType typeModel = this.toTypeModel();
        Collection parameterizedInterfaces = typeModel.getParameterizedInterfaces();
        Collection plainInterfaces = typeModel.getInterfaces();
        return Stream.concat(parameterizedInterfaces.stream().map(parameterizedInterface -> GeneralInterfaceModel.parameterizedFromSubInterface(parameterizedInterface, this)), plainInterfaces.stream().map(GeneralInterfaceModel::new));
    }

    public Collection<ParameterizedInterfaceModel> parametizedTypes() {
        return this.parameterizedTypes != null ? this.parameterizedTypes : this.parameterizedInterface.getParametizedTypes();
    }

    static GeneralInterfaceModel parameterizedFromSubInterface(ParameterizedInterfaceModel parameterizedInterface, GeneralInterfaceModel subInterface) {
        if (!subInterface.isParameterized()) {
            return new GeneralInterfaceModel(parameterizedInterface);
        }
        ArrayList<ParameterizedInterfaceModel> parameterizedTypes = new ArrayList<ParameterizedInterfaceModel>();
        Map formalTypeParametersOnSubInterface = subInterface.toTypeModel().getFormalTypeParameters();
        Iterator<ParameterizedInterfaceModel> iteratorThroughParameterizedTypesOnSubInterface = subInterface.parametizedTypes().iterator();
        for (Map.Entry formalTypeParameterOnSubInterface : formalTypeParametersOnSubInterface.entrySet()) {
            if (!iteratorThroughParameterizedTypesOnSubInterface.hasNext()) {
                throw new IllegalStateException("The number of parameterized types and formal type parameters is not the same, interface: " + String.valueOf(parameterizedInterface));
            }
            ParameterizedInterfaceModel parameterizedTypeOnSubInterface = iteratorThroughParameterizedTypesOnSubInterface.next();
            Map formalTypeParametersOnInterface = parameterizedInterface.getRawInterface().getFormalTypeParameters();
            if (!formalTypeParametersOnInterface.containsKey(formalTypeParameterOnSubInterface.getKey())) continue;
            parameterizedTypes.add(parameterizedTypeOnSubInterface);
        }
        return new GeneralInterfaceModel(parameterizedInterface, parameterizedTypes);
    }
}

