/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.core.helper.CoreConversionManager;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.ConversionManager;
import org.eclipse.persistence.internal.oxm.UnmarshalXPathEngine;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathPredicate;
import org.eclipse.persistence.internal.oxm.documentpreservation.NoDocumentPreservationPolicy;
import org.eclipse.persistence.internal.oxm.documentpreservation.XMLBinderPolicy;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.mappings.UnionField;
import org.eclipse.persistence.internal.oxm.record.XMLRecord;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.documentpreservation.DocumentPreservationPolicy;
import org.eclipse.persistence.oxm.exceptions.XMLMarshalException;
import org.eclipse.persistence.oxm.record.XMLEntry;
import org.eclipse.persistence.platform.xml.XMLNamespaceResolver;
import org.eclipse.persistence.platform.xml.XMLNodeList;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XPathEngine<XML_FIELD extends Field> {
    private static XPathEngine instance = null;
    private UnmarshalXPathEngine unmarshalXPathEngine;
    private DocumentPreservationPolicy noDocPresPolicy = new NoDocumentPreservationPolicy();
    private DocumentPreservationPolicy xmlBinderPolicy = new XMLBinderPolicy();

    public static XPathEngine getInstance() {
        if (instance == null) {
            instance = new XPathEngine();
        }
        return instance;
    }

    private XPathEngine() {
        this.unmarshalXPathEngine = new UnmarshalXPathEngine();
    }

    public Node create(Field xmlField, Node element, CoreAbstractSession session) throws XMLMarshalException {
        return this.create(xmlField, element, this, session);
    }

    public Node create(Field xmlField, Node element, Object value, CoreAbstractSession session) {
        return this.create(xmlField, element, value, null, this.noDocPresPolicy, session);
    }

    public Node create(Field xmlField, Node element, Object value, Field lastUpdated, DocumentPreservationPolicy docPresPolicy, CoreAbstractSession session) throws XMLMarshalException {
        XPathFragment fragment;
        if (null == value) {
            return null;
        }
        if (docPresPolicy == null) {
            docPresPolicy = this.noDocPresPolicy;
        }
        if ((fragment = xmlField.getXPathFragment()).getNextFragment() == null && fragment.nameIsText()) {
            Object textValue = this.getValueToWrite(value, xmlField, session);
            if (textValue instanceof String) {
                if (xmlField.isTypedTextField()) {
                    XMLNodeList createdElements = new XMLNodeList();
                    createdElements.add(element);
                    this.addTypeAttributes(createdElements, xmlField, value, this.resolveNamespacePrefixForURI("http://www.w3.org/2001/XMLSchema-instance", this.getNamespaceResolverForField(xmlField)), session);
                }
                return this.addText(xmlField, element, (String)textValue);
            }
            return null;
        }
        NodeList created = this.createCollection(xmlField, element, value, lastUpdated, docPresPolicy, session);
        if (created == null || created.getLength() == 0) {
            return null;
        }
        return created.item(0);
    }

    public void create(List<Field> xmlFields, Node contextNode, List<XMLEntry> values, Field lastUpdatedField, DocumentPreservationPolicy docPresPolicy, CoreAbstractSession session) {
        ArrayList<Object> itemsToWrite = new ArrayList<Object>();
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            XMLEntry nextEntry = values.get(i);
            itemsToWrite.add(nextEntry.getValue());
            if (i != values.size() - 1 && values.get(i + 1).getXMLField() == nextEntry.getXMLField()) continue;
            this.create(nextEntry.getXMLField(), contextNode, itemsToWrite, lastUpdatedField, docPresPolicy, session);
            itemsToWrite = new ArrayList();
            lastUpdatedField = nextEntry.getXMLField();
        }
    }

    private NodeList createCollection(Field xmlField, Node element, Object value, Field lastUpdated, DocumentPreservationPolicy docPresPolicy, CoreAbstractSession session) throws XMLMarshalException {
        NodeList nodes;
        XMLNodeList createdElements = new XMLNodeList();
        if (value == null || value instanceof Collection && ((Collection)value).isEmpty()) {
            return createdElements;
        }
        Node nextElement = element;
        Element sibling = null;
        XPathFragment siblingFragment = null;
        if (lastUpdated != null) {
            siblingFragment = lastUpdated.getXPathFragment();
        }
        if (lastUpdated != null && !siblingFragment.isAttribute() && !siblingFragment.nameIsText() && (nodes = this.unmarshalXPathEngine.selectElementNodes(element, siblingFragment, this.getNamespaceResolverForField(lastUpdated))).getLength() > 0) {
            sibling = (Element)nodes.item(nodes.getLength() - 1);
        }
        XPathFragment next = xmlField.getXPathFragment();
        while (next != null) {
            NodeList nodes2;
            if (next.isAttribute()) {
                this.addAttribute(next, xmlField, nextElement, value, session);
            } else if (next.containsIndex()) {
                boolean hasMore;
                boolean bl = hasMore = !next.getHasText() && next.getNextFragment() != null;
                if (hasMore) {
                    nextElement = this.addIndexedElement(next, xmlField, nextElement, this, !hasMore, session);
                } else {
                    Object valueToWrite = this.getValueToWrite(value, xmlField, session);
                    nextElement = this.addIndexedElement(next, xmlField, nextElement, valueToWrite, !hasMore, session);
                    createdElements.add(nextElement);
                }
            } else {
                NodeList elements;
                boolean hasMore;
                boolean bl = hasMore = !next.getHasText() && next.getNextFragment() != null;
                if (hasMore) {
                    elements = this.addElements(next, xmlField, nextElement, this, !hasMore, sibling, docPresPolicy, session);
                } else {
                    XPathFragment nextFragment = next.getNextFragment();
                    if (nextFragment != null && nextFragment.isAttribute() && !(value instanceof List)) {
                        elements = this.addElements(next, xmlField, nextElement, this, hasMore, sibling, docPresPolicy, session);
                    } else {
                        Object valueToWrite = this.getValueToWrite(value, xmlField, session);
                        elements = this.addElements(next, xmlField, nextElement, valueToWrite, !hasMore, sibling, docPresPolicy, session);
                        createdElements.addAll(elements);
                    }
                }
                nextElement = elements.item(elements.getLength() - 1);
            }
            sibling = siblingFragment != null && sibling != null && siblingFragment.equals(next) ? ((siblingFragment = siblingFragment.getNextFragment()) != null && !siblingFragment.isAttribute() && !siblingFragment.nameIsText() ? ((nodes2 = this.unmarshalXPathEngine.selectElementNodes(nextElement, siblingFragment, this.getNamespaceResolverForField(lastUpdated))).getLength() > 0 ? (Element)nodes2.item(nodes2.getLength() - 1) : null) : null) : null;
            if ((next = next.getNextFragment()) == null || !next.nameIsText()) continue;
            next = null;
        }
        if (xmlField.isTypedTextField()) {
            this.addTypeAttributes(createdElements, xmlField, value, this.resolveNamespacePrefixForURI("http://www.w3.org/2001/XMLSchema-instance", this.getNamespaceResolverForField(xmlField)), session);
        }
        return createdElements;
    }

    private Object getNonNodeValueToWrite(Object value, Field xmlField, CoreAbstractSession session) {
        if (this == value) {
            return this;
        }
        QName schemaType = null;
        if (xmlField.getLeafElementType() != null) {
            schemaType = xmlField.getLeafElementType();
        } else {
            if (xmlField.isUnionField()) {
                return this.getValueToWriteForUnion((UnionField)xmlField, value, session);
            }
            if (xmlField.isTypedTextField()) {
                ConversionManager conversionManager = (ConversionManager)session.getDatasourcePlatform().getConversionManager();
                schemaType = xmlField.getXMLType(value.getClass(), conversionManager);
            } else if (xmlField.getSchemaType() != null) {
                schemaType = xmlField.getSchemaType();
            }
        }
        if (value instanceof List) {
            if (xmlField.usesSingleNode()) {
                StringBuilder returnStringBuilder = new StringBuilder();
                for (int i = 0; i < ((List)value).size(); ++i) {
                    Object nextItem = ((List)value).get(i);
                    String nextConvertedItem = null;
                    nextConvertedItem = schemaType != null && schemaType.equals(Constants.QNAME_QNAME) ? this.getStringForQName((QName)nextItem, this.getNamespaceResolverForField(xmlField)) : ((ConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(nextItem, CoreClassConstants.STRING, schemaType);
                    returnStringBuilder.append(nextConvertedItem);
                    if (i >= ((List)value).size() - 1) continue;
                    returnStringBuilder.append(' ');
                }
                return returnStringBuilder.toString();
            }
            ArrayList items = new ArrayList(((List)value).size());
            for (int index = 0; index < ((List)value).size(); ++index) {
                String nextConvertedItem;
                Object nextItem = ((List)value).get(index);
                if (nextItem instanceof Node || nextItem == XMLRecord.NIL) {
                    items.add(nextItem);
                    continue;
                }
                if (schemaType != null && schemaType.equals(Constants.QNAME_QNAME)) {
                    nextConvertedItem = this.getStringForQName((QName)nextItem, this.getNamespaceResolverForField(xmlField));
                    items.add(nextConvertedItem);
                    continue;
                }
                nextConvertedItem = ((ConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(nextItem, CoreClassConstants.STRING, schemaType);
                items.add(nextConvertedItem);
            }
            return items;
        }
        if (schemaType != null && schemaType.equals(Constants.QNAME_QNAME)) {
            return this.getStringForQName((QName)value, this.getNamespaceResolverForField(xmlField));
        }
        return ((ConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(value, CoreClassConstants.STRING, schemaType);
    }

    private Object getValueToWrite(Object value, Field xmlField, CoreAbstractSession session) {
        if (value instanceof Node || value == XMLRecord.NIL) {
            return value;
        }
        return this.getNonNodeValueToWrite(value, xmlField, session);
    }

    private String getSingleValueToWriteForUnion(UnionField xmlField, Object value, CoreAbstractSession session) {
        List<QName> schemaTypes = xmlField.getSchemaTypes();
        QName schemaType = null;
        for (int i = 0; i < schemaTypes.size(); ++i) {
            QName nextQName = xmlField.getSchemaTypes().get(i);
            try {
                if (nextQName == null) continue;
                ConversionManager conversionManager = (ConversionManager)session.getDatasourcePlatform().getConversionManager();
                Class<?> javaClass = xmlField.getJavaClass(nextQName, conversionManager);
                value = conversionManager.convertObject(value, javaClass, nextQName);
                schemaType = nextQName;
                break;
            }
            catch (ConversionException ce) {
                if (i != schemaTypes.size() - 1) continue;
                schemaType = nextQName;
            }
        }
        return ((ConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(value, CoreClassConstants.STRING, schemaType);
    }

    private Object getValueToWriteForUnion(UnionField xmlField, Object value, CoreAbstractSession session) {
        if (value instanceof List) {
            if (xmlField.usesSingleNode()) {
                StringBuilder returnStringBuilder = new StringBuilder();
                Object next = null;
                for (int i = 0; i < ((List)value).size(); ++i) {
                    next = ((List)value).get(i);
                    returnStringBuilder.append(this.getSingleValueToWriteForUnion(xmlField, next, session));
                    if (i >= ((List)value).size() - 1) continue;
                    returnStringBuilder.append(' ');
                }
                return returnStringBuilder.toString();
            }
            ArrayList<String> items = new ArrayList<String>(((List)value).size());
            Object next = null;
            for (int i = 0; i < ((List)value).size(); ++i) {
                next = ((List)value).get(i);
                items.add(this.getSingleValueToWriteForUnion(xmlField, next, session));
            }
            return items;
        }
        return this.getSingleValueToWriteForUnion(xmlField, value, session);
    }

    private Node addIndexedElement(XPathFragment fragment, Field xmlField, Node parent, Object value, boolean forceCreate, CoreAbstractSession session) throws XMLMarshalException {
        Node existingElement;
        String element = fragment.getShortName();
        int index = fragment.getIndexValue();
        if (index < 0) {
            throw XMLMarshalException.invalidXPathIndexString(fragment.getXPath());
        }
        NamespaceResolver namespaceResolver = this.getNamespaceResolverForField(xmlField);
        for (int i = 1; i < index; ++i) {
            XMLField field = new XMLField(element + "[" + i + "]");
            field.setNamespaceResolver(namespaceResolver);
            existingElement = (Node)this.unmarshalXPathEngine.selectSingleNode(parent, field, namespaceResolver);
            if (existingElement != null) continue;
            this.addElement(new XPathFragment(element), xmlField, parent, this, true, session);
        }
        XMLField field = new XMLField(fragment.getXPath());
        field.setNamespaceResolver(namespaceResolver);
        existingElement = (Node)this.unmarshalXPathEngine.selectSingleNode(parent, field, namespaceResolver);
        if (existingElement == null) {
            return this.addElement(new XPathFragment(element), field, parent, value, true, session);
        }
        if (!forceCreate) {
            return existingElement;
        }
        String namespace = this.resolveNamespacePrefix(fragment, namespaceResolver);
        Element elementToReturn = parent.getOwnerDocument().createElementNS(namespace, element);
        if (value != this && value != null && value instanceof String) {
            this.addText(xmlField, elementToReturn, (String)value);
        }
        parent.replaceChild(elementToReturn, existingElement);
        return elementToReturn;
    }

    private Node addElement(XPathFragment fragment, Field xmlField, Node parent, Object value, boolean forceCreate, CoreAbstractSession session) {
        return this.addElement(fragment, xmlField, parent, null, value, forceCreate, session);
    }

    private Node addElement(XPathFragment fragment, Field xmlField, Node parent, QName schemaType, Object value, boolean forceCreate, CoreAbstractSession session) {
        NodeList list = this.addElements(fragment, xmlField, parent, value, forceCreate, null, this.noDocPresPolicy, session);
        if (list.getLength() > 0) {
            return list.item(0);
        }
        return null;
    }

    private NodeList addElements(XPathFragment fragment, Field xmlField, Node parent, Object value, boolean forceCreate, Element sibling, DocumentPreservationPolicy docPresPolicy, CoreAbstractSession session) {
        NodeList nodes;
        if (!forceCreate && (nodes = this.unmarshalXPathEngine.selectElementNodes(parent, fragment, this.getNamespaceResolverForField(xmlField))).getLength() > 0) {
            return nodes;
        }
        XMLNodeList elementsToReturn = new XMLNodeList();
        if (value == this) {
            XPathFragment predicateFragment;
            String namespace = this.resolveNamespacePrefix(fragment, this.getNamespaceResolverForField(xmlField));
            Element newElement = parent.getOwnerDocument().createElementNS(namespace, fragment.getShortName());
            XPathPredicate predicate = fragment.getPredicate();
            if (predicate != null && (predicateFragment = predicate.getXPathFragment()).isAttribute()) {
                if (predicateFragment.getNamespaceURI() == null || predicateFragment.getNamespaceURI().isEmpty()) {
                    newElement.setAttribute(predicateFragment.getLocalName(), fragment.getPredicate().getValue());
                } else {
                    Object name = predicateFragment.getLocalName();
                    if (predicateFragment.getPrefix() != null && !predicateFragment.getPrefix().isEmpty()) {
                        name = predicateFragment.getPrefix() + ":" + (String)name;
                    }
                    newElement.setAttributeNS(predicateFragment.getNamespaceURI(), (String)name, fragment.getPredicate().getValue());
                }
            }
            elementsToReturn.add(newElement);
            docPresPolicy.getNodeOrderingPolicy().appendNode(parent, newElement, sibling);
        } else if (value == null) {
            elementsToReturn.add(parent);
        } else if (value instanceof List) {
            List values = (List)value;
            for (int index = 0; index < values.size(); ++index) {
                XPathFragment predicateFragment;
                Element newElement = null;
                if (values.get(index) != XMLRecord.NIL) {
                    newElement = (Element)this.createElement(parent, fragment, xmlField, values.get(index), session);
                } else {
                    newElement = (Element)this.createElement(parent, fragment, xmlField, "", session);
                    this.addXsiNilToElement(newElement, xmlField);
                }
                XPathPredicate predicate = fragment.getPredicate();
                if (predicate != null && (predicateFragment = predicate.getXPathFragment()).isAttribute()) {
                    if (predicateFragment.getNamespaceURI() == null || predicateFragment.getNamespaceURI().isEmpty()) {
                        newElement.setAttribute(predicateFragment.getLocalName(), fragment.getPredicate().getValue());
                    } else {
                        Object name = predicateFragment.getLocalName();
                        if (predicateFragment.getPrefix() != null && !predicateFragment.getPrefix().isEmpty()) {
                            name = predicateFragment.getPrefix() + ":" + (String)name;
                        }
                        newElement.setAttributeNS(predicateFragment.getNamespaceURI(), (String)name, fragment.getPredicate().getValue());
                    }
                }
                docPresPolicy.getNodeOrderingPolicy().appendNode(parent, newElement, sibling);
                elementsToReturn.add(newElement);
                sibling = newElement;
            }
        } else {
            XPathFragment predicateFragment;
            Element newElement = null;
            if (value != XMLRecord.NIL) {
                newElement = (Element)this.createElement(parent, fragment, xmlField, value, session);
            } else {
                newElement = (Element)this.createElement(parent, fragment, xmlField, "", session);
                this.addXsiNilToElement(newElement, xmlField);
            }
            XPathPredicate predicate = fragment.getPredicate();
            if (predicate != null && (predicateFragment = predicate.getXPathFragment()).isAttribute()) {
                if (predicateFragment.getNamespaceURI() == null || predicateFragment.getNamespaceURI().isEmpty()) {
                    newElement.setAttribute(predicateFragment.getLocalName(), fragment.getPredicate().getValue());
                } else {
                    Object name = predicateFragment.getLocalName();
                    if (predicateFragment.getPrefix() != null && !predicateFragment.getPrefix().isEmpty()) {
                        name = predicateFragment.getPrefix() + ":" + (String)name;
                    }
                    newElement.setAttributeNS(predicateFragment.getNamespaceURI(), (String)name, fragment.getPredicate().getValue());
                }
            }
            docPresPolicy.getNodeOrderingPolicy().appendNode(parent, newElement, sibling);
            elementsToReturn.add(newElement);
        }
        return elementsToReturn;
    }

    private Node createElement(Node parent, XPathFragment fragment, Field xmlField, Object value, CoreAbstractSession session) {
        if (value == null) {
            return parent;
        }
        if (value instanceof Node) {
            return this.createElement(parent, fragment, this.getNamespaceResolverForField(xmlField), (Node)value);
        }
        Element element = null;
        if (parent.getOwnerDocument() == null) {
            element = ((Document)parent).getDocumentElement();
        } else {
            XPathFragment predicateFragment;
            XPathPredicate predicate;
            String namespace = this.resolveNamespacePrefix(fragment, this.getNamespaceResolverForField(xmlField));
            NamespaceResolver domResolver = new NamespaceResolver();
            domResolver.setDOM(parent);
            String existingPrefix = domResolver.resolveNamespaceURI(namespace);
            Object elementName = fragment.getShortName();
            if (existingPrefix != null) {
                elementName = !existingPrefix.isEmpty() ? existingPrefix + ":" + fragment.getLocalName() : fragment.getLocalName();
            }
            element = parent.getOwnerDocument().createElementNS(namespace, (String)elementName);
            if (fragment.isGeneratedPrefix() && existingPrefix == null) {
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + fragment.getPrefix(), fragment.getNamespaceURI());
            }
            if ((predicate = fragment.getPredicate()) != null && (predicateFragment = predicate.getXPathFragment()).isAttribute()) {
                element.setAttributeNS(predicateFragment.getNamespaceURI(), predicateFragment.getLocalName(), fragment.getPredicate().getValue());
            }
        }
        XPathFragment nextFragment = fragment.getNextFragment();
        if (nextFragment != null && nextFragment.isAttribute()) {
            this.addAttribute(nextFragment, xmlField, element, value, session);
        } else if (value instanceof String && !((String)value).isEmpty()) {
            this.addText(xmlField, element, (String)value);
        } else if (value == XMLRecord.NIL) {
            this.addXsiNilToElement(element, xmlField);
        }
        return element;
    }

    public Element createUnownedElement(Node parent, Field xmlField) {
        XPathFragment lastFragment = xmlField.getXPathFragment();
        while (lastFragment.getNextFragment() != null) {
            lastFragment = lastFragment.getNextFragment();
        }
        String nodeName = lastFragment.getShortName();
        String namespace = this.resolveNamespacePrefix(lastFragment, this.getNamespaceResolverForField(xmlField));
        NamespaceResolver domResolver = new NamespaceResolver();
        domResolver.setDOM(parent);
        String existingPrefix = domResolver.resolveNamespaceURI(namespace);
        Object elementName = nodeName;
        if (existingPrefix != null) {
            elementName = !existingPrefix.isEmpty() ? existingPrefix + ":" + lastFragment.getLocalName() : lastFragment.getLocalName();
        }
        Element elem = parent.getOwnerDocument().createElementNS(namespace, (String)elementName);
        if (lastFragment.isGeneratedPrefix() && existingPrefix == null) {
            elem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + lastFragment.getPrefix(), lastFragment.getNamespaceURI());
        }
        return elem;
    }

    private void addTypeAttributes(NodeList elements, Field field, Object value, String schemaInstancePrefix, CoreAbstractSession session) {
        ArrayList<Object> values;
        NamespaceResolver namespaceResolver = this.getNamespaceResolverForField(field);
        if (!field.isTypedTextField()) {
            return;
        }
        if (value instanceof List) {
            values = (ArrayList<Object>)value;
        } else {
            values = new ArrayList<Object>();
            values.add(value);
        }
        int size = elements.getLength();
        int valuesSize = values.size();
        if (size != valuesSize) {
            return;
        }
        Node next = null;
        for (int i = 0; i < size; ++i) {
            String prefix;
            ConversionManager conversionManager;
            QName qname;
            Class<?> valueClass;
            next = elements.item(i);
            if (next.getNodeType() != 1 || (valueClass = values.get(i).getClass()) == CoreClassConstants.STRING || (qname = field.getXMLType(valueClass, conversionManager = (ConversionManager)session.getDatasourcePlatform().getConversionManager())) == null) continue;
            if (null == schemaInstancePrefix) {
                schemaInstancePrefix = namespaceResolver.generatePrefix("xsi");
                ((Element)next).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + schemaInstancePrefix, "http://www.w3.org/2001/XMLSchema-instance");
            }
            if ((prefix = this.resolveNamespacePrefixForURI(qname.getNamespaceURI(), namespaceResolver)) == null || prefix.isEmpty()) {
                prefix = qname.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") ? namespaceResolver.generatePrefix("xsd") : namespaceResolver.generatePrefix();
                ((Element)next).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, qname.getNamespaceURI());
            }
            String type = prefix + ":" + qname.getLocalPart();
            ((Element)next).setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", schemaInstancePrefix + ":type", type);
        }
    }

    private Node createElement(Node parent, XPathFragment fragment, NamespaceResolver namespaceResolver, Node value) {
        Document document = parent.getOwnerDocument();
        if (document == null && parent.getNodeType() == 9) {
            document = (Document)parent;
        }
        String nodeUri = value.getNamespaceURI();
        String nodeName = value.getLocalName();
        String fragUri = fragment.getNamespaceURI();
        String fragName = fragment.getLocalName();
        if (nodeName != null && nodeName.equals(fragName) && (nodeUri != null && nodeUri.equals(fragUri) || nodeUri == null && fragUri == null)) {
            if (document != value.getOwnerDocument()) {
                return document.importNode(value, true);
            }
            return value;
        }
        String namespace = this.resolveNamespacePrefix(fragment, namespaceResolver);
        Element clone = document.createElementNS(namespace, fragName);
        NamedNodeMap attributes = value.getAttributes();
        int attributesLength = attributes.getLength();
        for (int index = 0; index < attributesLength; ++index) {
            Node attribute = document.importNode(attributes.item(index), true);
            clone.setAttributeNode((Attr)attribute);
        }
        NodeList elements = value.getChildNodes();
        int elementsLength = elements.getLength();
        for (int index = 0; index < elementsLength; ++index) {
            Node attribute = document.importNode(elements.item(index), true);
            clone.appendChild(attribute);
        }
        return clone;
    }

    private Node addAttribute(XPathFragment attributeFragment, Field xmlField, Node parent, Object value, CoreAbstractSession session) {
        Object valueToWrite = null;
        if (!(parent instanceof Element)) {
            return parent;
        }
        Element parentElement = (Element)parent;
        if (value instanceof Node) {
            if (((Node)value).getNodeType() == 2) {
                Attr attr = (Attr)value;
                if (parent.getAttributes().getNamedItemNS(attr.getNamespaceURI(), attr.getLocalName()) == null) {
                    String pfx = null;
                    if (xmlField.getNamespaceResolver() != null) {
                        pfx = this.getNamespaceResolverForField(xmlField).resolveNamespaceURI(attr.getNamespaceURI());
                    }
                    if (pfx != null) {
                        parentElement.setAttributeNS(attr.getNamespaceURI(), pfx + ":" + attr.getLocalName(), attr.getNodeValue());
                    } else {
                        parentElement.setAttributeNS(attr.getNamespaceURI(), attr.getName(), attr.getNodeValue());
                    }
                }
                return parent;
            }
            valueToWrite = value;
        } else {
            valueToWrite = this.getNonNodeValueToWrite(value, xmlField, session);
        }
        String attributeName = attributeFragment.getLocalName();
        String attributeNamespace = this.resolveNamespacePrefix(attributeFragment, this.getNamespaceResolverForField(xmlField));
        if (valueToWrite != null && parent.getAttributes().getNamedItemNS(attributeNamespace, attributeName) == null) {
            if (valueToWrite == this) {
                parentElement.setAttributeNS(attributeNamespace, attributeFragment.getShortName(), "");
            } else if (valueToWrite instanceof String) {
                parentElement.setAttributeNS(attributeNamespace, attributeFragment.getShortName(), (String)valueToWrite);
            }
            if (attributeFragment.isGeneratedPrefix()) {
                parentElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + attributeFragment.getPrefix(), attributeFragment.getNamespaceURI());
            }
        }
        return parent;
    }

    public NodeList remove(Field xmlField, Node element) throws XMLMarshalException {
        return this.remove(xmlField, element, false);
    }

    public NodeList remove(Field xmlField, Node element, boolean forceRemove) throws XMLMarshalException {
        String xpathString = xmlField.getXPath();
        NodeList nodes = this.unmarshalXPathEngine.selectNodes(element, xmlField, (XMLNamespaceResolver)this.getNamespaceResolverForField(xmlField));
        int numberOfNodes = nodes.getLength();
        boolean shouldNullOutNode = this.containsIndex(xpathString) && !forceRemove;
        for (int i = 0; i < numberOfNodes; ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 2) {
                ((Attr)node).getOwnerElement().removeAttribute(node.getNodeName());
                continue;
            }
            if (shouldNullOutNode) {
                Element blankNode = node.getParentNode().getOwnerDocument().createElementNS(node.getNamespaceURI(), node.getNodeName());
                node.getParentNode().replaceChild(blankNode, node);
                continue;
            }
            node.getParentNode().removeChild(node);
        }
        return nodes;
    }

    public NodeList replaceValue(Field xmlField, Node parent, Object value, CoreAbstractSession session) throws XMLMarshalException {
        int i;
        NodeList nodes = this.unmarshalXPathEngine.selectNodes(parent, xmlField, (XMLNamespaceResolver)this.getNamespaceResolverForField(xmlField), null, false, false);
        int numberOfNodes = nodes.getLength();
        if (numberOfNodes == 0 && xmlField.getLastXPathFragment().nameIsText()) {
            nodes = this.unmarshalXPathEngine.selectNodes(parent, xmlField, this.getNamespaceResolverForField(xmlField), null, true);
            XMLNodeList textNodes = new XMLNodeList();
            for (i = 0; i < nodes.getLength(); ++i) {
                Element nextNode = (Element)nodes.item(i);
                Text text = nextNode.getOwnerDocument().createTextNode("");
                nextNode.appendChild(text);
                textNodes.add(text);
            }
            numberOfNodes = textNodes.getLength();
            nodes = textNodes;
        }
        XMLNodeList createdElements = new XMLNodeList();
        for (i = 0; i < numberOfNodes; ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) {
                Attr nil;
                if ((node.getNodeType() == 3 || node.getNodeType() == 4) && value == null) {
                    Node parentNode = node.getParentNode();
                    if (parentNode == null) continue;
                    Node grandParentNode = parentNode.getParentNode();
                    NodeList childNodes = parentNode.getChildNodes();
                    if (childNodes.getLength() == numberOfNodes) {
                        grandParentNode.removeChild(parentNode);
                        continue;
                    }
                    for (int x = 0; x < childNodes.getLength(); ++x) {
                        Node next = childNodes.item(x);
                        if (next.getNodeType() != 3 && next.getNodeType() != 4) continue;
                        parentNode.removeChild(next);
                    }
                    continue;
                }
                if (value == null) {
                    ((Attr)node).getOwnerElement().removeAttributeNode((Attr)node);
                    continue;
                }
                if (value == XMLRecord.NIL && (node.getNodeType() == 3 || node.getNodeType() == 4)) {
                    Element parentElement = (Element)node.getParentNode();
                    this.addXsiNilToElement(parentElement, xmlField);
                    parentElement.removeChild(node);
                    continue;
                }
                String stringValue = ((CoreConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(value, CoreClassConstants.STRING);
                Element parentElement = (Element)node.getParentNode();
                if (parentElement == null && parent.getNodeType() == 1) {
                    parentElement = (Element)parent;
                }
                if (stringValue.isEmpty() && (node.getNodeType() == 3 || node.getNodeType() == 4) && parentElement != null) {
                    parentElement.removeChild(node);
                    continue;
                }
                node.setNodeValue(stringValue);
                if (node.getNodeType() != 3 && node.getNodeType() != 4 || parentElement == null || (nil = parentElement.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "nil")) == null) continue;
                parentElement.removeAttributeNode(nil);
                continue;
            }
            Element element = (Element)node;
            Node parentNode = element.getParentNode();
            if (value == null) {
                parentNode.removeChild(element);
                continue;
            }
            String elementName = element.getTagName();
            Element newElement = null;
            Object valueToWrite = this.getValueToWrite(value, xmlField, session);
            XPathFragment childFrag = new XPathFragment(elementName);
            childFrag.setNamespaceURI(element.getNamespaceURI());
            newElement = (Element)this.createElement(parentNode, childFrag, xmlField, valueToWrite, session);
            createdElements.add(newElement);
            if (newElement == element) continue;
            parentNode.replaceChild(newElement, element);
        }
        if (xmlField.isTypedTextField()) {
            this.addTypeAttributes(createdElements, xmlField, value, this.resolveNamespacePrefixForURI("http://www.w3.org/2001/XMLSchema-instance", this.getNamespaceResolverForField(xmlField)), session);
        }
        return nodes;
    }

    public List<XMLEntry> replaceCollection(List<Field> xmlFields, List<XMLEntry> values, Node contextNode, DocumentPreservationPolicy docPresPolicy, Field lastUpdatedField, CoreAbstractSession session) {
        List<XMLEntry> oldNodes = this.unmarshalXPathEngine.selectNodes(contextNode, xmlFields, (XMLNamespaceResolver)this.getNamespaceResolverForField(xmlFields.get(0)));
        if (oldNodes == null || oldNodes.isEmpty()) {
            return oldNodes;
        }
        for (XMLEntry entry : oldNodes) {
            Node nextNode = (Node)entry.getValue();
            Node parent = nextNode.getParentNode();
            parent.removeChild(nextNode);
            while (parent != contextNode && parent.getChildNodes().getLength() == 0) {
                nextNode = parent;
                parent = nextNode.getParentNode();
                parent.removeChild(nextNode);
            }
        }
        this.create(xmlFields, contextNode, values, lastUpdatedField, this.xmlBinderPolicy, session);
        return oldNodes;
    }

    public NodeList replaceCollection(Field xmlField, Node parent, Collection values, CoreAbstractSession session) throws XMLMarshalException {
        int i;
        NodeList nodes = null;
        nodes = xmlField != null ? this.unmarshalXPathEngine.selectNodes(parent, xmlField, (XMLNamespaceResolver)this.getNamespaceResolverForField(xmlField)) : parent.getChildNodes();
        if (nodes.getLength() == 0) {
            return nodes;
        }
        Iterator collectionValues = values.iterator();
        int nodesLength = nodes.getLength();
        Vector<Element> newNodes = new Vector<Element>();
        boolean performedReplace = true;
        Object value = null;
        for (i = 0; i < nodesLength && collectionValues.hasNext(); ++i) {
            Node oldChild = nodes.item(i);
            Element newChild = null;
            if (performedReplace) {
                value = collectionValues.next();
            }
            Node parentNode = oldChild.getParentNode();
            if (oldChild.getNodeType() != 1) {
                if ((oldChild.getNodeType() == 3 || oldChild.getNodeType() == 4) && value == null) {
                    Node grandParentNode = parentNode.getParentNode();
                    grandParentNode.removeChild(parentNode);
                    continue;
                }
                oldChild.setNodeValue(((CoreConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(value, CoreClassConstants.STRING));
                continue;
            }
            Element element = (Element)oldChild;
            String elementName = element.getTagName();
            Object valueToWrite = this.getValueToWrite(value, xmlField, session);
            XPathFragment childFragment = new XPathFragment(elementName);
            childFragment.setNamespaceURI(element.getNamespaceURI());
            newChild = (Element)this.createElement(parentNode, childFragment, xmlField, valueToWrite, session);
            if (!newNodes.contains(oldChild)) {
                if (newChild != oldChild) {
                    parentNode.replaceChild(newChild, oldChild);
                }
                newNodes.add(newChild);
                performedReplace = true;
                continue;
            }
            performedReplace = false;
        }
        while (i < nodesLength) {
            Node toRemove = nodes.item(i);
            Node removedParent = toRemove.getParentNode();
            if (removedParent != null && !newNodes.contains(toRemove)) {
                removedParent.removeChild(toRemove);
            }
            ++i;
        }
        if (value != null && !performedReplace) {
            if (xmlField.getXPathFragment().getNextFragment() == null || xmlField.getXPathFragment().getHasText()) {
                this.create(xmlField, parent, value, xmlField, this.xmlBinderPolicy, session);
            } else {
                this.create(xmlField, parent, value, session);
            }
        }
        while (collectionValues.hasNext()) {
            value = collectionValues.next();
            if (xmlField.getXPathFragment().getNextFragment() == null || xmlField.getXPathFragment().getHasText()) {
                this.create(xmlField, parent, value, xmlField, this.xmlBinderPolicy, session);
                continue;
            }
            this.create(xmlField, parent, value, session);
        }
        return nodes;
    }

    private boolean containsIndex(String xpathString) {
        return xpathString.lastIndexOf(91) != -1 && xpathString.lastIndexOf(93) != -1;
    }

    private String resolveNamespacePrefix(XPathFragment fragment, NamespaceResolver namespaceResolver) {
        try {
            if (fragment.getNamespaceURI() != null) {
                return fragment.getNamespaceURI();
            }
            if (fragment.getPrefix() == null && fragment.isAttribute()) {
                return null;
            }
            return namespaceResolver.resolveNamespacePrefix(fragment.getPrefix());
        }
        catch (Exception e) {
            return null;
        }
    }

    private String resolveNamespacePrefixForURI(String namespaceURI, NamespaceResolver namespaceResolver) {
        if (null == namespaceResolver) {
            return null;
        }
        return namespaceResolver.resolveNamespaceURI(namespaceURI);
    }

    private Node addText(Field xmlField, Node element, String textValue) {
        if (xmlField.isCDATA()) {
            CDATASection cdata = element.getOwnerDocument().createCDATASection(textValue);
            element.appendChild(cdata);
            return cdata;
        }
        Text text = element.getOwnerDocument().createTextNode(textValue);
        element.appendChild(text);
        return text;
    }

    private String getStringForQName(QName qName, NamespaceResolver namespaceResolver) {
        if (null == qName) {
            return null;
        }
        if (null == qName.getNamespaceURI()) {
            return qName.getLocalPart();
        }
        String namespaceURI = qName.getNamespaceURI();
        if (namespaceResolver == null) {
            throw XMLMarshalException.namespaceResolverNotSpecified(namespaceURI);
        }
        String prefix = namespaceResolver.resolveNamespaceURI(namespaceURI);
        if (null == prefix) {
            return qName.getLocalPart();
        }
        return prefix + ":" + qName.getLocalPart();
    }

    private NamespaceResolver getNamespaceResolverForField(Field field) {
        NamespaceResolver nr = (NamespaceResolver)field.getNamespaceResolver();
        if (nr == null) {
            field.setNamespaceResolver(new NamespaceResolver());
        }
        return (NamespaceResolver)field.getNamespaceResolver();
    }

    private void addXsiNilToElement(Element element, Field xmlField) {
        NamespaceResolver nsr = new NamespaceResolver();
        nsr.setDOM(element);
        String schemaInstancePrefix = this.resolveNamespacePrefixForURI("http://www.w3.org/2001/XMLSchema-instance", nsr);
        for (Node parentNode = element.getParentNode(); schemaInstancePrefix == null && parentNode != null && parentNode.getNodeType() == 1; parentNode = parentNode.getParentNode()) {
            nsr.setDOM(element);
            schemaInstancePrefix = this.resolveNamespacePrefixForURI("http://www.w3.org/2001/XMLSchema-instance", nsr);
        }
        if (schemaInstancePrefix == null && element.getOwnerDocument() != null) {
            nsr.setDOM(element.getOwnerDocument().getDocumentElement());
            schemaInstancePrefix = this.resolveNamespacePrefixForURI("http://www.w3.org/2001/XMLSchema-instance", nsr);
        }
        if (schemaInstancePrefix == null) {
            nsr = this.getNamespaceResolverForField(xmlField);
            schemaInstancePrefix = nsr.resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
            if (schemaInstancePrefix == null) {
                schemaInstancePrefix = nsr.generatePrefix("xsi");
            }
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + schemaInstancePrefix, "http://www.w3.org/2001/XMLSchema-instance");
        }
        element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:nil", "true");
    }
}

