/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import org.apache.derby.iapi.db.OptimizerTrace;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.ClassFactoryContext;
import org.apache.derby.iapi.sql.compile.OptTrace;
import org.apache.derby.iapi.sql.dictionary.OptionalTool;
import org.apache.derby.impl.sql.compile.DefaultOptTrace;
import org.apache.derby.impl.sql.compile.XMLOptTrace;
import org.apache.derby.shared.common.error.PublicAPI;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;

public class OptimizerTracer
implements OptionalTool {
    @Override
    public void loadTool(String ... stringArray) throws SQLException {
        OptTrace optTrace;
        if (stringArray == null || stringArray.length == 0) {
            optTrace = new DefaultOptTrace();
        } else if ("xml".equals(stringArray[0])) {
            try {
                optTrace = new XMLOptTrace();
            }
            catch (Throwable throwable) {
                throw this.wrap(throwable);
            }
        } else if ("custom".equals(stringArray[0])) {
            if (stringArray.length != 2) {
                throw this.wrap(MessageService.getTextMessage("X0Y89.S", new Object[0]));
            }
            String string = stringArray[1];
            try {
                ClassFactoryContext classFactoryContext = (ClassFactoryContext)OptimizerTracer.getContext("ClassFactoryContext");
                ClassFactory classFactory = classFactoryContext.getClassFactory();
                Class clazz = classFactory.loadApplicationClass(string);
                optTrace = (OptTrace)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (InstantiationException instantiationException) {
                throw this.cantInstantiate(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw this.cantInstantiate(string);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw this.cantInstantiate(string);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw this.cantInstantiate(string);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw this.cantInstantiate(string);
            }
            catch (Throwable throwable) {
                throw this.wrap(throwable);
            }
        } else {
            throw this.wrap(MessageService.getTextMessage("X0Y89.S", new Object[0]));
        }
        OptimizerTrace.setOptimizerTracer(optTrace);
    }

    private SQLException cantInstantiate(String string) {
        return this.wrap(MessageService.getTextMessage("X0Y90.S", string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unloadTool(String ... stringArray) throws SQLException {
        try {
            PrintWriter printWriter;
            OptTrace optTrace = OptimizerTrace.getOptimizerTracer();
            boolean bl = false;
            if (stringArray != null && stringArray.length > 0) {
                try {
                    String string = stringArray[0];
                    File file = new File(string);
                    if (file.exists()) {
                        throw PublicAPI.wrapStandardException(StandardException.newException("XIE0S.S", string));
                    }
                    printWriter = new PrintWriter(file);
                }
                catch (IOException iOException) {
                    throw this.wrap(new IllegalArgumentException(iOException.getMessage(), iOException));
                }
                bl = true;
            } else {
                printWriter = new PrintWriter(System.out);
            }
            if (optTrace != null) {
                optTrace.printToWriter(printWriter);
                printWriter.flush();
            }
            if (bl) {
                printWriter.close();
            }
        }
        finally {
            OptimizerTrace.setOptimizerTracer(null);
        }
    }

    private SQLException wrap(Throwable throwable) {
        return new SQLException(throwable.getMessage(), throwable);
    }

    private SQLException wrap(String string) {
        String string2 = "XJ001.U".substring(0, 5);
        return new SQLException(string, string2);
    }

    private static Context getContext(String string) {
        return ContextService.getContext(string);
    }
}

