/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.naming.SimpleJndiName;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class ConnectionPoolUtil {
    private static final LocalStringManagerImpl I18N = new LocalStringManagerImpl(ConnectionPoolUtil.class);
    @Inject
    private Applications applications;
    @Inject
    private Domain domain;
    @Inject
    private ServerEnvironment env;

    public boolean isValidApplication(String applicationName, String poolName, ActionReport report) {
        if (applicationName == null) {
            this.setAppNameNeededErrorMessage(report);
            return false;
        }
        Application application = this.applications.getApplication(applicationName);
        if (application == null) {
            this.setApplNotFoundErrorMessage(report, applicationName);
            return false;
        }
        if ("true".equalsIgnoreCase(application.getEnabled())) {
            Server server = this.domain.getServerNamed(this.env.getInstanceName());
            ApplicationRef appRef = server.getApplicationRef(applicationName);
            if (appRef == null) {
                this.setAppDisabledErrorMessage(report, applicationName, poolName);
                return false;
            }
            if (appRef.getRef().equals(applicationName)) {
                if ("false".equalsIgnoreCase(appRef.getEnabled())) {
                    this.setAppDisabledErrorMessage(report, applicationName, poolName);
                    return false;
                }
                return true;
            }
        } else {
            this.setAppDisabledErrorMessage(report, applicationName, poolName);
        }
        return false;
    }

    public boolean isValidModule(String applicationName, String moduleName, String poolName, ActionReport report) {
        Application application = this.applications.getApplication(applicationName);
        if (!this.isValidApplication(applicationName, poolName, report)) {
            return false;
        }
        Module module = application.getModule(moduleName);
        if (module == null) {
            this.setModuleNotFoundErrorMessage(report, moduleName, applicationName);
            return false;
        }
        return true;
    }

    public boolean isValidPool(Resources resources, SimpleJndiName poolName, String prefix, ActionReport report) {
        if (resources == null) {
            this.setResourceNotFoundErrorMessage(report, poolName);
            return false;
        }
        if (resources.getResourceByName(ResourcePool.class, poolName) == null) {
            this.setResourceNotFoundErrorMessage(report, poolName);
            return false;
        }
        return true;
    }

    private void setAppNameNeededErrorMessage(ActionReport report) {
        report.setMessage(I18N.getLocalString("pool.util.app.name.needed", "--appname is needed when --modulename is specified"));
        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
    }

    private void setAppDisabledErrorMessage(ActionReport report, String applicationName, String poolName) {
        report.setMessage(I18N.getLocalString("pool.util.app.is.not.enabled", "Application [ {0} ] in which the pool [ {1} ] is defined, is not enabled", new Object[]{applicationName, poolName}));
        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
    }

    private void setApplNotFoundErrorMessage(ActionReport report, String applicationName) {
        report.setMessage(I18N.getLocalString("pool.util.app.does.not.exist", "Application {0} does not exist.", new Object[]{applicationName}));
        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
    }

    private void setModuleNotFoundErrorMessage(ActionReport report, String moduleName, String applicationName) {
        report.setMessage(I18N.getLocalString("pool.util.module.does.not.exist", "Module {0} does not exist in application {1}.", new Object[]{moduleName, applicationName}));
        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
    }

    private void setResourceNotFoundErrorMessage(ActionReport report, SimpleJndiName poolName) {
        report.setMessage(I18N.getLocalString("pool.util.pool.does.not-exist", "Pool {0} does not exist.", new Object[]{poolName}));
        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
    }
}

