/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.launcher;

import com.sun.enterprise.admin.launcher.CommandLine;
import com.sun.enterprise.admin.launcher.GFLauncher;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.admin.launcher.GFLauncherLogger;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.xml.MiniXmlParser;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import com.sun.enterprise.util.HostAndPort;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.embeddable.GlassFishVariable;

class GFEmbeddedLauncher
extends GFLauncher {
    private static final String GFE_RUNSERVER_JAR = "GFE_RUNSERVER_JAR";
    private static final String GFE_RUNSERVER_CLASS = "GFE_RUNSERVER_CLASS";
    private static final String GFE_JAR = "GFE_JAR";
    private static final String INSTALL_HOME = "S1AS_HOME";
    private static final String GENERAL_MESSAGE = " *********  GENERAL MESSAGE ********\nYou must setup four different environmental variables to run embedded with asadmin. They are\nGFE_JAR - path to the embedded jar\nS1AS_HOME - path to installation directory. This can be empty or not exist yet.\n" + GlassFishVariable.JAVA_HOME.getEnvName() + " - path to a JDK installation. JRE installation is generally not good enough\nGFE_DEBUG_PORT - optional debugging port. It will start suspended.\n\n*********  SPECIFIC MESSAGE ********\n";
    private static final String[] DERBY_FILES = new String[]{"derby.jar", "derbyclient.jar"};
    private boolean setup;
    private File gfeJar;
    private File runServerJar;
    private File installDir;
    private File javaExe;
    private File domainDir;
    private List<File> javaDbClassPath;
    private Path logFile;
    private File[] classpath;

    GFEmbeddedLauncher(GFLauncherInfo info) {
        super(info);
    }

    @Override
    public Long getPidBeforeRestart() {
        return null;
    }

    @Override
    public File getAdminRealmKeyFile() {
        return null;
    }

    @Override
    public boolean isSecureAdminEnabled() {
        return false;
    }

    @Override
    public Integer getDebugPort() {
        return null;
    }

    @Override
    public boolean isSuspendEnabled() {
        return false;
    }

    @Override
    public Path getLogFile() {
        return this.logFile;
    }

    @Override
    public boolean needsAutoUpgrade() {
        return false;
    }

    @Override
    public final boolean needsManualUpgrade() {
        return false;
    }

    @Override
    public void setup() throws GFLauncherException, MiniXmlParserException {
        if (this.setup) {
            throw new IllegalStateException("The setup() was already executed.");
        }
        this.setup = true;
        try {
            this.setupFromEnv();
        }
        catch (GFLauncherException e) {
            throw new GFLauncherException(GENERAL_MESSAGE + e.getMessage(), e);
        }
        GFLauncherInfo launchParams = this.getParameters();
        String instanceName = launchParams.getInstanceName() == null ? "server" : launchParams.getInstanceName();
        File configDir = new File(this.domainDir, "config");
        File domainXmlFile = new File(configDir, "domain.xml");
        launchParams.setConfigDir(configDir);
        launchParams.setDomainRootDir(new File(System.getenv(INSTALL_HOME)));
        MiniXmlParser parser = new MiniXmlParser(domainXmlFile, instanceName);
        launchParams.setAsadminAdminAddress(new HostAndPort("localhost", 4848, false));
        launchParams.setXmlAdminAddresses(parser.getAdminAddresses());
        File logsDir = new File(this.domainDir, "logs");
        this.logFile = new File(logsDir, "server.log").toPath().toAbsolutePath();
        GFLauncherLogger.addLogFileHandler(this.logFile);
        this.setCommandLine(this.prepareCommandLine());
    }

    private void setClasspath() {
        ArrayList<File> cp = new ArrayList<File>();
        cp.add(this.gfeJar);
        cp.addAll(this.javaDbClassPath);
        if (this.runServerJar != null) {
            cp.add(this.runServerJar);
        }
        this.classpath = (File[])cp.toArray(File[]::new);
    }

    private CommandLine prepareCommandLine() {
        CommandLine cmdLine = new CommandLine(CommandLine.CommandFormat.ProcessBuilder);
        cmdLine.append(this.javaExe.toPath());
        this.addThreadDump(cmdLine);
        if (this.classpath.length > 0) {
            cmdLine.appendClassPath(this.classpath);
        }
        this.addDebug(cmdLine);
        cmdLine.append(this.getMainClass());
        cmdLine.append("--installdir");
        cmdLine.append(this.installDir.toPath());
        cmdLine.append("--instancedir");
        cmdLine.append(this.domainDir.toPath());
        cmdLine.append("--autodelete");
        cmdLine.append("false");
        cmdLine.append("--autodeploy");
        return cmdLine;
    }

    private String getMainClass() {
        String className = System.getenv(GFE_RUNSERVER_CLASS);
        if (className == null) {
            return "org.glassfish.tests.embedded.EmbeddedMain";
        }
        return className;
    }

    private void addDebug(CommandLine cmdLine) {
        String suspend = System.getenv("GFE_DEBUG_SUSPEND");
        String debugPort = System.getenv("GFE_DEBUG_PORT");
        if (debugPort == null) {
            return;
        }
        String suspendOption = Boolean.valueOf(suspend) != false ? "y" : "n";
        cmdLine.append("-Xdebug");
        cmdLine.append("-Xrunjdwp:transport=dt_socket,server=y,suspend=" + suspendOption + ",address=" + debugPort);
    }

    private void addThreadDump(CommandLine cmdLine) {
        Path jvmLog = this.domainDir.toPath().resolve(Path.of("logs", "jvm.log"));
        cmdLine.appendJavaOption("-XX:+UnlockDiagnosticVMOptions");
        cmdLine.appendJavaOption("-XX:+LogVMOutput");
        cmdLine.appendJavaOption("-XX:LogFile", jvmLog);
    }

    private void setupFromEnv() throws GFLauncherException {
        this.setupEmbeddedJars();
        this.setupInstallationDir();
        this.setupJDK();
        this.setupDomainDir();
        this.setupJavaDB();
        this.setClasspath();
    }

    private void setupDomainDir() throws GFLauncherException {
        String domainDirName = this.getParameters().getDomainName();
        this.domainDir = this.getParameters().getDomainParentDir();
        this.domainDir = new File(this.domainDir, domainDirName);
        if (!FileUtils.mkdirsMaybe((File)this.domainDir)) {
            throw new GFLauncherException("Can not create directory: " + String.valueOf(this.domainDir));
        }
        this.domainDir = SmartFile.sanitize((File)this.domainDir);
    }

    private void setupJDK() throws GFLauncherException {
        File jdkDir;
        String err = "You must set the environmental variable " + GlassFishVariable.JAVA_HOME.getEnvName() + " to point at a valid JDK.  <jdk>/bin/javac[.exe] must exist.";
        String jdkDirName = System.getenv(GlassFishVariable.JAVA_HOME.getEnvName());
        if (!GFEmbeddedLauncher.ok(jdkDirName)) {
            jdkDirName = System.getProperty("java.home");
        }
        if (!(jdkDir = new File(jdkDirName)).isDirectory()) {
            throw new GFLauncherException(err);
        }
        this.javaExe = File.separatorChar == '\\' ? new File(jdkDir, "bin/java.exe") : new File(jdkDir, "bin/java");
        if (!this.javaExe.isFile()) {
            throw new GFLauncherException(err);
        }
        this.javaExe = SmartFile.sanitize((File)this.javaExe);
    }

    private void setupInstallationDir() throws GFLauncherException {
        String err = "You must set the environmental variable S1AS_HOME to point at a GlassFish installation or at an empty directory or at a location where an empty directory can be created.";
        String installDirName = System.getenv(INSTALL_HOME);
        if (!GFEmbeddedLauncher.ok(installDirName)) {
            throw new GFLauncherException(err);
        }
        this.installDir = new File(installDirName);
        if (!FileUtils.mkdirsMaybe((File)this.installDir)) {
            throw new GFLauncherException(err);
        }
        this.installDir = SmartFile.sanitize((File)this.installDir);
    }

    private void setupEmbeddedJars() throws GFLauncherException {
        String err = "You must set the environmental variable GFE_JAR to point at the Embedded jarfile.";
        String gfeJarName = System.getenv(GFE_JAR);
        if (!GFEmbeddedLauncher.ok(gfeJarName)) {
            throw new GFLauncherException(err);
        }
        this.gfeJar = new File(gfeJarName);
        if (!this.gfeJar.isFile() || this.gfeJar.length() < 1000000L) {
            throw new GFLauncherException(err);
        }
        this.gfeJar = SmartFile.sanitize((File)this.gfeJar);
        err = "You must set the environmental variable GFE_RUNSERVER_JAR to point at the server startup jar.";
        String runServerJarName = System.getenv(GFE_RUNSERVER_JAR);
        if (runServerJarName != null) {
            if (!GFEmbeddedLauncher.ok(runServerJarName)) {
                throw new GFLauncherException(err);
            }
            this.runServerJar = new File(runServerJarName);
            if (!this.runServerJar.isFile()) {
                throw new GFLauncherException(err);
            }
            this.runServerJar = SmartFile.sanitize((File)this.runServerJar);
        }
    }

    private void setupJavaDB() throws GFLauncherException {
        String relPath = "javadb/lib";
        File derbyLib = new File(this.installDir, relPath);
        if (!derbyLib.isDirectory()) {
            derbyLib = new File(this.installDir.getParentFile(), relPath);
        }
        if (!derbyLib.isDirectory()) {
            throw new GFLauncherException("Could not find the JavaDB lib directory.");
        }
        this.javaDbClassPath = new ArrayList<File>();
        for (String fname : DERBY_FILES) {
            File file = new File(derbyLib, fname);
            this.javaDbClassPath.add(file);
            if (file.exists()) continue;
            throw new GFLauncherException("Could not find the JavaDB jar: " + String.valueOf(file));
        }
    }

    private static boolean ok(String s) {
        return s != null && !s.isEmpty();
    }
}

