/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.model;

import jakarta.faces.model.DataModel;
import jakarta.faces.model.DataModelEvent;
import jakarta.faces.model.DataModelListener;
import jakarta.faces.model.NoRowAvailableException;

public class ScalarDataModel<E>
extends DataModel<E> {
    private int index;
    private E scalar;

    public ScalarDataModel() {
        this(null);
    }

    public ScalarDataModel(E scalar) {
        this.setWrappedData(scalar);
    }

    @Override
    public boolean isRowAvailable() {
        return this.scalar != null && this.index == 0;
    }

    @Override
    public int getRowCount() {
        if (this.scalar == null) {
            return -1;
        }
        return 1;
    }

    @Override
    public E getRowData() {
        if (this.scalar == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new NoRowAvailableException();
        }
        return this.scalar;
    }

    @Override
    public int getRowIndex() {
        return this.index;
    }

    @Override
    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException();
        }
        int old = this.index;
        this.index = rowIndex;
        if (this.scalar == null) {
            return;
        }
        DataModelListener[] listeners = this.getDataModelListeners();
        if (old != this.index && listeners != null) {
            Object rowData = null;
            if (this.isRowAvailable()) {
                rowData = this.getRowData();
            }
            DataModelEvent event = new DataModelEvent(this, this.index, rowData);
            for (DataModelListener listener : listeners) {
                if (null == listener) continue;
                listener.rowSelected(event);
            }
        }
    }

    @Override
    public Object getWrappedData() {
        return this.scalar;
    }

    @Override
    public void setWrappedData(Object data) {
        if (data == null) {
            this.scalar = null;
            this.setRowIndex(-1);
        } else {
            this.scalar = data;
            this.index = -1;
            this.setRowIndex(0);
        }
    }
}

