/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.exceptions;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.exceptions.i18n.ExceptionMessageGenerator;

public class IntegrityException
extends ValidationException {
    protected IntegrityChecker integrityChecker;

    public IntegrityException() {
    }

    public IntegrityException(IntegrityChecker integrityChecker) {
        this.integrityChecker = integrityChecker;
    }

    public IntegrityChecker getIntegrityChecker() {
        return this.integrityChecker;
    }

    @Override
    public String getMessage() {
        String cr = System.lineSeparator();
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        writer.println(cr + ExceptionMessageGenerator.getHeader("DescriptorExceptionsHeader"));
        writer.println("---------------------------------------------------------");
        for (Exception e : this.getIntegrityChecker().getCaughtExceptions()) {
            if (!(e instanceof DescriptorException)) continue;
            writer.println(cr + String.valueOf(e));
        }
        if (this.getIntegrityChecker().hasRuntimeExceptions()) {
            writer.println(cr + ExceptionMessageGenerator.getHeader("RuntimeExceptionsHeader"));
            writer.println("---------------------------------------------------------");
            for (Exception e : this.getIntegrityChecker().getCaughtExceptions()) {
                if (e instanceof DescriptorException) continue;
                writer.println(cr + String.valueOf(e));
            }
        }
        writer.flush();
        swriter.flush();
        return swriter.toString();
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream outStream) {
        this.printStackTrace(new PrintWriter(outStream));
    }

    @Override
    public void printStackTrace(PrintWriter writer) {
        super.printStackTrace(writer);
        String cr = System.lineSeparator();
        writer.println(cr + ExceptionMessageGenerator.getHeader("DescriptorExceptionsHeader"));
        writer.println("---------------------------------------------------------");
        for (Exception e : this.getIntegrityChecker().getCaughtExceptions()) {
            if (!(e instanceof DescriptorException)) continue;
            writer.println(cr);
            e.printStackTrace(writer);
        }
        if (this.getIntegrityChecker().hasRuntimeExceptions()) {
            writer.println(cr + ExceptionMessageGenerator.getHeader("RuntimeExceptionsHeader"));
            writer.println("---------------------------------------------------------");
            for (Exception e : this.getIntegrityChecker().getCaughtExceptions()) {
                if (e instanceof DescriptorException) continue;
                writer.println(cr);
                e.printStackTrace(writer);
            }
        }
        writer.flush();
    }
}

